<?php
namespace AwsWPTC;

/**
 * Builds AWS clients based on configuration settings.
 *
 * @method \AwsWPTC\ACMPCA\ACMPCAClient createACMPCA(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionACMPCA(array $args = [])
 * @method \AwsWPTC\AccessAnalyzer\AccessAnalyzerClient createAccessAnalyzer(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAccessAnalyzer(array $args = [])
 * @method \AwsWPTC\Acm\AcmClient createAcm(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAcm(array $args = [])
 * @method \AwsWPTC\AlexaForBusiness\AlexaForBusinessClient createAlexaForBusiness(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAlexaForBusiness(array $args = [])
 * @method \AwsWPTC\Amplify\AmplifyClient createAmplify(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAmplify(array $args = [])
 * @method \AwsWPTC\AmplifyBackend\AmplifyBackendClient createAmplifyBackend(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAmplifyBackend(array $args = [])
 * @method \AwsWPTC\ApiGateway\ApiGatewayClient createApiGateway(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApiGateway(array $args = [])
 * @method \AwsWPTC\ApiGatewayManagementApi\ApiGatewayManagementApiClient createApiGatewayManagementApi(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApiGatewayManagementApi(array $args = [])
 * @method \AwsWPTC\ApiGatewayV2\ApiGatewayV2Client createApiGatewayV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApiGatewayV2(array $args = [])
 * @method \AwsWPTC\AppConfig\AppConfigClient createAppConfig(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppConfig(array $args = [])
 * @method \AwsWPTC\AppIntegrationsService\AppIntegrationsServiceClient createAppIntegrationsService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppIntegrationsService(array $args = [])
 * @method \AwsWPTC\AppMesh\AppMeshClient createAppMesh(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppMesh(array $args = [])
 * @method \AwsWPTC\AppRegistry\AppRegistryClient createAppRegistry(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppRegistry(array $args = [])
 * @method \AwsWPTC\AppRunner\AppRunnerClient createAppRunner(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppRunner(array $args = [])
 * @method \AwsWPTC\AppSync\AppSyncClient createAppSync(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppSync(array $args = [])
 * @method \AwsWPTC\Appflow\AppflowClient createAppflow(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppflow(array $args = [])
 * @method \AwsWPTC\ApplicationAutoScaling\ApplicationAutoScalingClient createApplicationAutoScaling(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApplicationAutoScaling(array $args = [])
 * @method \AwsWPTC\ApplicationCostProfiler\ApplicationCostProfilerClient createApplicationCostProfiler(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApplicationCostProfiler(array $args = [])
 * @method \AwsWPTC\ApplicationDiscoveryService\ApplicationDiscoveryServiceClient createApplicationDiscoveryService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApplicationDiscoveryService(array $args = [])
 * @method \AwsWPTC\ApplicationInsights\ApplicationInsightsClient createApplicationInsights(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionApplicationInsights(array $args = [])
 * @method \AwsWPTC\Appstream\AppstreamClient createAppstream(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAppstream(array $args = [])
 * @method \AwsWPTC\Athena\AthenaClient createAthena(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAthena(array $args = [])
 * @method \AwsWPTC\AuditManager\AuditManagerClient createAuditManager(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAuditManager(array $args = [])
 * @method \AwsWPTC\AugmentedAIRuntime\AugmentedAIRuntimeClient createAugmentedAIRuntime(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAugmentedAIRuntime(array $args = [])
 * @method \AwsWPTC\AutoScaling\AutoScalingClient createAutoScaling(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAutoScaling(array $args = [])
 * @method \AwsWPTC\AutoScalingPlans\AutoScalingPlansClient createAutoScalingPlans(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionAutoScalingPlans(array $args = [])
 * @method \AwsWPTC\Backup\BackupClient createBackup(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionBackup(array $args = [])
 * @method \AwsWPTC\Batch\BatchClient createBatch(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionBatch(array $args = [])
 * @method \AwsWPTC\Braket\BraketClient createBraket(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionBraket(array $args = [])
 * @method \AwsWPTC\Budgets\BudgetsClient createBudgets(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionBudgets(array $args = [])
 * @method \AwsWPTC\Chime\ChimeClient createChime(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionChime(array $args = [])
 * @method \AwsWPTC\Cloud9\Cloud9Client createCloud9(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloud9(array $args = [])
 * @method \AwsWPTC\CloudDirectory\CloudDirectoryClient createCloudDirectory(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudDirectory(array $args = [])
 * @method \AwsWPTC\CloudFormation\CloudFormationClient createCloudFormation(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudFormation(array $args = [])
 * @method \AwsWPTC\CloudFront\CloudFrontClient createCloudFront(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudFront(array $args = [])
 * @method \AwsWPTC\CloudHSMV2\CloudHSMV2Client createCloudHSMV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudHSMV2(array $args = [])
 * @method \AwsWPTC\CloudHsm\CloudHsmClient createCloudHsm(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudHsm(array $args = [])
 * @method \AwsWPTC\CloudSearch\CloudSearchClient createCloudSearch(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudSearch(array $args = [])
 * @method \AwsWPTC\CloudSearchDomain\CloudSearchDomainClient createCloudSearchDomain(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudSearchDomain(array $args = [])
 * @method \AwsWPTC\CloudTrail\CloudTrailClient createCloudTrail(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudTrail(array $args = [])
 * @method \AwsWPTC\CloudWatch\CloudWatchClient createCloudWatch(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudWatch(array $args = [])
 * @method \AwsWPTC\CloudWatchEvents\CloudWatchEventsClient createCloudWatchEvents(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudWatchEvents(array $args = [])
 * @method \AwsWPTC\CloudWatchLogs\CloudWatchLogsClient createCloudWatchLogs(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCloudWatchLogs(array $args = [])
 * @method \AwsWPTC\CodeArtifact\CodeArtifactClient createCodeArtifact(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeArtifact(array $args = [])
 * @method \AwsWPTC\CodeBuild\CodeBuildClient createCodeBuild(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeBuild(array $args = [])
 * @method \AwsWPTC\CodeCommit\CodeCommitClient createCodeCommit(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeCommit(array $args = [])
 * @method \AwsWPTC\CodeDeploy\CodeDeployClient createCodeDeploy(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeDeploy(array $args = [])
 * @method \AwsWPTC\CodeGuruProfiler\CodeGuruProfilerClient createCodeGuruProfiler(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeGuruProfiler(array $args = [])
 * @method \AwsWPTC\CodeGuruReviewer\CodeGuruReviewerClient createCodeGuruReviewer(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeGuruReviewer(array $args = [])
 * @method \AwsWPTC\CodePipeline\CodePipelineClient createCodePipeline(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodePipeline(array $args = [])
 * @method \AwsWPTC\CodeStar\CodeStarClient createCodeStar(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeStar(array $args = [])
 * @method \AwsWPTC\CodeStarNotifications\CodeStarNotificationsClient createCodeStarNotifications(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeStarNotifications(array $args = [])
 * @method \AwsWPTC\CodeStarconnections\CodeStarconnectionsClient createCodeStarconnections(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCodeStarconnections(array $args = [])
 * @method \AwsWPTC\CognitoIdentity\CognitoIdentityClient createCognitoIdentity(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCognitoIdentity(array $args = [])
 * @method \AwsWPTC\CognitoIdentityProvider\CognitoIdentityProviderClient createCognitoIdentityProvider(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCognitoIdentityProvider(array $args = [])
 * @method \AwsWPTC\CognitoSync\CognitoSyncClient createCognitoSync(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCognitoSync(array $args = [])
 * @method \AwsWPTC\Comprehend\ComprehendClient createComprehend(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionComprehend(array $args = [])
 * @method \AwsWPTC\ComprehendMedical\ComprehendMedicalClient createComprehendMedical(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionComprehendMedical(array $args = [])
 * @method \AwsWPTC\ComputeOptimizer\ComputeOptimizerClient createComputeOptimizer(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionComputeOptimizer(array $args = [])
 * @method \AwsWPTC\ConfigService\ConfigServiceClient createConfigService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionConfigService(array $args = [])
 * @method \AwsWPTC\Connect\ConnectClient createConnect(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionConnect(array $args = [])
 * @method \AwsWPTC\ConnectContactLens\ConnectContactLensClient createConnectContactLens(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionConnectContactLens(array $args = [])
 * @method \AwsWPTC\ConnectParticipant\ConnectParticipantClient createConnectParticipant(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionConnectParticipant(array $args = [])
 * @method \AwsWPTC\CostExplorer\CostExplorerClient createCostExplorer(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCostExplorer(array $args = [])
 * @method \AwsWPTC\CostandUsageReportService\CostandUsageReportServiceClient createCostandUsageReportService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCostandUsageReportService(array $args = [])
 * @method \AwsWPTC\CustomerProfiles\CustomerProfilesClient createCustomerProfiles(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionCustomerProfiles(array $args = [])
 * @method \AwsWPTC\DAX\DAXClient createDAX(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDAX(array $args = [])
 * @method \AwsWPTC\DLM\DLMClient createDLM(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDLM(array $args = [])
 * @method \AwsWPTC\DataExchange\DataExchangeClient createDataExchange(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDataExchange(array $args = [])
 * @method \AwsWPTC\DataPipeline\DataPipelineClient createDataPipeline(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDataPipeline(array $args = [])
 * @method \AwsWPTC\DataSync\DataSyncClient createDataSync(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDataSync(array $args = [])
 * @method \AwsWPTC\DatabaseMigrationService\DatabaseMigrationServiceClient createDatabaseMigrationService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDatabaseMigrationService(array $args = [])
 * @method \AwsWPTC\Detective\DetectiveClient createDetective(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDetective(array $args = [])
 * @method \AwsWPTC\DevOpsGuru\DevOpsGuruClient createDevOpsGuru(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDevOpsGuru(array $args = [])
 * @method \AwsWPTC\DeviceFarm\DeviceFarmClient createDeviceFarm(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDeviceFarm(array $args = [])
 * @method \AwsWPTC\DirectConnect\DirectConnectClient createDirectConnect(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDirectConnect(array $args = [])
 * @method \AwsWPTC\DirectoryService\DirectoryServiceClient createDirectoryService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDirectoryService(array $args = [])
 * @method \AwsWPTC\DocDB\DocDBClient createDocDB(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDocDB(array $args = [])
 * @method \AwsWPTC\DynamoDb\DynamoDbClient createDynamoDb(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDynamoDb(array $args = [])
 * @method \AwsWPTC\DynamoDbStreams\DynamoDbStreamsClient createDynamoDbStreams(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionDynamoDbStreams(array $args = [])
 * @method \AwsWPTC\EBS\EBSClient createEBS(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEBS(array $args = [])
 * @method \AwsWPTC\EC2InstanceConnect\EC2InstanceConnectClient createEC2InstanceConnect(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEC2InstanceConnect(array $args = [])
 * @method \AwsWPTC\ECRPublic\ECRPublicClient createECRPublic(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionECRPublic(array $args = [])
 * @method \AwsWPTC\EKS\EKSClient createEKS(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEKS(array $args = [])
 * @method \AwsWPTC\EMRContainers\EMRContainersClient createEMRContainers(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEMRContainers(array $args = [])
 * @method \AwsWPTC\Ec2\Ec2Client createEc2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEc2(array $args = [])
 * @method \AwsWPTC\Ecr\EcrClient createEcr(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEcr(array $args = [])
 * @method \AwsWPTC\Ecs\EcsClient createEcs(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEcs(array $args = [])
 * @method \AwsWPTC\Efs\EfsClient createEfs(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEfs(array $args = [])
 * @method \AwsWPTC\ElastiCache\ElastiCacheClient createElastiCache(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElastiCache(array $args = [])
 * @method \AwsWPTC\ElasticBeanstalk\ElasticBeanstalkClient createElasticBeanstalk(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticBeanstalk(array $args = [])
 * @method \AwsWPTC\ElasticInference\ElasticInferenceClient createElasticInference(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticInference(array $args = [])
 * @method \AwsWPTC\ElasticLoadBalancing\ElasticLoadBalancingClient createElasticLoadBalancing(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticLoadBalancing(array $args = [])
 * @method \AwsWPTC\ElasticLoadBalancingV2\ElasticLoadBalancingV2Client createElasticLoadBalancingV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticLoadBalancingV2(array $args = [])
 * @method \AwsWPTC\ElasticTranscoder\ElasticTranscoderClient createElasticTranscoder(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticTranscoder(array $args = [])
 * @method \AwsWPTC\ElasticsearchService\ElasticsearchServiceClient createElasticsearchService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionElasticsearchService(array $args = [])
 * @method \AwsWPTC\Emr\EmrClient createEmr(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEmr(array $args = [])
 * @method \AwsWPTC\EventBridge\EventBridgeClient createEventBridge(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionEventBridge(array $args = [])
 * @method \AwsWPTC\FIS\FISClient createFIS(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFIS(array $args = [])
 * @method \AwsWPTC\FMS\FMSClient createFMS(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFMS(array $args = [])
 * @method \AwsWPTC\FSx\FSxClient createFSx(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFSx(array $args = [])
 * @method \AwsWPTC\FinSpaceData\FinSpaceDataClient createFinSpaceData(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFinSpaceData(array $args = [])
 * @method \AwsWPTC\Firehose\FirehoseClient createFirehose(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFirehose(array $args = [])
 * @method \AwsWPTC\ForecastQueryService\ForecastQueryServiceClient createForecastQueryService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionForecastQueryService(array $args = [])
 * @method \AwsWPTC\ForecastService\ForecastServiceClient createForecastService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionForecastService(array $args = [])
 * @method \AwsWPTC\FraudDetector\FraudDetectorClient createFraudDetector(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionFraudDetector(array $args = [])
 * @method \AwsWPTC\GameLift\GameLiftClient createGameLift(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGameLift(array $args = [])
 * @method \AwsWPTC\Glacier\GlacierClient createGlacier(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGlacier(array $args = [])
 * @method \AwsWPTC\GlobalAccelerator\GlobalAcceleratorClient createGlobalAccelerator(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGlobalAccelerator(array $args = [])
 * @method \AwsWPTC\Glue\GlueClient createGlue(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGlue(array $args = [])
 * @method \AwsWPTC\GlueDataBrew\GlueDataBrewClient createGlueDataBrew(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGlueDataBrew(array $args = [])
 * @method \AwsWPTC\Greengrass\GreengrassClient createGreengrass(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGreengrass(array $args = [])
 * @method \AwsWPTC\GreengrassV2\GreengrassV2Client createGreengrassV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGreengrassV2(array $args = [])
 * @method \AwsWPTC\GroundStation\GroundStationClient createGroundStation(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGroundStation(array $args = [])
 * @method \AwsWPTC\GuardDuty\GuardDutyClient createGuardDuty(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionGuardDuty(array $args = [])
 * @method \AwsWPTC\Health\HealthClient createHealth(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionHealth(array $args = [])
 * @method \AwsWPTC\HealthLake\HealthLakeClient createHealthLake(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionHealthLake(array $args = [])
 * @method \AwsWPTC\Honeycode\HoneycodeClient createHoneycode(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionHoneycode(array $args = [])
 * @method \AwsWPTC\IVS\IVSClient createIVS(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIVS(array $args = [])
 * @method \AwsWPTC\Iam\IamClient createIam(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIam(array $args = [])
 * @method \AwsWPTC\IdentityStore\IdentityStoreClient createIdentityStore(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIdentityStore(array $args = [])
 * @method \AwsWPTC\ImportExport\ImportExportClient createImportExport(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionImportExport(array $args = [])
 * @method \AwsWPTC\Inspector\InspectorClient createInspector(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionInspector(array $args = [])
 * @method \AwsWPTC\IoT1ClickDevicesService\IoT1ClickDevicesServiceClient createIoT1ClickDevicesService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoT1ClickDevicesService(array $args = [])
 * @method \AwsWPTC\IoT1ClickProjects\IoT1ClickProjectsClient createIoT1ClickProjects(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoT1ClickProjects(array $args = [])
 * @method \AwsWPTC\IoTAnalytics\IoTAnalyticsClient createIoTAnalytics(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTAnalytics(array $args = [])
 * @method \AwsWPTC\IoTDeviceAdvisor\IoTDeviceAdvisorClient createIoTDeviceAdvisor(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTDeviceAdvisor(array $args = [])
 * @method \AwsWPTC\IoTEvents\IoTEventsClient createIoTEvents(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTEvents(array $args = [])
 * @method \AwsWPTC\IoTEventsData\IoTEventsDataClient createIoTEventsData(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTEventsData(array $args = [])
 * @method \AwsWPTC\IoTFleetHub\IoTFleetHubClient createIoTFleetHub(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTFleetHub(array $args = [])
 * @method \AwsWPTC\IoTJobsDataPlane\IoTJobsDataPlaneClient createIoTJobsDataPlane(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTJobsDataPlane(array $args = [])
 * @method \AwsWPTC\IoTSecureTunneling\IoTSecureTunnelingClient createIoTSecureTunneling(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTSecureTunneling(array $args = [])
 * @method \AwsWPTC\IoTSiteWise\IoTSiteWiseClient createIoTSiteWise(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTSiteWise(array $args = [])
 * @method \AwsWPTC\IoTThingsGraph\IoTThingsGraphClient createIoTThingsGraph(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTThingsGraph(array $args = [])
 * @method \AwsWPTC\IoTWireless\IoTWirelessClient createIoTWireless(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIoTWireless(array $args = [])
 * @method \AwsWPTC\Iot\IotClient createIot(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIot(array $args = [])
 * @method \AwsWPTC\IotDataPlane\IotDataPlaneClient createIotDataPlane(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionIotDataPlane(array $args = [])
 * @method \AwsWPTC\Kafka\KafkaClient createKafka(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKafka(array $args = [])
 * @method \AwsWPTC\Kinesis\KinesisClient createKinesis(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesis(array $args = [])
 * @method \AwsWPTC\KinesisAnalytics\KinesisAnalyticsClient createKinesisAnalytics(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisAnalytics(array $args = [])
 * @method \AwsWPTC\KinesisAnalyticsV2\KinesisAnalyticsV2Client createKinesisAnalyticsV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisAnalyticsV2(array $args = [])
 * @method \AwsWPTC\KinesisVideo\KinesisVideoClient createKinesisVideo(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisVideo(array $args = [])
 * @method \AwsWPTC\KinesisVideoArchivedMedia\KinesisVideoArchivedMediaClient createKinesisVideoArchivedMedia(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisVideoArchivedMedia(array $args = [])
 * @method \AwsWPTC\KinesisVideoMedia\KinesisVideoMediaClient createKinesisVideoMedia(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisVideoMedia(array $args = [])
 * @method \AwsWPTC\KinesisVideoSignalingChannels\KinesisVideoSignalingChannelsClient createKinesisVideoSignalingChannels(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKinesisVideoSignalingChannels(array $args = [])
 * @method \AwsWPTC\Kms\KmsClient createKms(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionKms(array $args = [])
 * @method \AwsWPTC\LakeFormation\LakeFormationClient createLakeFormation(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLakeFormation(array $args = [])
 * @method \AwsWPTC\Lambda\LambdaClient createLambda(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLambda(array $args = [])
 * @method \AwsWPTC\LexModelBuildingService\LexModelBuildingServiceClient createLexModelBuildingService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLexModelBuildingService(array $args = [])
 * @method \AwsWPTC\LexModelsV2\LexModelsV2Client createLexModelsV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLexModelsV2(array $args = [])
 * @method \AwsWPTC\LexRuntimeService\LexRuntimeServiceClient createLexRuntimeService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLexRuntimeService(array $args = [])
 * @method \AwsWPTC\LexRuntimeV2\LexRuntimeV2Client createLexRuntimeV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLexRuntimeV2(array $args = [])
 * @method \AwsWPTC\LicenseManager\LicenseManagerClient createLicenseManager(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLicenseManager(array $args = [])
 * @method \AwsWPTC\Lightsail\LightsailClient createLightsail(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLightsail(array $args = [])
 * @method \AwsWPTC\LocationService\LocationServiceClient createLocationService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLocationService(array $args = [])
 * @method \AwsWPTC\LookoutEquipment\LookoutEquipmentClient createLookoutEquipment(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLookoutEquipment(array $args = [])
 * @method \AwsWPTC\LookoutMetrics\LookoutMetricsClient createLookoutMetrics(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLookoutMetrics(array $args = [])
 * @method \AwsWPTC\LookoutforVision\LookoutforVisionClient createLookoutforVision(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionLookoutforVision(array $args = [])
 * @method \AwsWPTC\MQ\MQClient createMQ(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMQ(array $args = [])
 * @method \AwsWPTC\MTurk\MTurkClient createMTurk(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMTurk(array $args = [])
 * @method \AwsWPTC\MWAA\MWAAClient createMWAA(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMWAA(array $args = [])
 * @method \AwsWPTC\MachineLearning\MachineLearningClient createMachineLearning(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMachineLearning(array $args = [])
 * @method \AwsWPTC\Macie\MacieClient createMacie(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMacie(array $args = [])
 * @method \AwsWPTC\Macie2\Macie2Client createMacie2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMacie2(array $args = [])
 * @method \AwsWPTC\ManagedBlockchain\ManagedBlockchainClient createManagedBlockchain(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionManagedBlockchain(array $args = [])
 * @method \AwsWPTC\MarketplaceCatalog\MarketplaceCatalogClient createMarketplaceCatalog(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMarketplaceCatalog(array $args = [])
 * @method \AwsWPTC\MarketplaceCommerceAnalytics\MarketplaceCommerceAnalyticsClient createMarketplaceCommerceAnalytics(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMarketplaceCommerceAnalytics(array $args = [])
 * @method \AwsWPTC\MarketplaceEntitlementService\MarketplaceEntitlementServiceClient createMarketplaceEntitlementService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMarketplaceEntitlementService(array $args = [])
 * @method \AwsWPTC\MarketplaceMetering\MarketplaceMeteringClient createMarketplaceMetering(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMarketplaceMetering(array $args = [])
 * @method \AwsWPTC\MediaConnect\MediaConnectClient createMediaConnect(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaConnect(array $args = [])
 * @method \AwsWPTC\MediaConvert\MediaConvertClient createMediaConvert(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaConvert(array $args = [])
 * @method \AwsWPTC\MediaLive\MediaLiveClient createMediaLive(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaLive(array $args = [])
 * @method \AwsWPTC\MediaPackage\MediaPackageClient createMediaPackage(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaPackage(array $args = [])
 * @method \AwsWPTC\MediaPackageVod\MediaPackageVodClient createMediaPackageVod(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaPackageVod(array $args = [])
 * @method \AwsWPTC\MediaStore\MediaStoreClient createMediaStore(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaStore(array $args = [])
 * @method \AwsWPTC\MediaStoreData\MediaStoreDataClient createMediaStoreData(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaStoreData(array $args = [])
 * @method \AwsWPTC\MediaTailor\MediaTailorClient createMediaTailor(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMediaTailor(array $args = [])
 * @method \AwsWPTC\MigrationHub\MigrationHubClient createMigrationHub(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMigrationHub(array $args = [])
 * @method \AwsWPTC\MigrationHubConfig\MigrationHubConfigClient createMigrationHubConfig(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMigrationHubConfig(array $args = [])
 * @method \AwsWPTC\Mobile\MobileClient createMobile(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionMobile(array $args = [])
 * @method \AwsWPTC\Neptune\NeptuneClient createNeptune(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionNeptune(array $args = [])
 * @method \AwsWPTC\NetworkFirewall\NetworkFirewallClient createNetworkFirewall(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionNetworkFirewall(array $args = [])
 * @method \AwsWPTC\NetworkManager\NetworkManagerClient createNetworkManager(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionNetworkManager(array $args = [])
 * @method \AwsWPTC\NimbleStudio\NimbleStudioClient createNimbleStudio(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionNimbleStudio(array $args = [])
 * @method \AwsWPTC\OpsWorks\OpsWorksClient createOpsWorks(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionOpsWorks(array $args = [])
 * @method \AwsWPTC\OpsWorksCM\OpsWorksCMClient createOpsWorksCM(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionOpsWorksCM(array $args = [])
 * @method \AwsWPTC\Organizations\OrganizationsClient createOrganizations(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionOrganizations(array $args = [])
 * @method \AwsWPTC\Outposts\OutpostsClient createOutposts(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionOutposts(array $args = [])
 * @method \AwsWPTC\PI\PIClient createPI(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPI(array $args = [])
 * @method \AwsWPTC\Personalize\PersonalizeClient createPersonalize(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPersonalize(array $args = [])
 * @method \AwsWPTC\PersonalizeEvents\PersonalizeEventsClient createPersonalizeEvents(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPersonalizeEvents(array $args = [])
 * @method \AwsWPTC\PersonalizeRuntime\PersonalizeRuntimeClient createPersonalizeRuntime(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPersonalizeRuntime(array $args = [])
 * @method \AwsWPTC\Pinpoint\PinpointClient createPinpoint(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPinpoint(array $args = [])
 * @method \AwsWPTC\PinpointEmail\PinpointEmailClient createPinpointEmail(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPinpointEmail(array $args = [])
 * @method \AwsWPTC\PinpointSMSVoice\PinpointSMSVoiceClient createPinpointSMSVoice(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPinpointSMSVoice(array $args = [])
 * @method \AwsWPTC\Polly\PollyClient createPolly(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPolly(array $args = [])
 * @method \AwsWPTC\Pricing\PricingClient createPricing(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPricing(array $args = [])
 * @method \AwsWPTC\PrometheusService\PrometheusServiceClient createPrometheusService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionPrometheusService(array $args = [])
 * @method \AwsWPTC\Proton\ProtonClient createProton(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionProton(array $args = [])
 * @method \AwsWPTC\QLDB\QLDBClient createQLDB(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionQLDB(array $args = [])
 * @method \AwsWPTC\QLDBSession\QLDBSessionClient createQLDBSession(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionQLDBSession(array $args = [])
 * @method \AwsWPTC\QuickSight\QuickSightClient createQuickSight(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionQuickSight(array $args = [])
 * @method \AwsWPTC\RAM\RAMClient createRAM(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRAM(array $args = [])
 * @method \AwsWPTC\RDSDataService\RDSDataServiceClient createRDSDataService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRDSDataService(array $args = [])
 * @method \AwsWPTC\Rds\RdsClient createRds(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRds(array $args = [])
 * @method \AwsWPTC\Redshift\RedshiftClient createRedshift(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRedshift(array $args = [])
 * @method \AwsWPTC\RedshiftDataAPIService\RedshiftDataAPIServiceClient createRedshiftDataAPIService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRedshiftDataAPIService(array $args = [])
 * @method \AwsWPTC\Rekognition\RekognitionClient createRekognition(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRekognition(array $args = [])
 * @method \AwsWPTC\ResourceGroups\ResourceGroupsClient createResourceGroups(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionResourceGroups(array $args = [])
 * @method \AwsWPTC\ResourceGroupsTaggingAPI\ResourceGroupsTaggingAPIClient createResourceGroupsTaggingAPI(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionResourceGroupsTaggingAPI(array $args = [])
 * @method \AwsWPTC\RoboMaker\RoboMakerClient createRoboMaker(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRoboMaker(array $args = [])
 * @method \AwsWPTC\Route53\Route53Client createRoute53(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRoute53(array $args = [])
 * @method \AwsWPTC\Route53Domains\Route53DomainsClient createRoute53Domains(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRoute53Domains(array $args = [])
 * @method \AwsWPTC\Route53Resolver\Route53ResolverClient createRoute53Resolver(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionRoute53Resolver(array $args = [])
 * @method \AwsWPTC\S3\S3Client createS3(array $args = [])
 * @method \AwsWPTC\S3\S3MultiRegionClient createMultiRegionS3(array $args = [])
 * @method \AwsWPTC\S3Control\S3ControlClient createS3Control(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionS3Control(array $args = [])
 * @method \AwsWPTC\S3Outposts\S3OutpostsClient createS3Outposts(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionS3Outposts(array $args = [])
 * @method \AwsWPTC\SSMContacts\SSMContactsClient createSSMContacts(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSSMContacts(array $args = [])
 * @method \AwsWPTC\SSMIncidents\SSMIncidentsClient createSSMIncidents(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSSMIncidents(array $args = [])
 * @method \AwsWPTC\SSO\SSOClient createSSO(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSSO(array $args = [])
 * @method \AwsWPTC\SSOAdmin\SSOAdminClient createSSOAdmin(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSSOAdmin(array $args = [])
 * @method \AwsWPTC\SSOOIDC\SSOOIDCClient createSSOOIDC(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSSOOIDC(array $args = [])
 * @method \AwsWPTC\SageMaker\SageMakerClient createSageMaker(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSageMaker(array $args = [])
 * @method \AwsWPTC\SageMakerFeatureStoreRuntime\SageMakerFeatureStoreRuntimeClient createSageMakerFeatureStoreRuntime(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSageMakerFeatureStoreRuntime(array $args = [])
 * @method \AwsWPTC\SageMakerRuntime\SageMakerRuntimeClient createSageMakerRuntime(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSageMakerRuntime(array $args = [])
 * @method \AwsWPTC\SagemakerEdgeManager\SagemakerEdgeManagerClient createSagemakerEdgeManager(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSagemakerEdgeManager(array $args = [])
 * @method \AwsWPTC\SavingsPlans\SavingsPlansClient createSavingsPlans(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSavingsPlans(array $args = [])
 * @method \AwsWPTC\Schemas\SchemasClient createSchemas(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSchemas(array $args = [])
 * @method \AwsWPTC\SecretsManager\SecretsManagerClient createSecretsManager(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSecretsManager(array $args = [])
 * @method \AwsWPTC\SecurityHub\SecurityHubClient createSecurityHub(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSecurityHub(array $args = [])
 * @method \AwsWPTC\ServerlessApplicationRepository\ServerlessApplicationRepositoryClient createServerlessApplicationRepository(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionServerlessApplicationRepository(array $args = [])
 * @method \AwsWPTC\ServiceCatalog\ServiceCatalogClient createServiceCatalog(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionServiceCatalog(array $args = [])
 * @method \AwsWPTC\ServiceDiscovery\ServiceDiscoveryClient createServiceDiscovery(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionServiceDiscovery(array $args = [])
 * @method \AwsWPTC\ServiceQuotas\ServiceQuotasClient createServiceQuotas(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionServiceQuotas(array $args = [])
 * @method \AwsWPTC\Ses\SesClient createSes(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSes(array $args = [])
 * @method \AwsWPTC\SesV2\SesV2Client createSesV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSesV2(array $args = [])
 * @method \AwsWPTC\Sfn\SfnClient createSfn(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSfn(array $args = [])
 * @method \AwsWPTC\Shield\ShieldClient createShield(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionShield(array $args = [])
 * @method \AwsWPTC\Sms\SmsClient createSms(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSms(array $args = [])
 * @method \AwsWPTC\SnowBall\SnowBallClient createSnowBall(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSnowBall(array $args = [])
 * @method \AwsWPTC\Sns\SnsClient createSns(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSns(array $args = [])
 * @method \AwsWPTC\Sqs\SqsClient createSqs(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSqs(array $args = [])
 * @method \AwsWPTC\Ssm\SsmClient createSsm(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSsm(array $args = [])
 * @method \AwsWPTC\StorageGateway\StorageGatewayClient createStorageGateway(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionStorageGateway(array $args = [])
 * @method \AwsWPTC\Sts\StsClient createSts(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSts(array $args = [])
 * @method \AwsWPTC\Support\SupportClient createSupport(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSupport(array $args = [])
 * @method \AwsWPTC\Swf\SwfClient createSwf(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSwf(array $args = [])
 * @method \AwsWPTC\Synthetics\SyntheticsClient createSynthetics(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionSynthetics(array $args = [])
 * @method \AwsWPTC\Textract\TextractClient createTextract(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTextract(array $args = [])
 * @method \AwsWPTC\TimestreamQuery\TimestreamQueryClient createTimestreamQuery(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTimestreamQuery(array $args = [])
 * @method \AwsWPTC\TimestreamWrite\TimestreamWriteClient createTimestreamWrite(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTimestreamWrite(array $args = [])
 * @method \AwsWPTC\TranscribeService\TranscribeServiceClient createTranscribeService(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTranscribeService(array $args = [])
 * @method \AwsWPTC\Transfer\TransferClient createTransfer(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTransfer(array $args = [])
 * @method \AwsWPTC\Translate\TranslateClient createTranslate(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionTranslate(array $args = [])
 * @method \AwsWPTC\WAFV2\WAFV2Client createWAFV2(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWAFV2(array $args = [])
 * @method \AwsWPTC\Waf\WafClient createWaf(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWaf(array $args = [])
 * @method \AwsWPTC\WafRegional\WafRegionalClient createWafRegional(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWafRegional(array $args = [])
 * @method \AwsWPTC\WellArchitected\WellArchitectedClient createWellArchitected(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWellArchitected(array $args = [])
 * @method \AwsWPTC\WorkDocs\WorkDocsClient createWorkDocs(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWorkDocs(array $args = [])
 * @method \AwsWPTC\WorkLink\WorkLinkClient createWorkLink(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWorkLink(array $args = [])
 * @method \AwsWPTC\WorkMail\WorkMailClient createWorkMail(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWorkMail(array $args = [])
 * @method \AwsWPTC\WorkMailMessageFlow\WorkMailMessageFlowClient createWorkMailMessageFlow(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWorkMailMessageFlow(array $args = [])
 * @method \AwsWPTC\WorkSpaces\WorkSpacesClient createWorkSpaces(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionWorkSpaces(array $args = [])
 * @method \AwsWPTC\XRay\XRayClient createXRay(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionXRay(array $args = [])
 * @method \AwsWPTC\finspace\finspaceClient createfinspace(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionfinspace(array $args = [])
 * @method \AwsWPTC\imagebuilder\imagebuilderClient createimagebuilder(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionimagebuilder(array $args = [])
 * @method \AwsWPTC\kendra\kendraClient createkendra(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionkendra(array $args = [])
 * @method \AwsWPTC\mgn\mgnClient createmgn(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionmgn(array $args = [])
 * @method \AwsWPTC\signer\signerClient createsigner(array $args = [])
 * @method \AwsWPTC\MultiRegionClient createMultiRegionsigner(array $args = [])
 */
class Sdk
{
    const VERSION = '3.185.7';

    /** @var array Arguments for creating clients */
    private $args;

    /**
     * Constructs a new SDK object with an associative array of default
     * client settings.
     *
     * @param array $args
     *
     * @throws \InvalidArgumentException
     * @see AwsWPTC\AwsClient::__construct for a list of available options.
     */
    public function __construct(array $args = [])
    {
        $this->args = $args;

        if (!isset($args['handler']) && !isset($args['http_handler'])) {
            $this->args['http_handler'] = default_http_handler();
        }
    }

    public function __call($name, array $args)
    {
        $args = isset($args[0]) ? $args[0] : [];
        if (strpos($name, 'createMultiRegion') === 0) {
            return $this->createMultiRegionClient(substr($name, 17), $args);
        }

        if (strpos($name, 'create') === 0) {
            return $this->createClient(substr($name, 6), $args);
        }

        throw new \BadMethodCallException("Unknown method: {$name}.");
    }

    /**
     * Get a client by name using an array of constructor options.
     *
     * @param string $name Service name or namespace (e.g., DynamoDb, s3).
     * @param array  $args Arguments to configure the client.
     *
     * @return AwsClientInterface
     * @throws \InvalidArgumentException if any required options are missing or
     *                                   the service is not supported.
     * @see AwsWPTC\AwsClient::__construct for a list of available options for args.
     */
    public function createClient($name, array $args = [])
    {
        // Get information about the service from the manifest file.
        $service = manifest($name);
        $namespace = $service['namespace'];

        // Instantiate the client class.
        $client = "AwsWPTC\\{$namespace}\\{$namespace}Client";
        return new $client($this->mergeArgs($namespace, $service, $args));
    }

    public function createMultiRegionClient($name, array $args = [])
    {
        // Get information about the service from the manifest file.
        $service = manifest($name);
        $namespace = $service['namespace'];

        $klass = "AwsWPTC\\{$namespace}\\{$namespace}MultiRegionClient";
        $klass = class_exists($klass) ? $klass : 'AwsWPTC\\MultiRegionClient';

        return new $klass($this->mergeArgs($namespace, $service, $args));
    }

    /**
     * Clone existing SDK instance with ability to pass an associative array
     * of extra client settings.
     *
     * @param array $args
     *
     * @return self
     */
    public function copy(array $args = [])
    {
        return new self($args + $this->args);
    }

    private function mergeArgs($namespace, array $manifest, array $args = [])
    {
        // Merge provided args with stored, service-specific args.
        if (isset($this->args[$namespace])) {
            $args += $this->args[$namespace];
        }

        // Provide the endpoint prefix in the args.
        if (!isset($args['service'])) {
            $args['service'] = $manifest['endpoint'];
        }

        return $args + $this->args;
    }

    /**
     * Determine the endpoint prefix from a client namespace.
     *
     * @param string $name Namespace name
     *
     * @return string
     * @internal
     * @deprecated Use the `\AwsWPTC\manifest()` function instead.
     */
    public static function getEndpointPrefix($name)
    {
        return manifest($name)['endpoint'];
    }
}
