/**
 * WordPress dependencies
 */
import { memo } from '@wordpress/element';

const AwsIcon = memo(() => (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512">
		<path d="M180.4 203c-.7 22.7 10.6 32.7 10.9 39.1a8.2 8.2 0 0 1 -4.1 6.3l-12.8 9a10.7 10.7 0 0 1 -5.6 1.9c-.4 0-8.2 1.8-20.5-25.6a78.6 78.6 0 0 1 -62.6 29.5c-16.3 .9-60.4-9.2-58.1-56.2-1.6-38.3 34.1-62.1 70.9-60.1 7.1 0 21.6 .4 47 6.3v-15.6c2.7-26.5-14.7-47-44.8-43.9-2.4 0-19.4-.5-45.8 10.1-7.4 3.4-8.3 2.8-10.8 2.8-7.4 0-4.4-21.5-2.9-24.2 5.2-6.4 35.9-18.4 65.9-18.2a76.9 76.9 0 0 1 55.7 17.3 70.3 70.3 0 0 1 17.7 52.4v69.3zM94 235.4c32.4-.5 46.2-20 49.3-30.5 2.5-10.1 2.1-16.4 2.1-27.4-9.7-2.3-23.6-4.9-39.6-4.9-15.2-1.1-42.8 5.6-41.7 32.3-1.2 16.8 11.1 31.4 30 30.5zm170.9 23.1c-7.9 .7-11.5-4.9-12.7-10.4l-49.8-164.7c-1-2.8-1.6-5.7-1.9-8.6a4.6 4.6 0 0 1 3.9-5.3c.2 0-2.1 0 22.3 0 8.8-.9 11.6 6 12.6 10.4l35.7 140.8 33.2-140.8c.5-3.2 2.9-11.1 12.8-10.2h17.2c2.2-.2 11.1-.5 12.7 10.4l33.4 142.6L421 80.1c.5-2.2 2.7-11.4 12.7-10.4h19.7c.9-.1 6.2-.8 5.3 8.6-.4 1.9 3.4-10.7-52.8 169.9-1.2 5.5-4.8 11.1-12.7 10.4h-18.7c-10.9 1.2-12.5-9.7-12.7-10.8L328.7 110.7l-32.8 137c-.2 1.1-1.7 11.9-12.7 10.8h-18.3zm273.5 5.6c-5.9 0-33.9-.3-57.4-12.3a12.8 12.8 0 0 1 -7.8-11.9v-10.8c0-8.5 6.2-6.9 8.8-5.9 10 4.1 16.5 7.1 28.8 9.6 36.7 7.5 52.8-2.3 56.7-4.5 13.2-7.8 14.2-25.7 5.3-35-10.5-8.8-15.5-9.1-53.1-21-4.6-1.3-43.7-13.6-43.8-52.4-.6-28.2 25.1-56.2 69.5-56 12.7 0 46.4 4.1 55.6 15.6 1.4 2.1 2 4.6 1.9 7v10.1c0 4.4-1.6 6.7-4.9 6.7-7.7-.9-21.4-11.2-49.2-10.8-6.9-.4-39.9 .9-38.4 25-.4 19 26.6 26.1 29.7 26.9 36.5 11 48.7 12.8 63.1 29.6 17.1 22.3 7.9 48.3 4.4 55.4-19.1 37.5-68.4 34.4-69.3 34.4zm40.2 104.9c-70 51.7-171.7 79.3-258.5 79.3A469.1 469.1 0 0 1 2.8 327.5c-6.5-5.9-.8-14 7.2-9.5a637.4 637.4 0 0 0 316.9 84.1 630.2 630.2 0 0 0 241.6-49.6c11.8-5 21.8 7.8 10.1 16.4zm29.2-33.3c-9-11.5-59.3-5.4-81.8-2.7-6.8 .8-7.9-5.1-1.8-9.5 40.1-28.2 105.9-20.1 113.4-10.6 7.6 9.5-2.1 75.4-39.6 106.9-5.8 4.9-11.3 2.3-8.7-4.1 8.4-21.3 27.4-68.5 18.4-80z" />
	</svg>
));

const BrevoIcon = memo(() => (
	<svg
		width="40"
		viewBox="0 0 1000 295"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M820.28 182.338C820.28 137.755 848.604 106.4 888.892 106.4C929.18 106.4 957.956 137.737 957.956 182.338C957.956 226.939 929.187 256.5 888.892 256.5C848.598 256.5 820.28 225.588 820.28 182.338ZM778.224 182.338C778.224 248.12 824.262 294.479 888.886 294.479C953.51 294.479 1000 248.12 1000 182.338C1000 116.556 953.962 68.4399 888.886 68.4399C823.81 68.4399 778.224 115.686 778.224 182.338ZM563.521 71.0853L650.292 291.821H691.025L777.791 71.0853H733.966L671.104 241.498H670.214L607.352 71.0853H563.521ZM394.856 174.383C397.508 133.76 424.515 106.4 461.261 106.4C493.128 106.4 517.037 126.712 520.58 157.179H447.089C420.973 157.179 406.801 160.269 396.191 174.402H394.856V174.39V174.383ZM352.805 181.006C352.805 246.788 399.289 294.46 463.468 294.46C506.854 294.46 544.916 272.391 561.295 237.502L525.885 219.835C513.494 242.792 489.585 256.482 463.468 256.482C432.028 256.482 403.704 232.637 403.704 209.679C403.704 197.766 411.673 192.457 423.18 192.457H563.502V180.544C563.502 114.317 521.007 68.4029 459.925 68.4029C398.844 68.4029 352.799 115.649 352.799 180.988M232.399 291.796H272.242V156.285C272.242 127.149 290.382 106.394 315.627 106.394C326.256 106.394 337.311 109.927 342.635 114.774C346.623 104.174 352.818 93.5923 362.111 82.9924C351.482 74.1684 333.342 68.4153 315.627 68.4153C266.937 68.4153 232.399 104.618 232.399 156.267V291.809V291.796ZM39.843 145.698V37.9598H105.358C127.486 37.9598 142.103 50.7611 142.103 70.185C142.103 92.2542 123.072 109.033 84.1191 121.834C57.5571 130.214 45.6116 137.281 41.1785 145.679L39.843 145.692V145.698ZM39.843 253.861V208.835C39.843 188.967 56.6668 169.543 80.1311 162.032C100.943 154.966 118.193 147.899 132.81 140.407C152.286 151.895 164.232 171.744 164.232 192.5C164.232 227.814 130.584 253.861 84.9909 253.861H39.843ZM0 291.821H88.5337C155.829 291.821 206.282 249.884 206.282 194.257C206.282 163.79 190.794 136.43 163.341 118.763C177.513 104.63 184.153 88.2955 184.153 68.4276C184.153 27.3784 154.493 0 109.791 0H0V291.821Z"
			fill="#0B996E"
		/>
	</svg>
));

const Logo = memo(() => (
	<svg
		width="120"
		height="120"
		viewBox="0 0 160 160"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<circle cx="80" cy="80" r="80" fill="#6817C5" />
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M40.246 53.9952L79.7414 88.2759L119.753 53.9924C119.189 52.4669 117.722 51.3794 116 51.3794H44C42.2774 51.3794 40.8092 52.4682 40.246 53.9952ZM120 55.8578L79.7414 94.1379L40 55.8589V104.621C40 106.83 41.7909 108.621 44 108.621H116C118.209 108.621 120 106.83 120 104.621V55.8578Z"
			fill="white"
		/>
		<path
			d="M64.4828 79.3965L40.6897 108.621H119.31L95.2587 79.3965L79.7414 94.1379L64.4828 79.3965Z"
			fill="#D9D9D9"
			fillOpacity="0.5"
		/>
	</svg>
));

const LogoHeader = memo(() => (
	<svg
		height="25"
		viewBox="0 0 775 160"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<circle cx="80" cy="80" r="80" fill="#6817C5" />
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M40.246 53.9952L79.7414 88.2759L119.753 53.9924C119.189 52.4669 117.722 51.3794 116 51.3794H44C42.2774 51.3794 40.8092 52.4682 40.246 53.9952ZM120 55.8578L79.7414 94.1379L40 55.8589V104.621C40 106.83 41.7909 108.621 44 108.621H116C118.209 108.621 120 106.83 120 104.621V55.8578Z"
			fill="white"
		/>
		<path
			d="M64.4827 79.3965L40.6896 108.621H119.31L95.2586 79.3965L79.7414 94.1379L64.4827 79.3965Z"
			fill="#D9D9D9"
			fillOpacity="0.5"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M214.02 117.246L214.014 117.242C206.167 111.896 202.202 103.929 202.033 93.6467L202 91.6229H223.243L223.336 93.5163C223.544 97.7508 225.327 100.804 228.728 102.913C232.288 105.12 237.218 106.318 243.688 106.318H245.599C252.291 106.318 256.672 105.394 259.123 103.87C261.673 102.285 262.604 100.576 262.604 98.7512C262.604 96.7497 261.774 95.1454 259.869 93.8116L259.856 93.8025L259.843 93.7931C257.929 92.4069 254.417 91.1889 248.989 90.3237L248.978 90.322L235.953 88.171C226.252 86.5541 218.832 83.8051 213.974 79.7277L213.967 79.722L213.961 79.7163C209.022 75.4963 206.692 69.3356 206.692 61.5963C206.692 56.8885 208.051 52.4877 210.725 48.4336C213.455 44.2944 217.658 41.0529 223.163 38.6323C228.761 36.0903 235.795 34.875 244.166 34.875C256.051 34.875 265.676 37.3959 272.82 42.6669C279.988 47.8746 284.009 55.0923 284.856 64.1588L285.06 66.3352H263.81L263.577 64.6097C263.1 61.0637 261.372 58.3971 258.286 56.4772C255.12 54.5066 250.785 53.4326 245.121 53.4326H243.21C237.552 53.4326 233.493 54.2927 230.817 55.7986C228.156 57.3422 227.281 58.9393 227.281 60.5211C227.281 62.9112 228.108 64.4274 229.62 65.4351C231.424 66.6381 234.441 67.6933 238.881 68.4734L252.251 70.6221C262.237 72.2458 269.981 75.2877 275.233 79.9373C280.545 84.6393 283.192 90.7701 283.192 98.1539C283.192 106.741 279.75 113.504 272.887 118.196L272.882 118.199C266.201 122.739 256.74 124.875 244.763 124.875C232.027 124.875 221.715 122.405 214.026 117.25L214.02 117.246Z"
			fill="black"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M295.257 109.383L295.247 109.367C292.075 104.309 290.522 98.4367 290.522 91.822C290.522 85.2082 292.075 79.3686 295.255 74.3839L295.26 74.3766C298.493 69.356 302.92 65.4919 308.49 62.7914C314.063 60.0892 320.463 58.7689 327.637 58.7689C334.812 58.7689 341.211 60.0892 346.785 62.7914C352.352 65.4909 356.742 69.3554 359.898 74.38C363.158 79.3637 364.752 85.2051 364.752 91.822C364.752 98.4449 363.155 104.323 359.898 109.382C356.74 114.332 352.349 118.155 346.785 120.852C341.211 123.555 334.812 124.875 327.637 124.875C320.463 124.875 314.063 123.555 308.49 120.852C302.928 118.156 298.503 114.338 295.268 109.4L295.257 109.383ZM336.851 77.5681L336.821 77.5513C334.446 76.2245 331.683 75.5344 328.473 75.5344H326.801C323.593 75.5344 320.779 76.2242 318.313 77.5631L318.304 77.568L318.294 77.5729C315.921 78.8294 314.039 80.6365 312.628 83.0351C311.25 85.377 310.513 88.2772 310.513 91.822C310.513 95.2719 311.244 98.182 312.634 100.62C314.044 103.012 315.927 104.86 318.304 106.195C320.771 107.457 323.589 108.11 326.801 108.11H328.473C331.696 108.11 334.471 107.453 336.851 106.195C339.316 104.855 341.235 103.005 342.64 100.62C344.031 98.1818 344.761 95.2717 344.761 91.822C344.761 88.2772 344.024 85.377 342.647 83.0351C341.244 80.6512 339.333 78.8447 336.881 77.5838L336.851 77.5681Z"
			fill="black"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M373.828 123.68V36.0697H393.7V123.68H373.828Z"
			fill="black"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M405.534 61.9547H425.406V123.68H405.534V61.9547Z"
			fill="black"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M450.145 120.949L450.133 120.943C445.106 118.302 441.096 114.502 438.124 109.576L438.12 109.57L438.116 109.563C435.116 104.505 433.656 98.5657 433.656 91.822C433.656 84.7116 435.103 78.6331 438.127 73.7033C441.104 68.7724 445.127 65.0424 450.175 62.56C455.244 60.0264 460.766 58.7689 466.709 58.7689C472.548 58.7689 477.524 59.6702 481.538 61.5881C483.667 62.585 485.554 63.7218 487.178 65.008V36.0697H507.05V123.68H487.178V118.945C485.393 120.33 483.314 121.497 480.962 122.457L480.946 122.464L480.929 122.47C476.76 124.087 472.089 124.875 466.948 124.875C460.842 124.875 455.229 123.576 450.145 120.949ZM484.949 100.84L484.953 100.833C486.406 98.4117 487.178 95.4365 487.178 91.822C487.178 88.117 486.402 85.1563 484.967 82.8329L484.955 82.8147L484.944 82.7962C483.548 80.4214 481.649 78.6648 479.22 77.4847L479.189 77.4696L479.158 77.4534C476.776 76.1923 473.998 75.5344 470.771 75.5344H469.099C464.455 75.5344 460.794 76.9681 457.945 79.7472L457.936 79.756L457.927 79.7647C455.168 82.3889 453.647 86.2976 453.647 91.822C453.647 97.3374 455.164 101.297 457.936 104.007C460.781 106.709 464.445 108.11 469.099 108.11H470.771C474.011 108.11 476.801 107.486 479.189 106.294C481.636 105.033 483.544 103.229 484.944 100.848L484.949 100.84Z"
			fill="black"
		/>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M415.124 55.7588C408.443 55.7588 403.834 51.1499 403.834 45.4645C403.834 39.7792 408.443 35.1703 415.124 35.1703H415.601C422.282 35.1703 426.891 39.7792 426.891 45.4645C426.891 51.1499 422.282 55.7588 415.601 55.7588H415.124Z"
			fill="black"
		/>
		<path
			d="M593.875 115.875L630.125 36.375H645.375V123.875H636.25V43.375L599.625 123.875H587.875L551.375 43.75V123.875H542.25V36.375H557.625L593.875 115.875Z"
			fill="black"
		/>
		<path
			d="M685.653 125.125C669.903 125.125 661.778 117.25 661.778 106.5C661.778 93.75 672.153 88.5 685.278 87.625L711.528 86.125V83.625C711.528 73 704.278 67.25 692.278 67.25H690.278C680.653 67.25 673.403 71.75 672.278 78.875H663.528C664.778 68.125 675.778 60.125 691.278 60.125C710.028 60.125 720.028 69.875 720.028 83.875V110.125C720.028 113.875 720.403 119.5 720.903 123.875H713.028C712.403 120.75 712.153 115.625 712.153 113.75C708.528 119.625 699.153 125.125 685.653 125.125ZM686.528 118H688.278C699.153 118 711.528 111 711.528 98.625V93.125L689.278 94.25C675.278 95.125 670.403 99.25 670.403 106C670.403 113.125 675.028 118 686.528 118Z"
			fill="black"
		/>
		<path
			d="M747.61 50.125H737.86V39.5H747.61V50.125ZM747.11 123.875H738.61V61.375H747.11V123.875Z"
			fill="black"
		/>
		<path
			d="M774.884 123.875H766.384V36.375H774.884V123.875Z"
			fill="black"
		/>
	</svg>
));

const MailGunIcon = memo(() => (
	<svg
		version="1.1"
		xmlns="http://www.w3.org/2000/svg"
		xmlnsXlink="http://www.w3.org/1999/xlink"
		x="0px"
		y="0px"
		viewBox="0 0 1000 1000"
		xmlSpace="preserve"
	>
		<style type="text/css">{`.st0{fill:#C12126;}`}</style>
		<path
			className="st0"
			d="M493,305.7c-88.9,0-161,72.1-161,161c0,88.9,72.1,161,161,161c88.9,0,161-72.1,161-161  C654,377.8,582,305.7,493,305.7z M242,466.7c0-138.7,112.4-251,251-251c138.7,0,251.1,112.4,251.1,251c0,9.2-0.5,18.2-1.4,27.1  c-1.9,24.5,16.1,43.2,40.4,43.2c41.3,0,45.7-53.2,45.7-70.3c0-185.4-150.3-335.6-335.6-335.6S157.4,281.4,157.4,466.7  c0,185.4,150.3,335.6,335.6,335.6c98.4,0,187-42.4,248.4-109.9l69,57.9c-77.9,87.1-191.3,142-317.4,142  c-235.1,0-425.7-190.6-425.7-425.7S257.9,41,493,41c235.1,0,425.7,190.6,425.7,425.7c0,94.5-45,171.2-135.4,171.2  c-39.8,0-64-18.2-77.2-38.6C661.9,670.5,583,717.8,493,717.8C354.4,717.8,242,605.4,242,466.7z M493,393.1c40.7,0,73.7,33,73.7,73.7  c0,40.7-33,73.7-73.7,73.7c-40.7,0-73.7-33-73.7-73.7S452.3,393.1,493,393.1z"
		/>
	</svg>
));

const MailIcon = memo(() => (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		width="40"
		height="40"
		fill="none"
		viewBox="0 0 24 24"
	>
		<path
			d="M18 6.75H6C5.30964 6.75 4.75 7.30964 4.75 8V16C4.75 16.6904 5.30964 17.25 6 17.25H18C18.6904 17.25 19.25 16.6904 19.25 16V8C19.25 7.30964 18.6904 6.75 18 6.75Z"
			stroke="#1E1E1E"
			strokeWidth="1.5"
		/>
		<path d="M5 7L12 13L19 7" stroke="#1E1E1E" strokeWidth="1.5" />
	</svg>
));

const SendGridIcon = memo(() => (
	<svg xmlns="http://www.w3.org/2000/svg" id="Sendgrid" viewBox="0 0 32 32">
		<defs>
			<style>
				{`.cls-1 {
          fill: #51a9e3;
        }`}
			</style>
		</defs>
		<g id="Icon_Updated_Keylines" data-name="Icon, Updated Keylines">
			<path
				className="cls-1"
				d="m21,1h-8c-1.1,0-2,.9-2,2v6c0,1.1.9,2,2,2h6c1.1,0,2,.9,2,2v6c0,1.1.9,2,2,2h6c1.1,0,2-.9,2-2V2c0-.55-.45-1-1-1h-9Z"
			/>
			<path
				className="cls-1"
				d="m11,31h8c1.1,0,2-.9,2-2v-6c0-1.1-.9-2-2-2h-6c-1.1,0-2-.9-2-2v-6c0-1.1-.9-2-2-2H3c-1.1,0-2,.9-2,2v17c0,.55.45,1,1,1h9Z"
			/>
		</g>
	</svg>
));

const PostmarkIcon = memo(() => (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		xmlnsXlink="http://www.w3.org/1999/xlink"
		width="40"
		viewBox="0 0 64 64"
	>
		<defs>
			<path
				id="A"
				d="M128 117v6a5 5 0 0 0-5 5h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0h-6a5 5 0 1 0-10 0H5a5 5 0 0 0-5-5v-6a5 5 0 1 0 0-10v-6a5 5 0 0 0 0-10v-6a5 5 0 0 0 0-10v-6a5 5 0 0 0 0-10v-6a5 5 0 0 0 0-10v-6a5 5 0 0 0 0-10v-6a5 5 0 0 0 0-10V5a5 5 0 0 0 5-5h6a5 5 0 0 0 10 0h6a5 5 0 0 0 10 0h6a5 5 0 0 0 10 0h6a5 5 0 0 0 10 0h6a5 5 0 0 0 10 0h6a5 5 0 0 0 10 0h6a5 5 0 1 0 10 0h6a5 5 0 0 0 5 5v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10v6a5 5 0 1 0 0 10z"
			/>
			<rect id="B" width="96" height="96" x="16" y="16" rx="2" />
		</defs>
		<g
			transform="matrix(.492308 0 0 .492308 .492308 .492308)"
			fill="none"
			fillRule="evenodd"
		>
			<use xlinkHref="#A" fill="#f0f0f0" />
			<path
				d="M128.5 116.5v7h-.5a4.5 4.5 0 0 0-4.5 4.5v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-9 0v.5h-7v-.5a4.5 4.5 0 0 0-4.5-4.5h-.5v-7H0a4.5 4.5 0 0 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0a4.5 4.5 0 1 0 0-9h-.5v-7H0A4.5 4.5 0 0 0 4.5 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 1 0 9 0v-.5h7V0a4.5 4.5 0 0 0 9 0v-.5h7V0a4.5 4.5 0 0 0 4.5 4.5h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9h.5v7h-.5a4.5 4.5 0 0 0 0 9z"
				stroke="#ccc"
			/>
			<path
				d="M127.5 117.478a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956v-5.044a5.5 5.5 0 0 1 0-10.956V5.478A5.502 5.502 0 0 1 122.522.5h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0h-5.044a5.5 5.5 0 0 1-10.956 0H5.478A5.502 5.502 0 0 1 .5 5.478v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.5 5.5 0 0 1 0 10.956v5.044a5.502 5.502 0 0 1 4.978 4.978h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.5 5.5 0 0 1 10.956 0h5.044a5.502 5.502 0 0 1 4.978-4.978z"
				stroke="#fff"
			/>
			<use xlinkHref="#B" fill="#fedd00" />
			<rect
				width="95"
				height="95"
				x="16.5"
				y="16.5"
				rx="2"
				stroke="#d9b500"
			/>
			<rect
				width="97"
				height="97"
				x="15.5"
				y="15.5"
				rx="2"
				stroke="#fff"
			/>
			<path
				d="M50.3 86.084V42.3H43V35h25.886c16.168 0 19.522 10.664 19.522 18.06 0 5.934-2.408 10.492-4.902 12.986-4.042 4.042-9.546 4.988-17.888 4.988h-6.536v15.05h7.654v7.3H43v-7.3zm8.772-22.102h7.3c10.75 0 13.072-4.988 13.072-11.008 0-6.88-3.87-10.664-10.32-10.664H59.082z"
				fill="#000"
			/>
		</g>
	</svg>
));

export {
	AwsIcon,
	BrevoIcon,
	Logo,
	LogoHeader,
	MailGunIcon,
	MailIcon,
	SendGridIcon,
	PostmarkIcon,
};
