<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malai;

class MalwareScan extends Base {

	public const API_ENDPOINT = 'scan';
	public const REQUEST_TYPE = 'POST';

	public function scan( string $filename, string $content, string $codeType ) :?string {
		$req = $this->getRequestVO();
		$req->file_name = $filename;
		$req->file_content = $content;
		$req->code_type = $codeType;
		return $this->query()[ 'status' ] ?? null;
	}
}