<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malai;

class MalwareReport extends Base {

	public const API_ENDPOINT = 'report';
	public const REQUEST_TYPE = 'POST';

	public function report( array $reports ) :bool {
		$success = true;
		if ( !empty( $reports ) ) {
			$req = $this->getRequestVO();
			$req->reports = \array_values( $reports ); // ensures it hits the API as type 'array'
			$result = $this->query();
			$success = !empty( $result ) && ( $result[ 'error' ] ?? true ) !== false;
		}
		return $success;
	}
}