<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Tables\DataTables\Build\Scans;

use FernleafSystems\Wordpress\Plugin\Shield\Scans;

class ForMalware extends BaseForScan {

	protected function getColumnsToDisplay() :array {
		return [
			'rid',
			'status_file_type',
			'status_file_size',
			'file_as_href',
			'mal_sig',
			'mal_details',
			'detected',
			'actions',
		];
	}

	protected function getColumnDefs() :array {
		$colDefs = parent::getColumnDefs();
		$colDefs[ 'mal_sig' ] = [
			'data'        => 'mal_sig',
			'title'       => __( 'Pattern Detected' ),
			'className'   => 'mal_sig',
			'orderable'   => false,
			'searchable'  => false,
			'visible'     => false,
			'searchPanes' => [
				'show' => false
			],
		];
		$colDefs[ 'mal_details' ] = [
			'data'        => 'mal_details',
			'title'       => __( 'Malware Details' ),
			'className'   => 'mal_details',
			'orderable'   => false,
			'searchable'  => false,
			'visible'     => true,
			'searchPanes' => [
				'show' => false
			],
		];
		return $colDefs;
	}
}