<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Includes the files needed for the Backup/Restore admin area
 *
 */
function wpsbc_include_files_admin_backup() {

	// Get legend admin dir path
	$dir_path = plugin_dir_path( __FILE__ );

	// Include actions
	if( file_exists( $dir_path . 'functions-actions-backup.php' ) )
		include $dir_path . 'functions-actions-backup.php';

	// Include submenu page
	if( file_exists( $dir_path . 'class-submenu-page-backup.php' ) )
		include $dir_path . 'class-submenu-page-backup.php';

}
add_action( 'wpsbc_include_files', 'wpsbc_include_files_admin_backup' );


/**
 * Register the Backup/Restore admin submenu page
 *
 */
function wpsbc_register_submenu_page_backup( $submenu_pages ) {

	if( ! is_array( $submenu_pages ) )
		return $submenu_pages;

	$submenu_pages['backup'] = array(
		'class_name' => 'WPSBC_Submenu_Page_Backup',
		'data' 		 => array(
			'page_title' => __( 'Backup/Restore', 'wp-simple-booking-calendar' ),
			'menu_title' => __( 'Backup/Restore', 'wp-simple-booking-calendar' ),
			'capability' => apply_filters( 'wpsbc_submenu_page_capability_backup', 'manage_options' ),
			'menu_slug'  => 'wpsbc-backup'
		)
	);

	return $submenu_pages;

}
add_filter( 'wpsbc_register_submenu_page', 'wpsbc_register_submenu_page_backup', 75 );