/**
 * Creates a new object with the same keys as the original object, but without the excluded keys.
 * @param source original object
 * @param excluded keys to remove from the original object
 * @returns the new object
 */
export declare function omit<TSource extends Record<string, unknown>, TExcluded extends keyof TSource>(source: TSource, excluded: TExcluded[]): Omit<TSource, TExcluded>;
