import type { AlgoliaSearchHelper, SearchParameters } from 'algoliasearch-helper';
/**
 * Clears the refinements of a SearchParameters object based on rules provided.
 * The included attributes list is applied before the excluded attributes list. If the list
 * is not provided, this list of all the currently refined attributes is used as included attributes.
 * @returns search parameters with refinements cleared
 */
export declare function clearRefinements({ helper, attributesToClear, }: {
    helper: AlgoliaSearchHelper;
    attributesToClear?: string[];
}): SearchParameters;
