<?php
/**
 * Autocomplete config admin template partial.
 *
 * @author  WebDevStudios <contact@webdevstudios.com>
 * @since   1.0.0
 *
 * @package WebDevStudios\WPSWA
 */

?>

<p class="description" id="home-description">
	<?php esc_html_e( 'Configure the indices you want to display in the autocomplete search dropdown menu.', 'wp-search-with-algolia' ); ?>
	<br />
	<?php esc_html_e( 'Use the `Max. Suggestions` column to configure the number of results displayed by section.', 'wp-search-with-algolia' ); ?>
	<br />
	<?php esc_html_e( 'Use drag and drop to control the order of the sections in the autocomplete search dropdown menu.', 'wp-search-with-algolia' ); ?>
</p>
<table class="widefat table-autocomplete striped">
	<thead>
		<tr>
			<th style="width: 20px;"></th>
			<th style="width: 75px;"><?php esc_html_e( 'Enable', 'wp-search-with-algolia' ); ?></th>
			<th><?php esc_html_e( 'Index', 'wp-search-with-algolia' ); ?></th>
			<th><?php esc_html_e( 'Label', 'wp-search-with-algolia' ); ?></th>
			<th style="width: 75px;"><?php esc_html_e( 'Max. Suggestions', 'wp-search-with-algolia' ); ?></th>
			<th><?php esc_html_e( 'Actions', 'wp-search-with-algolia' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		$prefix = $this->settings->get_index_name_prefix(); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
		foreach ( $indices as $index ) : // phpcs:ignore -- This is an admin partial.  ?>
		<tr>
			<td>
				<span class="dashicons dashicons-move"></span>
				<input type="hidden" class="position-input" name="algolia_autocomplete_config[<?php echo esc_attr( $index['index_id'] ); ?>][position]"  value="<?php echo (int) $index['position']; ?>" />
			</td>
			<td>
				<input type="checkbox" name="algolia_autocomplete_config[<?php echo esc_attr( $index['index_id'] ); ?>][enabled]" <?php echo $index['enabled'] ? 'checked="checked"' : ''; ?>/>
			</td>
			<td>
				<?php echo esc_html( $index['admin_name'] ); ?><br>
				<small>
					<?php
					printf(
						// translators: placeholder is the name of an Algolia search index.
						esc_html__( 'Index name: %s', 'wp-search-with-algolia' ),
						esc_html( $index['index_id'] )
					);
					?>
				</small><br/>
				<small>
					<?php
					printf(
					// translators: placeholder is the name of an Algolia search index.
						esc_html__( 'Prefixed: %1$s%2$s', 'wp-search-with-algolia' ),
						esc_html( $prefix ),
						esc_html( $index['index_id'] )
					);
					?>
				</small>
				<?php if ( $index['debounce'] > 0 ) : ?>
					<br /><small>
						<?php
						printf(
							// translators: placeholder is the custom debounce value.
							esc_html__( 'Custom debounce timing: %s ms', 'wp-search-with-algolia' ),
							esc_html( $index['debounce'] )
						);
						?>
					</small>
				<?php endif; ?>
			</td>
			<td>
				<input type="text" name="algolia_autocomplete_config[<?php echo esc_attr( $index['index_id'] ); ?>][label]"  value="<?php echo esc_attr( $index['label'] ); ?>" />
			</td>
			<td>
				<input type="number" class="small-text" name="algolia_autocomplete_config[<?php echo esc_attr( $index['index_id'] ); ?>][max_suggestions]"  value="<?php echo (int) $index['max_suggestions']; ?>" />
			</td>
			<td>
				<button type="button" class="algolia-reindex-button button button-primary" data-index="<?php echo esc_attr( $index['index_id'] ); ?>"><?php esc_html_e( 'Re-index', 'wp-search-with-algolia' ); ?></button>
				<button type="button" class="algolia-push-settings-button button" data-index="<?php echo esc_attr( $index['index_id'] ); ?>"><?php esc_html_e( 'Push Settings', 'wp-search-with-algolia' ); ?></button>
			</td>
		</tr>
		<?php endforeach; ?>
	</tbody>
</table>
<p class="description" id="home-description">
	<?php esc_html_e( 'Configure the indices you want to display in the autocomplete search dropdown menu.', 'wp-search-with-algolia' ); ?>
	<br />
	<?php esc_html_e( 'Use the `Max. Suggestions` column to configure the number of results displayed by section.', 'wp-search-with-algolia' ); ?>
	<br />
	<?php esc_html_e( 'Use drag and drop to control the order of the sections in the autocomplete search dropdown menu.', 'wp-search-with-algolia' ); ?>
</p>
