const LogoFree = ( { className, ...props } ) => {
    return (
        <svg className={ className } viewBox="0 0 924 159" xmlns="http://www.w3.org/2000/svg" fill="none" { ...props }>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0 79.5C0 40.0116 32.0116 8 71.5 8C110.988 8 143 40.0116 143 79.5C143 92.7979 139.37 105.248 133.046 115.913C127.362 102.535 117.719 91.2443 105.588 83.5121C105.741 82.196 105.82 80.8572 105.82 79.5C105.82 60.5456 90.4544 45.18 71.5 45.18C52.7323 45.18 37.483 60.2444 37.1845 78.941C20.0073 86.9002 6.52154 101.477 0 119.399V79.5Z"
                fill="url(#paint0)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M143 79.5C143 118.988 110.988 151 71.5 151C32.0116 151 0 118.988 0 79.5C0 66.2021 3.63023 53.7521 9.95374 43.087C15.6379 56.4653 25.2807 67.7557 37.412 75.4879C37.2588 76.804 37.18 78.1428 37.18 79.5C37.18 98.4544 52.5456 113.82 71.5 113.82C90.2677 113.82 105.517 98.7556 105.816 80.059C122.993 72.0998 136.478 57.5229 143 39.6009V79.5Z"
                fill="url(#paint1)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M71.5 8C32.0116 8 0 40.0116 0 79.5V151H71.5C110.988 151 143 118.988 143 79.5C143 40.0116 110.988 8 71.5 8ZM71.5 45.18C52.5456 45.18 37.18 60.5456 37.18 79.5L37.18 113.82H71.5C90.4544 113.82 105.82 98.4544 105.82 79.5C105.82 60.5456 90.4544 45.18 71.5 45.18Z"
                fill="url(#paint2)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M71.5 151C110.988 151 143 118.988 143 79.5V8H71.5C32.0116 8 0 40.0116 0 79.5C0 118.988 32.0116 151 71.5 151ZM71.5 113.82C90.4544 113.82 105.82 98.4544 105.82 79.5L105.82 45.18H71.5C52.5456 45.18 37.18 60.5456 37.18 79.5C37.18 98.4544 52.5456 113.82 71.5 113.82Z"
                fill="url(#paint3)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M71.5 8C32.0116 8 0 40.0116 0 79.5V151H71.5C110.988 151 143 118.988 143 79.5C143 40.0116 110.988 8 71.5 8ZM71.5 45.18C52.5456 45.18 37.18 60.5456 37.18 79.5L37.18 113.82H71.5C90.4544 113.82 105.82 98.4544 105.82 79.5C105.82 60.5456 90.4544 45.18 71.5 45.18Z"
                fill="url(#paint4)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M71.5 151C110.988 151 143 118.988 143 79.5V8H71.5C32.0116 8 0 40.0116 0 79.5C0 118.988 32.0116 151 71.5 151ZM71.5 113.82C90.4544 113.82 105.82 98.4544 105.82 79.5L105.82 45.18H71.5C52.5456 45.18 37.18 60.5456 37.18 79.5C37.18 98.4544 52.5456 113.82 71.5 113.82Z"
                fill="url(#paint5)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0 113.169V150.349H71.5C110.988 150.349 143 118.338 143 78.8494C143 69.4794 141.198 60.5303 137.921 52.3301C133.449 82.2448 110.445 106.102 80.9659 111.847C77.9591 112.708 74.7834 113.169 71.5 113.169H67.21H37.18H0Z"
                fill="url(#paint6)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M143 45.8306V8.65057H71.5C32.0116 8.65057 0 40.6622 0 80.1506C0 89.5206 1.8024 98.4696 5.07941 106.67C9.55139 76.7552 32.5547 52.8976 62.0341 47.1526C65.0409 46.2916 68.2166 45.8306 71.5 45.8306H75.79H105.82H143Z"
                fill="url(#paint7)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0 113.169V151H71V150.998C71.1665 150.999 71.3332 151 71.5 151C110.988 151 143 118.764 143 78.9999C143 69.568 141.199 60.5597 137.924 52.3047C133.462 82.2312 110.454 106.101 80.966 111.847C77.9592 112.708 74.7834 113.169 71.5 113.169H37.18L0 113.169Z"
                fill="url(#paint8)"
                fillOpacity="0.4"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M143 45.4268V7.99998L71.5 8C32.0116 8 0 40.2241 0 79.9746C0 89.4068 1.80238 98.4152 5.07938 106.67C9.55139 76.5566 32.5548 52.5407 62.0342 46.7576C65.041 45.8909 68.2166 45.4268 71.5 45.4268L71.5326 45.4268H75.7374C75.7549 45.4268 75.7724 45.4268 75.79 45.4268H143Z"
                fill="url(#paint9)"
                fillOpacity="0.4"
            />

            { /* The text/logo portion remains filled */ }
            <path
                d="M203.48 33.12L220.248 100.96L236.888 33.12H252.376L269.272 100.96L285.784 33.12H303.32L279 124H260.568L244.696 63.072L228.696 124H210.392L185.944 33.12H203.48ZM344.82 33.12C351.817 33.12 357.833 34.272 362.868 36.576C367.988 38.88 371.913 42.2507 374.644 46.688C377.375 51.04 378.74 56.16 378.74 62.048C378.74 68.1067 377.375 73.3547 374.644 77.792C371.913 82.144 367.988 85.472 362.868 87.776C357.833 90.08 351.817 91.232 344.82 91.232H326.26V124H309.62V33.12H344.82ZM344.052 76.768C349.684 76.768 353.993 75.5307 356.98 73.056C360.052 70.5813 361.588 66.912 361.588 62.048C361.588 57.3547 360.052 53.7707 356.98 51.296C353.993 48.8213 349.684 47.584 344.052 47.584H326.26V76.768H344.052ZM452.646 33.12C458.961 33.12 464.507 34.2293 469.286 36.448C474.15 38.5813 477.947 41.7387 480.678 45.92C483.409 50.016 484.774 54.88 484.774 60.512C484.774 64.608 483.878 68.2773 482.086 71.52C480.379 74.6773 478.033 77.2373 475.046 79.2C472.059 81.1627 468.774 82.3573 465.19 82.784L462.502 81.632C469.414 81.632 474.449 82.8693 477.606 85.344C480.849 87.7333 482.726 91.872 483.238 97.76L485.542 124H468.774L466.854 100.192C466.598 96.2667 465.19 93.536 462.63 92C460.07 90.464 455.846 89.696 449.958 89.696H431.27V124H414.63V33.12H452.646ZM450.854 75.104C456.23 75.104 460.369 73.952 463.27 71.648C466.171 69.2587 467.622 65.888 467.622 61.536C467.622 57.0133 466.171 53.5573 463.27 51.168C460.369 48.7787 456.23 47.584 450.854 47.584H431.27V75.104H450.854ZM524.057 125.536C517.316 125.536 511.428 124.085 506.393 121.184C501.358 118.283 497.433 114.187 494.617 108.896C491.801 103.52 490.393 97.248 490.393 90.08C490.393 82.912 491.801 76.6827 494.617 71.392C497.433 66.016 501.358 61.8773 506.393 58.976C511.428 56.0747 517.316 54.624 524.057 54.624C530.713 54.624 536.558 56.0747 541.593 58.976C546.713 61.8773 550.638 66.016 553.369 71.392C556.185 76.6827 557.593 82.912 557.593 90.08C557.593 97.248 556.185 103.52 553.369 108.896C550.638 114.187 546.713 118.283 541.593 121.184C536.558 124.085 530.713 125.536 524.057 125.536ZM524.057 112.224C529.348 112.224 533.444 110.304 536.345 106.464C539.246 102.539 540.697 97.0773 540.697 90.08C540.697 83.0827 539.246 77.664 536.345 73.824C533.444 69.8987 529.348 67.936 524.057 67.936C518.766 67.936 514.67 69.856 511.769 73.696C508.868 77.536 507.417 82.9973 507.417 90.08C507.417 97.1627 508.868 102.624 511.769 106.464C514.67 110.304 518.766 112.224 524.057 112.224ZM583.119 33.12V106.336C583.119 107.872 583.546 109.109 584.399 110.048C585.338 110.901 586.575 111.328 588.111 111.328H593.231V124H583.887C578.682 124 574.5 122.507 571.343 119.52C568.271 116.448 566.735 112.267 566.735 106.976V33.12H583.119ZM618.124 33.12V106.336C618.124 107.872 618.551 109.109 619.404 110.048C620.343 110.901 621.58 111.328 623.116 111.328H628.236V124H618.892C613.687 124 609.505 122.507 606.348 119.52C603.276 116.448 601.74 112.267 601.74 106.976V33.12H618.124ZM653.129 33.12V65.376C655.177 62.048 657.993 59.4453 661.577 57.568C665.161 55.6053 669.172 54.624 673.609 54.624C679.412 54.624 684.489 56.0747 688.841 58.976C693.193 61.8773 696.521 66.016 698.825 71.392C701.129 76.6827 702.281 82.912 702.281 90.08C702.281 97.248 701.129 103.52 698.825 108.896C696.521 114.187 693.193 118.283 688.841 121.184C684.489 124.085 679.412 125.536 673.609 125.536C669.001 125.536 664.862 124.555 661.193 122.592C657.524 120.544 654.708 117.771 652.745 114.272L652.361 124H636.745V33.12H653.129ZM652.105 90.08C652.105 94.6027 652.788 98.528 654.153 101.856C655.518 105.184 657.438 107.787 659.913 109.664C662.473 111.456 665.417 112.352 668.745 112.352C673.78 112.352 677.79 110.347 680.777 106.336C683.849 102.24 685.385 96.8213 685.385 90.08C685.385 83.168 683.892 77.664 680.905 73.568C677.918 69.472 673.865 67.424 668.745 67.424C665.417 67.424 662.473 68.3627 659.913 70.24C657.438 72.032 655.518 74.6347 654.153 78.048C652.788 81.4613 652.105 85.472 652.105 90.08ZM709.69 76.896C711.055 69.8133 714.341 64.352 719.546 60.512C724.837 56.5867 731.663 54.624 740.026 54.624C749.754 54.624 757.135 57.0987 762.17 62.048C767.29 66.9973 769.85 74.2507 769.85 83.808V107.104C769.85 108.981 770.191 110.304 770.874 111.072C771.642 111.755 772.709 112.096 774.074 112.096H776.762V124L772.922 124.128H771.514C767.589 124.299 764.09 123.701 761.018 122.336C757.946 120.885 756.154 117.984 755.642 113.632C753.935 117.216 751.119 120.117 747.194 122.336C743.354 124.469 738.618 125.536 732.986 125.536C725.989 125.536 720.143 123.787 715.45 120.288C710.842 116.789 708.538 112.096 708.538 106.208C708.538 101.941 709.519 98.4853 711.482 95.84C713.53 93.1947 716.389 91.1467 720.058 89.696C723.727 88.16 728.506 86.7947 734.394 85.6L753.338 81.888C753.338 76.5973 752.229 72.7147 750.01 70.24C747.791 67.68 744.463 66.4 740.026 66.4C736.357 66.4 733.37 67.3813 731.066 69.344C728.762 71.2213 727.226 74.0373 726.458 77.792L709.69 76.896ZM725.562 105.696C725.562 108.171 726.586 110.176 728.634 111.712C730.682 113.248 733.626 114.016 737.466 114.016C740.623 114.016 743.397 113.248 745.786 111.712C748.261 110.176 750.181 107.915 751.546 104.928C752.997 101.856 753.722 98.1867 753.722 93.92V93.024L740.794 95.328C740.197 95.4133 739.557 95.4987 738.874 95.584C735.802 96.1813 733.327 96.8213 731.45 97.504C729.658 98.1013 728.207 99.0827 727.098 100.448C726.074 101.728 725.562 103.477 725.562 105.696ZM828.049 81.12C827.366 77.024 825.66 73.824 822.929 71.52C820.284 69.1307 817.126 67.936 813.457 67.936C808.166 67.936 804.07 69.856 801.169 73.696C798.268 77.536 796.817 82.9973 796.817 90.08C796.817 97.1627 798.268 102.624 801.169 106.464C804.07 110.304 808.166 112.224 813.457 112.224C817.297 112.224 820.582 111.029 823.313 108.64C826.044 106.165 827.708 102.667 828.305 98.144L845.329 98.912C844.732 104.288 842.982 108.981 840.081 112.992C837.18 117.003 833.425 120.117 828.817 122.336C824.209 124.469 819.089 125.536 813.457 125.536C806.716 125.536 800.828 124.085 795.793 121.184C790.758 118.283 786.833 114.144 784.017 108.768C781.201 103.392 779.793 97.1627 779.793 90.08C779.793 82.9973 781.201 76.768 784.017 71.392C786.833 66.016 790.758 61.8773 795.793 58.976C800.828 56.0747 806.716 54.624 813.457 54.624C818.918 54.624 823.91 55.6907 828.433 57.824C833.041 59.872 836.796 62.816 839.697 66.656C842.598 70.496 844.348 75.0187 844.945 80.224L828.049 81.12ZM868.644 33.12V86.752L896.42 56.16H916.516L890.02 84.192L917.796 124H899.364L879.268 94.048L868.644 105.44V124H852.26V33.12H868.644Z"
                fill="#1D2A39"
            />

            { /* Gradients */ }
            <defs>
                <linearGradient id="paint0" x1="71.5" y1="8" x2="71.5" y2="151" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient id="paint1" x1="71.5" y1="151" x2="71.5" y2="8" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient id="paint2" x1="71.5" y1="8" x2="71.5" y2="151" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient id="paint3" x1="71.5" y1="151" x2="71.5" y2="8" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient id="paint4" x1="71.5" y1="8" x2="71.5" y2="151" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient id="paint5" x1="71.5" y1="151" x2="71.5" y2="8" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient
                    id="paint6"
                    x1="133.705"
                    y1="89.5101"
                    x2="71.5"
                    y2="150.349"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient
                    id="paint7"
                    x1="9.295"
                    y1="69.4899"
                    x2="71.5"
                    y2="8.65065"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient
                    id="paint8"
                    x1="133.705"
                    y1="89.5099"
                    x2="71.5"
                    y2="150.349"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
                <linearGradient
                    id="paint9"
                    x1="9.29501"
                    y1="69.2432"
                    x2="71.9023"
                    y2="8.41414"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#FF61EF" />
                    <stop offset="0.598958" stopColor="#A972F9" stopOpacity="0.772396" />
                    <stop offset="1" stopColor="#707EFF" stopOpacity="0.62" />
                </linearGradient>
            </defs>
        </svg>
    );
};

export default LogoFree;
