<?php
/**
 * WP Post Hide Support page.
 *
 * @package WP Post Hide Setup.
 * @since 1.0.0
 */

// Exit if directly access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// phpcs:ignore
$selected_tab = isset( $_GET['tab'] ) ? $_GET['tab'] :  'report';
?>
<div class="warp">
	<div id="icon-options-general" class="icon32"></div>
	<h1>
		<?php esc_html_e( 'WP Post Hide', 'xswphp-domain' ); ?>
	</h1>
		<nav class="nav-tab-wrapper wp-clearfix" aria-label="Secondary menu">
			<a class="nav-tab <?php echo ( 'report' === $selected_tab ) ? 'nav-tab-active' : ''; ?>" href="?page=xswphp-support&tab=report" class="nav-tab">
				<?php esc_html_e( 'Report a bug', 'xswphp-domain' ); ?>
			</a>
			<a class="nav-tab <?php echo ( 'request' === $selected_tab ) ? 'nav-tab-active' : ''; ?>" href="?page=xswphp-support&tab=request" class="nav-tab">
				<?php esc_html_e( 'Request a Feature', 'xswphp-domain' ); ?>
			</a>
			<a class="nav-tab <?php echo ( 'hire' === $selected_tab ) ? 'nav-tab-active' : ''; ?>" href="?page=xswphp-support&tab=hire" class="nav-tab">
				<?php esc_html_e( 'Hire US', 'xswphp-domain' ); ?>
			</a>
			<a class="nav-tab <?php echo ( 'review' === $selected_tab ) ? 'nav-tab-active' : ''; ?>" href="?page=xswphp-support&tab=review" class="nav-tab">
				<?php esc_html_e( 'Review', 'xswphp-domain' ); ?>
			</a>

		</nav>
		<div class="tab-content">
			<?php
			switch ( $selected_tab ) {
				case 'request':
					?>
					<div class="xs-send-email-notice xswphp-top-margin">
						<p></p>
						<button type="button" class="notice-dismiss xs-notice-dismiss"><span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'xswphp-domain' ); ?></span></button>
					</div>
					<form method="post" class="xswphp_support_form">
						<input type="hidden" name="type" value="request">
						<table class="form-table">
							<tbody>
								<tr valign="top">
									<th>
										<label for='xswphp_name'><?php esc_html_e( 'Your Name:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="text" id="xswphp_name" name="xswphp_name" required>
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_email"><?php esc_html_e( 'Your Email:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="email" id="xswphp_email" name="xswphp_email" required>
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_message"><?php esc_html_e( 'Message:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<textarea id="xswphp_message" name="xswphp_message" rows="12", cols="47" required></textarea>
									</td>
								</tr>
							</tbody>
						</table>
						<div class="input-group">
							<?php submit_button( __( 'Send', 'xswphp-domain' ), 'primary xswphp-send-mail' ); ?>
							<span class="spinner xswphp-mail-spinner"></span> 
						</div>
						
					</form>
					<?php
					break;
				case 'hire':
					?>
					<h2 class="xswphp-top-margin"><?php esc_html_e( 'Hire us for Customization and Development of WordPress Plugins and Themes.', 'xswphp-domain' ); ?></h2>
					<div class="xs-send-email-notice xswphp-top-margin">
						<p></p>
						<button type="button" class="notice-dismiss xs-notice-dismiss"><span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'xswphp-domain' ); ?></span></button>
					</div>
					<form method="post" class="xswphp_support_form">
						<input type="hidden" name="type" value="hire">
						<table class="form-table">
							<tbody>
								<tr valign="top">
									<th>
										<label for='xswphp_name'><?php esc_html_e( 'Your Name:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="text" id="xswphp_name" name="xswphp_name" required="required">
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_email"><?php esc_html_e( 'Your Email:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="email" id="xswphp_email" name="xswphp_email" required="required">
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_message"><?php esc_html_e( 'Message:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<textarea id="xswphp_message" name="xswphp_message" rows="12", cols="47" required="required"></textarea>
									</td>
								</tr>
							</tbody>
						</table>
						<div class="input-group">
							<?php submit_button( __( 'Send', 'xswphp-domain' ), 'primary xswphp-send-mail' ); ?>
							<span class="spinner xswphp-mail-spinner"></span> 
						</div>
					</form>
					<?php
					break;
				case 'review':
					?>
					<p class="about-description xswphp-top-margin"><?php esc_html_e( 'If you like our plugin and support than kindly share your  ', 'xswphp-domain' ); ?> <a href="https://codecanyon.net/item/woocommerce-advanced-product-duplicator/22147932" target="_blank"> <?php esc_html_e( 'feedback', 'xswphp-domain' ); ?> </a><?php esc_html_e( 'Your feedback is valuable.', 'xswphp-domain' ); ?> </p>
					<?php
					break;
				default:
					?>
					<div class="xs-send-email-notice xswphp-top-margin">
						<p></p>
						<button type="button" class="notice-dismiss xs-notice-dismiss"><span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'xswphp-domain' ); ?></span></button>
					</div>
					<form method="post" class="xswphp_support_form">
						<input type="hidden" name="type" value="report">
						<table class="form-table">
							<tbody>
								<tr valign="top">
									<th>
										<label for='xswphp_name'><?php esc_html_e( 'Your Name:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="text" id="xswphp_name" name="xswphp_name" required="required">
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_email"><?php esc_html_e( 'Your Email:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<input type="email" id="xswphp_email" name="xswphp_email" required="required">
									</td>
								</tr>
								<tr valign="top">
									<th>
										<label for="xswphp_message"><?php esc_html_e( 'Message:', 'xswphp-domain' ); ?></label>
									</th>
									<td>
										<textarea id="xswphp_message" name="xswphp_message" rows="12", cols="47" required="required"></textarea>
									</td>
								</tr>
							</tbody>
						</table>
						<div class="input-group">
							<?php submit_button( __( 'Send', 'xswphp-domain' ), 'primary xswphp-send-mail' ); ?>
							<span class="spinner xswphp-mail-spinner"></span> 
						</div>
						
					</form>
					<?php
					break;
			}
			?>
		</div>
</div>
