<?php

namespace WPPayForm\App\Models;

use WPPayForm\Framework\Support\Arr;

class DemoForms extends Model
{
    public static function insertTemplate($formId, $data, $template)
    {
        $demoForms = self::demoForms();
        if (!isset($demoForms[$template])) {
            return;
        }
        $demoForm = $demoForms[$template];

        $data = Arr::get($demoForm, 'data');
        if (!$data) {
            return;
        }

        $data = json_decode($data, true);

        $metas = Arr::get($data, 'form_meta');
        if (!is_array($metas)) {
            return;
        }
        foreach ($metas as $metaKey => $metaValue) {
            update_post_meta($formId, $metaKey, $metaValue);
        }
    }

    public static function checkFormCategory($formId, $category)
    {
        do_action('wppayform/doing_ajax_forms_get_forms');
        $form_name = explode("-", $formId);
        $last = end($form_name);
        if (is_numeric($last)) {
            array_pop($form_name);
        }
        $new_form_name = implode('_', $form_name);
        $forms = static::demoForms();
        return Arr::get($forms, $new_form_name . '.category') === $category;
    }

    public static function getDemoForms()
    {
        do_action('wppayform/doing_ajax_forms_get_forms');

        $forms = static::demoForms();
        $formattedForms = [];
        $categories = [];
        foreach ($forms as $formName => $form) {
            unset($form['data']);
            $formattedForms[$formName] = $form;
            $categories[] = Arr::get($form, 'category');
        }
        return array(
            'forms' => $formattedForms,
            'categories' => array_unique($categories)
        );
    }

    public static function demoForms()
    {
        $demoForms = array(
            'blank_form' => array(
                'label' => 'Blank Form',
                'description' => 'Create a form From Scratch',
                'category' => 'Blank From',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/blank_form.svg',
                'data' => '{"post_content":"","post_title":"Blank Form","form_meta":{"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait…","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}</p>\n<p>{submission.all_input_field_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/after_form_submission_complete","status":"disabled"}]}}',
                'is_pro' => false
            ),
            'multiple_item_sale' => array(
                'label' => 'Multiple Items Sale Form',
                'description' => 'Sale multiple products in a single form',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/payment_form-01.svg',
                'data' => '{"post_title":"Multiple items Sale","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Customer Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Name","placeholder":"Your Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Customer Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Select the Product That you want to purchase","required":"yes","pricing_details":{"one_time_type":"choose_multiple","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Product 1","value":"25"},{"label":"Product 2","value":"35"},{"label":"Product 3","value":"50"}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Add On Products","required":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Add-on Item 1","value":"10"},{"label":"Add-on Item 2","value":"15"}],"prices_display_type":"radio"}},"id":"payment_item_1"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":"true","editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip/Postal Code","type":"switch"}},"field_options":{"label":"Your Card info (Powered By Stripe)","verify_zip":"yes","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","require_shipping_info":"no"}},"id":"stripe_card_element"}],"wppayform_submit_button_settings":{"button_text":"Pay {payment_total}","processing_text":"Please Wait…","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Thank you for your purchase. Your Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Your Order ID: {submission.id}</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"New Product Sale, Customer: {input.customer_name} #{submission.id}","email_body":"<p>Good news! New Sale</p>\n<p>Customer Info:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"active"},{"title":"Email Notification to Submitter","email_to":"{input.customer_email}","reply_to":"{wp:admin_email}","email_subject":"Thank You  for your Order","email_body":"<p>Hello {input.customer_name},</p>\n<p>Thank you for order. Here is your payment receipt:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Your Order ID: {submission.id}</p>\n<p>Thank You</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"disabled"}],"wppayform_show_title_description":""}}',
                'is_pro' => false
            ),
            'gym_membership_form' => array(
                'label' => 'Gym Membership Form',
                'description' => 'Create a form to accept Gym Membership',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":830,"post_author":"12","post_date":"2024-05-21 03:57:30","post_date_gmt":"2024-05-21 03:57:30","post_content":"","post_title":"Gym Membership Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-83","to_ping":"","pinged":"","post_modified":"2024-05-21 04:47:14","post_modified_gmt":"2024-05-21 04:47:14","post_content_filtered":"","post_parent":0,"guid":"https:\/\/pm.pennito.com\/?p=830","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Pay {payment_total}","processing_text":"Please Wait\u2026","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","is_pro":"no","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h2 style=\"text-align: center;\">Gym Membership Form<\/h2>\n<p style=\"text-align: center;\"><img class=\"aligncenter wp-image-833 size-full\" src=\"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/Add-a-heading-1.jpg\" alt=\"gym membership form\" width=\"500\" height=\"200\" \/><\/p>\n<p style=\"text-align: center;\">This is a multi-step Gym Membership Form template.<\/p>\n<p style=\"text-align: center;\">Customize everything as per your needs. Get Paymattic Pro for subscription payments.<\/p>\n<h2 style=\"text-align: center;\">\u00a0<\/h2>"},"id":"custom_html","active_page":0},{"type":"customer_name","active_page":1,"is_pro":"no","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","is_pro":"no","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":1,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"no","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","is_pro":"no","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"yes","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_country_code":"US"},"id":"phone","active_page":1},{"type":"step_form","is_pro":"no","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Membership Packages","description":"","fields":[]},{"title":"Your Information","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"text","is_pro":"no","editor_title":"Single Line Text","active_page":1,"quick_checkout_form":true,"group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"What is your age?","placeholder":"","required":"yes","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"text_2"},{"type":"text","is_pro":"no","editor_title":"Single Line Text","active_page":1,"quick_checkout_form":true,"group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Weight (kg)","placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"text_3"},{"type":"radio","is_pro":"no","editor_title":"Radio Field","quick_checkout_form":true,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Gender","placeholder":"","required":"yes","options":[{"label":"Male","value":"Male"},{"label":"Female","value":"Female"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"radio_1","active_page":1},{"type":"checkbox","editor_title":"Checkbox Field","quick_checkout_form":true,"group":"input","is_pro":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Medical Issues (if any)","required":"yes","default_value":"","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"options":[{"label":"Heart Conditions","value":"Heart Conditions"},{"label":"Respiratory Issues","value":"Respiratory Issues"},{"label":"Allergies","value":"Allergies"},{"label":"Recent Surgeries","value":"Recent Surgeries"},{"label":"Joint Problems","value":"Joint Problems"},{"label":"None","value":"None"}]},"id":"checkbox_1","active_page":1},{"type":"terms_conditions","editor_title":"Consent\/T&C","conditional_hide":true,"group":"input","is_pro":"no","postion_group":"general","editor_elements":{"label":{"label":"Terms Text","type":"textarea","group":"general","info":"Provide Terms & Conditions \/ Consent Text (HTML Supported)"},"tc_description":{"label":"Terms Description (optional)","type":"html","group":"general","info":"The full description of your terms and condition. It will show as scrollable text"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general","info":"Keep value 1 if you want to make it pre-checked by default"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"I Agree With The Terms And Condition","required":"yes","wrapper_class":"","admin_label":"Terms & Condition Agreement","tc_description":"","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"terms_conditions","active_page":1},{"type":"payment_item","editor_title":"Payment Item","group":"payment","is_pro":"no","postion_group":"payment","isNumberic":"yes","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Choose your Membership Package","required":"yes","enable_image":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"3 months","value":30},{"label":"6 months","value":180},{"label":"12 months","value":300}],"prices_display_type":"radio"}},"id":"payment_item_1","active_page":0},{"type":"date","quick_checkout_form":true,"editor_title":"Date & Time Field","group":"input","is_pro":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/paymattic.com\/docs\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"custom_config":{"label":"Advanced Date Configuration","type":"custom_date_config","group":"advanced","css_class":"wpf_code_editor","placeholder":"{}","tips":"You can write your own date configuration in jSON. Please write valid configuration as per flatpickr config.","info":"Only valid JS object will work. Please check <a target=\"_blank\" href=\"https:\/\/paymattic.com\/docs\/date-formats-customization\/\">the documentation for available config options<\/a>"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Date & Time","placeholder":"","required":"yes","date_format":"m\/d\/Y","custom_config":"","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"date","active_page":0},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card Info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","place_a_hold_on_stripe":"no"},"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"stripe_card_element","active_page":1}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => false
            ),
            'donation_form' => array(
                'label' => 'Donation Form',
                'description' => 'Create a simple Donation form.',
                'category'=> 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/donation_form.svg',
                'data' => '{"post_title":"Donation Form","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Customer Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Your Name","placeholder":"Your Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Customer Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Your Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"}},"field_options":{"label":"Your Donation Amount","placeholder":"Your Donation Amount","required":"yes","default_value":"25","min_value":"5"},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":"true","editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip/Postal Code","type":"switch"}},"field_options":{"label":"Your Card info (Powered By Stripe)","verify_zip":"yes","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","require_shipping_info":"no"}},"id":"stripe_card_element"}],"wppayform_submit_button_settings":{"button_text":"Donate {payment_total}","processing_text":"Please Wait…","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Thank you for your donation.</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"New Donation Made By by {input.customer_name} #{submission.id}","email_body":"<p>Good news! New Donation made by {input.customer_name}</p>\n<p>{submission.all_input_field_html}</p>\n<p>Donation Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"active"}],"wppayform_show_title_description":""}}',
                'is_pro' => false
            ),
            'contact_form' => array(
                'label' => 'Contact Form',
                'description' => 'Create a simple contact form.',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"post_content":"","post_title":"Contact Form","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Customer Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Name","placeholder":"Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Customer Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Subject","placeholder":"","required":"no"},"id":"text"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"}},"field_options":{"label":"Your Message","placeholder":"","required":"yes"},"id":"textarea"}],"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait…","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted. We will contact with you as soon as possible</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}</p>\n<p>{submission.all_input_field_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/after_form_submission_complete","status":"active"}]}}',
                'is_pro' => false
            ),
            'event_registration' => array(
                'label' => 'Event Registration Form',
                'description' => 'Create an Event Registration form and accept payment',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"post_title":"Event Registration Form","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Name","placeholder":"Your Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Choose Your Ticket","required":"yes","pricing_details":{"one_time_type":"choose_single","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Early Bird Ticket","value":"25"},{"label":"Regular Ticket","value":"35"}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"item_quantity","editor_title":"Item Quantity","group":"item_quantity","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Quantity","type":"text","group":"general"},"target_product":{"label":"Target Payment Item","type":"product_selector","group":"general","info":"Please select the product in where the quantity will be applied"},"min_value":{"label":"Minimum Quantity","type":"number","group":"general"},"max_value":{"label":"Maximum Quantity","type":"number","group":"general"}},"field_options":{"label":"Ticket Quantity","placeholder":"Provide Quantity","required":"yes","min_value":"1","target_product":"payment_item","default_value":"1"},"id":"item_quantity"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":"true","editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip/Postal Code","type":"switch"}},"field_options":{"label":"Your Card info (Powered By Stripe)","verify_zip":"yes","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","require_shipping_info":"no"}},"id":"stripe_card_element"}],"wppayform_submit_button_settings":{"button_text":"Register and Pay {payment_total}","processing_text":"Please Wait…","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Thank you for your registration. Please contact with us if you have any query.</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"New Event Registration by {input.customer_name} #{submission.id}","email_body":"<p>Good news! New Registration made by {input.customer_name}</p>\n<p>{submission.all_input_field_html}</p>\n<p>Payment Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"active"},{"title":"Email Notification to Submitter","email_to":"{input.customer_email}","reply_to":"{wp:admin_email}","email_subject":"Event Registration Confirmation","email_body":"<p>Hello {input.customer_name},</p>\n<p>Thank you for completing the registration. Here is your payment receipt:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Your Registration ID: {submission.id}</p>\n<p>Thank You</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"disabled"}],"wppayform_show_title_description":""}}',
                'is_pro' => false
            ),
            'soccer_match_tickets' => array(
                'label' => 'Soccer Match Tickets',
                'description' => 'Create a Payment form to sell soccer match tickets',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":824,"post_author":"13","post_date":"2024-05-20 10:32:48","post_date_gmt":"2024-05-20 10:32:48","post_content":"","post_title":"Soccer Match Tickets","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-80","to_ping":"","pinged":"","post_modified":"2024-05-21 06:53:55","post_modified_gmt":"2024-05-21 06:53:55","post_content_filtered":"","post_parent":0,"guid":"https:\/\/pm.pennito.com\/?p=824","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Pay {payment_total} (with Stripe)","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","is_pro":"no","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h1 style=\"text-align: center;\">Book Your Seat<\/h1>\n<p><img class=\"size-medium wp-image-838 aligncenter\" src=\"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/Group-132131516asda4-300x222.webp\" alt=\"\" width=\"300\" height=\"222\" \/><\/p>\n<p style=\"text-align: center;\">(This is a Demo image and Demo Form. <\/br>You can edit everything from the settings)<\/p>"},"id":"custom_html","active_page":0},{"type":"radio","is_pro":"no","editor_title":"Radio Field","quick_checkout_form":true,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Choose the soccer match you are interested in:","placeholder":"","required":"yes","options":[{"label":"Manchester United vs Fulham (Date)","value":"Manchester United vs Fulham (Date)"},{"label":"Chelsea vs Newcastle United (Date)","value":"Chelsea vs Newcastle United (Date)"},{"label":"Crystal Palace vs Nottingham Forest (Date)","value":"Crystal Palace vs Nottingham Forest (Date)"},{"label":"Everton vs Bournemouth (Date)","value":"Everton vs Bournemouth (Date)"},{"label":"Southampton\t vs Liverpool (Date)","value":"Southampton\t vs Liverpool (Date)"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"radio","active_page":0},{"type":"payment_item","editor_title":"Payment Item","group":"payment","is_pro":"no","postion_group":"payment","isNumberic":"yes","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"What is your desired seat location?","required":"yes","enable_image":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":"","photo":{"alt_text":"","image_full":"","image_thumb":""}}],"multiple_pricing":[{"label":"VIP","value":250},{"label":"Longside Tier","value":200},{"label":"Longside Lower Tier","value":150},{"label":"Longside Upper Tier","value":100},{"label":"Shortside Tier","value":200},{"label":"Shortside Lower Tier","value":150},{"label":"Shortside Middle Tier","value":100},{"label":"Shortside Upper Tier","value":50},{"label":"Away Fan Section","value":50}],"prices_display_type":"select"}},"id":"payment_item","active_page":0},{"type":"customer_name","active_page":0,"is_pro":"no","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","is_pro":"no","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":0,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","is_pro":"no","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_country_code":"GB"},"id":"phone","active_page":0},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","is_pro":"no","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Address","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"subfields":{"address_line_1":{"isNumberic":"no","label":"Address:","field_options":{"label":"Address Line 1"},"placeholder":"Address Line 1","visibility":"yes","required":"no","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"isNumberic":"no","label":"Address Line 2","field_options":{"label":"Address Line 2"},"placeholder":"Address Line 2","visibility":"no","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"isNumberic":"no","label":"City","field_options":{"label":"City"},"placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"isNumberic":"no","label":"State","placeholder":"State","field_options":{"label":"State"},"visibility":"yes","required":"no","type":"text","id":"state","default_value":""},"zip_code":{"isNumberic":"no","label":"ZIP Code","field_options":{"label":"ZIP Code"},"placeholder":"ZIP Code","visibility":"no","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"isNumberic":"no","label":"Country","field_options":{"label":"Country"},"placeholder":"Select Country","visibility":"yes","required":"no","type":"select","id":"country","default_value":""}}},"id":"address_input","active_page":0},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card Info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","place_a_hold_on_stripe":"no"},"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"stripe_card_element","active_page":0}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","_payment_settings":[]}}',
                'is_pro' => false
            ),

            'shopping_cart_step_grid' => array(
                'label' => 'Full fledged shopping cart step form template (Grid view)',
                'description' => 'Full fledged shopping cart step form template (Grid view)',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":536,"post_author":"1","post_date":"2023-01-11 09:23:03","post_date_gmt":"2023-01-11 09:23:03","post_content":"","post_title":"Full fledged shopping cart step form template (Grid view)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"full-fledged-shopping-cart-step-form-template-grid-view-5","to_ping":"","pinged":"","post_modified":"2023-01-11 09:23:03","post_modified_gmt":"2023-01-11 09:23:03","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=536","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"grid","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Pant","value":"Pant"},{"label":"T-shirt","value":"T-shirt"},{"label":"Shoes","value":"Shoes"}],"products":[{"product_name":"Printed Cotton T Shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","category":"T-shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"S"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}]},{"product_name":"Casual Shoes","default_quantity":0,"min_quantity":20,"max_quantity":100,"product_price":100,"product_description":"Sneakers for men Casual Shoes for Men","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"43","value":"43"},{"label":"44","value":"44"},{"label":"45","value":"45"}]}],[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 3-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2 copy 4-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2-50","image_full":"/images\/form\/shoes2.jpg","image_thumb":"/images\/form\/shoes2.jpg"}],"category":"Shoes"},{"product_name":"Casual T-shirt","default_quantity":0,"min_quantity":1,"max_quantity":10,"product_price":200,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","categories":["all"],"enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"s"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}],"category":"T-shirt"},{"product_name":"Men T-shirt","default_quantity":0,"min_quantity":2,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"L","value":"L"},{"label":"M","value":"M"},{"label":"N","value":"N"}]}],[{"label":"Color ","options":[{"label":"Black","value":"Black"},{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Mens Pant","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":900,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"},{"product_name":"Mobile Pant ","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":700,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Cart","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":1},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Shipping Address","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"subfields":{"address_line_1":{"isNumberic":"no","label":"Address Line 1","field_options":{"label":"Address Line 1"},"placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"isNumberic":"no","label":"Address Line 2","field_options":{"label":"Address Line 2"},"placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"isNumberic":"no","label":"City","field_options":{"label":"City"},"placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"isNumberic":"no","label":"State","placeholder":"State","field_options":{"label":"State"},"visibility":"no","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"isNumberic":"no","label":"ZIP Code","field_options":{"label":"ZIP code"},"placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"isNumberic":"no","label":"Country","field_options":{"label":"Country"},"placeholder":"Select Country","visibility":"no","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input","active_page":2},{"type":"customer_name","active_page":2,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":2,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":2},{"type":"step_form","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Product","description":"","fields":[]},{"title":"Cart","description":"","fields":[]},{"title":"Contact","description":"","fields":[]},{"title":"Payment","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Payment Summary","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary_1","active_page":3},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"chip":{"label":"CHIP","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with CHIP"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no","checkKey":"Credit\/Debit Card (Stripe)"},"paypal":{"enabled":"no","label":"Pay with Paypal","require_shipping_address":"no","checkKey":"Paypal"},"mollie":{"enabled":"yes","label":"Pay with Mollie","checkKey":"Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay","checkKey":"Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack","checkKey":"Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx","checkKey":"Payrexx"},"square":{"enabled":"yes","label":"Pay with Square","checkKey":"Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz","checkKey":"SSLCOMMERZ"},"billplz":{"enabled":"yes","label":"Pay with Billplz","checkKey":"Billplz"},"chip":{"enabled":"no","label":"Pay with CHIP","checkKey":"CHIP"},"offline":{"enabled":"no","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited","checkKey":"Offline\/Cheque Payment"}}},"default_value":"stripe"},"id":"choose_payment_method","active_page":3}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'shopping_cart_step_single_line' => array(
                'label' => 'Full fledged shopping cart step form template (Single line view)',
                'description' => 'Full fledged shopping cart step form template (Single line view)',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":536,"post_author":"1","post_date":"2023-01-11 09:23:03","post_date_gmt":"2023-01-11 09:23:03","post_content":"","post_title":"Full fledged shopping cart step form template (Single line view)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"full-fledged-shopping-cart-step-form-template-single line-view-6","to_ping":"","pinged":"","post_modified":"2023-01-11 09:23:03","post_modified_gmt":"2023-01-11 09:23:03","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=536","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"row","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Pant","value":"Pant"},{"label":"T-shirt","value":"T-shirt"},{"label":"Shoes","value":"Shoes"}],"products":[{"product_name":"Printed Cotton T Shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","category":"T-shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"S"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}]},{"product_name":"Casual Shoes","default_quantity":0,"min_quantity":20,"max_quantity":100,"product_price":100,"product_description":"Sneakers for men Casual Shoes for Men","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"43","value":"43"},{"label":"44","value":"44"},{"label":"45","value":"45"}]}],[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 3-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2 copy 4-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2-50","image_full":"/images\/form\/shoes2.jpg","image_thumb":"/images\/form\/shoes2.jpg"}],"category":"Shoes"},{"product_name":"Casual T-shirt","default_quantity":0,"min_quantity":1,"max_quantity":10,"product_price":200,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","categories":["all"],"enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"s"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}],"category":"T-shirt"},{"product_name":"Men T-shirt","default_quantity":0,"min_quantity":2,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"L","value":"L"},{"label":"M","value":"M"},{"label":"N","value":"N"}]}],[{"label":"Color ","options":[{"label":"Black","value":"Black"},{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Mens Pant","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":900,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"},{"product_name":"Mobile Pant ","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":700,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Cart","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":1},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Shipping Address","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"subfields":{"address_line_1":{"isNumberic":"no","label":"Address Line 1","field_options":{"label":"Address Line 1"},"placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"isNumberic":"no","label":"Address Line 2","field_options":{"label":"Address Line 2"},"placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"isNumberic":"no","label":"City","field_options":{"label":"City"},"placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"isNumberic":"no","label":"State","placeholder":"State","field_options":{"label":"State"},"visibility":"no","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"isNumberic":"no","label":"ZIP Code","field_options":{"label":"ZIP code"},"placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"isNumberic":"no","label":"Country","field_options":{"label":"Country"},"placeholder":"Select Country","visibility":"no","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input","active_page":2},{"type":"customer_name","active_page":2,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":2,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":2},{"type":"step_form","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Product","description":"","fields":[]},{"title":"Cart","description":"","fields":[]},{"title":"Contact","description":"","fields":[]},{"title":"Payment","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Payment Summary","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary_1","active_page":3},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"chip":{"label":"CHIP","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with CHIP"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no","checkKey":"Credit\/Debit Card (Stripe)"},"paypal":{"enabled":"no","label":"Pay with Paypal","require_shipping_address":"no","checkKey":"Paypal"},"mollie":{"enabled":"yes","label":"Pay with Mollie","checkKey":"Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay","checkKey":"Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack","checkKey":"Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx","checkKey":"Payrexx"},"square":{"enabled":"yes","label":"Pay with Square","checkKey":"Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz","checkKey":"SSLCOMMERZ"},"billplz":{"enabled":"yes","label":"Pay with Billplz","checkKey":"Billplz"},"chip":{"enabled":"no","label":"Pay with CHIP","checkKey":"CHIP"},"offline":{"enabled":"no","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited","checkKey":"Offline\/Cheque Payment"}}},"default_value":"stripe"},"id":"choose_payment_method","active_page":3}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'shopping_cart_single_line' => array(
                'label' => 'Full fledged shopping cart template (Single line view)',
                'description' => 'Full fledged shopping cart template (Single line view)',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":521,"post_author":"1","post_date":"2023-01-06 06:12:47","post_date_gmt":"2023-01-06 06:12:47","post_content":"","post_title":"Full fledged shopping cart template (Single line view)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"full-fledged-shopping-cart-template-grid-view","to_ping":"","pinged":"","post_modified":"2023-01-06 06:14:59","post_modified_gmt":"2023-01-06 06:14:59","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=521","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Choose your product","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"row","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Pant","value":"Pant"},{"label":"T-shirt","value":"T-shirt"},{"label":"Shoes","value":"Shoes"}],"products":[{"product_name":"Printed Cotton T Shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","category":"T-shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"S"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}]},{"product_name":"Casual Shoes","default_quantity":0,"min_quantity":20,"max_quantity":100,"product_price":100,"product_description":"Sneakers for men Casual Shoes for Men","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"43","value":"43"},{"label":"44","value":"44"},{"label":"45","value":"45"}]}],[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 3-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2 copy 4-50","image_full":"/images\/form\/shoes2.jpg","image_thumb":"/images\/form\/shoes2.jpg"},{"alt_text":"Artboard 2-50","image_full":"/images\/form\/shoes3.jpg","image_thumb":"/images\/form\/shoes3.jpg"}],"category":"Shoes"},{"product_name":"Casual T-shirt","default_quantity":0,"min_quantity":1,"max_quantity":10,"product_price":200,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","categories":["all"],"enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"s"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Men T-shirt","default_quantity":0,"min_quantity":2,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"L","value":"L"},{"label":"M","value":"M"},{"label":"N","value":"N"}]}],[{"label":"Color ","options":[{"label":"Black","value":"Black"},{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Mens Pant","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":900,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"},{"product_name":"Mobile Pant ","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":700,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Cart","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":0},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Shipping Address","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"subfields":{"address_line_1":{"isNumberic":"no","label":"Address Line 1","field_options":{"label":"Address Line 1"},"placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"isNumberic":"no","label":"Address Line 2","field_options":{"label":"Address Line 2"},"placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"isNumberic":"no","label":"City","field_options":{"label":"City"},"placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"isNumberic":"no","label":"State","placeholder":"State","field_options":{"label":"State"},"visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"isNumberic":"no","label":"ZIP Code","field_options":{"label":"ZIP code"},"placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"isNumberic":"no","label":"Country","field_options":{"label":"Country"},"placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input","active_page":0},{"type":"customer_name","active_page":0,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":0,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":0}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'shopping_cart_grid' => array(
                'label' => 'Full fledged shopping cart template (Grid view)',
                'description' => 'Full fledged shopping cart template (Grid view)',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":521,"post_author":"1","post_date":"2023-01-06 06:12:47","post_date_gmt":"2023-01-06 06:12:47","post_content":"","post_title":"Full fledged shopping cart template (Grid view)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"full-fledged-shopping-cart-template-grid-view","to_ping":"","pinged":"","post_modified":"2023-01-06 06:14:59","post_modified_gmt":"2023-01-06 06:14:59","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=521","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Choose your product","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"grid","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Pant","value":"Pant"},{"label":"T-shirt","value":"T-shirt"},{"label":"Shoes","value":"Shoes"}],"products":[{"product_name":"Printed Cotton T Shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","category":"T-shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"S"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"},{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"}]},{"product_name":"Casual Shoes","default_quantity":0,"min_quantity":20,"max_quantity":100,"product_price":100,"product_description":"Sneakers for men Casual Shoes for Men","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"43","value":"43"},{"label":"44","value":"44"},{"label":"45","value":"45"}]}],[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 3-50","image_full":"/images\/form\/shoes1.jpg","image_thumb":"/images\/form\/shoes1.jpg"},{"alt_text":"Artboard 2 copy 4-50","image_full":"/images\/form\/shoes2.jpg","image_thumb":"/images\/form\/shoes2.jpg"},{"alt_text":"Artboard 2-50","image_full":"/images\/form\/shoes3.jpg","image_thumb":"/images\/form\/shoes3.jpg"}],"category":"Shoes"},{"product_name":"Casual T-shirt","default_quantity":0,"min_quantity":1,"max_quantity":10,"product_price":200,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","categories":["all"],"enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"s"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1.jpg","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Men T-shirt","default_quantity":0,"min_quantity":2,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"L","value":"L"},{"label":"M","value":"M"},{"label":"N","value":"N"}]}],[{"label":"Color ","options":[{"label":"Black","value":"Black"},{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"Artboard 2 copy 7-50","image_full":"/images\/form\/t-shirt3.jpg","image_thumb":"/images\/form\/t-shirt3.jpg"},{"alt_text":"Artboard 2 copy 8-50","image_full":"/images\/form\/t-shirt2.jpg","image_thumb":"/images\/form\/t-shirt2.jpg"},{"alt_text":"Artboard 2 copy 2-50","image_full":"/images\/form\/t-shirt1","image_thumb":"/images\/form\/t-shirt1.jpg"}],"category":"T-shirt"},{"product_name":"Mens Pant","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":900,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"},{"product_name":"Mobile Pant ","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":700,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"Artboard 2 copy 5-50","image_full":"/images\/form\/pant1.jpg","image_thumb":"/images\/form\/pant1.jpg"},{"alt_text":"Artboard 2 copy 6-50","image_full":"/images\/form\/pant2.jpg","image_thumb":"/images\/form\/pant2.jpg"},{"alt_text":"Artboard 2 copy-50","image_full":"/images\/form\/pant3.jpg","image_thumb":"/images\/form\/pant3.jpg"}],"category":"Pant"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Cart","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":0},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Shipping Address","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"subfields":{"address_line_1":{"isNumberic":"no","label":"Address Line 1","field_options":{"label":"Address Line 1"},"placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"isNumberic":"no","label":"Address Line 2","field_options":{"label":"Address Line 2"},"placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"isNumberic":"no","label":"City","field_options":{"label":"City"},"placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"isNumberic":"no","label":"State","placeholder":"State","field_options":{"label":"State"},"visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"isNumberic":"no","label":"ZIP Code","field_options":{"label":"ZIP code"},"placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"isNumberic":"no","label":"Country","field_options":{"label":"Country"},"placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input","active_page":0},{"type":"customer_name","active_page":0,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":0,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":0}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'electronics_shopping_form' => array(
                'label' => 'Electronics Shopping Form',
                'description' => 'Electronics Shopping Form',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":662,"post_author":"1","post_date":"2023-01-10 11:12:36","post_date_gmt":"2023-01-10 05:12:36","post_content":"","post_title":"Electronics Shopping Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-90","to_ping":"","pinged":"","post_modified":"2023-01-10 11:56:49","post_modified_gmt":"2023-01-10 05:56:49","post_content_filtered":"","post_parent":0,"guid":"https:\/\/debug.tastewp.com\/?p=662","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h2 style=\"text-align: center;\">Electronics Shopping Form<\/h2>\n<p>&nbsp;<\/p>\n<p><img class=\"alignnone size-medium wp-image-685 aligncenter\" src=\"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Offer-300x144.png\" alt=\"\" width=\"300\" height=\"144\" \/><\/p>\n<p>&nbsp;<\/p>"},"id":"custom_html","active_page":0},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Select Product","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"grid","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Electronics","value":"Electronics"}],"products":[{"product_name":"Headphone","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":12,"product_description":"High quality premium headphones","category":"Electronics","enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"White","value":"White"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"levitating-music-headphones-display","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/levitating-music-headphones-display-scaled.jpg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/levitating-music-headphones-display-150x150.jpg"}]},{"product_name":"Laptop","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":120,"product_description":"HP Laptop Core i7 6th Generation","enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"Silver","value":"Silver"},{"label":"Black","value":"Black"},{"label":"Rose Gold","value":"Rose Gold"}]}]],"photo":[{"alt_text":"air13teaser_480x480","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/air13teaser_480x480.webp","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/air13teaser_480x480-150x150.webp"}],"category":"Electronics"},{"product_name":"Camera","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":22,"product_description":"Sony Digital Camera","categories":["all"],"enable_product":"no","product_size":[[{"label":"Model","options":[{"label":"S32EX","value":"S32EX"},{"label":"X456L","value":"X456L"}]}]],"photo":[{"alt_text":"Camera And Accessory","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/13130-scaled.jpg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/13130-150x150.jpg"}],"category":"Electronics"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"customer_name","active_page":0,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":0,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no"},"mollie":{"enabled":"yes","label":"Pay with Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx"},"square":{"enabled":"yes","label":"Pay with Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz"},"billplz":{"enabled":"yes","label":"Pay with Billplz"},"offline":{"enabled":"yes","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}},"default_value":"paypal","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"choose_payment_method","active_page":0}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"no","_wpf_custom_css":".wpf_form_wrapper_662 {\n    \n    background-color: #fff0e4; \n    border: 1px solid #ced4da; \n    border-radius: 10px; \n    font-family: calibri; \n    color: purple;\n   }\n\n.wpf_form_wrapper_662 h2,h4,h5,p {\n    color : purple;\n}\n\n.wpf-product-title {\n    color: purple;\n}\n\n.wpf_form_wrapper_662 #wpf_input_342_customer_name {\n   \n padding: 6px 12px;  \/*change padding*\/\n    background-color: #fff; \/*change background color*\/\n    border: 1px solid #ced4da; \/*change border width and color*\/\n    border-radius: 10px; \/*change corner round\/ border radius*\/\n    }\n\n.wpf_form_wrapper_662 #wpf_input_342_customer_email {\n    \n    padding: 6px 12px;  \/*change padding*\/\n    background-color: #fff; \/*change background color*\/\n    border: 1px solid #ced4da; \/*change border width and color*\/\n    border-radius: 10px;\n}\n\n.wpf_form_wrapper_662 .wpf_html_content_wrapper {\n    padding : 0;    \n}\n\n .wpf_form_wrapper_662 .wpf_preview_body{ \n     width: 600px;     \n }","_wpf_custom_js":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'shopping_cart_template_01S' => array(
                'label' => 'Shopping Cart Template 01S',
                'description' => 'Shopping Cart Template 01S',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":657,"post_author":"1","post_date":"2023-01-10 10:49:17","post_date_gmt":"2023-01-10 04:49:17","post_content":"","post_title":"Shopping Cart Template 01S","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"full-fledged-shopping-cart-step-form-template-grid-view","to_ping":"","pinged":"","post_modified":"2023-01-10 11:01:41","post_modified_gmt":"2023-01-10 05:01:41","post_content_filtered":"","post_parent":0,"guid":"https:\/\/debug.tastewp.com\/?p=657","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"grid","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Pant","value":"Pant"},{"label":"T-shirt","value":"T-shirt"},{"label":"Shoes","value":"Shoes"}],"products":[{"product_name":"Printed Cotton T Shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","category":"T-shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"S"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.33","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.33.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.33-150x150.jpeg"}]},{"product_name":"Casual Shoes","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":100,"product_description":"Sneakers for men Casual Shoes for Men","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"43","value":"43"},{"label":"44","value":"44"},{"label":"45","value":"45"}]}],[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.37","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.37.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.37-150x150.jpeg"}],"category":"Shoes"},{"product_name":"Casual T-shirt","default_quantity":1,"min_quantity":1,"max_quantity":10,"product_price":200,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","categories":["all"],"enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"S","value":"s"},{"label":"L","value":"L"},{"label":"M","value":"M"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.45","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.45.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.45-150x150.jpeg"}],"category":"T-shirt"},{"product_name":"Men T-shirt","default_quantity":1,"min_quantity":2,"max_quantity":10,"product_price":1000,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"L","value":"L"},{"label":"M","value":"M"},{"label":"N","value":"N"}]}],[{"label":"Color ","options":[{"label":"Black","value":"Black"},{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.45","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.45.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.45-150x150.jpeg"}],"category":"T-shirt"},{"product_name":"Mens Pant","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":900,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Black","value":"Black"},{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.46","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.46.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.46-150x150.jpeg"}],"category":"Pant"},{"product_name":"Mobile Pant ","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":700,"product_description":"Stylish Alphabet A To Z T-shirt For Unisex - T-Shirt & Stylish Jeans","enable_product":"no","product_size":[[{"label":"Size","options":[{"label":"32","value":"32"},{"label":"34","value":"34"},{"label":"36","value":"36"}]}],[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Black","value":"Black"}]}]],"photo":[{"alt_text":"photo_2023-01-03 17.18.42","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.42.jpeg","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/photo_2023-01-03-17.18.42-150x150.jpeg"}],"category":"Pant"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"customer_name","active_page":2,"quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":2,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":2},{"type":"step_form","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Product","description":"","fields":[]},{"title":"Cart","description":"","fields":[]},{"title":"Payment","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Payment Summary","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":1},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no"},"mollie":{"enabled":"yes","label":"Pay with Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx"},"square":{"enabled":"yes","label":"Pay with Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz"},"billplz":{"enabled":"yes","label":"Pay with Billplz"},"offline":{"enabled":"yes","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}},"default_value":"stripe"},"id":"choose_payment_method","active_page":2}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'furniture_shopping_art_form' => array(
                'label' => 'Furniture Shopping Cart Form',
                'description' => 'Furniture Shopping Cart Form',
                'category'=> 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"ID":673,"post_author":"1","post_date":"2023-01-10 11:50:10","post_date_gmt":"2023-01-10 05:50:10","post_content":"","post_title":"Furniture Shopping Cart Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-91","to_ping":"","pinged":"","post_modified":"2023-01-10 12:48:40","post_modified_gmt":"2023-01-10 06:48:40","post_content_filtered":"","post_parent":0,"guid":"https:\/\/debug.tastewp.com\/?p=673","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total}","processing_text":"Please Wait\u2026","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h2 style=\"text-align: center;\">Furniture Shopping Cart<\/h2>\n<p style=\"text-align: center;\"><img class=\"alignnone size-medium wp-image-685\" src=\"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Offer-300x144.png\" alt=\"\" width=\"300\" height=\"144\" \/><\/p>"},"id":"custom_html","active_page":0},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","isNumberic":"yes","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup Your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Select Product","show_sub_total":"yes","table_item_label":"Product","table_description_label":"Description","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","layout":"row","enable_quantity":"yes","enable_product_size":"yes","enable_search":"yes","enable_feature":"yes","categories":[{"label":"Furniture","value":"Furniture"}],"products":[{"product_name":"Red Chair","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":"$76","product_description":"Comfortable Red Chair for Household Use","category":"Furniture","enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Screen Shot 2023-01-10 at 12.49.29 PM","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.49.29-PM.png","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.49.29-PM-150x150.png"}]},{"product_name":"Red Sofa","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":90,"product_description":"High Quality Sofa for living room","enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"Green","value":"Green"},{"label":"Red","value":"Red"}]}]],"photo":[{"alt_text":"Screen Shot 2023-01-10 at 12.48.50 PM","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.48.50-PM.png","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.48.50-PM-150x150.png"}],"category":"Furniture"},{"product_name":"Modern chair","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":60,"product_description":"Modern chair for living room","categories":["all"],"enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Screen Shot 2023-01-10 at 1.00.53 PM","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-1.00.53-PM.png","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-1.00.53-PM-150x150.png"}],"category":"Furniture"},{"product_name":"Egg Chair","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":650,"product_description":"Comfy Egg Chair for office and home","enable_product":"no","product_size":[[{"label":"Color","options":[{"label":"Red","value":"Red"},{"label":"Green","value":"Green"}]}]],"photo":[{"alt_text":"Screen Shot 2023-01-10 at 12.48.50 PM","image_full":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.48.50-PM.png","image_thumb":"https:\/\/debug.tastewp.com\/wp-content\/uploads\/2023\/01\/Screen-Shot-2023-01-10-at-12.48.50-PM-150x150.png"}],"category":"Furniture"}],"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products","active_page":0},{"type":"step_form","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Cart","description":"","fields":[]},{"title":"Payment","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"payment_summary","editor_title":"Payment Summary","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Error Message","type":"textarea","group":"general","value":"You Have Not Any Payment Item"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Payment Summary","placeholder":"","min_height":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"payment_summary","active_page":1},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no"},"mollie":{"enabled":"yes","label":"Pay with Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx"},"square":{"enabled":"yes","label":"Pay with Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz"},"billplz":{"enabled":"yes","label":"Pay with Billplz"},"offline":{"enabled":"yes","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}},"default_value":"stripe","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"choose_payment_method","active_page":1}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_show_title_description":"","_wpf_custom_css":".wpf_form_wrapper_673 {\n    \n    background-color: #fff; \n    border: 1px solid #ced4da; \n    border-radius: 10px; \n    font-family: Poppins; \n    color: #EB455F;\n   }\n\n.wpf_form_wrapper_673 h2,h4,h5,p {\n    color : #EB455F;\n    font-family: Poppins; \n}\n\n.wpf-product-title {\n    color: #EB455F;\n}\n\n.wpf_form_wrapper_673 #wpf_input_342_customer_name {\n   \n padding: 6px 12px;  \/*change padding*\/\n    background-color: #fff; \/*change background color*\/\n    border: 1px solid #ced4da; \/*change border width and color*\/\n    border-radius: 10px; \/*change corner round\/ border radius*\/\n    }\n\n.wpf_form_wrapper_673 #wpf_input_342_customer_email {\n    \n    padding: 6px 12px;  \/*change padding*\/\n    background-color: #fff; \/*change background color*\/\n    border: 1px solid #ced4da; \/*change border width and color*\/\n    border-radius: 10px;\n}\n\n.wpf_form_wrapper_673 .wpf_html_content_wrapper {\n    padding : 0;    \n}\n\n .wpf_form_wrapper_673 .wpf_preview_body{ \n     width: 600px;     \n }","_wpf_custom_js":"","_payment_settings":[]}}',
                'is_pro' => true
            ),
            'multi_step_donation_form' => array(
                'label' => 'Multi Step Donation Form',
                'description' => 'Create a multi step donation form in one click',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":816,"post_author":"10","post_date":"2024-05-20 08:29:26","post_date_gmt":"2024-05-20 08:29:26","post_content":"","post_title":"Multi-Step Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-77","to_ping":"","pinged":"","post_modified":"2024-05-20 09:49:18","post_modified_gmt":"2024-05-20 09:49:18","post_content_filtered":"","post_parent":0,"guid":"https:\/\/pm.pennito.com\/?p=816","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Donate {payment_total} via Stripe","processing_text":"Please Wait\u2026","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","is_pro":"no","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h2 style=\"text-align: center;\">Multi-Step Donation Form<\/h2>\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-820 aligncenter\" src=\"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/Rectangle-3464059.png\" alt=\"\" width=\"98\" height=\"5\" \/><\/p>\n<p style=\"text-align: center;\">This is a multi-step donation form template.<\/p>\n<p style=\"text-align: center;\">Click the gear icon to change the text, image, form steps, field name, amount, etc as per your need.<\/p>"},"id":"custom_html","active_page":0},{"type":"donation_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"donation_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Choose Your Donation Amount","required":"yes","enable_image":"yes","intial_raising_amount":"320","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"show_statistic":"yes","donation_goals":1000,"progress_bar":"yes","one_time_type":"choose_single","image_url":[{"label":"","value":"","photo":{"alt_text":"image","image_full":"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/image.webp","image_thumb":"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/image-150x150.webp"}}],"multiple_pricing":[{"label":"$20","value":20},{"label":"$30","value":30},{"label":"$40","value":40},{"label":"$50","value":50},{"label":"$60","value":60},{"label":"$70","value":70},{"label":"$80","value":80},{"label":"$90","value":90},{"label":"$100","value":100}],"allow_custom_amount":"no","allow_recurring":"no","bill_time_max":"0","intervals":["day","week","month","year"],"interval_options":["day","week","month","year"]},"default_value":1},"id":"donation_item","active_page":0},{"type":"step_form","is_pro":"no","editor_title":"Step Form","group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":"","method":"prev","icon":"el-icon-back"},"next_btn":{"type":"default","text":"Next","img_url":"","method":"next","icon":"el-icon-right"},"del_step":{"type":"danger","text":"Delete Step","img_url":"","method":"del_step","icon":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"form_steps":[{"title":"Amount","description":"","fields":[]},{"title":"Info","description":"","fields":[]}]},"field_options":{"placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"step_form","active_page":0},{"type":"customer_name","active_page":1,"is_pro":"no","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"no","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","is_pro":"no","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":1,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"no","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"phone","quick_checkout_form":true,"editor_title":"Phone Number","is_pro":"no","group":"input","postion_group":"general","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_country_code":{"label":"Default Country","type":"select_option","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"active_list":{"label":"Show status","type":"radio_button","options":{"all":"All","hidden_list":"Hide these","visible_list":"Show all these","priority_based":"Prioritybased"},"group":"general","creatable":"yes"},"priority_country_code":{"label":"Country List","type":"select_multi_tags","options":{"AF":"Afghanistan","AX":"\u00c5land Islands","AL":"Albania","DZ":"Algeria","AS":"American Samoa","AD":"Andorra","AO":"Angola","AI":"Anguilla","AQ":"Antarctica","AG":"Antigua and Barbuda","AR":"Argentina","AM":"Armenia","AW":"Aruba","AU":"Australia","AT":"Austria","AZ":"Azerbaijan","BS":"Bahamas","BH":"Bahrain","BD":"Bangladesh","BB":"Barbados","BY":"Belarus","BE":"Belgium","PW":"Belau","BZ":"Belize","BJ":"Benin","BM":"Bermuda","BT":"Bhutan","BO":"Bolivia","BQ":"Bonaire, Saint Eustatius and Saba","BA":"Bosnia and Herzegovina","BW":"Botswana","BV":"Bouvet Island","BR":"Brazil","IO":"British Indian Ocean Territory","VG":"British Virgin Islands","BN":"Brunei","BG":"Bulgaria","BF":"Burkina Faso","BI":"Burundi","KH":"Cambodia","CM":"Cameroon","CA":"Canada","CV":"Cape Verde","KY":"Cayman Islands","CF":"Central African Republic","TD":"Chad","CL":"Chile","CN":"China","CX":"Christmas Island","CC":"Cocos (Keeling) Islands","CO":"Colombia","KM":"Comoros","CG":"Congo (Brazzaville)","CD":"Congo (Kinshasa)","CK":"Cook Islands","CR":"Costa Rica","HR":"Croatia","CU":"Cuba","CW":"Cura&ccedil;ao","CY":"Cyprus","CZ":"Czech Republic","DK":"Denmark","DJ":"Djibouti","DM":"Dominica","DO":"Dominican Republic","EC":"Ecuador","EG":"Egypt","SV":"El Salvador","GQ":"Equatorial Guinea","ER":"Eritrea","EE":"Estonia","ET":"Ethiopia","FK":"Falkland Islands","FO":"Faroe Islands","FJ":"Fiji","FI":"Finland","FR":"France","GF":"French Guiana","PF":"French Polynesia","TF":"French Southern Territories","GA":"Gabon","GM":"Gambia","GE":"Georgia","DE":"Germany","GH":"Ghana","GI":"Gibraltar","GR":"Greece","GL":"Greenland","GD":"Grenada","GP":"Guadeloupe","GU":"Guam","GT":"Guatemala","GG":"Guernsey","GN":"Guinea","GW":"Guinea-Bissau","GY":"Guyana","HT":"Haiti","HM":"Heard Island and McDonald Islands","HN":"Honduras","HK":"Hong Kong","HU":"Hungary","IS":"Iceland","IN":"India","ID":"Indonesia","IR":"Iran","IQ":"Iraq","IE":"Ireland","IM":"Isle of Man","IL":"Israel","IT":"Italy","CI":"Ivory Coast","JM":"Jamaica","JP":"Japan","JE":"Jersey","JO":"Jordan","KZ":"Kazakhstan","KE":"Kenya","KI":"Kiribati","KW":"Kuwait","KG":"Kyrgyzstan","LA":"Laos","LV":"Latvia","LB":"Lebanon","LS":"Lesotho","LR":"Liberia","LY":"Libya","LI":"Liechtenstein","LT":"Lithuania","LU":"Luxembourg","MO":"Macao S.A.R., China","MK":"Macedonia","MG":"Madagascar","MW":"Malawi","MY":"Malaysia","MV":"Maldives","ML":"Mali","MT":"Malta","MH":"Marshall Islands","MQ":"Martinique","MR":"Mauritania","MU":"Mauritius","YT":"Mayotte","MX":"Mexico","FM":"Micronesia","MD":"Moldova","MC":"Monaco","MN":"Mongolia","ME":"Montenegro","MS":"Montserrat","MA":"Morocco","MZ":"Mozambique","MM":"Myanmar","NA":"Namibia","NR":"Nauru","NP":"Nepal","NL":"Netherlands","NC":"New Caledonia","NZ":"New Zealand","NI":"Nicaragua","NE":"Niger","NG":"Nigeria","NU":"Niue","NF":"Norfolk Island","MP":"Northern Mariana Islands","KP":"North Korea","NO":"Norway","OM":"Oman","PK":"Pakistan","PS":"Palestinian Territory","PA":"Panama","PG":"Papua New Guinea","PY":"Paraguay","PE":"Peru","PH":"Philippines","PN":"Pitcairn","PL":"Poland","PT":"Portugal","PR":"Puerto Rico","QA":"Qatar","RE":"Reunion","RO":"Romania","RU":"Russia","RW":"Rwanda","BL":"Saint Barth&eacute;lemy","SH":"Saint Helena","KN":"Saint Kitts and Nevis","LC":"Saint Lucia","MF":"Saint Martin (French part)","SX":"Saint Martin (Dutch part)","PM":"Saint Pierre and Miquelon","VC":"Saint Vincent and the Grenadines","SM":"San Marino","ST":"S&atilde;o Tom&eacute; and Pr&iacute;ncipe","SA":"Saudi Arabia","SN":"Senegal","RS":"Serbia","SC":"Seychelles","SL":"Sierra Leone","SG":"Singapore","SK":"Slovakia","SI":"Slovenia","SB":"Solomon Islands","SO":"Somalia","ZA":"South Africa","GS":"South Georgia\/Sandwich Islands","KR":"South Korea","SS":"South Sudan","ES":"Spain","LK":"Sri Lanka","SD":"Sudan","SR":"Suriname","SJ":"Svalbard and Jan Mayen","SZ":"Swaziland","SE":"Sweden","CH":"Switzerland","SY":"Syria","TW":"Taiwan","TJ":"Tajikistan","TZ":"Tanzania","TH":"Thailand","TL":"Timor-Leste","TG":"Togo","TK":"Tokelau","TO":"Tonga","TT":"Trinidad and Tobago","TN":"Tunisia","TR":"Turkey","TM":"Turkmenistan","TC":"Turks and Caicos Islands","TV":"Tuvalu","UG":"Uganda","UA":"Ukraine","AE":"United Arab Emirates","GB":"United Kingdom (UK)","US":"United States (US)","UM":"United States (US) Minor Outlying Islands","VI":"United States (US) Virgin Islands","UY":"Uruguay","UZ":"Uzbekistan","VU":"Vanuatu","VA":"Vatican","VE":"Venezuela","VN":"Vietnam","WF":"Wallis and Futuna","EH":"Western Sahara","WS":"Samoa","YE":"Yemen","ZM":"Zambia","ZW":"Zimbabwe"},"group":"general","creatable":"yes"},"admin_label":{"label":"Admin Label","type":"number","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","active_list":"all","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"phone","active_page":1},{"type":"text","is_pro":"no","editor_title":"Single Line Text","active_page":1,"quick_checkout_form":true,"group":"input","postion_group":"general","isNumberic":"no","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"On Behalf Of (optional)","placeholder":"","required":"no","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"text"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card Info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","place_a_hold_on_stripe":"no"},"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"stripe_card_element","active_page":1}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => false
            ),
            'simple_donation_form' => array(
                'label' => 'Simple Donation Form',
                'description' => 'Create a simple donation Form for your website',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":826,"post_author":"10","post_date":"2024-05-21 03:42:36","post_date_gmt":"2024-05-21 03:42:36","post_content":"","post_title":"Simple Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blank-form-81","to_ping":"","pinged":"","post_modified":"2024-05-21 03:43:05","post_modified_gmt":"2024-05-21 03:43:05","post_content_filtered":"","post_parent":0,"guid":"https:\/\/pm.pennito.com\/?p=826","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wppayform_submit_button_settings":{"button_text":"Donate Now","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","customUrl":"","messageToShow":"<p>Thank you for your donation.<\/p>\n<div id=\"gtx-trans\" style=\"position: absolute;left: -110px;top: -9px\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","is_pro":"no","conditional_hide":true,"postion_group":"general","editor_elements":{"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}},"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"custom_html":"<h2 style=\"text-align: center;\">Simple Donation Form <\/h2>\n<p style=\"text-align: center;\"><img class=\"alignnone size-medium wp-image-827 aligncenter\" src=\"https:\/\/pm.pennito.com\/wp-content\/uploads\/2024\/05\/Donation-300x284.png\" alt=\"\" width=\"300\" height=\"284\" \/><\/p>\n<p>&nbsp;<\/p>"},"id":"custom_html","active_page":0},{"type":"customer_name","active_page":0,"is_pro":"no","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","is_pro":"no","group":"input","postion_group":"general","isNumberic":"no","page":"3","active_page":0,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"donation_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"donation_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation Progress Item","required":"yes","enable_image":"yes","intial_raising_amount":"0","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"show_statistic":"no","donation_goals":"1000","progress_bar":"yes","one_time_type":"choose_single","image_url":[{"label":"","value":"","photo":{"alt_text":"","image_full":"","image_thumb":""}}],"multiple_pricing":[{"label":"Donation Item 1","value":30},{"label":"Donation Item 2","value":40},{"label":"Donation Item 3","value":50},{"label":"Donation Item 4 ","value":60}],"allow_custom_amount":"no","allow_recurring":"no","bill_time_max":"0","intervals":["day","week","month","year"],"interval_options":["day","week","month","year"]},"default_value":0},"id":"donation_item","active_page":0},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card Info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no","place_a_hold_on_stripe":"no"}},"id":"stripe_card_element","active_page":0}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => false
            ),
            'donor_information_form' => array(
                'label' => 'Donor Information Form',
                'description' => 'Create donor information form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1105,"post_author":"1","post_date":"2022-01-28 08:19:30","post_date_gmt":"2022-01-28 08:19:30","post_content":"","post_title":"Donor Information Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"donor-information-form","to_ping":"","pinged":"","post_modified":"2022-01-28 08:21:47","post_modified_gmt":"2022-01-28 08:21:47","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1105","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation  Item","required":"yes","enable_image":"yes","pricing_details":{"one_time_type":"single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":"","photo":{"alt_text":"Banner-1","image_full":"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2021\/08\/Banner-1.png","image_thumb":"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2021\/08\/Banner-1-150x150.png"}}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => false,
            ),
            'paypal_payment_form' => array(
                'label' => 'PayPal Payment Form',
                'description' => 'Accept Payment using paypal',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"post_title":"Paypal Payment Form","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Customer Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Name","placeholder":"Your Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Customer Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Select the Product That you want to purchase","required":"yes","pricing_details":{"one_time_type":"choose_multiple","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Product 1","value":"25"},{"label":"Product 2","value":"35"},{"label":"Product 3","value":"50"}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Add On Products","required":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Add-on Item 1","value":"10"},{"label":"Add-on Item 2","value":"15"}],"prices_display_type":"radio"}},"id":"payment_item_1"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":"true","editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"yes"},"id":"paypal_gateway_element"}],"wppayform_submit_button_settings":{"button_text":"Pay with PayPal {payment_total}","processing_text":"Please Wait…","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Thank you for your purchase. Your Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Your Order ID: {submission.id}</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"New Product Sale, Customer: {input.customer_name} #{submission.id}","email_body":"<p>Good news! New Sale</p>\n<p>Customer Info:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"active"},{"title":"Email Notification to Submitter","email_to":"{input.customer_email}","reply_to":"{wp:admin_email}","email_subject":"Thank You  for your Order","email_body":"<p>Hello {input.customer_name},</p>\n<p>Thank you for order. Here is your payment receipt:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Your Order ID: {submission.id}</p>\n<p>Thank You</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"disabled"}],"wppayform_show_title_description":""}}',
                'is_pro' => true
            ),
            'multiple_payment_method' => array(
                'label' => 'Multiple Payment Method Form',
                'description' => 'Create form with PayPal and Stripe Payment Method',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form.png',
                'data' => '{"post_title":"Multiple Payment Method Form","form_meta":{"wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Customer Name","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Name","placeholder":"Your Name","required":"yes"},"id":"customer_name"},{"type":"customer_email","editor_title":"Customer Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"}},"field_options":{"label":"Email Address","placeholder":"Email Address","required":"yes","default_value":""},"id":"customer_email"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Select the Product That you want to purchase","required":"yes","pricing_details":{"one_time_type":"choose_multiple","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Product 1","value":"25"},{"label":"Product 2","value":"35"},{"label":"Product 3","value":"50"}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}}},"is_system_field":"true","is_payment_field":"true","field_options":{"label":"Add On Products","required":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":"10","show_onetime_labels":"yes","multiple_pricing":[{"label":"Add-on Item 1","value":"10"},{"label":"Add-on Item 2","value":"15"}],"prices_display_type":"radio"}},"id":"payment_item_1"},{"type":"choose_payment_method","editor_title":"Choose Payment Method Field","group":"payment_method_element","postion_group":"payment_method","single_only":"true","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Payment method","type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit/Debit Card (Stripe)","isActive":"true","editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":"true","editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"offline":{"label":"Offline/Check Payment","isActive":"true","editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amound is deposited"}}}},"group":"general"}},"field_options":{"label":"Select Payment Method","default_value":"","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"yes"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no"},"offline":{"enabled":"no"}}}},"id":"choose_payment_method"}],"wppayform_submit_button_settings":{"button_text":"Pay Now {payment_total}","processing_text":"Please Wait…","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Thank you for your purchase. Your Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Your Order ID: {submission.id}</p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"New Product Sale, Customer: {input.customer_name} #{submission.id}","email_body":"<p>Good news! New Sale</p>\n<p>Customer Info:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Order Details:</p>\n<p>{submission.product_items_table_html}</p>\n<p>Form Page URL: {wp:post_url}</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"active"},{"title":"Email Notification to Submitter","email_to":"{input.customer_email}","reply_to":"{wp:admin_email}","email_subject":"Thank You  for your Order","email_body":"<p>Hello {input.customer_name},</p>\n<p>Thank you for order. Here is your payment receipt:</p>\n<p>{submission.all_input_field_html}</p>\n<p>Your Order ID: {submission.id}</p>\n<p>Thank You</p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform/form_payment_success","status":"disabled"}],"wppayform_show_title_description":""}}',
                'is_pro' => true
            ),
            'sponsor_signup_and_payment_form' => array(
                'label' => 'Sponsor Signup and Payment Form',
                'description' => 'Create sponsor signup and payment form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1102,"post_author":"1","post_date":"2022-01-27 11:27:09","post_date_gmt":"2022-01-27 11:27:09","post_content":"","post_title":"Sponsor Signup and Payment Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"sponsor-signup-and-payment-form","to_ping":"","pinged":"","post_modified":"2022-01-27 11:27:38","post_modified_gmt":"2022-01-27 11:27:38","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1102","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Sponsorship Package","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_multiple","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Platinum","value":100},{"label":"Gold","value":50},{"label":"Silver","value":20}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Message","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'school_fee_payment_form' => array(
                'label' => 'School Fee Payment Form',
                'description' => 'Create school fee payment form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":85,"post_author":"1","post_date":"2022-03-08 10:12:24","post_date_gmt":"2022-03-08 10:12:24","post_content":"","post_title":"School Fee Payment Form with Payrexx","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"school-fee-payment-form-with-payrexx","to_ping":"","pinged":"","post_modified":"2022-03-08 10:13:14","post_modified_gmt":"2022-03-08 10:13:14","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=85","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with Payrexx","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">School Fee Payment Form with Payrexx<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Student Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Student ID","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"select","editor_title":"Dropdown Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Grade Level","placeholder":"","required":"no","options":[{"label":"Play Group","value":"Play Group"},{"label":"Grade 1","value":"Grade 1"},{"label":"Grade 2","value":"Grade 2"},{"label":"Grade 3","value":"Grade 3"},{"label":"Grade 4","value":"Grade 4"},{"label":"Grade 5","value":"Grade 5"}],"default_value":""},"id":"select"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Guardian Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"donation_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"donation_options","group":"general","label":"Configure Donation progress Item","selection_type":"Payment Type"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Select The Item You Want To Pay","required":"no","enable_image":"no","pricing_details":{"show_statistic":"no","donation_goals":"1000","progress_bar":"yes","one_time_type":"choose_single","image_url":[{"label":"","value":"","photo":{"alt_text":"","image_full":"","image_thumb":""}}],"multiple_pricing":[{"label":"Tution Fee","value":1000},{"label":"Exam Fee","value":200},{"label":"Book Fee","value":80},{"label":"Uniform Fee","value":90}],"allow_custom_amount":"yes","allow_recurring":"no","bill_time_max":"0","intervals":["day","week","month","year"],"interval_options":["day","week","month","year"]}},"id":"donation_item"},{"type":"terms_conditions","editor_title":"Consent\/T&C","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Terms Text","type":"textarea","group":"general","info":"Provide Terms & Confitions \/ Consent text (HTML Supported)"},"tc_description":{"label":"Terms Description (optional)","type":"html","group":"general","info":"The full description of your terms and condition. It will show as scrolable text"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general","info":"Keep value 1 if you want to make it pre-checked by default"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"I agree with the terms and condition","required":"yes","wrapper_class":"","admin_label":"Terms & Condition Agreement","tc_description":"","default_value":""},"id":"terms_conditions"},{"type":"payrexx_gateway_element","editor_title":"Payrexx Payment","editor_icon":"","group":"payment_method_element","method_handler":"payrexx","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Payrexx Payment Gateway"},"id":"payrexx_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'hotel_booking_form_with_square' => array(
                'label' => 'Hotel Booking From',
                'description' => 'Create hotel booking form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":79,"post_author":"1","post_date":"2022-03-08 09:27:58","post_date_gmt":"2022-03-08 09:27:58","post_content":"","post_title":"Hotel Booking Form with Square","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"hotel-booking-form-with-square","to_ping":"","pinged":"","post_modified":"2022-03-08 09:29:24","post_modified_gmt":"2022-03-08 09:29:24","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=79","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with Square","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Hotel Booking Form with Square<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Guest Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Room Type","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"Standard Room","trial_days":0,"has_trial_days":"no","billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.99,"is_default":"yes","plan_features":[]},{"name":"Family Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.99,"plan_features":[],"is_default":"no"},{"name":"Private Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.99,"plan_features":[],"is_default":"no"},{"name":"Mix Dorm Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":21.99,"plan_features":[],"is_default":"no"}]}},"id":"recurring_payment_item"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Check-in Date","placeholder":"","required":"yes","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Free Pickup?","placeholder":"","required":"no","options":[{"label":"Yes Please !","value":"Yes Please !"},{"label":"Not Thanks !","value":"Not Thanks !"}],"default_value":""},"id":"radio"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Flight Number","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Special Instruction","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"square_gateway_element","editor_title":"Square Payment","editor_icon":"","group":"payment_method_element","method_handler":"square","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Square Payment Gateway"},"id":"square_gateway_element"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'customer_bill_pay_form_with_Razorpay' => array(
                'label' => 'Customer Bill Pay Form With Razorpay',
                'description' => 'Create bill pay form with razorpay',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":79,"post_author":"1","post_date":"2022-03-08 09:27:58","post_date_gmt":"2022-03-08 09:27:58","post_content":"","post_title":"Hotel Booking Form with Square","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"hotel-booking-form-with-square","to_ping":"","pinged":"","post_modified":"2022-03-08 09:29:24","post_modified_gmt":"2022-03-08 09:29:24","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=79","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with Square","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Hotel Booking Form with Square<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Guest Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Room Type","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"Standard Room","trial_days":0,"has_trial_days":"no","billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.99,"is_default":"yes","plan_features":[]},{"name":"Family Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.99,"plan_features":[],"is_default":"no"},{"name":"Private Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.99,"plan_features":[],"is_default":"no"},{"name":"Mix Dorm Room","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"daily","bill_times":1,"has_signup_fee":"no","signup_fee":0,"subscription_amount":21.99,"plan_features":[],"is_default":"no"}]}},"id":"recurring_payment_item"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Check-in Date","placeholder":"","required":"yes","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Free Pickup?","placeholder":"","required":"no","options":[{"label":"Yes Please !","value":"Yes Please !"},{"label":"Not Thanks !","value":"Not Thanks !"}],"default_value":""},"id":"radio"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Flight Number","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Special Instruction","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"square_gateway_element","editor_title":"Square Payment","editor_icon":"","group":"payment_method_element","method_handler":"square","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Square Payment Gateway"},"id":"square_gateway_element"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'restaurant_order_form_with_paystack' => array(
                'label' => 'Restaurant Order Form With Paystack',
                'description' => 'Create restaurant order form with paystack',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":80,"post_author":"1","post_date":"2022-03-08 09:43:33","post_date_gmt":"2022-03-08 09:43:33","post_content":"","post_title":"Restaurant Order Form with Paystack","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"restaurant-order-form-with-paystack","to_ping":"","pinged":"","post_modified":"2022-03-08 09:44:05","post_modified_gmt":"2022-03-08 09:44:05","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=80","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with Paystack","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Restaurant Order Form with Paystack<\/h2>\n<h2 style=\"text-align: center;\">Order Now<\/h2>"}},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Crispy Onion Rings","required":"yes","enable_image":"yes","pricing_details":{"one_time_type":"single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":"","photo":{"alt_text":"high-angle-shot-fried-onion-rings-placed-green-plate","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/high-angle-shot-fried-onion-rings-placed-green-plate.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/high-angle-shot-fried-onion-rings-placed-green-plate-150x150.jpg"}}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"item_quantity","editor_title":"Item Quantity","group":"item_quantity","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Quantity","type":"text","group":"general"},"target_product":{"label":"Target Payment Item","type":"product_selector","group":"general","info":"Please select the product in where the quantity will be applied"},"min_value":{"label":"Minimum Quantity","type":"number","group":"general"},"max_value":{"label":"Maximum Quantity","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Quantity","placeholder":"Provide Quantity","required":"yes","min_value":1,"target_product":"payment_item","default_value":""},"id":"item_quantity"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Chose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Spring Rolls","required":"no","enable_image":"yes","pricing_details":{"one_time_type":"single","payment_amount":11,"show_onetime_labels":"yes","image_url":[{"label":"","value":"","photo":{"alt_text":"egg-roll-fried-spring-rolls-white-plate-thai-food","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/egg-roll-fried-spring-rolls-white-plate-thai-food.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/egg-roll-fried-spring-rolls-white-plate-thai-food-150x150.jpg"}}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item_1"},{"type":"item_quantity","editor_title":"Item Quantity","group":"item_quantity","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Quantity","type":"text","group":"general"},"target_product":{"label":"Target Payment Item","type":"product_selector","group":"general","info":"Please select the product in where the quantity will be applied"},"min_value":{"label":"Minimum Quantity","type":"number","group":"general"},"max_value":{"label":"Maximum Quantity","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Quantity","placeholder":"Provide Quantity","required":"yes","min_value":1,"target_product":"payment_item_1","default_value":""},"id":"item_quantity_1"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Chose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Sandwich","required":"no","enable_image":"yes","pricing_details":{"one_time_type":"single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":"","photo":{"alt_text":"sandwich","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/sandwich.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/sandwich-150x150.jpg"}}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item_2"},{"type":"item_quantity","editor_title":"Item Quantity","group":"item_quantity","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Quantity","type":"text","group":"general"},"target_product":{"label":"Target Payment Item","type":"product_selector","group":"general","info":"Please select the product in where the quantity will be applied"},"min_value":{"label":"Minimum Quantity","type":"number","group":"general"},"max_value":{"label":"Maximum Quantity","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Quantity","placeholder":"Provide Quantity","required":"yes","min_value":1,"target_product":"payment_item_2","default_value":""},"id":"item_quantity_2"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"How you want your order delivered?","required":"no","default_value":"","options":[{"label":"I will pickup my order.","value":"I will pickup my order."},{"label":"I want you to deliver at my door.","value":"I want you to deliver at my door."}]},"id":"checkbox"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comment","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"paystack_gateway_element","editor_title":"Paystack Payment","editor_icon":"","group":"payment_method_element","method_handler":"paystack","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Paystack Payment Gateway"},"id":"paystack_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'rental_payment_form_with_offline_payment' => array(
                'label' => 'Rental Payment Form With Offline Payment',
                'description' => 'Create rental payment form with offline payment',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":87,"post_author":"1","post_date":"2022-03-08 10:50:42","post_date_gmt":"2022-03-08 10:50:42","post_content":"","post_title":"Rental Payment Form with Offline Payment","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"rental-payment-form-with-offline-payment","to_ping":"","pinged":"","post_modified":"2022-03-08 10:52:22","post_modified_gmt":"2022-03-08 10:52:22","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=87","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Rental Payment Form with Offline Payment<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Tenant Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Rent To Pay","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Payment Method","placeholder":"","required":"no","options":[{"label":"Cash","value":"Cash"},{"label":"Cheque","value":"Cheque"},{"label":"Money Order","value":"Money Order"}],"default_value":""},"id":"radio"},{"type":"offline_gateway_element","editor_title":"Offline\/Check Payment","editor_icon":"","group":"payment_method_element","method_handler":"offline","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea"}},"field_options":{"label":"Offline Payment Instruction","description":"Make your payment directly into our bank account. Please use your Tenant ID as the payment reference. The payment will be marked as paid once the amount is deposited"},"id":"offline_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'product_purchase_order_form_with_paypal' => array(
                'label' => 'Product Purchase Order Form With Paypal',
                'description' => 'Create product purchase order form with paypal',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":71,"post_author":"1","post_date":"2022-03-07 06:20:04","post_date_gmt":"2022-03-07 06:20:04","post_content":"","post_title":"Product Purchase Order Form with Paypal","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"product-purchase-order-form-with-paypal","to_ping":"","pinged":"","post_modified":"2022-03-08 08:11:35","post_modified_gmt":"2022-03-08 08:11:35","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=71","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<h3 style=\"text-align: center;\">Product Purchase Order Form with Paypal<\/h3>\n<h3 style=\"text-align: center;\">Purchase Order<\/h3>\n<p style=\"text-align: center;\">What would you like to purchase?<\/p>"},"id":"custom_html"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"My Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":10},{"product_name":"Product 2","default_quantity":1,"min_quantity":1,"max_quantity":100,"product_price":20},{"product_name":"Product 3","default_quantity":0,"min_quantity":1,"max_quantity":100,"product_price":30}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"paypal_gateway_element","editor_title":"Paypal Payment","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","_wp_old_slug":"blank-form-13","wppayform_show_title_description":"no"}}',
                'is_pro' => true
            ),
            'tabular_product_order_form_with_stripe' => array(
                'label' => 'Tabular Product Order Form With Stripe',
                'description' => 'Create tabular product order form with stripe',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":65,"post_author":"1","post_date":"2022-03-01 11:28:39","post_date_gmt":"2022-03-01 11:28:39","post_content":"<p>What are you interested to buy?<\/p>","post_title":"Tabular Product Order Form with Stripe","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"tabular-product-order-form-with-stripe","to_ping":"","pinged":"","post_modified":"2022-03-08 08:25:11","post_modified_gmt":"2022-03-08 08:25:11","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=65","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h3 style=\"text-align: center;\">Tabular Product Order Form with Stripe<\/h3>\n<p style=\"text-align: center;\">What are you interested to buy?<\/p>"}},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10,"photo":{"alt_text":"product 3","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-3.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-3-150x150.jpg"}},{"product_name":"Product 2","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20,"photo":{"alt_text":"product 1","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-1.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-1-150x150.jpg"}},{"product_name":"Product 3","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":25,"photo":{"alt_text":"product 2","image_full":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-2.jpg","image_thumb":"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/product-2-150x150.jpg"}}],"enable_image":"yes","enable_lightbox":"no"},"id":"tabular_products"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","wppayform_form_scheduling_settings":{"limitNumberOfEntries":{"status":"no","limit_type":"total","number_of_entries":100,"limit_payment_statuses":[],"limit_exceeds_message":"Number of entry has been exceeds, Please check back later"},"scheduleForm":{"status":"no","start_date":"2022-03-01 11:35:40","end_date":"","before_start_message":"Form submission time schedule is not started yet. Please check back later","expire_message":"Form submission time has been expired."},"limitByPayments":{"status":"yes","limit_type":"payment","payment_limit":1000,"limit_exceeds_message":"Payment target amount reached, Please check back later."},"requireLogin":{"status":"no","message":"You need to login to submit this form"},"restriction_applied_type":"hide_form"},"_wp_old_slug":"tabular-product-order-form","wppayform_show_title_description":"no"}}',
                'is_pro' => true
            ),
            'multiple_choice_recurring_subscription_form_with_sslcommerz' => array(
                'label' => 'Multiple Choice Recurring Subscription Form With SSLCOMMERZ',
                'description' => 'Create multiple choice recurring subscription form with sslcommerz',
                'category' => 'Subscription',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":86,"post_author":"1","post_date":"2022-03-08 10:21:23","post_date_gmt":"2022-03-08 10:21:23","post_content":"","post_title":"Multiple Choice Recurring Subscription Form with SSLCOMMERZ","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"multiple-choice-recurring-subscription-form-with-sslcommerz","to_ping":"","pinged":"","post_modified":"2022-03-08 10:22:01","post_modified_gmt":"2022-03-08 10:22:01","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=86","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with SSLCOMMERZ","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Multiple Choice Recurring Subscription Form with SSLCOMMERZ<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Subscription Plans","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"Bronze","trial_days":7,"has_trial_days":"yes","billing_interval":"month","bill_times":12,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.99,"is_default":"yes","plan_features":[]},{"name":"Gold","trial_days":7,"has_trial_days":"yes","trial_preriod_days":0,"billing_interval":"month","bill_times":12,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.99,"plan_features":[],"is_default":"no"},{"name":"Diamond","trial_days":7,"has_trial_days":"yes","trial_preriod_days":0,"billing_interval":"month","bill_times":12,"has_signup_fee":"no","signup_fee":0,"subscription_amount":29.99,"plan_features":[],"is_default":"no"}]}},"id":"recurring_payment_item"},{"type":"sslcommerz_gateway_element","editor_title":"SSLCommerz Payment","editor_icon":"","group":"payment_method_element","method_handler":"sslcommerz","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Sslcommerz Payment Gateway"},"id":"sslcommerz_gateway_element"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'online_taxi_booking_form_with_multiple_payment_gateway' => array(
                'label' => 'Online Taxi Booking Form With Multiple Payment Gateway',
                'description' => 'Create online taxi booking form with payment gateway',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":88,"post_author":"1","post_date":"2022-03-08 10:58:12","post_date_gmt":"2022-03-08 10:58:12","post_content":"","post_title":"Online Taxi Booking Form with Multiple Payment Gateway","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"online-taxi-booking-form-with-multiple-payment-gateway","to_ping":"","pinged":"","post_modified":"2022-03-08 10:58:41","post_modified_gmt":"2022-03-08 10:58:41","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=88","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} Now","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Online Taxi Booking Form with Multiple Payment Gateway<\/h2>\n<p><img class=\"alignnone size-medium wp-image-89 aligncenter\" src=\"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/yellow-black-sign-taxi-placed-top-car-night-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" \/><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Pickup Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"no","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"no","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"no","required":"no","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Destination Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"no","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"no","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"no","required":"no","type":"select","id":"country","default_value":""}}},"id":"address_input_1"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Taxi Fare","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"0 - 5 KM","value":5},{"label":"5 - 10 KM","value":10},{"label":"10 - 15 KM","value":15}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_value":{"label":"Default Payment method","type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout","require_billing_info":"no"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"sslcommerz":{"label":"Sslcommerz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"offline":{"label":"Offline\/Check Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","default_value":"","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no"},"mollie":{"enabled":"yes","label":"Pay with Mollie"},"razorpay":{"enabled":"yes","label":"Pay with Razorpay"},"paystack":{"enabled":"yes","label":"Pay with Paystack"},"payrexx":{"enabled":"yes","label":"Pay with Payrexx"},"square":{"enabled":"yes","label":"Pay with Square"},"sslcommerz":{"enabled":"yes","label":"Pay with Sslcommerz"},"offline":{"enabled":"no"}}}},"id":"choose_payment_method"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'pledge_form' => array(
                'label' => 'Pledge Form',
                'description' => 'Create pledge form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1125,"post_author":"1","post_date":"2022-01-28 10:54:34","post_date_gmt":"2022-01-28 10:54:34","post_content":"","post_title":"Pledge Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"pledge-form","to_ping":"","pinged":"","post_modified":"2022-01-28 10:54:48","post_modified_gmt":"2022-01-28 10:54:48","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1125","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<p style=\"text-align: center;\"><span style=\"color: #339966;\"><strong>Green Peace Center<\/strong><\/span><\/p>\n<p style=\"text-align: center;\"><strong><span style=\"color: #008080;\">Pledge Towards Global Resource Foundation<\/span><\/strong><\/p>\n<p>&nbsp;<\/p>"},"id":"custom_html"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"select","editor_title":"Dropdown Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Green Peace Community","placeholder":"","required":"no","options":[{"label":"Atlanta","value":"Atlanta"},{"label":"Barbados","value":"Barbados"},{"label":"Belize","value":"Belize"},{"label":"Cairo Centre","value":"Cairo Centre"},{"label":"Cairo South Centre","value":"Cairo South Centre"},{"label":"California Centre","value":"California Centre"},{"label":"Durban","value":"Durban"},{"label":"Jamaica","value":"Jamaica"},{"label":"Johannesburg","value":"Johannesburg"}],"default_value":""},"id":"select"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Do you currently pledge to the Global Resource Fund?","placeholder":"","required":"no","options":[{"label":"Yes","value":"Yes"},{"label":"No","value":"No"}],"default_value":""},"id":"radio"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comment","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html_1","field_options":{"custom_html":"<p>Thank you for your contribution.<\/p>"}}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => false,
            ),
            'blood_donation_form' => array(
                'label' => 'Blood Donation Form',
                'description' => 'Create simple blood donation form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1084,"post_author":"1","post_date":"2022-01-27 07:14:23","post_date_gmt":"2022-01-27 07:14:23","post_content":"","post_title":"Blood Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"blood-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 08:01:43","post_modified_gmt":"2022-01-27 08:01:43","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1084","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><span style=\"color: #ff0000;\"><strong>Donors Registration Form<\/strong><\/span><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"no","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"no","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"no","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"select","editor_title":"Dropdown Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Blood Group","placeholder":"","required":"no","options":[{"label":"A+","value":"A+"},{"label":"AB+","value":"AB+"},{"label":"A-","value":"A-"},{"label":"AB-","value":"AB-"},{"label":"B+","value":"B+"},{"label":"B-","value":"B-"},{"label":"O+","value":"O+"},{"label":"O-","value":"O-"}],"default_value":""},"id":"select"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email ","placeholder":"Email ","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Feedback","placeholder":"","min_height":0,"required":"no"},"id":"textarea"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true
            ),
            'church_donation_form' => array(
                'label' => 'Church Donation Form',
                'description' => 'Create church donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1081,"post_author":"1","post_date":"2022-01-27 06:04:06","post_date_gmt":"2022-01-27 06:04:06","post_content":"","post_title":"Church Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"church-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 06:04:56","post_modified_gmt":"2022-01-27 06:04:56","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1081","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"yes","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Product 2","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'paypal_donation_form' => array(
                'label' => 'PayPal Donation Form',
                'description' => 'Create paypal donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1087,"post_author":"1","post_date":"2022-01-27 08:19:36","post_date_gmt":"2022-01-27 08:19:36","post_content":"","post_title":"Paypal Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"paypal-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 08:19:55","post_modified_gmt":"2022-01-27 08:19:55","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1087","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-responsive-charity-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email ","placeholder":"Email ","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":" Amount","placeholder":"$","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comment","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment ","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'online_donation_form' => array(
                'label' => 'Online Donation Form',
                'description' => 'Create online donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1101,"post_author":"1","post_date":"2022-01-27 11:07:41","post_date_gmt":"2022-01-27 11:07:41","post_content":"<p>Make a Donation!<\/p>","post_title":"Online Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"online-donation-form-2","to_ping":"","pinged":"","post_modified":"2022-01-27 11:08:25","post_modified_gmt":"2022-01-27 11:08:25","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1101","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation Progress Item","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"A","value":10},{"label":"B","value":20},{"label":"C","value":30}],"prices_display_type":"radio"}},"id":"payment_item"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'responsive_charity_donation_form' => array(
                'label' => 'Responsive Charity Donation Form',
                'description' => 'Create responsive charity donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1085,"post_author":"1","post_date":"2022-01-27 08:04:06","post_date_gmt":"2022-01-27 08:04:06","post_content":"","post_title":"Responsive Charity Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"responsive-charity-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 08:07:03","post_modified_gmt":"2022-01-27 08:07:03","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1085","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email ","placeholder":"Email ","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":" Amount","placeholder":"$","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Message","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'online_foundation_donation_form' => array(
                'label' => 'Online Foundation Donation Form',
                'description' => 'Create online foundation donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1094,"post_author":"1","post_date":"2022-01-27 09:36:54","post_date_gmt":"2022-01-27 09:36:54","post_content":"<p><strong><span style=\"color: #008000\">Yes, I am happy to support Green Foundation.<\/span><\/strong><\/p>","post_title":"Online Foundation Donation","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"online-foundation-donation","to_ping":"","pinged":"","post_modified":"2022-01-27 09:38:52","post_modified_gmt":"2022-01-27 09:38:52","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1094","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donation Type","placeholder":"","required":"no","options":[{"label":"Donation by Phone - Please call 000 000 000 000 to donate by phone","value":"Donation by Phone - Please call 000 000 000 000 to donate by phone"},{"label":"Donation by Mail - Please mail your form to [address]","value":"Donation by Mail - Please mail your form to [address]"},{"label":"Donate Online","value":"Donate Online"}],"default_value":""},"id":"radio"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<p>Thank you! Your support is greatly appreciated.<\/p>"},"id":"custom_html"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"USD","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'product_pre_order_form_with_mollie' => array(
                'label' => 'Product Pre Order Form With Mollie',
                'description' => 'Create product pre-order form with mollie',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":76,"post_author":"1","post_date":"2022-03-08 09:02:26","post_date_gmt":"2022-03-08 09:02:26","post_content":"","post_title":"Product Pre-Order Form with Mollie","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"product-pre-order-form-with-mollie","to_ping":"","pinged":"","post_modified":"2022-03-08 09:02:48","post_modified_gmt":"2022-03-08 09:02:48","post_content_filtered":"","post_parent":0,"guid":"https:\/\/payform.tastewp.com\/?p=76","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"wppayform_submit_button_settings":{"button_text":"Pay {payment_total} with Mollie","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-12","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<h2 style=\"text-align: center;\">Product Pre-Order Form with Mollie<\/h2>\n<p><img class=\"alignnone size-medium wp-image-82 aligncenter\" src=\"https:\/\/payform.tastewp.com\/wp-content\/uploads\/2022\/03\/4497268-300x149.jpg\" alt=\"\" width=\"300\" height=\"149\" \/><\/p>"},"id":"custom_html"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Shipping Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Shipping Instruction","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Brand","required":"no","default_value":"","options":[{"label":"NYX","value":"NYX"},{"label":"ELF","value":"ELF"},{"label":"MAC","value":"MAC"},{"label":"OPPO","value":"OPPO"},{"label":"REALME","value":"REALME"},{"label":"XIOMI","value":"XIOMI"}]},"id":"checkbox"},{"type":"payment_item","editor_title":"Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Payment Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Payment Item","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_multiple","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Model A343","value":100}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"item_quantity","editor_title":"Item Quantity","group":"item_quantity","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Quantity","type":"text","group":"general"},"target_product":{"label":"Target Payment Item","type":"product_selector","group":"general","info":"Please select the product in where the quantity will be applied"},"min_value":{"label":"Minimum Quantity","type":"number","group":"general"},"max_value":{"label":"Maximum Quantity","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Quantity","placeholder":"Provide Quantity","required":"yes","min_value":1,"target_product":"payment_item","default_value":""},"id":"item_quantity"},{"type":"mollie_gateway_element","editor_title":"Mollie Payment","editor_icon":"","group":"payment_method_element","method_handler":"mollie","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Mollie Payment Gateway"},"id":"mollie_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true
            ),
            'baseball_fundraising_form' => array(
                'label' => 'Baseball Fundraising Form',
                'description' => 'Create baseball fundraising form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1093,"post_author":"1","post_date":"2022-01-27 09:18:36","post_date_gmt":"2022-01-27 09:18:36","post_content":"<p><span style=\"color: #339966\"><strong>Support Starclub Baseball Team<\/strong><\/span><\/p>","post_title":"Baseball Fundraising Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"baseball-fundraising-form","to_ping":"","pinged":"","post_modified":"2022-01-27 09:20:00","post_modified_gmt":"2022-01-27 09:20:00","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1093","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Sponsorship Packages","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Platinum Sponsor","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":300},{"product_name":"Gold Sponsor","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":200},{"product_name":"Silver Sponsor","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":100}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Sponsors Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player Sponsored","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Sponsors Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Would you like your name to appear on sponsor banner?","required":"no","default_value":"","options":[{"label":"Yes","value":"Yes"},{"label":"No","value":"No"}]},"id":"checkbox"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Name","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'square_charity_donation' => array(
                'label' => 'Square Charity Donation Form',
                'description' => 'Create Charity Donation form with square',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1089,"post_author":"1","post_date":"2022-01-27 08:31:16","post_date_gmt":"2022-01-27 08:31:16","post_content":"","post_title":"Square Charity Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"square-charity-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 08:31:58","post_modified_gmt":"2022-01-27 08:31:58","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1089","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Message","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"square_gateway_element","editor_title":"Square payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"square","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Pay by Square"},"id":"square_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'register_as_a_blood_donor_form' => array(
                'label' => 'Register As A Blood Donor Form',
                'description' => 'Create blood donor registration form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1099,"post_author":F"1","post_date":"2022-01-27 10:58:31","post_date_gmt":"2022-01-27 10:58:31","post_content":"","post_title":"Register as a Blood Donor Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"register-as-a-blood-donor-form","to_ping":"","pinged":"","post_modified":"2022-01-27 10:59:04","post_modified_gmt":"2022-01-27 10:59:04","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1099","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Birth","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Blood Group","placeholder":"A+","required":"no","default_value":""},"id":"text"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Last Donate Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date_1"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'recurring_donation_form' => array(
                'label' => 'Recurring Donation Form',
                'description' => 'Create recurring donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1092,"post_author":"1","post_date":"2022-01-27 09:09:36","post_date_gmt":"2022-01-27 09:09:36","post_content":"<p>Set a custom amount to make a recurring donation.<\/p>","post_title":"Recurring Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"recurring-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 09:11:29","post_modified_gmt":"2022-01-27 09:11:29","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1092","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Product 2","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Recurring Payment Amount","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"$9.99 \/ Month","trial_days":0,"has_trial_days":"no","billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.9900000000000002,"is_default":"yes","plan_features":[]}]}},"id":"recurring_payment_item"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'quick_donation_form' => array(
                'label' => 'Quick Donation Form',
                'description' => 'Create quick donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1083,"post_author":"1","post_date":"2022-01-27 06:17:47","post_date_gmt":"2022-01-27 06:17:47","post_content":"","post_title":"Quick Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"quick-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 08:02:54","post_modified_gmt":"2022-01-27 08:02:54","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1083","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"select","editor_title":"Dropdown Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Types of Donation","placeholder":"","required":"yes","options":[{"label":"Cash","value":"Cash"},{"label":"Product\/Item","value":"Product\/Item"},{"label":"Service","value":"Service"},{"label":"Other","value":"Other"}],"default_value":""},"id":"select"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Notes","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Company Name","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email","placeholder":"Email ","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number_1"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"no","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"no","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"no","required":"no","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'quick_and_easy_church_donation_form' => array(
                'label' => 'Quick And Easy Church Donation Form',
                'description' => 'Create quick and easy church donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1095,"post_author":"1","post_date":"2022-01-27 09:56:58","post_date_gmt":"2022-01-27 09:56:58","post_content":"","post_title":"Quick and Easy Church Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"quick-and-easy-church-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 09:57:28","post_modified_gmt":"2022-01-27 09:57:28","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1095","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"General Ministry Fund Commitment for 2022","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"simple","selection_type":"radio","pricing_options":[{"name":"$9.99 \/ Month","trial_days":0,"has_trial_days":"no","billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.9900000000000002,"is_default":"yes","plan_features":[],"user_input":"yes"}]}},"id":"recurring_payment_item"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Chose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Building Fund","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"simple","selection_type":"radio","pricing_options":[{"name":"$99.99 \/ Month","trial_days":0,"has_trial_days":"no","billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":99.989999999999995,"is_default":"yes","plan_features":[]}]}},"id":"recurring_payment_item_1"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment ","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'item_donation_form' => array(
                'label' => 'Item Donation Form',
                'description' => 'Create item donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1100,"post_author":"1","post_date":"2022-01-27 11:03:08","post_date_gmt":"2022-01-27 11:03:08","post_content":"","post_title":"Item Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"item-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-27 11:03:25","post_modified_gmt":"2022-01-27 11:03:25","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1100","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Types of Donation","placeholder":"","required":"no","options":[{"label":"Financial Donation","value":"Financial Donation"},{"label":"Shoes and Bags","value":"Shoes and Bags"},{"label":"Books","value":"Books"},{"label":"Furniture","value":"Furniture"},{"label":"Hygiene Essentials","value":"Hygiene Essentials"}],"default_value":""},"id":"radio"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"What would you like to donate?","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":"","min_value":"1"},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'walk_a_thon_registration_form' => array(
                'label' => 'Walk-a-Thon Registration Form',
                'description' => 'Create walk-a-thon registration form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1111,"post_author":"1","post_date":"2022-01-28 09:22:50","post_date_gmt":"2022-01-28 09:22:50","post_content":"<h3>MCC\/MUW Giving Campaign<\/h3>\n<p>Projects United Walk a Thon: REGISTRATION &amp; DONOR FORM<\/p>","post_title":"Walk a Thon Registration Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"walk-a-thon-registration-form","to_ping":"","pinged":"","post_modified":"2022-01-28 09:24:18","post_modified_gmt":"2022-01-28 09:24:18","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1111","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Interested in","required":"no","default_value":"","options":[{"label":"Walking or Running","value":"Walking or Running"},{"label":"Organization Table","value":"Organization Table"},{"label":"Voluteering","value":"Voluteering"},{"label":"Donation Funds","value":"Donation Funds"},{"label":"Other","value":"Other"}]},"id":"checkbox"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comments","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Association","placeholder":"","required":"no","options":[{"label":"MCC Employee","value":"MCC Employee"},{"label":"General Community Member","value":"General Community Member"},{"label":"Company Organization","value":"Company Organization"}],"default_value":""},"id":"radio"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'toys_for_tots_application_form' => array(
                'label' => 'Toys For Tots Application Form',
                'description' => 'Create toys for tots application form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1121,"post_author":"1","post_date":"2022-01-28 10:16:55","post_date_gmt":"2022-01-28 10:16:55","post_content":"","post_title":"Toys for Tots Application Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"toys-for-tots-application-form","to_ping":"","pinged":"","post_modified":"2022-01-28 10:17:31","post_modified_gmt":"2022-01-28 10:17:31","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1121","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"no","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><br \/><img class=\"alignnone size-medium wp-image-1122 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/Toys-For-Tots-Logo-300x102.jpg\" alt=\"\" width=\"300\" height=\"102\" \/><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Applicant Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Birth","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Applicant Photo","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":4,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Child Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Child Birth Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date_1"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select which of the following you receive","placeholder":"","required":"no","options":[{"label":"Medicaid","value":"Medicaid"},{"label":"Food & Nutrition","value":"Food & Nutrition"},{"label":"Social Security Disability","value":"Social Security Disability"}],"default_value":""},"id":"radio"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html_1","field_options":{"custom_html":"<p><strong>*Please Read Carefully<\/strong><\/p>\n<p>The Mankind Church of Christ is proud to serve as a donation site for Toys for Tots. Each application is submitted as a request and therefore not guaranteed. All application decisions are granted at the sole discretion of Toys for Tots and its partners. Please submit all required documents before the specified date so that your request will be processed in an efficient timeframe. Please fill out all required information so we can keep you updated on your application status. To ensure that all approved applicants are served, a government issued ID is required.<\/p>\n<p>If you have any questions please leave it in the box below.<\/p>"}}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'thanksgiving_donation_form' => array(
                'label' => 'Thanksgiving Donation Form',
                'description' => 'Create thanks giving donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1126,"post_author":"1","post_date":"2022-01-28 11:17:26","post_date_gmt":"2022-01-28 11:17:26","post_content":"<p>The holidays are approaching and we need a little donation in providing a Thanksgiving Dinner for the needy from the local area. Your support is highly appreciated!<\/p>","post_title":"Thanksgiving Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"thanksgiving-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 11:26:56","post_modified_gmt":"2022-01-28 11:26:56","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1126","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><img class=\"alignnone size-medium wp-image-1127 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/Call-us-at-123-456-7890-300x150.png\" alt=\"\" width=\"300\" height=\"150\" \/><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Donation Item","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Product 2","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20},{"product_name":"Product 3","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":0}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'save_the_trees_donation_form' => array(
                'label' => 'Save The Trees Donation Form',
                'description' => 'Create save the trees donation from',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1104,"post_author":"1","post_date":"2022-01-28 08:16:58","post_date_gmt":"2022-01-28 08:16:58","post_content":"<p>Help us save our planet<\/p>","post_title":"Save The Trees Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"save-the-trees-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 08:17:31","post_modified_gmt":"2022-01-28 08:17:31","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1104","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Save Our Planet For","placeholder":"USD","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'orphanage_donation_form' => array(
                'label' => 'Orphanage Donation Form',
                'description' => 'Create orphanage donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1112,"post_author":"1","post_date":"2022-01-28 09:30:54","post_date_gmt":"2022-01-28 09:30:54","post_content":"<p><img src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2021\/08\/Banner-1-300x118.png\" alt=\"\" width=\"600\" height=\"236\" \/><\/p>\n<p>Just a dollar could save a soul.<\/p>","post_title":"Orphanage Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"orphanage-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 09:35:41","post_modified_gmt":"2022-01-28 09:35:41","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1112","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Payment Methods","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donor Email","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'non_profit_donation_form' => array(
                'label' => 'Non Profit Donation Form',
                'description' => 'Create non profit donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1118,"post_author":"1","post_date":"2022-01-28 10:04:55","post_date_gmt":"2022-01-28 10:04:55","post_content":"","post_title":"Non Profit Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"non-profit-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 10:05:38","post_modified_gmt":"2022-01-28 10:05:38","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1118","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p style=\"text-align: center;\"><span style=\"color: #008000;\"><strong>Save The Planet<\/strong><\/span><\/p>\n<p style=\"text-align: center;\">Donate and help us plant a tree.<\/p>"}},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donate to Our Cause","placeholder":"USD","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'fund_raiser_for_elementary_school_project_form' => array(
                'label' => 'Fundraiser For Elementary School Project Form',
                'description' => 'Create fundraiser for elementary school project form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1106,"post_author":"1","post_date":"2022-01-28 08:25:14","post_date_gmt":"2022-01-28 08:25:14","post_content":"<p>Thank you for supporting our fundraising campaign. All profits go to Sunrise Elementary School Project. For quick information directly contact to Mike Powel at 000 000 000.<\/p>","post_title":"Fund Raiser for Elementary School Project","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"fund-raiser-for-elementary-school-project","to_ping":"","pinged":"","post_modified":"2022-01-28 08:34:58","post_modified_gmt":"2022-01-28 08:34:58","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1106","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<p><img class=\"alignnone size-medium wp-image-1110 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/1253543-5-26-21-The-18-Best-Essential-Oils-for-Anxiety-732x549-Feature-300x225.jpg\" alt=\"\" width=\"300\" height=\"225\" \/><\/p>"},"id":"custom_html"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Essential Oil Intro Kit","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Citrus Bliss Hand Lotion","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20},{"product_name":"Body Butter","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":30},{"product_name":"Essential Oil Difuser","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":25}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Preferred Contact Method","placeholder":"","required":"no","options":[{"label":"Phone","value":"Phone"},{"label":"Email","value":"Email"}],"default_value":""},"id":"radio"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'fund_giving_donation_form' => array(
                'label' => 'Fund Giving Donation Form',
                'description' => 'Create fund giving donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1132,"post_author":"1","post_date":"2022-01-28 12:30:02","post_date_gmt":"2022-01-28 12:30:02","post_content":"<p>Donate using your credit card.<\/p>","post_title":"Fund Giving Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"fund-giving-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 12:30:28","post_modified_gmt":"2022-01-28 12:30:28","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1132","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-credit-card-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Dedicate to Your Loved One","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'donation_payment_form_template' => array(
                'label' => 'Donation Payment Form',
                'description' => 'Create donation payment form template',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1135,"post_author":"1","post_date":"2022-01-28 12:40:01","post_date_gmt":"2022-01-28 12:40:01","post_content":"","post_title":"Donation Payment Form Template","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"donation-payment-form-template","to_ping":"","pinged":"","post_modified":"2022-01-28 12:40:24","post_modified_gmt":"2022-01-28 12:40:24","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1135","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-online-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donation Type","placeholder":"","required":"yes","options":[{"label":"Love Offering","value":"Love Offering"},{"label":"Building Expansion","value":"Building Expansion"},{"label":"One Time Donation","value":"One Time Donation"}],"default_value":""},"id":"radio"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comments","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"USD","required":"yes","default_value":"","min_value":"1"},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":" Payment Method","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'credit_card_donation_form' => array(
                'label' => 'Credit Card Donation Form',
                'description' => 'Create credit card donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1124,"post_author":"1","post_date":"2022-01-28 10:25:31","post_date_gmt":"2022-01-28 10:25:31","post_content":"<p>Donate using your credit card.<\/p>","post_title":"Credit Card Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"credit-card-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 10:26:05","post_modified_gmt":"2022-01-28 10:26:05","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1124","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Dedicate to Your Loved One","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'donate_for_nature_form' => array(
                'label' => 'Donate For Nature Form',
                'description' => 'Create donate for nature form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1120,"post_author":"1","post_date":"2022-01-28 10:14:53","post_date_gmt":"2022-01-28 10:14:53","post_content":"","post_title":"Donate for Nature","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"donate-for-nature","to_ping":"","pinged":"","post_modified":"2022-01-28 10:15:12","post_modified_gmt":"2022-01-28 10:15:12","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1120","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Contribute","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-form-generator-donate-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact No","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Occupation","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Payment Method","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'covid_19_plasma_donation_form' => array(
                'label' => 'Covid-19 Plasma Donation Form',
                'description' => 'Create covid-19 plasma donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1134,"post_author":"1","post_date":"2022-01-28 12:37:09","post_date_gmt":"2022-01-28 12:37:09","post_content":"","post_title":"COVID-19 Plasma Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"covid-19-plasma-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 12:37:35","post_modified_gmt":"2022-01-28 12:37:35","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1134","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-register-as-a-blood-donor-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Birth","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Blood Group","placeholder":"A+","required":"no","default_value":""},"id":"text"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Covid Recovery Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date_1"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Your Report","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":4,"max_allowed_files":1,"allowed_files":["images","pdf","docs","zips"]},"id":"file_upload_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'charity_partnership_application_form' => array(
                'label' => 'Charity Partnership Application Form',
                'description' => 'Create charity partnership application form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1103,"post_author":"1","post_date":"2022-01-28 08:02:32","post_date_gmt":"2022-01-28 08:02:32","post_content":"<p>Thanks for having interest in partnering with us, please fill out the form below and we will reach you soon<\/p>","post_title":"Charity Partnership Application Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"charity-partnership-application-form","to_ping":"","pinged":"","post_modified":"2022-01-28 08:04:11","post_modified_gmt":"2022-01-28 08:04:11","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1103","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Charity Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Charity URL","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Categories","required":"no","default_value":"","options":[{"label":"Children","value":"Children"},{"label":"Environment","value":"Environment"},{"label":"Health","value":"Health"},{"label":"Animals","value":"Animals"},{"label":"The Arts","value":"The Arts"},{"label":"Schools","value":"Schools"}]},"id":"checkbox"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Logo","button_text":"Drag & Drop your files or Browse","required":"no","max_file_size":5,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"CEO","placeholder":"","required":"no","default_value":""},"id":"text_1"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Registration Number","placeholder":"","required":"no","default_value":""},"id":"text_2"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Person","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Contact Email","placeholder":"ex: myname@example.com","required":"no","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"What is your charitys mission?","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Your File","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":4,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input_1"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'chargify_magazine_subscription_form' => array(
                'label' => 'Chargify Magazine Subscription Form',
                'description' => 'Create chargify magazine subscription form',
                'category' => 'Subscription',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1133,"post_author":"1","post_date":"2022-01-28 12:31:18","post_date_gmt":"2022-01-28 12:31:18","post_content":"","post_title":"Chargify Magazine Subscription Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"chargify-magazine-subscription-form","to_ping":"","pinged":"","post_modified":"2022-01-28 12:31:38","post_modified_gmt":"2022-01-28 12:31:38","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1133","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"My Products","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"$9.99 \/ Month","trial_days":0,"has_trial_days":"no","billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.9900000000000002,"is_default":"no","plan_features":[]},{"name":"12 Months Subscription","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"year","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.989999999999998,"plan_features":[],"is_default":"no"}]}},"id":"recurring_payment_item"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Enter Affiliate Link","placeholder":"https:\/\/www.example.com","required":"no","default_value":""},"id":"text"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'animal_shelter_donation_form' => array(
                'label' => 'Animal Shelter Donation Form',
                'description' => 'Create animal shelter donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1115,"post_author":"1","post_date":"2022-01-28 09:43:54","post_date_gmt":"2022-01-28 09:43:54","post_content":"","post_title":"Animal Shelter Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"animal-shelter-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 10:05:14","post_modified_gmt":"2022-01-28 10:05:14","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1115","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"animal-shelter","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><img class=\"alignnone size-medium wp-image-1117 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/Brown-Playful-Cartoon-Animal-Lovers-Facebook-Cover-300x169.png\" alt=\"\" width=\"300\" height=\"169\" \/><\/p>\n<p style=\"text-align: center;\"><span style=\"color: #339966;\"><strong>Animal Lovers Donation Form<\/strong><\/span><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation Amount","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Package 1","value":10},{"label":"Package 2","value":20},{"label":"Package 3","value":40}],"prices_display_type":"select"}},"id":"payment_item"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Comments","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'ada_bible_church_donation_form' => array(
                'label' => 'Ada Bible Church Donation Form',
                'description' => 'Create ada bible church donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1128,"post_author":"1","post_date":"2022-01-28 12:04:28","post_date_gmt":"2022-01-28 12:04:28","post_content":"","post_title":"Ada Bible Church Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"ada-bible-church-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-28 12:18:03","post_modified_gmt":"2022-01-28 12:18:03","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1128","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":"","min_value":"1"},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'student_data_tracking_form' => array(
                'label' => 'Student Data Tracking Form',
                'description' => 'Create student data tracking form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1159,"post_author":"1","post_date":"2022-01-31 11:09:57","post_date_gmt":"2022-01-31 11:09:57","post_content":"","post_title":"Student Data Tracking Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"student-data-tracking-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:10:12","post_modified_gmt":"2022-01-31 11:10:12","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1159","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h4 style=\"text-align: center;\">Student Profile<\/h4>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Student Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Grade","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Mother","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Father","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_2"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Referral","placeholder":"","required":"no","default_value":""},"id":"text_1"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Academic Strength","placeholder":"","required":"no","options":[{"label":"Mathmatics","value":"Mathmatics"},{"label":"Reading","value":"Reading"},{"label":"Others","value":"Others"}],"default_value":""},"id":"radio"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html_1","field_options":{"custom_html":"<h4 style=\"text-align: center;\">Testing Information<\/h4>"}},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Recheck Needed","placeholder":"","required":"no","options":[{"label":"Yes","value":"Yes"},{"label":"No","value":"No"}],"default_value":""},"id":"radio_1"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Results","placeholder":"","required":"no","default_value":""},"id":"text_2"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Admission Fees","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"single","payment_amount":350,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'square_food_bank_donation_form' => array(
                'label' => 'Square Food Bank Donation Form',
                'description' => 'Create food bank donation form with square',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1141,"post_author":"1","post_date":"2022-01-31 08:11:23","post_date_gmt":"2022-01-31 08:11:23","post_content":"","post_title":"Square Food Bank Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"square-food-bank-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 08:11:41","post_modified_gmt":"2022-01-31 08:11:41","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1141","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit Form","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p>&nbsp;<\/p>\n<p><img class=\"size-medium wp-image-1142 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/istockphoto-1224414210-612x612-1-300x176.jpg\" alt=\"\" width=\"300\" height=\"176\" \/><\/p>"}},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html_1","field_options":{"custom_html":"<h2 style=\"text-align: center;\">Square Food Bank Donation Form<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Birth","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Contact Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"square_gateway_element","editor_title":"Square payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"square","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"}},"field_options":{"label":"Square Payment Gateway"},"id":"square_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'organ_donation_registration_form' => array(
                'label' => 'Organ Donation Registration Form',
                'description' => 'Create organ donation registration form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1143,"post_author":"1","post_date":"2022-01-31 08:18:47","post_date_gmt":"2022-01-31 08:18:47","post_content":"","post_title":"Organ Donation Registration Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"organ-donation-registration-form","to_ping":"","pinged":"","post_modified":"2022-01-31 08:20:47","post_modified_gmt":"2022-01-31 08:20:47","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1143","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><img class=\"size-medium wp-image-1144 aligncenter\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/organ_donation_red_cross_iStock-1213891617-1800x1013-1-300x169.jpg\" alt=\"\" width=\"300\" height=\"169\" \/><\/p>\n<h2 style=\"text-align: center;\">Organ Donation Registration Form<\/h2>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Birth","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Religion","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Blood Group","placeholder":"O-","required":"no","default_value":""},"id":"text_1"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Height (ft)","placeholder":"","required":"no","default_value":""},"id":"text_2"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Weight (kg)","placeholder":"","required":"no","default_value":""},"id":"text_3"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Do you have any known allergies? If yes, then please specify below.","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Are you currently taking medications? If yes, then please list the medications and the reasons why are you taking them.","placeholder":"","min_height":0,"required":"no"},"id":"textarea_1"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"What is your current medical condition? Do you have any communicable disease, cardiovascular problems, diabetes, asthma etc.?","placeholder":"","min_height":0,"required":"no"},"id":"textarea_2"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Date of Registration","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date_1"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Organ to Donate","placeholder":"","required":"no","options":[{"label":"Lever","value":"Lever"},{"label":"Kidney","value":"Kidney"},{"label":"Pancrease","value":"Pancrease"},{"label":"Heart","value":"Heart"},{"label":"Cornea","value":"Cornea"},{"label":"Bone","value":"Bone"},{"label":"Lung","value":"Lung"}],"default_value":""},"id":"radio"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Signature","placeholder":"","required":"no","default_value":""},"id":"text_4"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Photo","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'non_profit_consent_donation_form' => array(
                'label' => 'Non Profit Consent Donation Form',
                'description' => 'Create non profit consent donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1171,"post_author":"1","post_date":"2022-01-31 11:34:51","post_date_gmt":"2022-01-31 11:34:51","post_content":"","post_title":"Non Profit Consent Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"non-profit-consent-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:35:09","post_modified_gmt":"2022-01-31 11:35:09","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1171","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-non-profit-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<p style=\"text-align: center;\"><span style=\"color: #008000;\"><strong>Non Profit Consent Donation Form.<\/strong><\/span><\/p>\n<p style=\"text-align: center;\">\u00a0<\/p>"},"id":"custom_html"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Consent","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images","pdf"]},"id":"file_upload_input"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donate to Our Cause","placeholder":"USD","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'giveaway_registration_form' => array(
                'label' => 'Giveaway Registration Form',
                'description' => 'Create giveaway registration form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1146,"post_author":"1","post_date":"2022-01-31 08:59:43","post_date_gmt":"2022-01-31 08:59:43","post_content":"","post_title":"Giveaway Registration Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"giveaway-registration-form","to_ping":"","pinged":"","post_modified":"2022-01-31 09:00:00","post_modified_gmt":"2022-01-31 09:00:00","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1146","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Register","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<h3 style=\"text-align: left;\">Presented by: CrossRoads Church \/ H.U.G Program<\/h3>"},"id":"custom_html"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Please Select Event Time Slot","placeholder":"","required":"no","options":[{"label":"12.00 PM - 1.30 PM","value":"12.00 PM - 1.30 PM"},{"label":"2.00 PM- 3.30 PM","value":"2.00 PM- 3.30 PM"},{"label":"4.00 PM - 5.30 PM","value":"4.00 PM - 5.30 PM"}],"default_value":""},"id":"radio"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<p><strong>Documents Required:\u00a0<\/strong><\/p>\n<p>-Picture I.D of PARENT<\/p>\n<p>-Proof of Children ( Birth Certificate, School I.D., of any state I.D.)<\/p>\n<p>-Proof of Residency (Mail under 30 days)<\/p>\n<p>&nbsp;<\/p>\n<h4 style=\"text-align: center;\">Parent Information<\/h4>"},"id":"custom_html_1"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"custom_html":"<h4 style=\"text-align: center;\">Children Information<\/h4>"},"id":"custom_html_2"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Child 1","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Gender","placeholder":"","required":"no","options":[{"label":"Male","value":"Male"},{"label":"Female","value":"Female"}],"default_value":""},"id":"radio_1"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Child 2","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_2"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Gender","placeholder":"","required":"no","options":[{"label":"Male","value":"Male"},{"label":"Female","value":"Female"}],"default_value":""},"id":"radio_2"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Child 3","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_3"},{"type":"radio","editor_title":"Radio Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Gender","placeholder":"","required":"no","options":[{"label":"Male","value":"Male"},{"label":"Female","value":"Female"}],"default_value":""},"id":"radio_3"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"no"}}',
                'is_pro' => true,
            ),
            'game_server_donation_form' => array(
                'label' => 'Game Server Donation Form',
                'description' => 'Create game server donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1172,"post_author":"1","post_date":"2022-01-31 11:38:40","post_date_gmt":"2022-01-31 11:38:40","post_content":"","post_title":"Game Server Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"game-server-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:38:55","post_modified_gmt":"2022-01-31 11:38:55","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1172","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Donate","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Steam ID","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Please Select","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Small Build Crate","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Medium Build Crate","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20},{"product_name":"Large Build Crate","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":30},{"product_name":"","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":0}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"recurring_payment_item","editor_title":"Recurring Payment Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Recurring Payment Item Name","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"show_main_label":{"label":"Show Pricing Label","type":"switch","group":"general"},"show_payment_summary":{"label":"Show Payment Summary","type":"switch","group":"general"},"recurring_payment_options":{"type":"recurring_payment_options","group":"general","label":"Configure Recurring Subscription Payment Plans","choice_label":"Choose your pricing plan","choice_types":{"simple":"Simple Recurring Plan (Single)","choose_single":"Choose One from Multiple Pricing Plans"},"selection_types":{"radio":"Radio input field","select":"Select input field"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Subscription Item","required":"yes","show_main_label":"yes","show_payment_summary":"yes","recurring_payment_options":{"choice_type":"choose_single","selection_type":"radio","pricing_options":[{"name":"$9.99 \/ Month","trial_days":30,"has_trial_days":"yes","billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":9.9900000000000002,"is_default":"yes","plan_features":[]},{"name":"$19.99 \/ Year","trial_days":0,"has_trial_days":"no","trial_preriod_days":0,"billing_interval":"month","bill_times":0,"has_signup_fee":"no","signup_fee":0,"subscription_amount":19.989999999999998,"plan_features":[],"is_default":"no"}]}},"id":"recurring_payment_item"}],"wpf_has_recurring_field":"yes","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'food_parcel_request_form' => array(
                'label' => 'Food Parcel Request Form',
                'description' => 'Create food parcel request form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1150,"post_author":"1","post_date":"2022-01-31 10:38:52","post_date_gmt":"2022-01-31 10:38:52","post_content":"<p>Please fill the form\u00a0carefully\u00a0in order us to provide you a complete and accurate food parcel. You will receive a phone call from our volunteers within 24 hours.<\/p>\n<p>Food Parcel includes chicken and tomato soup, pasta, rice, noodles, beans, carrots, peaches, steak pie, tuna, sausage, apples, tea, coffee, milk, bread.<\/p>","post_title":"Food Parcel Request Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"food-parcel-request-form","to_ping":"","pinged":"","post_modified":"2022-01-31 10:41:25","post_modified_gmt":"2022-01-31 10:41:25","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1150","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Food Item","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Pizza","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":15},{"product_name":"BBQ Burger","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20},{"product_name":"Fried Rice","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Soft Drinks","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":10}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Delivery Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'first_data_online_donation_form' => array(
                'label' => 'First Data Online Donation Form',
                'description' => 'Create first data online donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1149,"post_author":"1","post_date":"2022-01-31 10:35:04","post_date_gmt":"2022-01-31 10:35:04","post_content":"","post_title":"First Data Online Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"first-data-online-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 10:35:59","post_modified_gmt":"2022-01-31 10:35:59","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1149","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"tabular_products","editor_title":"Tabular Product Items","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"products":{"label":"Setup your Tabular products","group":"general","type":"tabular_products"},"show_sub_total":{"label":"Show Subtotal","type":"switch","group":"general","info":"If enabled then user can see subtotal after the table"},"table_photo_label":{"label":"Photo Column Label","type":"text","group":"general"},"table_item_label":{"label":"Table Item Column Label","type":"text","group":"general"},"table_price_label":{"label":"Table Price Column Label","type":"text","group":"general"},"table_quantity_label":{"label":"Table Quantity Column Label","type":"text","group":"general"},"table_subtotal_label":{"label":"Table Sub Total Label Label","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"label":"Products","show_sub_total":"yes","table_item_label":"Product","table_price_label":"Item Price","table_quantity_label":"Quantity","table_subtotal_label":"Sub Total","table_photo_label":"Photo","products":[{"product_name":"Product 1","default_quantity":1,"min_quantity":0,"max_quantity":100,"product_price":10},{"product_name":"Product 2","default_quantity":0,"min_quantity":0,"max_quantity":100,"product_price":20}],"enable_image":"no","enable_lightbox":"no"},"id":"tabular_products"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":" Payment Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => false,
            ),
            'elderly_meals_request_form' => array(
                'label' => 'Elderly Meals Request Form',
                'description' => 'Create elderly meals request form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1173,"post_author":"1","post_date":"2022-01-31 11:42:18","post_date_gmt":"2022-01-31 11:42:18","post_content":"","post_title":"Elderly Meals Request Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"elderly-meals-request-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:42:31","post_modified_gmt":"2022-01-31 11:42:31","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1173","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"checkbox","editor_title":"Checkbox Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Options","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Which day would you like us to deliver?","required":"no","default_value":"","options":[{"label":"Monday","value":"Monday"},{"label":"Tuesday","value":"Tuesday"},{"label":"Wednesday","value":"Wednesday"},{"label":"Thursday","value":"Thursday"},{"label":"Friday","value":"Friday"},{"label":"Saturday","value":"Saturday"},{"label":"Sunday","value":"Sunday"}]},"id":"checkbox"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Meal Class","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_single","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Budget","value":20},{"label":"Economy","value":30},{"label":"Super Saver","value":10}],"prices_display_type":"select"}},"id":"payment_item"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Delivery Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'donation_tracking_form' => array(
                'label' => 'Donation Tracking Form',
                'description' => 'Create donation tracking form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1137,"post_author":"1","post_date":"2022-01-31 07:55:43","post_date_gmt":"2022-01-31 07:55:43","post_content":"","post_title":"Donation Tracking Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"donation-tracking-form","to_ping":"","pinged":"","post_modified":"2022-01-31 07:55:57","post_modified_gmt":"2022-01-31 07:55:57","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1137","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donor Email","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donation Date","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Notes","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'donate_for_education_form' => array(
                'label' => 'Donate For Education Form',
                'description' => 'Create donate for education form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1160,"post_author":"1","post_date":"2022-01-31 11:19:14","post_date_gmt":"2022-01-31 11:19:14","post_content":"<p>Lets make the world a better place.<\/p>","post_title":"Donate for Education","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"donate-for-education","to_ping":"","pinged":"","post_modified":"2022-01-31 11:19:48","post_modified_gmt":"2022-01-31 11:19:48","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1160","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Your Donation Counts!","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"text"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'dinner_event_donation_form' => array(
                'label' => 'Dinner Event Donation Form',
                'description' => 'Create dinner event donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1164,"post_author":"1","post_date":"2022-01-31 11:30:18","post_date_gmt":"2022-01-31 11:30:18","post_content":"","post_title":"Dinner Event Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"dinner-event-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:30:40","post_modified_gmt":"2022-01-31 11:30:40","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1164","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Number of Guest","placeholder":"","required":"no","default_value":""},"id":"number_1"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Requested Item","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_multiple","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Item 1","value":10},{"label":"Item 2","value":25},{"label":"Item 3","value":30},{"label":"Item 4","value":0}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'covid_response_form' => array(
                'label' => 'Covid Response Form',
                'description' => 'Create covid response form',
                'category' => 'Basic',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1164,"post_author":"1","post_date":"2022-01-31 11:30:18","post_date_gmt":"2022-01-31 11:30:18","post_content":"","post_title":"Dinner Event Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"dinner-event-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:30:40","post_modified_gmt":"2022-01-31 11:30:40","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1164","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Full Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Number of Guest","placeholder":"","required":"no","default_value":""},"id":"number_1"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Requested Item","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"choose_multiple","payment_amount":10,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"Item 1","value":10},{"label":"Item 2","value":25},{"label":"Item 3","value":30},{"label":"Item 4","value":0}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'book_donation_form' => array(
                'label' => 'Book Donation Form',
                'description' => 'Create book donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1162,"post_author":"1","post_date":"2022-01-31 11:28:51","post_date_gmt":"2022-01-31 11:28:51","post_content":"<p>Donate using your credit card.<\/p>","post_title":"Charitable Request Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"charitable-request-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:29:16","post_modified_gmt":"2022-01-31 11:29:16","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1162","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-fund-giving-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Dedicate to Your Loved One","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'charitable_request_form' => array(
                'label' => 'Charitable Request Form',
                'description' => 'Create charitable request form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1162,"post_author":"1","post_date":"2022-01-31 11:28:51","post_date_gmt":"2022-01-31 11:28:51","post_content":"<p>Donate using your credit card.<\/p>","post_title":"Charitable Request Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"charitable-request-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:29:16","post_modified_gmt":"2022-01-31 11:29:16","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1162","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-fund-giving-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Dedicate to Your Loved One","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'art_auction_form' => array(
                'label' => 'Art Auction Form',
                'description' => 'Create art auction form',
                'category' => 'Payment',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1153,"post_author":"1","post_date":"2022-01-31 11:01:57","post_date_gmt":"2022-01-31 11:01:57","post_content":"","post_title":"Art Auction  Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"art-auction-form","to_ping":"","pinged":"","post_modified":"2022-01-31 11:02:20","post_modified_gmt":"2022-01-31 11:02:20","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1153","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"duplicate-2022-gala-auction-item-donation-form","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Business Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Description of Item(s) Please be as specific as possible. Include terms or any other information that will accurately describe the o\ufb00ering. Brochures or display material are helpful","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Special Instructions Please note any exclusions, whether reservations are required and expiration date, if any. Certificates should be valid for at least one year from date of event","placeholder":"","min_height":0,"required":"no"},"id":"textarea_1"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Art Image","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Estimated Fair Market Value","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Solicited by","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Signature","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input_1"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'alumni_donation_form' => array(
                'label' => 'Alumni Donation form',
                'description' => 'Create alumni donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1139,"post_author":"1","post_date":"2022-01-31 08:03:16","post_date_gmt":"2022-01-31 08:03:16","post_content":"","post_title":"Alumni Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"alumni-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 08:04:13","post_modified_gmt":"2022-01-31 08:04:13","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1139","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Complete Donation","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><img class=\"aligncenter size-medium wp-image-1140\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/36494_Screen-Shot-2016-02-24-at-3.35.02-PM-300x112.png\" alt=\"\" width=\"300\" height=\"112\" \/><\/p>\n<h1 style=\"text-align: center;\"><strong>Alumni Donation Form<\/strong><\/h1>\n<p style=\"text-align: center;\">We are grateful for your donation to your school. Thank you!<\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"select","editor_title":"Dropdown Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"options":{"label":"Field Choices","type":"key_pair","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"From which program did you earn your degree?","placeholder":"","required":"no","options":[{"label":"Engineer","value":"Engineer"},{"label":"Arts and Music","value":"Arts and Music"},{"label":"Business","value":"Business"},{"label":"Medicine","value":"Medicine"},{"label":"Law","value":"Law"}],"default_value":""},"id":"select"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Graduation Year","placeholder":"2001","required":"no","default_value":""},"id":"text"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Donation Amount","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'ae_fundraising_pubg_tournament_registration_form' => array(
                'label' => 'AE Fundraising PUBG Tournament Registration Form',
                'description' => 'Create ae fundraising pubg tournament registration form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1138,"post_author":"1","post_date":"2022-01-31 08:00:19","post_date_gmt":"2022-01-31 08:00:19","post_content":"","post_title":"AE FUNDRAISING PUBG Tournament Registration Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"ae-fundraising-pubg-tournament-registration-form","to_ping":"","pinged":"","post_modified":"2022-01-31 08:00:33","post_modified_gmt":"2022-01-31 08:00:33","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1138","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<p><img class=\"aligncenter size-medium wp-image-1176\" src=\"https:\/\/marketing.wpninjathemes.com\/wp-content\/uploads\/2022\/01\/image-1582794123008-1638983418793-300x169.jpg\" alt=\"\" width=\"300\" height=\"169\" \/><\/p>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Team Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player 1","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player 2","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_2"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player 3","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_3"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Player 4","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_4"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone Number","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"payment_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"payment_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type","selection_type_options":{"one_time":"One Time Payment","one_time_custom":"One Time Custom Amount"},"one_time_field_options":{"single":"Single Item","choose_single":"Choose One From Multiple Item","choose_multiple":"Choose Multiple Items"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Registration Fees","required":"yes","enable_image":"no","pricing_details":{"one_time_type":"single","payment_amount":100,"show_onetime_labels":"yes","image_url":[{"label":"","value":""}],"multiple_pricing":[{"label":"","value":""}],"prices_display_type":"radio"}},"id":"payment_item"},{"type":"stripe_card_element","editor_title":"Card Elements (Stripe)","editor_icon":"","group":"payment_method_element","method_handler":"stripe","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options"},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}},"field_options":{"disable":false,"label":"Your Card info (Powered By Stripe)","verify_zip":"no","checkout_display_style":{"style":"embedded_form","require_billing_info":"no"}},"id":"stripe_card_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'act_of_donation_form' => array(
                'label' => 'Act Of Donation Form',
                'description' => 'Create act of donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1148,"post_author":"1","post_date":"2022-01-31 09:13:20","post_date_gmt":"2022-01-31 09:13:20","post_content":"","post_title":"Act of Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"act-of-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 09:13:34","post_modified_gmt":"2022-01-31 09:13:34","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1148","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html","field_options":{"custom_html":"<h4 style=\"text-align: center;\">Donor Information<\/h4>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"custom_html","editor_title":"HTML Markup","group":"html","postion_group":"general","editor_elements":{"custom_html":{"label":"Custom HTML","type":"html","group":"general","info":"You can use the following dynamic placeholder on your HTML <span>{payment_total}<\/span> <span>{sub_total}<\/span> <span>{tax_total}<\/span>"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"id":"custom_html_1","field_options":{"custom_html":"<h4 style=\"text-align: center;\">Donee Information<\/h4>"}},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Your Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_1"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email_1"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Relationship","placeholder":"","required":"no","default_value":""},"id":"text_1"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Item","placeholder":"","required":"no","default_value":""},"id":"text_2"},{"type":"date","editor_title":"Date Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"date_format":{"label":"Date Format","type":"select_option","options":{"m\/d\/Y":"m\/d\/Y - (Ex: 04\/28\/2018)","d\/m\/Y":"d\/m\/Y - (Ex: 28\/04\/2018)","d.m.Y":"d.m.Y - (Ex: 28.04.2019)","n\/j\/y":"n\/j\/y - (Ex: 4\/28\/18)","m\/d\/y":"m\/d\/y - (Ex: 04\/28\/18)","M\/d\/Y":"M\/d\/Y - (Ex: Apr\/28\/2018)","y\/m\/d":"y\/m\/d - (Ex: 18\/04\/28)","Y-m-d":"Y-m-d - (Ex: 2018-04-28)","d-M-y":"d-M-y - (Ex: 28-Apr-18)","m\/d\/Y h:i K":"m\/d\/Y h:i K - (Ex: 04\/28\/2018 08:55 PM)","m\/d\/Y H:i":"m\/d\/Y H:i - (Ex: 04\/28\/2018 20:55)","d\/m\/Y h:i K":"d\/m\/Y h:i K - (Ex: 28\/04\/2018 08:55 PM)","d\/m\/Y H:i":"d\/m\/Y H:i - (Ex: 28\/04\/2018 20:55)","d.m.Y h:i K":"d.m.Y h:i K - (Ex: 28.04.2019 08:55 PM)","d.m.Y H:i":"d.m.Y H:i - (Ex: 28.04.2019 20:55)","h:i K":"h:i K (Only Time Ex: 08:55 PM)","H:i":"H:i (Only Time Ex: 20:55)"},"group":"general","creatable":"yes","info":"To create your own format check this <a target=\"_blank\" href=\"https:\/\/wpmanageninja.com\/docs\/wppayform\/frequently-asked-question-for-wppayform\/date-formats-customization\/\">documentation<\/a>"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Model\/Year","placeholder":"","required":"no","date_format":"m\/d\/Y","default_value":""},"id":"date"},{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Color","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name_2"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Value","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donor Signature","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Donee Signature","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input_1"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            '2022_gala_auction_item_donation_form' => array(
                'label' => '2022 Gala Auction Item Donation Form',
                'description' => 'Create 2022 gala auction item donation form',
                'category' => 'Donation',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/demo_form2.png',
                'data' => '{"ID":1145,"post_author":"1","post_date":"2022-01-31 08:28:50","post_date_gmt":"2022-01-31 08:28:50","post_content":"","post_title":"2022 Gala Auction Item Donation Form","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"2022-gala-auction-item-donation-form","to_ping":"","pinged":"","post_modified":"2022-01-31 08:30:03","post_modified_gmt":"2022-01-31 08:30:03","post_content_filtered":"","post_parent":0,"guid":"https:\/\/marketing.wpninjathemes.com\/?p=1145","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"count_items":"0","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_default_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"_wp_old_slug":"blank-form-6","wppayform_show_title_description":"yes","wppayform_paymentform_builder_settings":[{"type":"customer_name","editor_title":"Name","disable":false,"group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Business Name","placeholder":"Name","required":"yes","admin_label":"Name","default_value":""},"id":"customer_name"},{"type":"customer_email","editor_title":"Email","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Email Address","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","default_value":""},"id":"customer_email"},{"type":"number","editor_title":"Number Field","group":"input","is_markup":"no","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Phone","placeholder":"","required":"no","default_value":""},"id":"number"},{"type":"address_input","editor_title":"Address Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Label","type":"text","group":"general"},"subfields":{"label":"Address Fields","type":"address_subfields","group":"general","fields":{"address_line_1":"Address Line 1","address_line_2":"Address Line 2","city":"City","state":"State","zip_code":"ZIP Code","country":"Country"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Address","subfields":{"address_line_1":{"label":"Address Line 1","placeholder":"Address Line 1","visibility":"yes","required":"yes","type":"text","id":"address_line_1","default_value":""},"address_line_2":{"label":"Address Line 2","placeholder":"Address Line 2","visibility":"yes","required":"no","type":"text","id":"address_line_2","default_value":""},"city":{"label":"City","placeholder":"City","visibility":"yes","required":"no","type":"text","id":"city","default_value":""},"state":{"label":"State","placeholder":"State","visibility":"yes","required":"yes","type":"text","id":"state","default_value":""},"zip_code":{"label":"ZIP Code","placeholder":"ZIP Code","visibility":"yes","required":"no","type":"text","id":"zip_code","default_value":""},"country":{"label":"Country","placeholder":"Select Country","visibility":"yes","required":"yes","type":"select","id":"country","default_value":""}}},"id":"address_input"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Description of Item(s) Please be as specific as possible. Include terms or any other information that will accurately describe the o\ufb00ering. Brochures or display material are helpful","placeholder":"","min_height":0,"required":"no"},"id":"textarea"},{"type":"textarea","editor_title":"Textarea Field","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"textarea","group":"general"},"min_height":{"label":"Minimum Height","type":"number","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Special Instructions Please note any exclusions, whether reservations are required and expiration date, if any. Certificates should be valid for at least one year from date of event","placeholder":"","min_height":0,"required":"no"},"id":"textarea_1"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"If applicable, upload an image of donation for promotion.","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input"},{"type":"custom_payment_input","editor_title":"User Defined Pay Amount","group":"payment","postion_group":"payment","is_system_field":true,"is_payment_field":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"min_value":{"label":"Minimum Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"disable":false,"label":"Estimated Fair Market Value","placeholder":"","required":"no","default_value":""},"id":"custom_payment_input"},{"type":"text","editor_title":"Single Line Text","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Solicited by","placeholder":"","required":"no","default_value":""},"id":"text"},{"type":"file_upload_input","editor_title":"File Upload","group":"input","postion_group":"general","editor_elements":{"label":{"label":"Upload Label","type":"text","group":"general"},"button_text":{"label":"Upload Button Text","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"max_file_size":{"label":"Max File Size (in MegaByte)","type":"number","group":"general"},"max_allowed_files":{"label":"Max Upload Files","type":"number","group":"general"},"allowed_files":{"label":"Allowed file types","type":"checkbox","wrapper_class":"checkbox_new_lined","options":{"images":"Images (jpg, jpeg, gif, png, bmp)","audios":"Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)","pdf":"pdf","docs":"Docs (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)","zips":"Zip Archives (zip, gz, gzip, rar, 7z)","csv":"CSV (csv)"}},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input element CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Upload Signature","button_text":"Drag & Drop your files or Browse","required":"yes","max_file_size":2,"max_allowed_files":1,"allowed_files":["images"]},"id":"file_upload_input_1"},{"type":"paypal_gateway_element","editor_title":"Paypal payment gateway","editor_icon":"","group":"payment_method_element","method_handler":"paypal","postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}},"field_options":{"label":"PayPal Payment Gateway","require_shipping_address":"no"},"id":"paypal_gateway_element"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes"}}',
                'is_pro' => true,
            ),
            'donation_template_horizontal' => array(
                'label' => 'Donation template (horizontal)',
                'description' => 'Create donation form template 1',
                'category' => 'Quick checkout',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/left_side_template.svg',
                'data' => '{"ID":373,"post_author":"1","post_date":"2022-10-10 08:42:00","post_date_gmt":"2022-10-10 08:42:00","post_content":"","post_title":"Multiple step donation form (#373)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"multiple-step-donation-form-22","to_ping":"","pinged":"","post_modified":"2022-10-10 08:42:00","post_modified_gmt":"2022-10-10 08:42:00","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=373","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wpf_form_category":"quick_form","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"donation_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"donation_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation Progress Item","required":"yes","enable_image":"yes","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"show_statistic":"yes","donation_goals":1000,"progress_bar":"yes","one_time_type":"choose_single","image_url":[{"label":"","value":"","photo":{"alt_text":"donation-thumbnail-horizontal","image_full":"","image_thumb":""}}],"multiple_pricing":[{"label":"","value":10},{"label":"","value":20}],"allow_custom_amount":"yes","allow_recurring":"no","bill_time_max":"0","intervals":["day","week","fortnight","month","quarter","half_year","year"],"interval_options":["day","week","fortnight","month","quarter","half_year","year"]}},"id":"donation_item"},{"type":"customer_name","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":"","disable":false},"id":"customer_name"},{"type":"customer_email","quick_checkout_form":true,"editor_title":"Email","group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"confirm_email":{"label":"Enable Confirm Email Field","type":"confirm_email_switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"},"unique_email_validation":{"label":"Validate as Unique","type":"unique_email_validation_switch","group":"advanced"}}},"field_options":{"disable":false,"label":"","placeholder":"Email Address","required":"yes","confirm_email":"no","confirm_email_label":"Confirm Email","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_email"},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no","checkKey":"Credit\/Debit Card (Stripe)"},"paypal":{"enabled":"no","label":"Pay with Paypal","require_shipping_address":"no","checkKey":"Paypal"},"mollie":{"enabled":"no","label":"Pay with Mollie","checkKey":"Mollie"},"razorpay":{"enabled":"no","label":"Pay with Razorpay","checkKey":"Razorpay"},"paystack":{"enabled":"no","label":"Pay with Paystack","checkKey":"Paystack"},"payrexx":{"enabled":"no","label":"Pay with Payrexx","checkKey":"Payrexx"},"square":{"enabled":"no","label":"Pay with Square","checkKey":"Square"},"sslcommerz":{"enabled":"no","label":"Pay with Sslcommerz","checkKey":"SSLCOMMERZ"},"billplz":{"enabled":"no", "label":"Pay with Billplz","checkKey":"Billplz"},"offline":{"enabled":"no","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited","checkKey":"Offline\/Cheque Payment"}}},"default_value":"stripe","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"choose_payment_method"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","_payment_settings":[]}}',
                'is_pro' => true,
            ),
            'donation_template_vertical' => array(
                'label' => 'Donation template (vertical)',
                'description' => 'Create simple donation form',
                'category' => 'Quick checkout',
                'preview_image' => WPPAYFORM_URL . 'assets/images/forms/top_image_template.png',
                'data' => '{"ID":376,"post_author":"1","post_date":"2022-10-10 08:48:55","post_date_gmt":"2022-10-10 08:48:55","post_content":"","post_title":"Simple donation form (#376)","post_excerpt":"","post_status":"publish","comment_status":"closed","ping_status":"closed","post_password":"","post_name":"simple-donation-form-11","to_ping":"","pinged":"","post_modified":"2022-10-10 08:48:55","post_modified_gmt":"2022-10-10 08:48:55","post_content_filtered":"","post_parent":0,"guid":"https:\/\/wordpress.test\/?p=376","menu_order":0,"post_type":"wp_payform","post_mime_type":"","comment_count":"0","filter":"raw","ancestors":[],"page_template":"","post_category":[],"tags_input":[],"form_meta":{"_has_azonpress":"no","wpf_form_category":"quick_form","wppayform_submit_button_settings":{"button_text":"Submit","processing_text":"Please Wait\u2026","button_style":"wpf_full_block_btn","css_class":""},"wppapyform_paymentform_confirmation_settings":{"confirmation_type":"custom","redirectTo":"samePage","messageToShow":"<p>Form has been successfully submitted<\/p>","samePageFormBehavior":"hide_form"},"wppayform_form_design_settings":{"labelPlacement":"top","asteriskPlacement":"right","submit_button_position":"left","extra_styles":{"wpf_default_form_styles":"yes","wpf_bold_labels":"no"}},"wpf_email_notifications":[{"title":"Admin Email Notification","email_to":"{wp:admin_email}","reply_to":"{input.customer_email}","email_subject":"Contact form Submitted by {input.customer_name} #{submission.id}","email_body":"<p>The following data has been submitted by {input.customer_name}<\/p>\n<p>{submission.all_input_field_html}<\/p>\n<p>Form Page URL: {wp:post_url}<\/p>","from_name":"","from_email":"","format":"html","email_template":"default","cc_to":"","bcc_to":"","conditions":"","sending_action":"wppayform\/after_form_submission_complete","status":"disabled"}],"wppayform_paymentform_builder_settings":[{"type":"donation_item","editor_title":"Donation Progress Item","group":"payment","postion_group":"payment","conditional_hide":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"enable_image":{"label":"Enable Image","type":"switch","group":"general"},"payment_options":{"type":"donation_options","group":"general","label":"Configure Donation Progress Item","selection_type":"Payment Type"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"is_system_field":true,"is_payment_field":true,"field_options":{"disable":false,"label":"Donation Progress Item","required":"yes","enable_image":"yes","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"pricing_details":{"show_statistic":"yes","donation_goals":1000,"progress_bar":"yes","one_time_type":"choose_single","image_url":[{"label":"","value":"","photo":{"alt_text":"donation-thumbnail-vertical","image_full":"","image_thumb":""}}],"multiple_pricing":[{"label":"","value":10},{"label":"","value":20}],"allow_custom_amount":"yes","allow_recurring":"no","bill_time_max":"0","intervals":["day","week","fortnight","month","quarter","half_year","year"],"interval_options":["day","week","fortnight","month","quarter","half_year","year"]}},"id":"donation_item"},{"type":"customer_name","quick_checkout_form":true,"editor_title":"Name","disable":false,"group":"input","postion_group":"general","isNumberic":"no","page":"3","editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"placeholder":{"label":"Placeholder","type":"text","group":"general"},"required":{"label":"Required","type":"switch","group":"general"},"default_value":{"label":"Default Value","type":"text","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"},"element_class":{"label":"Input Element CSS Class","type":"text","group":"advanced"},"conditional_render":{"type":"conditional_render","group":"advanced","label":"Conditional render","selection_type":"Conditional logic","conditional_logic":{"yes":"Yes","no":"No"},"conditional_type":{"any":"Any","all":"All"}}},"field_options":{"label":"","placeholder":"Name","required":"yes","admin_label":"Name","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]},"default_value":""},"id":"customer_name"},{"type":"choose_payment_method","editor_title":"Choose Payment Method","group":"payment_method_element","conditional_hide":true,"postion_group":"payment_method","single_only":true,"editor_elements":{"label":{"label":"Field Label","type":"text","group":"general"},"default_payment_method":{"type":"text","group":"general"},"method_settings":{"label":"Payment Methods","type":"choose_payment_method","available_methods":{"stripe":{"label":"Credit\/Debit Card (Stripe)","isActive":true,"conditional_hide":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Card (Stripe)"},"checkout_display_style":{"label":"Checkout display style","type":"checkout_display_options","default":{"style":"stripe_checkout"}},"verify_zip":{"label":"Verify Zip\/Postal Code","type":"switch"}}},"paypal":{"label":"Paypal","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paypal"},"require_shipping_address":{"label":"Require Shipping Address","type":"switch"}}},"mollie":{"label":"Mollie","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Mollie"}}},"razorpay":{"label":"Razorpay","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Razorpay"}}},"paystack":{"label":"Paystack","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Paystack"}}},"payrexx":{"label":"Payrexx","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Payrexx"}}},"square":{"label":"Square","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Square"}}},"billplz":{"label":"Billplz","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Billplz"}}},"sslcommerz":{"label":"SSLCOMMERZ","isActive":true,"editor_elements":{"label":{"label":"Payment Option Label","type":"text","default":"Pay with Sslcommerz"}}},"offline":{"label":"Offline\/Cheque Payment","isActive":true,"editor_elements":{"label":{"label":"Payment Method Title","type":"text","default":"Direct bank transfer"},"description":{"label":"Payment instruction (will be shown on the form)","type":"textarea","default":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited"}}}},"group":"general"},"enable_image":{"label":"Enable image","type":"switch","group":"general"},"admin_label":{"label":"Admin Label","type":"text","group":"advanced"},"wrapper_class":{"label":"Field Wrapper CSS Class","type":"text","group":"advanced"}},"field_options":{"label":"Select Payment Method","enable_image":"yes","method_settings":{"prefered_method":"","payment_settings":{"stripe":{"enabled":"yes","label":"Pay with Card (Stripe)","checkout_display_style":{"style":"stripe_checkout","require_billing_info":"no"},"verify_zip":"no","checkKey":"Credit\/Debit Card (Stripe)"},"paypal":{"enabled":"yes","label":"Pay with Paypal","require_shipping_address":"no","checkKey":"Paypal"},"mollie":{"enabled":"no","label":"Pay with Mollie","checkKey":"Mollie"},"razorpay":{"enabled":"no","label":"Pay with Razorpay","checkKey":"Razorpay"},"paystack":{"enabled":"no","label":"Pay with Paystack","checkKey":"Paystack"},"payrexx":{"enabled":"no","label":"Pay with Payrexx","checkKey":"Payrexx"},"square":{"enabled":"no","label":"Pay with Square","checkKey":"Square"},"sslcommerz":{"enabled":"no","label":"Pay with Sslcommerz","checkKey":"SSLCOMMERZ"},"offline":{"enabled":"no","label":"Direct bank transfer","description":"Make your payment directly into our bank account. Please use your Order ID as the payment reference. The payment will be marked as paid once the amount is deposited","checkKey":"Offline\/Cheque Payment"}}},"default_value":"stripe","conditional_logic_option":{"conditional_logic":"no","conditional_type":"any","options":[{"target_field":"","condition":"","value":""}]}},"id":"choose_payment_method"}],"wpf_has_recurring_field":"no","wpf_has_payment_field":"yes","_payment_settings":[]}}',
                'is_pro' => true,
            ),
        );

        return apply_filters('wppayform/demo_form2s', $demoForms);
    }
}