<?php

class BWFAN_API_Get_Tools_Setting extends BWFAN_API_Base {
	public static $ins;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function __construct() {
		parent::__construct();
		$this->method = WP_REST_Server::READABLE;
		$this->route  = '/settings/tools';
	}

	public function default_args_values() {
		$args = [];

		return $args;
	}

	public function process_api_call() {
		$tool_settings = [
			[
				"title"          => __( "Optimize Engagement Tracking Meta table", "wp-marketing-automations" ),
				"description"    => __( "Once this tool is run the personalisation merge tags will not be available on single contact profile. There will be no changes to open/click tracking data.", "wp-marketing-automations" ),
				"task"           => "delete_engagement_tracking_meta",
				"task_text"      => __( "Optimize", "wp-marketing-automations" ),
				"processingText" => __( "We are optimizing the engagement tracking meta table", "wp-marketing-automations" ),
			]
		];

		$tool_settings[] = [
			"title"          => __( "Verify Database Tables", "wp-marketing-automations" ),
			"description"    => __( "This will verify FunnelKit Automations all the base tables which are required for smooth functioning.", "wp-marketing-automations" ),
			"task"           => "bwfan_validate_db_tables",
			"task_text"      => __( "Verify", "wp-marketing-automations" ),
			"processingText" => __( "Validate required tables in database", "wp-marketing-automations" ),
		];

		if ( bwfan_is_woocommerce_active() ) {
			$tool_settings[] = array(
				"title"          => __( "Re-index Cart and Orders conversions for multi-currency setups", "wp-marketing-automations" ),
				"description"    => __( "This will reindex cart and conversion table for order price.", "wp-marketing-automations" ),
				"task"           => "re_index_cart_orders_conversion",
				"task_text"      => __( "Re-index", "wp-marketing-automations" ),
				"processingText" => __( "We are Re-indexing all cart total & conversion total", "wp-marketing-automations" ),
			);
			$tool_settings[] = array(
				"title"          => __( "Delete Lost Carts", "wp-marketing-automations" ),
				"description"    => __( "This will schedule the process to delete all the lost carts.", "wp-marketing-automations" ),
				"task"           => "delete_lost_carts",
				"task_text"      => __( "Delete", "wp-marketing-automations" ),
				"processingText" => __( "We are deleting all the lost carts", "wp-marketing-automations" ),
			);
			$tool_settings[] = array(
				"title"          => __( "Delete Dynamically Generated Coupons", "wp-marketing-automations" ),
				"description"    => __( "This will schedule the process to delete all expired coupons generated by FunnelKit Automations.", "wp-marketing-automations" ),
				"task"           => "delete_expired_coupons",
				"task_text"      => __( "Delete", "wp-marketing-automations" ),
				"processingText" => __( "We are deleting all dynamically generated expired coupons", "wp-marketing-automations" ),
			);
		}

		if ( BWFAN_Common::is_automation_v1_active() ) { // check for single autonami active
			$tool_settings[] = array(
				"title"          => __( "Run All Queued Tasks (Automations Legacy)", "wp-marketing-automations" ),
				"description"    => __( "This will schedule the process to  run now all the queued tasks.", "wp-marketing-automations" ),
				"task"           => "run_all_tasks",
				"task_text"      => __( "Schedule", "wp-marketing-automations" ),
				"processingText" => __( "We are schedule all the queued tasks to run now", "wp-marketing-automations" ),
			);

			$tool_settings[] = array(
				"title"          => __( "Delete All Completed Tasks (Automations Legacy)", "wp-marketing-automations" ),
				"description"    => __( "This will schedule the process to delete all the completed tasks.", "wp-marketing-automations" ),
				"task"           => "delete_completed_tasks",
				"task_text"      => __( "Delete", "wp-marketing-automations" ),
				"processingText" => __( "We are deleting all the completed tasks", "wp-marketing-automations" ),
			);

			$tool_settings[] = array(
				"title"          => __( "Delete All Failed Tasks (Automations Legacy)", "wp-marketing-automations" ),
				"description"    => __( "This will schedule the process to delete all the failed tasks.", "wp-marketing-automations" ),
				"task"           => "delete_failed_tasks",
				"task_text"      => __( "Delete", "wp-marketing-automations" ),
				"processingText" => __( "We are deleting all the failed tasks", "wp-marketing-automations" ),
			);
		}
		$is_opted        = WooFunnels_OptIn_Manager::get_optIn_state();
		$tool_settings[] = array(
			"title"          => __( "Usage Tracking", "wp-marketing-automations" ),
			"type"           => 'toggle',
			"description"    => __( "This action controls Usage Tracking", "wp-marketing-automations" ),
			"task"           => "toggle_usage_tracking",
			"status"         => ! empty( $is_opted ),
			"processingText" => __( "Updating usage tracking", "wp-marketing-automations" ),
		);

		$this->response_code = 200;

		return $this->success_response( $tool_settings, __( 'Tool settings found', 'wp-marketing-automations' ) );
	}
}

BWFAN_API_Loader::register( 'BWFAN_API_Get_Tools_Setting' );
