<?php
/**
 * ProductSafetyLabelPictogram
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * ProductSafetyLabelPictogram Class Doc Comment
 *
 * @category Class
 * @description A type that describes pictograms for product safety labels.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProductSafetyLabelPictogram implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ProductSafetyLabelPictogram';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'pictogram_description' => 'string',
        'pictogram_id' => 'string',
        'pictogram_url' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'pictogram_description' => null,
        'pictogram_id' => null,
        'pictogram_url' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pictogram_description' => 'pictogramDescription',
        'pictogram_id' => 'pictogramId',
        'pictogram_url' => 'pictogramUrl'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pictogram_description' => 'setPictogramDescription',
        'pictogram_id' => 'setPictogramId',
        'pictogram_url' => 'setPictogramUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pictogram_description' => 'getPictogramDescription',
        'pictogram_id' => 'getPictogramId',
        'pictogram_url' => 'getPictogramUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['pictogram_description'] = isset($data['pictogram_description']) ? $data['pictogram_description'] : null;
        $this->container['pictogram_id'] = isset($data['pictogram_id']) ? $data['pictogram_id'] : null;
        $this->container['pictogram_url'] = isset($data['pictogram_url']) ? $data['pictogram_url'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pictogram_description
     *
     * @return string
     */
    public function getPictogramDescription()
    {
        return $this->container['pictogram_description'];
    }

    /**
     * Sets pictogram_description
     *
     * @param string $pictogram_description The description of the pictogram localized to the default language of the marketplace.
     *
     * @return $this
     */
    public function setPictogramDescription($pictogram_description)
    {
        $this->container['pictogram_description'] = $pictogram_description;

        return $this;
    }

    /**
     * Gets pictogram_id
     *
     * @return string
     */
    public function getPictogramId()
    {
        return $this->container['pictogram_id'];
    }

    /**
     * Sets pictogram_id
     *
     * @param string $pictogram_id The identifier of the pictogram.
     *
     * @return $this
     */
    public function setPictogramId($pictogram_id)
    {
        $this->container['pictogram_id'] = $pictogram_id;

        return $this;
    }

    /**
     * Gets pictogram_url
     *
     * @return string
     */
    public function getPictogramUrl()
    {
        return $this->container['pictogram_url'];
    }

    /**
     * Sets pictogram_url
     *
     * @param string $pictogram_url The URL of the pictogram.
     *
     * @return $this
     */
    public function setPictogramUrl($pictogram_url)
    {
        $this->container['pictogram_url'] = $pictogram_url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
