# ItemConditionPolicy

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**category_id** | **string** | The category ID to which the item-condition policy applies. | [optional] 
**category_tree_id** | **string** | A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree.    &lt;br&gt;&lt;br&gt;A &lt;i&gt;category tree&lt;/i&gt; is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique &lt;b&gt;categoryId&lt;/b&gt; value. Within a category tree, the root node has no parent node and &lt;i&gt;leaf nodes&lt;/i&gt; are nodes that have no child nodes. | [optional] 
**item_condition_required** | **bool** | This flag denotes whether or not you must list the item condition in a listing for the specified category. If set to &lt;code&gt;true&lt;/code&gt;, you must specify an item condition for the associated category. | [optional] 
**item_conditions** | [**\Swagger\Client\Model\ItemCondition[]**](ItemCondition.md) | The item-condition values allowed in the category.&lt;br /&gt;&lt;br /&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note: &lt;/b&gt;In all eBay marketplaces, Condition ID 2000 now maps to an item condition of &#x27;Certified Refurbished&#x27;, and not &#x27;Manufacturer Refurbished&#x27;. To list an item as &#x27;Certified Refurbished&#x27;, a seller must be pre-qualified by eBay for this feature. Any seller who is not eligible for this feature will be blocked if they try to create a new listing or revise an existing listing with this item condition.&lt;br&gt;&lt;br&gt; Any seller that is interested in eligibility requirements to list with &#x27;Certified Refurbished&#x27; should see the &lt;a href&#x3D;\&quot;https://pages.ebay.com/seller-center/listing-and-marketing/certified-refurbished-program.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Certified refurbished program&lt;/a&gt; page in Seller Center. &lt;/span&gt;&lt;br /&gt;&lt;br /&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; For the Cell Phones &amp; Smartphones category (9355), the &lt;code&gt;SELLER_REFURBISHED&lt;/code&gt; condition is being deprecated. Sellers trying to list an item in this category (9355) with the condition &lt;code&gt;SELLER_REFURBISHED&lt;/code&gt; will be blocked. Starting September 1, 2021, existing listings for this category (9355) with this item condition will be ended by eBay but three new additional refurbished items conditions will be available: &lt;code&gt;EXCELLENT_REFURBISHED&lt;/code&gt;, &lt;code&gt;VERY_GOOD_REFURBISHED&lt;/code&gt;, and &lt;code&gt;GOOD_REFURBISHED&lt;/code&gt;. To be eligible to list with these three item conditions, sellers will have to go through an application process. See &lt;a href&#x3D;\&quot;https://www.ebay.com/help/selling/listings/creating-managing-listings/item-conditions-category?id&#x3D;4765#section4\&quot;  target&#x3D;\&quot;_blank\&quot;&gt;Cameras &amp; Photo, Cell Phones &amp; Accessories...&lt;/a&gt; for details.&lt;/span&gt; | [optional] 

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

