<?php
/**
 * WPL_Core
 *
 * This class contains methods that should be available for all classes
 * 
 */

if ( ! defined( 'DS' ) ) define( 'DS', DIRECTORY_SEPARATOR );

class WPL_Core {
	
	static public $PLUGIN_URL;
	static public $PLUGIN_DIR;
	static public $PLUGIN_VERSION;

	const ParentPermissions	= 'publish_ebay_listings';
	const ParentMenuId		= 'wplister';
	
	const InputPrefix 		= 'wpl_e2e_';
	const OptionPrefix 		= 'wplister_';

	var $logger;
	var $message;
	var $messages = array();

	/* @var EbayController */
	var $EC;

	var $app_name;
	
	public function __construct() {

		$this->app_name = apply_filters_deprecated( 'wplister_app_name', array('eBay'), '2.8.4', 'wple_app_name' );
		$this->app_name = apply_filters( 'wple_app_name', $this->app_name );

		add_action( 'init', 				array( &$this, 'onWpInit' ), 1 );
		add_action( 'admin_init', 			array( &$this, 'onWpAdminInit' ) );

		$this->config();
	}

	// these methods can be overriden
	public function config() {
	}
	public function onWpInit() {
	}	
	public function onWpAdminInit() {
	}

	/* Generic message display */
	public function showMessage($message, $errormsg = false, $echo = false) {		
		if ( defined('WPLISTER_RESELLER_VERSION') ) {
		    $message = apply_filters_deprecated( 'wplister_tooltip_text', array($message), '2.8.4', 'wple_tooltip_text' );
		    $message = apply_filters( 'wple_tooltip_text', $message );
        }
		$class = ($errormsg) ? 'error' : 'updated';			// error or success
		$class = ($errormsg == 2) ? 'update-nag' : $class; 	// top warning
		$this->message .= '<div id="message" class="'.$class.'" style="display:block !important"><p>'.$message.'</p></div>';
		if ($echo) echo $this->message;
	}


	// init eBay connection
	public function initEC( $account_id = null, $site_id = null ) { 

		// make sure the database is up to date
	 	WPLE_UpgradeHelper::maybe_upgrade_db();

	 	// init controller
		$this->EC = new EbayController();	

		// use current default account by default (WPL1)
		$ebay_site_id    = self::getOption('ebay_site_id'); 
		$sandbox_enabled = self::getOption('sandbox_enabled');
		$ebay_token      = self::getOption('ebay_token');

		// set site_id dynamically during authentication
		if ( isset( $_REQUEST['site_id'] ) && isset( $_REQUEST['sandbox'] ) ) {
			$ebay_site_id    = wple_clean($_REQUEST['site_id']);
			$sandbox_enabled = wple_clean($_REQUEST['sandbox']);
			$ebay_token      = '';
		}

		// use specific account if provided in request or parameter
		if ( ! $account_id ) {
		    if (isset( $_REQUEST['account_id'] ) ) {
                $account_id = wple_clean($_REQUEST['account_id']);
            } else {
                $account_id = get_option('wplister_default_account_id');
            }
		}

		if ( $account_id ) {
			$account = WPLE_eBayAccount::getAccount( $account_id );
			if ( $account ) {
			    $ebay_site_id    = $account->site_id;
				$sandbox_enabled = $account->sandbox_mode; 
				$ebay_token      = $account->token; 
				$oauth_token     = $account->oauth_token;
			} else {
				$msg = sprintf('<b>Warning: You are trying to use an account which does not exist in WP-Lister</b> (ID %s).',$account_id) . '<br>';
				$msg .= 'This can happen when you delete an account from WP-Lister without removing all listings, profiles and orders first.'. '<br><br>';
				$msg .= 'In order to solve this issue, please visit your account settings and follow the instructions to assign all listings, orders and profiles to your default account.';
				wple_show_message($msg,'warn');
			}
		}

		if ( $site_id !== null ) $ebay_site_id = $site_id;

		$this->EC->initEbay( $ebay_site_id, 
							 $sandbox_enabled,
							 $ebay_token,
							 $oauth_token,
							 $account_id );
	}
	
	public function isStagingSite() {
		$staging_site_pattern = get_option('wplister_staging_site_pattern');
		if ( ! $staging_site_pattern ) {
			update_option('wplister_staging_site_pattern','staging'); // if no pattern set, use default 'staging'
			return false;
		}

        /**
         * Use bloginfo(url) to test agains the staging site URL pattern instead of only matching domains/subdomains
         */
        $url = get_bloginfo( 'url' );

        // (DEPRECATED)Fallback to parsing the siteurl if SERVER_NAME is unavailable #41332
        /*if ( !empty( $_SERVER['SERVER_NAME'] ) ) {
		    $domain = $_SERVER['SERVER_NAME'];
        } else {
		    $parts = parse_url( get_bloginfo( 'siteurl' ) );
		    $domain = $parts['host'];
        }*/
		
		if ( preg_match( "/$staging_site_pattern/", $url ) ) {
			return true;
		}
		if ( preg_match( "/wpstagecoach.com/", $url ) ) {
			return true;
		}

		return false;
	}


	/* prefixed request handlers */
	protected function getAnswerFromPost( $insKey, $insPrefix = null ) {
		if ( is_null( $insPrefix ) ) {
			$insKey = self::InputPrefix.$insKey;
		}
		return ( isset( $_POST[$insKey] )? 'Y': 'N' );
	}
	
	protected function getValueFromPost( $insKey, $insPrefix = null, $allow_html = false ) {
		if ( is_null( $insPrefix ) ) {
			$insKey = self::InputPrefix.$insKey;
		}

		$value = isset( $_POST[ $insKey ] ) ? $_POST[ $insKey ] : false;

		if ( $allow_html ) {
		    $value = wp_kses_post_deep( $value );
        } else {
            $value = wple_clean( $value );
        }

        return $value;
	}

	protected function requestAction() {
		if ( ( isset($_REQUEST['action']  ) ) && ( $_REQUEST['action']  != '' ) && ( $_REQUEST['action']  != '-1' ) ) return wple_clean($_REQUEST['action']);
		if ( ( isset($_REQUEST['action2'] ) ) && ( $_REQUEST['action2'] != '' ) && ( $_REQUEST['action2'] != '-1' ) ) return wple_clean($_REQUEST['action2']);
		return false;
	}

	
	/* prefixed option handlers */
	static public function getOption( $insKey, $default = null ) {
		return get_option( self::OptionPrefix.$insKey, $default );
	}
	
	static public function addOption( $insKey, $insValue ) {
		return add_option( self::OptionPrefix.$insKey, $insValue );
	}
	
	static public function updateOption( $insKey, $insValue ) {
		return update_option( self::OptionPrefix.$insKey, $insValue );
	}
	
	static public function deleteOption( $insKey ) {
		return delete_option( $insKey );
	}

	/* template methods */
	protected function getImageUrl( $insImage ) {
		return self::$PLUGIN_URL.'img/'.$insImage;
	}
	
	protected function getSubmenuPageTitle( $insTitle ) {
		return $insTitle.' - '.$this->app_name;
	}
	
	protected function getSubmenuId( $insId ) {
		return self::ParentMenuId.'-'.$insId;
	}

		
} // class WPL_Core

