<?php

class WPL_Autoloader {

	/**
	 * Namespace.
	 */
	protected static $namespaces = array(
	    'WPL'
	);

	/**
	 * class table
	 */
	protected static $class_cache = array(

		// core
		'WPLE_MemCache'      		=> '/classes/core/WPL_MemCache.php',
		'WPLE_AdminMessages'   		=> '/classes/core/WPL_AdminMessages.php',
		'WPLE_Rest_Controller'   	=> '/classes/core/WPL_RestController.php',
		'WPL_InventoryCheck'   		=> '/classes/core/WPL_InventoryCheck.php',
		'WPL_BackgroundInventoryCheck' => '/classes/core/WPL_BackgroundInventoryCheck.php',

		// pages
		'WPLE_GridEditorPage'   	=> '/classes/page/GridEditorPage.php',

		// helper
		'WPLE_UpgradeHelper'   		=> '/classes/helper/WPLE_UpgradeHelper.php',
		'WPLE_ListingQueryHelper'   => '/classes/helper/WPLE_ListingQueryHelper.php',
		'WPLE_ValidationHelper'     => '/classes/helper/WPLE_ValidationHelper.php',
		'WPLE_TranslationHelper'    => '/classes/helper/WPLE_TranslationHelper.php',
		'EbayMarketplaceApi'        => '/classes/helper/EbayMarketplaceApi.php',
		'EbayMediaApi'              => '/classes/helper/EbayMediaApi.php',

		// integration
		'ProductWrapper'   			=> '/classes/integration/ProductWrapper_woo.php',
		'OrderWrapper'   			=> '/classes/integration/OrderWrapper_woo.php',
		'WC_Product_Ebay'   		=> '/classes/integration/WooEbayProduct.php',

		// models
		'WPLE_eBaySite'         	=> '/classes/model/eBaySite.php',
		'WPLE_eBayAccount'      	=> '/classes/model/eBayAccount.php',

		'WPLab\Ebay\Models\EbayDocument'            => '/classes/model/EbayDocument.php',
		'WPLab\Ebay\Models\EbayAddress'             => '/classes/model/EbayAddress.php',
		'WPLab\Ebay\Models\EbayManufacturer'        => '/classes/model/EbayManufacturer.php',
		'WPLab\Ebay\Models\EbayResponsiblePerson'   => '/classes/model/EbayResponsiblePerson.php',

		'WPLab\Ebay\Listings\Listing'   => '/classes/listings/Listing.php',
		'WPLab\Ebay\Listings\Profile'   => '/classes/listings/Profile.php',


	);

	/**
	 * @param string $className
	 * @return string|false
	 */
	public static function autoload($className)
	{

	    if ( array_key_exists( $className, self::$class_cache ) ) {
   			return include WPLE_PLUGIN_PATH . self::$class_cache[ $className ];
	    } elseif ( ( $classPath = self::getClassPath($className) ) !== false ) {
	        return include $classPath;
	    } else {
	        return false;
	    }

	}

	public static function autoloadEbayClasses($className)
	{

	    if (($classPath = self::getEbayClassPath($className)) !== false) {
	        return include $classPath;
	    } else {
	        return false;
	    }

	}

	/**
	 * @param string $className
	 * @return string|false
	 */
	private static function getClassPath($className)
	{

		// load models
		if ( 'Model' == substr($className, -5) ) {
			$className = str_replace( 'WPLE_', '', $className );
            $path = WPLE_PLUGIN_PATH . '/classes/model/' . $className . '.php';
            if (is_readable($path)) {
                return $path;
            }
		}

		// load pages
		if ( 'Page' == substr($className, -4) ) {
			$className = str_replace( 'WPLE_', '', $className );
            $path = WPLE_PLUGIN_PATH . '/classes/page/' . $className . '.php';
            if (is_readable($path)) {
                return $path;
            }
		}

		// load tables
		if ( 'Table' == substr($className, -5) ) {
			$className = str_replace( 'WPLE_', '', $className );
            $path = WPLE_PLUGIN_PATH . '/classes/table/' . $className . '.php';
            if (is_readable($path)) {
                return $path;
            }
		}


		// conventional autoloader
	    $parts = explode("_", $className);

	    foreach (self::$namespaces as $ns) {
	        if (count($parts) && $parts[0] == $ns) {
	            $path = WPLE_PLUGIN_PATH . '/classes' . DIRECTORY_SEPARATOR . implode(DIRECTORY_SEPARATOR, $parts) . '.php';
	            if (is_readable($path)) {
	                return $path;
	            }
	        }
	    }
	    return false;
	}

	/**
	 * @param string $className
	 * @return string|false
	 */
	private static function getEbayClassPath($className)
	{

		// load EbatNs (ebay sdk) classes
        $path = WPLE_PLUGIN_PATH . '/includes/EbatNs/' . $className . '.php';
        if (is_readable($path)) {
            return $path;
        }
	    return false;
	}

}

