<?php
/**
 * Defines the options for the WP jQuery Lightbox plugin.
 *
 * @package LightPress
 */

$wp_jquery_lightbox_options = array(
	array(
		'id'                => 'jqlb_automate',
		'title'             => __( 'Autodetect Images', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_borderColor',
		'title'             => __( 'Border Color', 'wp-jquery-lightbox' ),
		'input'             => 'text',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '#ffffff',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Default: #ffffff', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_borderSize',
		'title'             => __( 'Border Size', 'wp-jquery-lightbox' ),
		'input'             => 'number',
		'sanitize_callback' => 'intval',
		'default'           => '6',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Width of border around image (default: 6)', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_overlayColor',
		'title'             => __( 'Overlay Color', 'wp-jquery-lightbox' ),
		'input'             => 'text',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '#ffffff',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Default: #ffffff', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_overlayOpacity',
		'title'             => __( 'Overlay Opacity', 'wp-jquery-lightbox' ),
		'input'             => 'text',
		'sanitize_callback' => 'floatval',
		'default'           => '0.7',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Value between 0 and 1. Default: .7', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_boxShadow',
		'title'             => __( 'Show Box Shadow', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Add box shadow around image', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_newNavStyle',
		'title'             => __( 'Use New Nav Style', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'More modern nav arrow style (recommended)', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_fixedNav',
		'title'             => __( 'Use Fixed Nav', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Fixed nav position (reqires new nav style)', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_navArrowColor',
		'title'             => __( 'Nav Arrow Color', 'wp-jquery-lightbox' ),
		'input'             => 'text',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '#000000',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Nav arrow color like #000 or rgba(0,0,0,.5) for transparency. Requires new nav style.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_navBackgroundColor',
		'title'             => __( 'Nav Background Color', 'wp-jquery-lightbox' ),
		'input'             => 'text',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'rgba(255,255,255,.7',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Nav background color like #fff or rgba(255,255,255,.5) for transparency. Requires new nav style.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_margin_size',
		'title'             => __( 'Margin Size', 'wp-jquery-lightbox' ),
		'input'             => 'number',
		'sanitize_callback' => 'intval',
		'default'           => '40',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Margin between lightbox and edge of browser window.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_mobile_margin_size',
		'title'             => __( 'Mobile Margin Size', 'wp-jquery-lightbox' ),
		'input'             => 'number',
		'sanitize_callback' => 'intval',
		'default'           => '10',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Margin between lightbox and edge of browser window on mobile.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_showInfoBar',
		'title'             => __( 'Show Info Bar', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_navbarOnTop',
		'title'             => __( 'Show Nav on Top', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '0',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_showTitle',
		'title'             => __( 'Show Title', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_useAltForTitle',
		'title'             => __( 'Use Alt for Title', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Use alt tag for title if it exists.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_showCaption',
		'title'             => __( 'Show Caption', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_showNumbers',
		'title'             => __( 'Show Image Numbers', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_showDownload',
		'title'             => __( 'Show Download Button', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '0',
		'section'           => 'lightpress-jqlb-settings-section',
	),
	array(
		'id'                => 'jqlb_slideshow_speed',
		'title'             => __( 'Slideshow Speed', 'wp-jquery-lightbox' ),
		'input'             => 'number',
		'min'               => '100',
		'max'               => '10000',
		'step'              => '50',
		'sanitize_callback' => 'intval',
		'default'           => '4000',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Slideshow speed (in milliseconds). 0 to disable.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_comments',
		'title'             => __( 'Lightbox in Comments', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Enable lighbox for comments in images. Note: Will disable nofollow attribute of comment links.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_resize_on_demand',
		'title'             => __( 'Fit images to screen', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Shrink images to fit screen if needed. Otherwise large images will extend off screen.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_resize_speed',
		'title'             => __( 'Animation Speed', 'wp-jquery-lightbox' ),
		'input'             => 'number',
		'min'               => '100',
		'max'               => '10000',
		'step'              => '50',
		'sanitize_callback' => 'intval',
		'default'           => '400',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Controls the speed of resize animations (in milliseconds).', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_use_theme_styles',
		'title'             => __( 'Use Theme Styles', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '0',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Put lightbox.min.css or lightbox.min.[locale].css in theme style folder. Helps keep custom CSS  when updating plugin.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_enqueue_in_footer',
		'title'             => __( 'Load JS in Footer', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Uncheck this box to load jQuery and lightbox in the header of your page.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_disable_core_lightbox',
		'title'             => __( 'Disable Core Lightbox', 'lightpress-pro' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
		'description'       => __( 'Disable the core lightbox when lightbox is active.', 'wp-jquery-lightbox' ),
	),
	array(
		'id'                => 'jqlb_pinchzoom',
		'title'             => __( 'Enable Mobile Pinchzoom', 'wp-jquery-lightbox' ),
		'input'             => 'checkbox',
		'sanitize_callback' => 'wp_validate_boolean',
		'default'           => '1',
		'section'           => 'lightpress-jqlb-settings-section',
	),
);
