<?php
/**
 * Zoom settings page
 */

defined( 'ABSPATH' ) || exit;

$brand = vsprintf(
	'<img src="%s" /> <a href="%s">%s</a>',
	array(
		IMAGE_ZOOM_URL . 'assets/images/silkypress_logo.png',
		'https://www.silkypress.com/?utm_source=wordpress&utm_campaign=iz_free&utm_medium=banner',
		'SilkyPress.com',
	)
);

?>
<style type="text/css">
	.form-group { display:flex; align-items: center; }
	.control-label{ height: auto; }
</style>

<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('[data-toggle="tooltip"]').tooltip();
	});
</script>

<?php add_thickbox(); ?>
<div id="supported-lightboxes" style="display:none;">
	<p>The zoom is compatible with:
		<ul style="list-style: inside; padding-left: 20px;">
			<li>the lightbox created by the <a href="https://www.silkypress.com/i/wp-photo-gallery" target="_blank" rel="nofollow">Photo Gallery</a> plugin</li>
			<li>the iLightbox from the <a href="https://www.silkypress.com/i/avada-theme" target="_blank" rel="nofollow">Avada Theme</a></li>
			<li>the <a href="https://www.silkypress.com/i/js-prettyphoto" target="_blank" rel="nofollow">prettyPhoto</a> lightbox (also used by the <a href="https://www.silkypress.com/i/visual-composer" target="_blank" rel="nofollow">WPBakery</a> gallery)</li>
			<li>the <a href="https://www.silkypress.com/i/js-fancybox" target="_blank" rel="nofollow">fancyBox</a> lightbox (also used by the <a href="https://wordpress.org/plugins/easy-fancybox/" target="_blank" rel="nofollow">Firelight Lightbox</a> or the <a href="https://wordpress.org/plugins/woocommerce-lightbox/" target="_blank" rel="nofollow">WooCommerce LightBox</a> plugin)</li>
			<li>the <a href="https://www.silkypress.com/i/js-featherlight" target="_blank" rel="nofollow">Featherlight.js</a> lightbox (also used by <a href="https://www.silkypress.com/i/wp-draw-attention" target="_blank" rel="nofollow">Draw Attention</a> plugin)</li>
			<li>the lightbox created by the Ultimate Product Catalogue by Etoile Web Design</li>
			<li>the <a href="http://dimsemenov.com/plugins/magnific-popup/" target="_blank" rel="nofollow">Magnific Popup</a> lightbox (also used by <a href="https://www.silkypress.com/i/enfold-theme" target="_blank" rel="nofollow">Enfold</a> portfolio items, the Divi gallery or the <a href="https://wordpress.org/plugins/beaver-builder-lite-version/" target="_blank">Beaver Builder</a>)</li>
			<li>the lightbox from the <a href="https://wordpress.org/plugins/elementor/" target="_blank" rel="nofollow">Elementor</a> Page Builder</li>
		</ul>
	</p>
</div>

<div id="add-zoooom-help" style="display:none;">
	<p>The zoom can be added to an image within a page/post by adding the “zoooom” CSS class to the image. Here are screenshots on how to do this with the most popular page builders:</p>
		<ul style="list-style: inside; padding-left: 20px;">
			<li> Gutenberg – <a href="https://www.silkypress.com/wp-content/uploads/2018/10/zoom-gutenberg.png" target="_blank">screenshot</a>
			<li> WPBakery – depending on the page builder’s version: 1) <a href="https://www.silkypress.com/wp-content/uploads/2017/05/image-zoom-js_composer.png" target="_blank">screenshot</a> with the “large” or “full” for the Image Size setting. Or 2) <a href="https://www.silkypress.com/wp-content/uploads/2019/06/wpbakery-zoooom.png" target="_blank">screenshot</a>.
			<li> Page Builder by SiteOrigin – <a href="https://www.silkypress.com/wp-content/uploads/2020/04/site-origin-zoooom.png" target="_blank">screenshot</a>
			<li> Elementor Page Builder – <a href="https://www.silkypress.com/wp-content/uploads/2016/09/image-zoom-elementor.png" target="_blank">screenshot</a>. It works with all the Image Size options, except Custom.
			<li> Beaver Builder – <a href="https://www.silkypress.com/wp-content/uploads/2020/04/beaver-builder-zoooom.png" target="_blank">screenshot</a>
			<li> Divi Builder – <a href="https://www.silkypress.com/wp-content/uploads/2024/11/divi-builder.png" target="_blank">screenshot</a> (used by the Divi theme)
			<li> Avia Layout Builder – <a href="https://www.silkypress.com/wp-content/uploads/2019/04/enfold-apply-zoooom.png" target="_blank">screenshot</a> (used by the Enfold theme)
			<li> Fusion Page Builder – <a href="https://www.silkypress.com/wp-content/uploads/2021/06/fusion-zoooom.png" target="_blank">screenshot</a>
			<li> Brizy Page Builder – <a href="https://www.silkypress.com/wp-content/uploads/2019/01/zoom-brizy.png" target="_blank">screenshot</a>
			<li> Tatsu Page Builder – <a href="https://www.dropbox.com/h?preview=tatsu-builder-zoom.flv" target="_blank">screencast</a>
		</ul>
</div>


<h2><?php printf( esc_html__( 'WP Image Zoom by %1$s', 'wp-image-zoooom' ), $brand ); ?></h2>

<div class="wrap">
	<h3 class="nav-tab-wrapper woo-nav-tab-wrapper">
		<a href="?page=zoooom_settings&tab=general" class="nav-tab nav-tab-active"><?php _e( 'General Settings', 'wp-image-zoooom' ); ?></a>
		<a href="?page=zoooom_settings&tab=settings" class="nav-tab"><?php _e( 'Zoom Settings', 'wp-image-zoooom' ); ?></a>
	</h3>
	<div class="panel panel-default">
		<div class="panel-body">
			<div class="row">
				<div id="alert_messages">
				<?php echo $messages; ?>
				</div>

				<form class="form-horizontal" method="post" action="" id="form_settings">
					<?php echo $form->render(); ?>

					<div class="form-group">
						<div class="col-lg-6">
							<input type="hidden" name="tab" value="general" />
							<button type="submit" class="btn btn-primary"><?php _e( 'Save changes', 'wp-image-zoooom' ); ?></button>
						</div>
					</div>
					<?php wp_nonce_field( 'zoooom_general' ); ?>
				</form>
			</div>
		</div>
	</div>
</div>
