<?php
/**
 * Hotelier Country Functions.
 *
 * @author   Benito Lopez <hello@lopezb.com>
 * @category Core
 * @package  Hotelier/Functions
 * @version  2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Get a full list of country codes
 *
 * @return array
 */
function htl_get_country_codes() {

	$countries = array(
		'AF' => __( 'Afghanistan', 'wp-hotelier' ),
		'AX' => __( '&#197;land Islands', 'wp-hotelier' ),
		'AL' => __( 'Albania', 'wp-hotelier' ),
		'DZ' => __( 'Algeria', 'wp-hotelier' ),
		'AS' => __( 'American Samoa', 'wp-hotelier' ),
		'AD' => __( 'Andorra', 'wp-hotelier' ),
		'AO' => __( 'Angola', 'wp-hotelier' ),
		'AI' => __( 'Anguilla', 'wp-hotelier' ),
		'AQ' => __( 'Antarctica', 'wp-hotelier' ),
		'AG' => __( 'Antigua and Barbuda', 'wp-hotelier' ),
		'AR' => __( 'Argentina', 'wp-hotelier' ),
		'AM' => __( 'Armenia', 'wp-hotelier' ),
		'AW' => __( 'Aruba', 'wp-hotelier' ),
		'AU' => __( 'Australia', 'wp-hotelier' ),
		'AT' => __( 'Austria', 'wp-hotelier' ),
		'AZ' => __( 'Azerbaijan', 'wp-hotelier' ),
		'BS' => __( 'Bahamas', 'wp-hotelier' ),
		'BH' => __( 'Bahrain', 'wp-hotelier' ),
		'BD' => __( 'Bangladesh', 'wp-hotelier' ),
		'BB' => __( 'Barbados', 'wp-hotelier' ),
		'BY' => __( 'Belarus', 'wp-hotelier' ),
		'BE' => __( 'Belgium', 'wp-hotelier' ),
		'PW' => __( 'Belau', 'wp-hotelier' ),
		'BZ' => __( 'Belize', 'wp-hotelier' ),
		'BJ' => __( 'Benin', 'wp-hotelier' ),
		'BM' => __( 'Bermuda', 'wp-hotelier' ),
		'BT' => __( 'Bhutan', 'wp-hotelier' ),
		'BO' => __( 'Bolivia', 'wp-hotelier' ),
		'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'wp-hotelier' ),
		'BA' => __( 'Bosnia and Herzegovina', 'wp-hotelier' ),
		'BW' => __( 'Botswana', 'wp-hotelier' ),
		'BV' => __( 'Bouvet Island', 'wp-hotelier' ),
		'BR' => __( 'Brazil', 'wp-hotelier' ),
		'IO' => __( 'British Indian Ocean Territory', 'wp-hotelier' ),
		'BN' => __( 'Brunei', 'wp-hotelier' ),
		'BG' => __( 'Bulgaria', 'wp-hotelier' ),
		'BF' => __( 'Burkina Faso', 'wp-hotelier' ),
		'BI' => __( 'Burundi', 'wp-hotelier' ),
		'KH' => __( 'Cambodia', 'wp-hotelier' ),
		'CM' => __( 'Cameroon', 'wp-hotelier' ),
		'CA' => __( 'Canada', 'wp-hotelier' ),
		'CV' => __( 'Cape Verde', 'wp-hotelier' ),
		'KY' => __( 'Cayman Islands', 'wp-hotelier' ),
		'CF' => __( 'Central African Republic', 'wp-hotelier' ),
		'TD' => __( 'Chad', 'wp-hotelier' ),
		'CL' => __( 'Chile', 'wp-hotelier' ),
		'CN' => __( 'China', 'wp-hotelier' ),
		'CX' => __( 'Christmas Island', 'wp-hotelier' ),
		'CC' => __( 'Cocos (Keeling) Islands', 'wp-hotelier' ),
		'CO' => __( 'Colombia', 'wp-hotelier' ),
		'KM' => __( 'Comoros', 'wp-hotelier' ),
		'CG' => __( 'Congo (Brazzaville)', 'wp-hotelier' ),
		'CD' => __( 'Congo (Kinshasa)', 'wp-hotelier' ),
		'CK' => __( 'Cook Islands', 'wp-hotelier' ),
		'CR' => __( 'Costa Rica', 'wp-hotelier' ),
		'HR' => __( 'Croatia', 'wp-hotelier' ),
		'CU' => __( 'Cuba', 'wp-hotelier' ),
		'CW' => __( 'Cura&ccedil;ao', 'wp-hotelier' ),
		'CY' => __( 'Cyprus', 'wp-hotelier' ),
		'CZ' => __( 'Czech Republic', 'wp-hotelier' ),
		'DK' => __( 'Denmark', 'wp-hotelier' ),
		'DJ' => __( 'Djibouti', 'wp-hotelier' ),
		'DM' => __( 'Dominica', 'wp-hotelier' ),
		'DO' => __( 'Dominican Republic', 'wp-hotelier' ),
		'EC' => __( 'Ecuador', 'wp-hotelier' ),
		'EG' => __( 'Egypt', 'wp-hotelier' ),
		'SV' => __( 'El Salvador', 'wp-hotelier' ),
		'GQ' => __( 'Equatorial Guinea', 'wp-hotelier' ),
		'ER' => __( 'Eritrea', 'wp-hotelier' ),
		'EE' => __( 'Estonia', 'wp-hotelier' ),
		'ET' => __( 'Ethiopia', 'wp-hotelier' ),
		'FK' => __( 'Falkland Islands', 'wp-hotelier' ),
		'FO' => __( 'Faroe Islands', 'wp-hotelier' ),
		'FJ' => __( 'Fiji', 'wp-hotelier' ),
		'FI' => __( 'Finland', 'wp-hotelier' ),
		'FR' => __( 'France', 'wp-hotelier' ),
		'GF' => __( 'French Guiana', 'wp-hotelier' ),
		'PF' => __( 'French Polynesia', 'wp-hotelier' ),
		'TF' => __( 'French Southern Territories', 'wp-hotelier' ),
		'GA' => __( 'Gabon', 'wp-hotelier' ),
		'GM' => __( 'Gambia', 'wp-hotelier' ),
		'GE' => __( 'Georgia', 'wp-hotelier' ),
		'DE' => __( 'Germany', 'wp-hotelier' ),
		'GH' => __( 'Ghana', 'wp-hotelier' ),
		'GI' => __( 'Gibraltar', 'wp-hotelier' ),
		'GR' => __( 'Greece', 'wp-hotelier' ),
		'GL' => __( 'Greenland', 'wp-hotelier' ),
		'GD' => __( 'Grenada', 'wp-hotelier' ),
		'GP' => __( 'Guadeloupe', 'wp-hotelier' ),
		'GU' => __( 'Guam', 'wp-hotelier' ),
		'GT' => __( 'Guatemala', 'wp-hotelier' ),
		'GG' => __( 'Guernsey', 'wp-hotelier' ),
		'GN' => __( 'Guinea', 'wp-hotelier' ),
		'GW' => __( 'Guinea-Bissau', 'wp-hotelier' ),
		'GY' => __( 'Guyana', 'wp-hotelier' ),
		'HT' => __( 'Haiti', 'wp-hotelier' ),
		'HM' => __( 'Heard Island and McDonald Islands', 'wp-hotelier' ),
		'HN' => __( 'Honduras', 'wp-hotelier' ),
		'HK' => __( 'Hong Kong', 'wp-hotelier' ),
		'HU' => __( 'Hungary', 'wp-hotelier' ),
		'IS' => __( 'Iceland', 'wp-hotelier' ),
		'IN' => __( 'India', 'wp-hotelier' ),
		'ID' => __( 'Indonesia', 'wp-hotelier' ),
		'IR' => __( 'Iran', 'wp-hotelier' ),
		'IQ' => __( 'Iraq', 'wp-hotelier' ),
		'IE' => __( 'Ireland', 'wp-hotelier' ),
		'IM' => __( 'Isle of Man', 'wp-hotelier' ),
		'IL' => __( 'Israel', 'wp-hotelier' ),
		'IT' => __( 'Italy', 'wp-hotelier' ),
		'CI' => __( 'Ivory Coast', 'wp-hotelier' ),
		'JM' => __( 'Jamaica', 'wp-hotelier' ),
		'JP' => __( 'Japan', 'wp-hotelier' ),
		'JE' => __( 'Jersey', 'wp-hotelier' ),
		'JO' => __( 'Jordan', 'wp-hotelier' ),
		'KZ' => __( 'Kazakhstan', 'wp-hotelier' ),
		'KE' => __( 'Kenya', 'wp-hotelier' ),
		'KI' => __( 'Kiribati', 'wp-hotelier' ),
		'KW' => __( 'Kuwait', 'wp-hotelier' ),
		'KG' => __( 'Kyrgyzstan', 'wp-hotelier' ),
		'LA' => __( 'Laos', 'wp-hotelier' ),
		'LV' => __( 'Latvia', 'wp-hotelier' ),
		'LB' => __( 'Lebanon', 'wp-hotelier' ),
		'LS' => __( 'Lesotho', 'wp-hotelier' ),
		'LR' => __( 'Liberia', 'wp-hotelier' ),
		'LY' => __( 'Libya', 'wp-hotelier' ),
		'LI' => __( 'Liechtenstein', 'wp-hotelier' ),
		'LT' => __( 'Lithuania', 'wp-hotelier' ),
		'LU' => __( 'Luxembourg', 'wp-hotelier' ),
		'MO' => __( 'Macao S.A.R., China', 'wp-hotelier' ),
		'MK' => __( 'North Macedonia', 'wp-hotelier' ),
		'MG' => __( 'Madagascar', 'wp-hotelier' ),
		'MW' => __( 'Malawi', 'wp-hotelier' ),
		'MY' => __( 'Malaysia', 'wp-hotelier' ),
		'MV' => __( 'Maldives', 'wp-hotelier' ),
		'ML' => __( 'Mali', 'wp-hotelier' ),
		'MT' => __( 'Malta', 'wp-hotelier' ),
		'MH' => __( 'Marshall Islands', 'wp-hotelier' ),
		'MQ' => __( 'Martinique', 'wp-hotelier' ),
		'MR' => __( 'Mauritania', 'wp-hotelier' ),
		'MU' => __( 'Mauritius', 'wp-hotelier' ),
		'YT' => __( 'Mayotte', 'wp-hotelier' ),
		'MX' => __( 'Mexico', 'wp-hotelier' ),
		'FM' => __( 'Micronesia', 'wp-hotelier' ),
		'MD' => __( 'Moldova', 'wp-hotelier' ),
		'MC' => __( 'Monaco', 'wp-hotelier' ),
		'MN' => __( 'Mongolia', 'wp-hotelier' ),
		'ME' => __( 'Montenegro', 'wp-hotelier' ),
		'MS' => __( 'Montserrat', 'wp-hotelier' ),
		'MA' => __( 'Morocco', 'wp-hotelier' ),
		'MZ' => __( 'Mozambique', 'wp-hotelier' ),
		'MM' => __( 'Myanmar', 'wp-hotelier' ),
		'NA' => __( 'Namibia', 'wp-hotelier' ),
		'NR' => __( 'Nauru', 'wp-hotelier' ),
		'NP' => __( 'Nepal', 'wp-hotelier' ),
		'NL' => __( 'Netherlands', 'wp-hotelier' ),
		'NC' => __( 'New Caledonia', 'wp-hotelier' ),
		'NZ' => __( 'New Zealand', 'wp-hotelier' ),
		'NI' => __( 'Nicaragua', 'wp-hotelier' ),
		'NE' => __( 'Niger', 'wp-hotelier' ),
		'NG' => __( 'Nigeria', 'wp-hotelier' ),
		'NU' => __( 'Niue', 'wp-hotelier' ),
		'NF' => __( 'Norfolk Island', 'wp-hotelier' ),
		'MP' => __( 'Northern Mariana Islands', 'wp-hotelier' ),
		'KP' => __( 'North Korea', 'wp-hotelier' ),
		'NO' => __( 'Norway', 'wp-hotelier' ),
		'OM' => __( 'Oman', 'wp-hotelier' ),
		'PK' => __( 'Pakistan', 'wp-hotelier' ),
		'PS' => __( 'Palestinian Territory', 'wp-hotelier' ),
		'PA' => __( 'Panama', 'wp-hotelier' ),
		'PG' => __( 'Papua New Guinea', 'wp-hotelier' ),
		'PY' => __( 'Paraguay', 'wp-hotelier' ),
		'PE' => __( 'Peru', 'wp-hotelier' ),
		'PH' => __( 'Philippines', 'wp-hotelier' ),
		'PN' => __( 'Pitcairn', 'wp-hotelier' ),
		'PL' => __( 'Poland', 'wp-hotelier' ),
		'PT' => __( 'Portugal', 'wp-hotelier' ),
		'PR' => __( 'Puerto Rico', 'wp-hotelier' ),
		'QA' => __( 'Qatar', 'wp-hotelier' ),
		'RE' => __( 'Reunion', 'wp-hotelier' ),
		'RO' => __( 'Romania', 'wp-hotelier' ),
		'RU' => __( 'Russia', 'wp-hotelier' ),
		'RW' => __( 'Rwanda', 'wp-hotelier' ),
		'BL' => __( 'Saint Barth&eacute;lemy', 'wp-hotelier' ),
		'SH' => __( 'Saint Helena', 'wp-hotelier' ),
		'KN' => __( 'Saint Kitts and Nevis', 'wp-hotelier' ),
		'LC' => __( 'Saint Lucia', 'wp-hotelier' ),
		'MF' => __( 'Saint Martin (French part)', 'wp-hotelier' ),
		'SX' => __( 'Saint Martin (Dutch part)', 'wp-hotelier' ),
		'PM' => __( 'Saint Pierre and Miquelon', 'wp-hotelier' ),
		'VC' => __( 'Saint Vincent and the Grenadines', 'wp-hotelier' ),
		'SM' => __( 'San Marino', 'wp-hotelier' ),
		'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'wp-hotelier' ),
		'SA' => __( 'Saudi Arabia', 'wp-hotelier' ),
		'SN' => __( 'Senegal', 'wp-hotelier' ),
		'RS' => __( 'Serbia', 'wp-hotelier' ),
		'SC' => __( 'Seychelles', 'wp-hotelier' ),
		'SL' => __( 'Sierra Leone', 'wp-hotelier' ),
		'SG' => __( 'Singapore', 'wp-hotelier' ),
		'SK' => __( 'Slovakia', 'wp-hotelier' ),
		'SI' => __( 'Slovenia', 'wp-hotelier' ),
		'SB' => __( 'Solomon Islands', 'wp-hotelier' ),
		'SO' => __( 'Somalia', 'wp-hotelier' ),
		'ZA' => __( 'South Africa', 'wp-hotelier' ),
		'GS' => __( 'South Georgia/Sandwich Islands', 'wp-hotelier' ),
		'KR' => __( 'South Korea', 'wp-hotelier' ),
		'SS' => __( 'South Sudan', 'wp-hotelier' ),
		'ES' => __( 'Spain', 'wp-hotelier' ),
		'LK' => __( 'Sri Lanka', 'wp-hotelier' ),
		'SD' => __( 'Sudan', 'wp-hotelier' ),
		'SR' => __( 'Suriname', 'wp-hotelier' ),
		'SJ' => __( 'Svalbard and Jan Mayen', 'wp-hotelier' ),
		'SZ' => __( 'Swaziland', 'wp-hotelier' ),
		'SE' => __( 'Sweden', 'wp-hotelier' ),
		'CH' => __( 'Switzerland', 'wp-hotelier' ),
		'SY' => __( 'Syria', 'wp-hotelier' ),
		'TW' => __( 'Taiwan', 'wp-hotelier' ),
		'TJ' => __( 'Tajikistan', 'wp-hotelier' ),
		'TZ' => __( 'Tanzania', 'wp-hotelier' ),
		'TH' => __( 'Thailand', 'wp-hotelier' ),
		'TL' => __( 'Timor-Leste', 'wp-hotelier' ),
		'TG' => __( 'Togo', 'wp-hotelier' ),
		'TK' => __( 'Tokelau', 'wp-hotelier' ),
		'TO' => __( 'Tonga', 'wp-hotelier' ),
		'TT' => __( 'Trinidad and Tobago', 'wp-hotelier' ),
		'TN' => __( 'Tunisia', 'wp-hotelier' ),
		'TR' => __( 'Turkey', 'wp-hotelier' ),
		'TM' => __( 'Turkmenistan', 'wp-hotelier' ),
		'TC' => __( 'Turks and Caicos Islands', 'wp-hotelier' ),
		'TV' => __( 'Tuvalu', 'wp-hotelier' ),
		'UG' => __( 'Uganda', 'wp-hotelier' ),
		'UA' => __( 'Ukraine', 'wp-hotelier' ),
		'AE' => __( 'United Arab Emirates', 'wp-hotelier' ),
		'GB' => __( 'United Kingdom (UK)', 'wp-hotelier' ),
		'US' => __( 'United States (US)', 'wp-hotelier' ),
		'UM' => __( 'United States (US) Minor Outlying Islands', 'wp-hotelier' ),
		'UY' => __( 'Uruguay', 'wp-hotelier' ),
		'UZ' => __( 'Uzbekistan', 'wp-hotelier' ),
		'VU' => __( 'Vanuatu', 'wp-hotelier' ),
		'VA' => __( 'Vatican', 'wp-hotelier' ),
		'VE' => __( 'Venezuela', 'wp-hotelier' ),
		'VN' => __( 'Vietnam', 'wp-hotelier' ),
		'VG' => __( 'Virgin Islands (British)', 'wp-hotelier' ),
		'VI' => __( 'Virgin Islands (US)', 'wp-hotelier' ),
		'WF' => __( 'Wallis and Futuna', 'wp-hotelier' ),
		'EH' => __( 'Western Sahara', 'wp-hotelier' ),
		'WS' => __( 'Samoa', 'wp-hotelier' ),
		'YE' => __( 'Yemen', 'wp-hotelier' ),
		'ZM' => __( 'Zambia', 'wp-hotelier' ),
		'ZW' => __( 'Zimbabwe', 'wp-hotelier' ),
	);

	return $countries;
}
