/*! hotel-datepicker 4.7.4 - Copyright 2024 Benito Lopez (http://lopezb.com) - https://github.com/benitolopez/hotel-datepicker - MIT */
var HotelDatepicker=function(t){"use strict";function e(t){var e=Object.create(null);return t&&Object.keys(t).forEach((function(s){if("default"!==s){var i=Object.getOwnPropertyDescriptor(t,s);Object.defineProperty(e,s,i.get?i:{enumerable:!0,get:function(){return t[s]}})}})),e.default=t,Object.freeze(e)}var s=e(t);let i=0;class a{constructor(t,e){this._boundedEventHandlers={},this.id=a.getNewId();const s=e||{};this.format=s.format||"YYYY-MM-DD",this.infoFormat=s.infoFormat||this.format,this.ariaDayFormat=s.ariaDayFormat||"dddd, MMMM DD, YYYY",this.separator=s.separator||" - ",this.startOfWeek=s.startOfWeek||"sunday",this.startDate=s.startDate||new Date,this.endDate=s.endDate||!1,this.minNights=s.minNights||1,this.minNightsMultiple=s.minNightsMultiple||!1,this.maxNights=s.maxNights||0,this.selectForward=s.selectForward||!1,this.disabledDates=s.disabledDates||[],this.noCheckInDates=s.noCheckInDates||[],this.noCheckOutDates=s.noCheckOutDates||[],this.disabledDaysOfWeek=s.disabledDaysOfWeek||[],this.noCheckInDaysOfWeek=s.noCheckInDaysOfWeek||[],this.noCheckOutDaysOfWeek=s.noCheckOutDaysOfWeek||[],this.daysWithExtraText=[],this.enableCheckout=s.enableCheckout||!1,this.preventContainerClose=s.preventContainerClose||!1,this.container=s.container||"",this.animationSpeed=s.animationSpeed||".5s",this.hoveringTooltip=s.hoveringTooltip||!0,this.autoClose=void 0===s.autoClose||s.autoClose,this.showTopbar=void 0===s.showTopbar||s.showTopbar,this.topbarPosition="bottom"===s.topbarPosition?"bottom":"top",this.moveBothMonths=s.moveBothMonths||!1,this.inline=s.inline||!1,this.clearButton=s.clearButton||!1,this.submitButton=Boolean(this.inline&&s.submitButton),this.submitButtonName=this.submitButton&&s.submitButtonName?s.submitButtonName:"",this.i18n=s.i18n||{selected:"Your stay:",night:"Night",nights:"Nights",button:"Close",clearButton:"Clear",submitButton:"Submit","checkin-disabled":"Check-in disabled","checkout-disabled":"Check-out disabled","day-names-short":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"day-names":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],"month-names-short":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"month-names":["January","February","March","April","May","June","July","August","September","October","November","December"],"error-more":"Date range should not be more than 1 night","error-more-plural":"Date range should not be more than %d nights","error-less":"Date range should not be less than 1 night","error-less-plural":"Date range should not be less than %d nights","info-more":"Please select a date range of at least 1 night","info-more-plural":"Please select a date range of at least %d nights","info-range":"Please select a date range between %d and %d nights","info-range-equal":"Please select a date range of %d nights","info-default":"Please select a date range","aria-application":"Calendar","aria-selected-checkin":"Selected as check-in date, %s","aria-selected-checkout":"Selected as check-out date, %s","aria-selected":"Selected, %s","aria-disabled":"Not available, %s","aria-choose-checkin":"Choose %s as your check-in date","aria-choose-checkout":"Choose %s as your check-out date","aria-prev-month":"Move backward to switch to the previous month","aria-next-month":"Move forward to switch to the next month","aria-close-button":"Close the datepicker","aria-clear-button":"Clear the selected dates","aria-submit-button":"Submit the form"},this.getValue=s.getValue||function(){return t.value},this.setValue=s.setValue||function(e){t.value=e},this.onDayClick=void 0!==s.onDayClick&&s.onDayClick,this.onOpenDatepicker=void 0!==s.onOpenDatepicker&&s.onOpenDatepicker,this.onSelectRange=void 0!==s.onSelectRange&&s.onSelectRange,this.extraDayText=void 0!==s.extraDayText&&s.extraDayText,this.input=t,this.init()}addBoundedListener(t,e,s,i){t in this._boundedEventHandlers||(this._boundedEventHandlers[t]={}),e in this._boundedEventHandlers[t]||(this._boundedEventHandlers[t][e]=[]);const a=s.bind(this);this._boundedEventHandlers[t][e].push([a,i]),t.addEventListener(e,a,i)}removeAllBoundedListeners(t,e){if(t in this._boundedEventHandlers){const s=this._boundedEventHandlers[t];if(e in s){const i=s[e];for(let s=i.length;s--;){const a=i[s];t.removeEventListener(e,a[0],a[1])}}}}static getNewId(){return++i}setFechaI18n(){s.setGlobalDateI18n({dayNamesShort:this.i18n["day-names-short"],dayNames:this.i18n["day-names"],monthNamesShort:this.i18n["month-names-short"],monthNames:this.i18n["month-names"]})}getWeekDayNames(){let t="";if("monday"===this.startOfWeek){for(let e=0;e<7;e++)t+='<th class="datepicker__week-name">'+this.lang("day-names-short")[(1+e)%7]+"</th>";return t}for(let e=0;e<7;e++)t+='<th class="datepicker__week-name">'+this.lang("day-names-short")[e]+"</th>";return t}getMonthDom(t){return document.getElementById(this.getMonthTableId(t))}getMonthName(t){return this.lang("month-names")[t]}getDatepickerId(){return"datepicker-"+this.generateId()}getMonthTableId(t){return"month-"+t+"-"+this.generateId()}getCloseButtonId(){return"close-"+this.generateId()}getClearButtonId(){return"clear-"+this.generateId()}getSubmitButtonId(){return"submit-"+this.generateId()}getTooltipId(){return"tooltip-"+this.generateId()}getNextMonth(t){const e=new Date(t.valueOf());return new Date(e.setMonth(e.getMonth()+1,1))}getPrevMonth(t){const e=new Date(t.valueOf());return new Date(e.setMonth(e.getMonth()-1,1))}getDateString(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.format;return this.setFechaI18n(),s.format(t,e)}parseDate(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.format;return this.setFechaI18n(),s.parse(t,e)}init(){this.parent=this.container?this.container:this.input.parentElement,this.start=!1,this.end=!1,this.minDays=this.minNights>1?this.minNights+1:2,this.maxDays=this.maxNights>0?this.maxNights+1:0,this.startDate&&"string"==typeof this.startDate&&(this.startDate=this.parseDate(this.startDate)),this.endDate&&"string"==typeof this.endDate&&(this.endDate=this.parseDate(this.endDate)),this.isTouchDevice()&&(this.hoveringTooltip=!1),this.isOpen=!1,this.changed=!1,this.justEsc=!1,this.isOnFocus=!1,this.createDom();let t=new Date;if(this.startDate&&this.compareMonth(t,this.startDate)<0&&(t=new Date(this.startDate.getTime())),this.endDate&&this.compareMonth(this.getNextMonth(t),this.endDate)>0&&(t=new Date(this.getPrevMonth(this.endDate.getTime()))),this.disabledDates.length>0&&this.parseDisabledDates(),this.disabledDaysOfWeek.length>0&&this.getDisabledDays(),this.showMonth(t,1),this.showMonth(this.getNextMonth(t),2),this.setDayIndexes(),this.topBarDefaultText(),this.inline&&(this.openDatepicker(),this.submitButton)){const t=document.getElementById(this.getSubmitButtonId());t.disabled=!0,t.setAttribute("aria-disabled","true")}if(this.clearButton&&(this.inline||!this.start&&!this.end)){const t=document.getElementById(this.getClearButtonId());t.disabled=!0,t.setAttribute("aria-disabled","true")}this.addListeners(),this.isFirstDisabledDate=0,this.lastDisabledDate=!1,this.setDayAriaAttributes()}addListeners(){const t=this.datepicker.getElementsByClassName("datepicker__month-button--next");for(let e=0;e<t.length;e++)t[e].addEventListener("click",(t=>this.goToNextMonth(t)));const e=this.datepicker.getElementsByClassName("datepicker__month-button--prev");for(let t=0;t<e.length;t++)e[t].addEventListener("click",(t=>this.goToPreviousMonth(t)));this.addBoundedListener(this.input,"click",(t=>this.openDatepicker(t))),this.showTopbar&&!this.inline&&document.getElementById(this.getCloseButtonId()).addEventListener("click",(t=>this.closeDatepicker(t))),this.showTopbar&&this.clearButton&&document.getElementById(this.getClearButtonId()).addEventListener("click",(t=>this.clearDatepicker(t))),window.addEventListener("resize",(t=>this.onResizeDatepicker(t))),this.datepicker.addEventListener("mouseover",(t=>this.datepickerHover(t))),this.datepicker.addEventListener("mouseout",(t=>this.datepickerMouseOut(t))),this.addBoundedListener(this.input,"change",(()=>this.checkAndSetDefaultValue())),this.inline||(this.justEsc||this.addBoundedListener(this.input,"focus",(t=>this.openDatepicker(t))),this.justEsc=!1),window.addEventListener("keydown",(t=>this.doKeyDown(t))),document.addEventListener("focus",(t=>this.checkOnFocus(t)),!0)}generateId(){return this.input.id?this.input.id:this.id}createDom(){const t=this.createDatepickerDomString();this.parent.insertAdjacentHTML("beforeend",t),this.datepicker=document.getElementById(this.getDatepickerId())}createDatepickerDomString(){let t=this.inline?" datepicker--inline":"";this.showTopbar&&("bottom"===this.topbarPosition?t+=" datepicker--topbar-bottom":t+=" datepicker--topbar-top"),this.inline||(t+=" datepicker--topbar-has-close-button"),this.clearButton&&(t+=" datepicker--topbar-has-clear-button"),this.submitButton&&(t+=" datepicker--topbar-has-submit-button");const e=this.inline?"":' style="display:none"';let s='<div id="'+this.getDatepickerId()+'"'+e+' class="datepicker datepicker--closed'+t+'" tabindex="0">';s+='<div class="datepicker__inner">';let i="";if(this.showTopbar){i+='<div class="datepicker__topbar"><div class="datepicker__info datepicker__info--selected"><span class="datepicker__info datepicker__info--selected-label">'+this.lang("selected")+' </span> <strong class="datepicker__info-text datepicker__info-text--start-day">...</strong> <span class="datepicker__info-text datepicker__info--separator">'+this.separator+'</span> <strong class="datepicker__info-text datepicker__info-text--end-day">...</strong> <em class="datepicker__info-text datepicker__info-text--selected-days">(<span></span>)</em></div><div class="datepicker__info datepicker__info--feedback"></div>';let t="";this.clearButton&&(t+='<button type="button" id="'+this.getClearButtonId()+'" class="datepicker__clear-button" aria-label="'+this.i18n["aria-clear-button"]+'">'+this.lang("clearButton")+"</button>"),this.inline||(t+='<button type="button" id="'+this.getCloseButtonId()+'" class="datepicker__close-button" aria-label="'+this.i18n["aria-close-button"]+'">'+this.lang("button")+"</button>"),this.submitButton&&(t+='<input type="submit" id="'+this.getSubmitButtonId()+'" class="datepicker__submit-button" value="'+this.lang("submitButton")+'" name="'+this.submitButtonName+'" aria-label="'+this.i18n["aria-submit-button"]+'">'),t&&(i+='<div class="datepicker__buttons">'+t+"</div>"),i+="</div>"}this.showTopbar&&"top"===this.topbarPosition&&(s+=i),s+='<div class="datepicker__months" role="application" aria-roledescription="datepicker" aria-label="'+this.i18n["aria-application"]+'">';for(let t=1;t<=2;t++)s+='<table role="presentation" id="'+this.getMonthTableId(t)+'" class="datepicker__month datepicker__month--month'+t+'"><thead><tr class="datepicker__month-caption"><th><span  role="button" tabindex="0" aria-label="'+this.i18n["aria-prev-month"]+'" class="datepicker__month-button datepicker__month-button--prev" month="'+t+'">&lt;</span></th><th colspan="5" class="datepicker__month-name"></th><th><span role="button" tabindex="0" aria-label="'+this.i18n["aria-next-month"]+'" class="datepicker__month-button datepicker__month-button--next" month="'+t+'">&gt;</span></th></tr><tr class="datepicker__week-days"  aria-hidden="true" role="presentation">'+this.getWeekDayNames(t)+"</tr></thead><tbody></tbody></table>";return s+="</div>",this.showTopbar&&"bottom"===this.topbarPosition&&(s+=i),s+='<div style="display:none" id="'+this.getTooltipId()+'" class="datepicker__tooltip"></div>',s+="</div>",s+="</div>",s}showMonth(t,e){t.setHours(0,0,0,0);const s=this.getMonthName(t.getMonth()),i=this.getMonthDom(e),a=i.getElementsByClassName("datepicker__month-name")[0],n=i.getElementsByTagName("tbody")[0];a.textContent=s+" "+t.getFullYear(),this.emptyElement(n),n.insertAdjacentHTML("beforeend",this.createMonthDomString(t)),this.updateSelectableRange(),this["month"+e]=t}createMonthDomString(t){const e=[];let s,i="";t.setDate(1);let a=t.getDay();const n=t.getMonth();if(0===a&&"monday"===this.startOfWeek&&(a=7),a>0)for(let i=a;i>0;i--){const a=new Date(t.getTime()-864e5*i);s=this.isValidDate(a.getTime()),(this.startDate&&this.compareDay(a,this.startDate)<0||this.endDate&&this.compareDay(a,this.endDate)>0)&&(s=!1),e.push({date:a,type:"lastMonth",day:a.getDate(),time:a.getTime(),valid:s})}for(let i=0;i<40;i++){const a=this.addDays(t,i);s=this.isValidDate(a.getTime()),(this.startDate&&this.compareDay(a,this.startDate)<0||this.endDate&&this.compareDay(a,this.endDate)>0)&&(s=!1),e.push({date:a,type:a.getMonth()===n?"visibleMonth":"nextMonth",day:a.getDate(),time:a.getTime(),valid:s})}for(let t=0;t<6&&"nextMonth"!==e[7*t].type;t++){i+='<tr class="datepicker__week-row">';for(let s=0;s<7;s++){let a="monday"===this.startOfWeek?s+1:s;a=e[7*t+a];const n=this.getDayClasses(a);let h="";this.hasClass(a,"datepicker__month-day--no-checkin")&&(h=this.i18n["checkin-disabled"]),this.hasClass(a,"datepicker__month-day--no-checkout")&&(h&&(h+=". "),h+=this.i18n["checkout-disabled"]);const r={daytype:a.type,time:a.time,class:n.join(" "),d:s+1};h&&(r.title=h),r.role="button",this.getDateString(a.time)===this.getDateString(new Date)&&(r.tabindex="0");let o="";this.extraDayText&&(o=this.extraDayText(this.getDateString(a.time),r)),o=o||"",o&&(r.class=r.class+" datepicker__month-day--with-extra",this.daysWithExtraText.push(this.getDateString(a.time))),i+='<td class="'+r.class+'" '+this.printAttributes(r)+">"+a.day+o+"</td>"}i+="</tr>"}return i}openDatepicker(){this.isOpen||(this.removeClass(this.datepicker,"datepicker--closed"),this.addClass(this.datepicker,"datepicker--open"),this.checkAndSetDefaultValue(),this.inline||this.slideDown(this.datepicker,this.animationSpeed),this.isOpen=!0,this.showSelectedDays(),this.disableNextPrevButtons(),this.addBoundedListener(document,"click",(t=>this.documentClick(t))),this.onOpenDatepicker&&this.onOpenDatepicker())}closeDatepicker(){if(!this.isOpen||this.inline)return;this.removeClass(this.datepicker,"datepicker--open"),this.addClass(this.datepicker,"datepicker--closed"),this.slideUp(this.datepicker,this.animationSpeed),this.isOpen=!1;const t=document.createEvent("Event");t.initEvent("afterClose",!0,!0),this.input.dispatchEvent(t),this.removeAllBoundedListeners(document,"click")}autoclose(){this.autoClose&&this.changed&&this.isOpen&&this.start&&this.end&&!this.inline&&this.closeDatepicker()}documentClick(t){this.parent.contains(t.target)||t.target===this.input?"td"===t.target.tagName.toLowerCase()&&this.dayClicked(t.target):this.preventContainerClose||this.closeDatepicker()}datepickerHover(t){t.target.tagName&&"td"===t.target.tagName.toLowerCase()&&this.dayHovering(t.target)}datepickerMouseOut(t){if(t.target.tagName&&"td"===t.target.tagName.toLowerCase()){document.getElementById(this.getTooltipId()).style.display="none"}}onResizeDatepicker(){this.checkAndSetDefaultValue(!0)}getDayClasses(t){const e=this.getDateString(t.time)===this.getDateString(new Date),i=this.getDateString(t.time)===this.getDateString(this.startDate),a=this.daysWithExtraText.indexOf(this.getDateString(t.time))>-1;let n=!1,h=!1,r=!1,o=!1,d=!1,l=!1;if(t.valid||"visibleMonth"===t.type){const e=this.getDateString(t.time,"YYYY-MM-DD");if(this.disabledDates.length>0){const s=this.getClosestDisabledDates(t.date);if(!1===s[0]&&(s[0]=this.substractDays(this.startDate,1)),s[0]&&s[1]&&this.compareDay(t.date,s[0])&&this.countDays(s[0],s[1])-2>0){const e=this.countDays(s[1],t.date)-1,i=this.countDays(t.date,s[0])-1;(this.selectForward&&e<this.minDays||!this.selectForward&&e<this.minDays&&i<this.minDays)&&(t.valid=!1),!t.valid&&this.enableCheckout&&2===e&&(l=!0)}this.disabledDates.indexOf(e)>-1?(t.valid=!1,n=!0,this.isFirstDisabledDate++,this.lastDisabledDate=t.date):this.isFirstDisabledDate=0,t.valid&&this.lastDisabledDate&&this.compareDay(t.date,this.lastDisabledDate)>0&&2===this.countDays(t.date,this.lastDisabledDate)&&(d=!0)}this.disabledDaysOfWeek.length>0&&this.disabledDaysOfWeek.indexOf(s.format(t.time,"dddd"))>-1&&(t.valid=!1,o=!0),this.noCheckInDates.length>0&&this.noCheckInDates.indexOf(e)>-1&&(h=!0,d=!1),this.noCheckOutDates.length>0&&this.noCheckOutDates.indexOf(e)>-1&&(r=!0),this.noCheckInDaysOfWeek.length>0&&this.noCheckInDaysOfWeek.indexOf(s.format(t.time,"dddd"))>-1&&(h=!0,d=!1),this.noCheckOutDaysOfWeek.length>0&&this.noCheckOutDaysOfWeek.indexOf(s.format(t.time,"dddd"))>-1&&(r=!0)}return["datepicker__month-day","datepicker__month-day--"+t.type,"datepicker__month-day--"+(t.valid?"valid":"invalid"),e?"datepicker__month-day--today":"",n?"datepicker__month-day--disabled":"",n&&this.enableCheckout&&1===this.isFirstDisabledDate?"datepicker__month-day--checkout-enabled":"",l?"datepicker__month-day--before-disabled-date":"",i||d?"datepicker__month-day--checkin-only":"",h?"datepicker__month-day--no-checkin":"",r?"datepicker__month-day--no-checkout":"",o?"datepicker__month-day--day-of-week-disabled":"",a?"datepicker__month-day--with-extra":""]}checkAndSetDayClasses(){const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++){const s=parseInt(t[e].getAttribute("time"),10),i=new Date(s),a=t[e].getAttribute("daytype");let n;n=this.isValidDate(i.getTime()),(this.startDate&&this.compareDay(i,this.startDate)<0||this.endDate&&this.compareDay(i,this.endDate)>0)&&(n=!1);const h={date:i,type:a,day:i.getDate(),time:s,valid:n},r=this.getDayClasses(h);t[e].className=r.join(" ")}}checkAndSetDefaultValue(){let t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const e=this.getValue(),s=e?e.split(this.separator):"";if(s&&s.length>=2){const e=this.format;this.changed=!1,this.setDateRange(this.parseDate(s[0],e),this.parseDate(s[1],e),t),this.changed=!0}else if(this.showTopbar){if(this.datepicker.getElementsByClassName("datepicker__info--selected")[0].style.display="none",t){let t=new Date;this.startDate&&this.compareMonth(t,this.startDate)<0&&(t=new Date(this.startDate.getTime())),this.endDate&&this.compareMonth(this.getNextMonth(t),this.endDate)>0&&(t=new Date(this.getPrevMonth(this.endDate.getTime()))),this.start&&!this.end&&this.clearSelection(),this.showMonth(t,1),this.showMonth(this.getNextMonth(t),2),this.setDayIndexes()}}}setDateRange(t,e){let s=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(t.getTime()>e.getTime()){let s=e;e=t,t=s,s=null}let i=!0;if((this.startDate&&this.compareDay(t,this.startDate)<0||this.endDate&&this.compareDay(e,this.endDate)>0)&&(i=!1),!i)return this.showMonth(this.startDate,1),this.showMonth(this.getNextMonth(this.startDate),2),this.setDayIndexes(),this.showSelectedDays(),void this.disableNextPrevButtons();t.setTime(t.getTime()+432e5),e.setTime(e.getTime()+432e5),this.start=t.getTime(),this.end=e.getTime(),this.compareDay(t,e)>0&&0===this.compareMonth(t,e)&&(e=this.getNextMonth(t)),0===this.compareMonth(t,e)&&(e=this.getNextMonth(t)),this.showMonth(t,1),this.showMonth(e,2),this.setDayIndexes(),this.showSelectedDays(),this.disableNextPrevButtons(),this.checkSelection(),this.showSelectedInfo(),s||this.autoclose(),this.setDayAriaAttributes()}showSelectedDays(){if(!this.start&&!this.end)return;const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++){const s=parseInt(t[e].getAttribute("time"),10);this.start&&this.end&&this.end>=s&&this.start<=s||this.start&&!this.end&&this.getDateString(this.start,"YYYY-MM-DD")===this.getDateString(s,"YYYY-MM-DD")?this.addClass(t[e],"datepicker__month-day--selected"):this.removeClass(t[e],"datepicker__month-day--selected"),this.start&&this.getDateString(this.start,"YYYY-MM-DD")===this.getDateString(s,"YYYY-MM-DD")?this.addClass(t[e],"datepicker__month-day--first-day-selected"):this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.end&&this.getDateString(this.end,"YYYY-MM-DD")===this.getDateString(s,"YYYY-MM-DD")?this.addClass(t[e],"datepicker__month-day--last-day-selected"):this.removeClass(t[e],"datepicker__month-day--last-day-selected")}}showSelectedInfo(){if(!this.showTopbar){if(this.start&&this.end){const t=this.getDateString(new Date(this.start))+this.separator+this.getDateString(new Date(this.end));this.setValue(t,this.getDateString(new Date(this.start)),this.getDateString(new Date(this.end))),this.changed=!0}return}const t=this.datepicker.getElementsByClassName("datepicker__info--selected")[0],e=t.getElementsByClassName("datepicker__info-text--start-day")[0],s=t.getElementsByClassName("datepicker__info-text--end-day")[0],i=t.getElementsByClassName("datepicker__info-text--selected-days")[0],a=document.getElementById(this.getCloseButtonId()),n=document.getElementById(this.getClearButtonId()),h=document.getElementById(this.getSubmitButtonId());if(e.textContent="...",s.textContent="...",i.style.display="none",this.start&&(t.style.display="",e.textContent=this.getDateString(new Date(parseInt(this.start,10)),this.infoFormat),this.clearButton&&(n.disabled=!1,n.setAttribute("aria-disabled","false"))),this.end&&(s.textContent=this.getDateString(new Date(parseInt(this.end,10)),this.infoFormat)),this.start&&this.end){const t=this.countDays(this.getDateString(new Date(this.end)),this.getDateString(new Date(this.start)))-1,e=1===t?t+" "+this.lang("night"):t+" "+this.lang("nights"),s=this.getDateString(new Date(this.start))+this.separator+this.getDateString(new Date(this.end));i.style.display="",i.firstElementChild.textContent=e,this.inline?this.submitButton&&(h.disabled=!1,h.setAttribute("aria-disabled","false")):(a.disabled=!1,a.setAttribute("aria-disabled","false")),this.setValue(s,this.getDateString(new Date(this.start)),this.getDateString(new Date(this.end))),this.changed=!0}else this.inline||!1!==this.start||!1!==this.end?this.inline?this.submitButton&&(h.disabled=!0,h.setAttribute("aria-disabled","true")):(a.disabled=!0,a.setAttribute("aria-disabled","true")):(a.disabled=!1,a.setAttribute("aria-disabled","false"));!this.clearButton||this.start||this.end||(n.disabled=!0,n.setAttribute("aria-disabled","true"))}dayClicked(t){if(this.hasClass(t,"datepicker__month-day--invalid"))return;const e=this.start&&this.end||!this.start&&!this.end,s=parseInt(t.getAttribute("time"),10);if(e){if(this.hasClass(t,"datepicker__month-day--no-checkin"))return}else if(this.start){if(this.start>s&&this.hasClass(t,"datepicker__month-day--no-checkin"))return;const e=this.datepicker.querySelectorAll('td[time="'+this.start+'"]')[0];if(e&&this.hasClass(e,"datepicker__month-day--no-checkout")&&this.start>s)return;if(this.hasClass(t,"datepicker__month-day--no-checkout")&&s>this.start)return}if(this.addClass(t,"datepicker__month-day--selected"),e?(this.start=s,this.end=!1):this.start&&(this.end=s),this.start&&this.end&&this.start>this.end){const t=this.end;this.end=this.start,this.start=t}this.start=parseInt(this.start,10),this.end=parseInt(this.end,10),this.clearHovering(),this.start&&!this.end&&this.dayHovering(t),this.updateSelectableRange(),this.checkSelection(),this.showSelectedInfo(),this.start&&this.end&&this.checkAndSetDayClasses(),this.showSelectedDays(),this.autoclose(),this.onDayClick&&this.onDayClick(),this.end&&this.onSelectRange&&this.onSelectRange(),this.setDayAriaAttributes()}isValidDate(t){if(t=parseInt(t,10),this.startDate&&this.compareDay(t,this.startDate)<0||this.endDate&&this.compareDay(t,this.endDate)>0)return!1;if(this.start&&!this.end){if(this.maxDays>0&&this.countDays(t,this.start)>this.maxDays||this.minDays>0&&this.countDays(t,this.start)>1&&this.countDays(t,this.start)<this.minDays)return!1;if(this.minNightsMultiple&&(this.countDays(t,this.start)-1)%7!=0)return!1;if(this.selectForward&&t<this.start)return!1;if(this.disabledDates.length>0){const e=this.getClosestDisabledDates(new Date(parseInt(this.start,10)));if(e[0]&&this.compareDay(t,e[0])<=0)return!1;if(e[1]&&this.compareDay(t,e[1])>=0)return!1}if(this.disabledDaysOfWeek.length>0){const e=this.getClosestDisabledDays(new Date(parseInt(this.start,10)));if(e[0]&&this.compareDay(t,e[0])<=0)return!1;if(e[1]&&this.compareDay(t,e[1])>=0)return!1}}return!0}checkSelection(){const t=this.countDays(this.end,this.start),e=!!this.showTopbar&&this.datepicker.getElementsByClassName("datepicker__info--feedback")[0];if(this.maxDays&&t>this.maxDays){this.start=!1,this.end=!1;const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--selected"),this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.removeClass(t[e],"datepicker__month-day--last-day-selected");if(this.showTopbar){const t=this.maxDays-1;this.topBarErrorText(e,"error-more",t)}}else if(this.minDays&&t<this.minDays){this.start=!1,this.end=!1;const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--selected"),this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.removeClass(t[e],"datepicker__month-day--last-day-selected");if(this.showTopbar){const t=this.minDays-1;this.topBarErrorText(e,"error-less",t)}}else this.start||this.end?this.showTopbar&&(this.removeClass(e,"datepicker__info--error"),this.removeClass(e,"datepicker__info--help")):this.showTopbar&&(this.removeClass(e,"datepicker__info--error"),this.addClass(e,"datepicker__info--help"))}addDays(t,e){const s=new Date(t);return s.setDate(s.getDate()+e),s}substractDays(t,e){const s=new Date(t);return s.setDate(s.getDate()-e),s}countDays(t,e){return Math.abs(this.daysFrom1970(t)-this.daysFrom1970(e))+1}compareDay(t,e){const s=parseInt(this.getDateString(t,"YYYYMMDD"),10)-parseInt(this.getDateString(e,"YYYYMMDD"),10);return s>0?1:0===s?0:-1}compareMonth(t,e){const s=parseInt(this.getDateString(t,"YYYYMM"),10)-parseInt(this.getDateString(e,"YYYYMM"),10);return s>0?1:0===s?0:-1}daysFrom1970(t){return Math.round(this.toLocalTimestamp(t)/864e5)}toLocalTimestamp(t){return"object"==typeof t&&t.getTime&&(t=t.getTime()),"string"!=typeof t||t.match(/\d{13}/)||(t=this.parseDate(t).getTime()),t=parseInt(t,10)-60*(new Date).getTimezoneOffset()*1e3}printAttributes(t){const e=t;let s="";for(const i in t)Object.prototype.hasOwnProperty.call(e,i)&&(s+=i+'="'+e[i]+'" ');return s}goToNextMonth(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const s=Number.isInteger(t)?t:t.target.getAttribute("month"),i=s>1;let a=i?this.month2:this.month1;return a=this.getNextMonth(a),!(!this.isSingleMonth()&&!i&&this.compareMonth(a,this.month2)>=0||this.isMonthOutOfRange(a))&&((this.moveBothMonths||e)&&i&&this.showMonth(this.month2,1),this.showMonth(a,s),this.setDayIndexes(),this.showSelectedDays(),this.disableNextPrevButtons(),!0)}goToPreviousMonth(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const s=Number.isInteger(t)?t:t.target.getAttribute("month"),i=s>1;let a=i?this.month2:this.month1;return a=this.getPrevMonth(a),!(i&&this.compareMonth(a,this.month1)<=0||this.isMonthOutOfRange(a))&&(!this.moveBothMonths&&!e||i||this.showMonth(this.month1,2),this.showMonth(a,s),this.setDayIndexes(),this.showSelectedDays(),this.disableNextPrevButtons(),!0)}isSingleMonth(){return!this.isVisible(this.getMonthDom(2))}isMonthOutOfRange(t){const e=new Date(t.valueOf());return!!(this.startDate&&new Date(e.getFullYear(),e.getMonth()+1,0,23,59,59)<this.startDate||this.endDate&&new Date(e.getFullYear(),e.getMonth(),1)>this.endDate)}disableNextPrevButtons(){if(this.isSingleMonth())return;const t=parseInt(this.getDateString(this.month1,"YYYYMM"),10),e=parseInt(this.getDateString(this.month2,"YYYYMM"),10),s=Math.abs(t-e),i=this.datepicker.getElementsByClassName("datepicker__month-button--next"),a=this.datepicker.getElementsByClassName("datepicker__month-button--prev");s>1&&89!==s?(this.removeClass(i[0],"datepicker__month-button--disabled"),i[0].setAttribute("aria-disabled","false"),this.removeClass(a[1],"datepicker__month-button--disabled"),a[1].setAttribute("aria-disabled","false")):(this.addClass(i[0],"datepicker__month-button--disabled"),i[0].setAttribute("aria-disabled","true"),this.addClass(a[1],"datepicker__month-button--disabled"),a[1].setAttribute("aria-disabled","true")),this.isMonthOutOfRange(this.getPrevMonth(this.month1))?(this.addClass(a[0],"datepicker__month-button--disabled"),a[0].setAttribute("aria-disabled","true")):(this.removeClass(a[0],"datepicker__month-button--disabled"),a[0].setAttribute("aria-disabled","false")),this.isMonthOutOfRange(this.getNextMonth(this.month2))?(this.addClass(i[1],"datepicker__month-button--disabled"),i[1].setAttribute("aria-disabled","true")):(this.removeClass(i[1],"datepicker__month-button--disabled"),i[1].setAttribute("aria-disabled","false"))}topBarDefaultText(){if(!this.showTopbar)return;let t="";t=this.minDays&&this.maxDays?this.minDays===this.maxDays?this.lang("info-range-equal"):this.lang("info-range"):this.minDays&&this.minDays>2?this.lang("info-more-plural"):this.minDays?this.lang("info-more"):this.lang("info-default");const e=this.datepicker.getElementsByClassName("datepicker__info--feedback")[0];t=t.replace(/%d/,this.minDays-1).replace(/%d/,this.maxDays-1),this.addClass(e,"datepicker__info--help"),this.removeClass(e,"datepicker__info--error"),e.textContent=t}topBarErrorText(t,e,s){if(!this.showTopbar)return;this.addClass(t,"datepicker__info--error"),this.removeClass(t,"datepicker__info--help"),s>1?(e=(e=this.lang(e+"-plural")).replace("%d",s),t.textContent=e):e=this.lang(e);this.datepicker.getElementsByClassName("datepicker__info--selected")[0].style.display="none"}updateSelectableRange(){const t=this.datepicker.getElementsByTagName("td"),e=this.start&&!this.end;for(let s=0;s<t.length;s++)if(this.hasClass(t[s],"datepicker__month-day--invalid")&&this.hasClass(t[s],"datepicker__month-day--tmp")&&(this.removeClass(t[s],"datepicker__month-day--tmp"),this.hasClass(t[s],"datepicker__month-day--tmpinvalid")?this.removeClass(t[s],"datepicker__month-day--tmpinvalid"):(this.removeClass(t[s],"datepicker__month-day--invalid"),this.addClass(t[s],"datepicker__month-day--valid"))),e){if(this.hasClass(t[s],"datepicker__month-day--visibleMonth")&&(this.hasClass(t[s],"datepicker__month-day--valid")||this.hasClass(t[s],"datepicker__month-day--disabled")||this.hasClass(t[s],"datepicker__month-day--before-disabled-date"))){const e=parseInt(t[s].getAttribute("time"),10);this.isValidDate(e)?(this.addClass(t[s],"datepicker__month-day--valid"),this.addClass(t[s],"datepicker__month-day--tmp"),this.removeClass(t[s],"datepicker__month-day--invalid"),this.removeClass(t[s],"datepicker__month-day--disabled")):(this.hasClass(t[s],"datepicker__month-day--invalid")&&this.addClass(t[s],"datepicker__month-day--tmpinvalid"),this.addClass(t[s],"datepicker__month-day--invalid"),this.addClass(t[s],"datepicker__month-day--tmp"),this.removeClass(t[s],"datepicker__month-day--valid"))}this.setDayAriaAttributes()}else(this.hasClass(t[s],"datepicker__month-day--checkout-enabled")||this.hasClass(t[s],"datepicker__month-day--before-disabled-date"))&&(this.addClass(t[s],"datepicker__month-day--invalid"),this.removeClass(t[s],"datepicker__month-day--valid"),this.hasClass(t[s],"datepicker__month-day--before-disabled-date")||this.addClass(t[s],"datepicker__month-day--disabled"));return!0}dayHovering(t){const e=parseInt(t.getAttribute("time"),10);let s="";if(!this.hasClass(t,"datepicker__month-day--invalid")){const t=this.datepicker.getElementsByTagName("td");for(let s=0;s<t.length;s++){const i=parseInt(t[s].getAttribute("time"),10);i===e?this.addClass(t[s],"datepicker__month-day--hovering"):this.removeClass(t[s],"datepicker__month-day--hovering"),this.start&&!this.end&&(this.start<i&&e>=i||this.start>i&&e<=i)?this.addClass(t[s],"datepicker__month-day--hovering"):this.removeClass(t[s],"datepicker__month-day--hovering")}if(this.start&&!this.end){const t=this.countDays(e,this.start)-1;if(this.hoveringTooltip)if("function"==typeof this.hoveringTooltip)s=this.hoveringTooltip(t,this.start,e);else if(!0===this.hoveringTooltip&&t>0){s=t+" "+(1===t?this.lang("night"):this.lang("nights"))}}}if(s){const e=t.getBoundingClientRect(),i=this.datepicker.getBoundingClientRect();let a=e.left-i.left,n=e.top-i.top;a+=e.width/2;const h=document.getElementById(this.getTooltipId());h.style.display="",h.textContent=s;const r=h.getBoundingClientRect().width,o=h.getBoundingClientRect().height;a-=r/2,n-=o,setTimeout((()=>{h.style.left=a+"px",h.style.top=n+"px"}),10)}else{document.getElementById(this.getTooltipId()).style.display="none"}}clearHovering(){const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--hovering");document.getElementById(this.getTooltipId()).style.display="none"}clearSelection(){this.start=!1,this.end=!1;const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--selected"),this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.removeClass(t[e],"datepicker__month-day--last-day-selected"),this.removeClass(t[e],"datepicker__month-day--hovering");this.setValue(""),this.checkSelection(),this.showSelectedInfo(),this.showSelectedDays()}clearDatepicker(){this.start=!1,this.end=!1;const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++)this.removeClass(t[e],"datepicker__month-day--selected"),this.removeClass(t[e],"datepicker__month-day--first-day-selected"),this.removeClass(t[e],"datepicker__month-day--last-day-selected"),this.removeClass(t[e],"datepicker__month-day--hovering");this.setValue(""),this.checkSelection(),this.showSelectedInfo();this.datepicker.getElementsByClassName("datepicker__info--selected")[0].style.display="none",this.showSelectedDays(),this.updateSelectableRange()}parseDisabledDates(){const t=[];this.setFechaI18n();for(let e=0;e<this.disabledDates.length;e++)t[e]=s.parse(this.disabledDates[e],"YYYY-MM-DD");t.sort(((t,e)=>t-e)),this.disabledDatesTime=t}getClosestDisabledDates(t){let e=[!1,!1];if(t<this.disabledDatesTime[0])e=this.enableCheckout?[!1,this.addDays(this.disabledDatesTime[0],1)]:[!1,this.disabledDatesTime[0]];else if(t>this.disabledDatesTime[this.disabledDatesTime.length-1])e=[this.disabledDatesTime[this.disabledDatesTime.length-1],!1];else{let s=this.disabledDatesTime.length,i=this.disabledDatesTime.length;const a=Math.abs(new Date(0,0,0).valueOf());let n,h=a,r=-a,o=0;for(n=0;n<this.disabledDatesTime.length;++n)o=t-this.disabledDatesTime[n],o<0&&o>r&&(i=n,r=o),o>0&&o<h&&(s=n,h=o);this.disabledDatesTime[s]&&(e[0]=this.disabledDatesTime[s]),void 0===this.disabledDatesTime[s]?e[1]=!1:this.enableCheckout?e[1]=this.addDays(this.disabledDatesTime[i],1):e[1]=this.disabledDatesTime[i]}return e}getDisabledDays(){const t=[],e=[],i=new Date;for(let e=0;e<7;e++){const a=this.addDays(i,e);t[s.format(a,"d")]=s.format(a,"dddd")}for(let s=0;s<this.disabledDaysOfWeek.length;s++)e.push(t.indexOf(this.disabledDaysOfWeek[s]));e.sort(),this.disabledDaysIndexes=e}getClosestDisabledDays(t){const e=[!1,!1];for(let i=0;i<7;i++){const a=this.substractDays(t,i);if(this.disabledDaysIndexes.indexOf(parseInt(s.format(a,"d"),10))>-1){e[0]=a;break}}for(let i=0;i<7;i++){const a=this.addDays(t,i);if(this.disabledDaysIndexes.indexOf(parseInt(s.format(a,"d"),10))>-1){e[1]=a;break}}return e}lang(t){return t in this.i18n?this.i18n[t]:""}emptyElement(t){for(;t.firstChild;)t.removeChild(t.firstChild)}classRegex(t){return new RegExp("(^|\\s+)"+t+"(\\s+|$)")}hasClass(t,e){return this.classRegex(e).test(t.className)}addClass(t,e){this.hasClass(t,e)||(t.className=t.className+" "+e)}removeClass(t,e){t.className=t.className.replace(this.classRegex(e)," ")}isVisible(t){return t.offsetWidth||t.offsetHeight||t.getClientRects().length}slideDown(t,e){t.style.display="";const s=t.getBoundingClientRect().height;t.style.height=0,this.recalc(t.offsetHeight),t.style.transition="height "+e,t.style.height=s+"px",t.addEventListener("transitionend",(()=>{t.style.height=t.style.transition=t.style.display=""}))}slideUp(t,e){const s=t.getBoundingClientRect().height;t.style.height=s+"px",this.recalc(t.offsetHeight),t.style.transition="height "+e,t.style.height=0,t.addEventListener("transitionend",(()=>{t.style.display="none"}))}recalc(t){return t.offsetHeight}isTouchDevice(){return"ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch}setDayAriaAttributes(){const t=this.datepicker.getElementsByTagName("td");for(let e=0;e<t.length;e++){const i=t[e].className,a=parseInt(t[e].getAttribute("time"),10);let n="false",h="";i.includes("datepicker__month-day--invalid")?(h=this.replacei18n(this.i18n["aria-disabled"],s.format(a,this.ariaDayFormat)),n="true"):h=i.includes("datepicker__month-day--first-day-selected")?this.replacei18n(this.i18n["aria-selected-checkin"],s.format(a,this.ariaDayFormat)):i.includes("datepicker__month-day--last-day-selected")?this.replacei18n(this.i18n["aria-selected-checkout"],s.format(a,this.ariaDayFormat)):i.includes("datepicker__month-day--selected")?this.replacei18n(this.i18n["aria-selected"],s.format(a,this.ariaDayFormat)):this.start&&!this.end?this.replacei18n(this.i18n["aria-choose-checkout"],s.format(a,this.ariaDayFormat)):this.replacei18n(this.i18n["aria-choose-checkin"],s.format(a,this.ariaDayFormat)),h&&t[e].setAttribute("aria-label",h),t[e].setAttribute("aria-disabled",n)}}replacei18n(t,e){return t.replace("%s",e)}checkOnFocus(t){t.target&&this.input===t.target||this.datepicker.contains(t.target)?this.isOnFocus=!0:(this.isOnFocus=!1,this.isOpen&&this.closeDatepicker())}doKeyDown(t){switch(t.keyCode){case 39:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("next"));break;case 37:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("prev"));break;case 40:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("down"));break;case 38:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("up"));break;case 36:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("first"));break;case 35:this.isOnFocus&&(t.preventDefault(),this.setActiveDay("last"));break;case 27:this.isOnFocus&&null!==this.input.offsetParent&&this.setFocusToInput();break;case 34:this.isOnFocus&&(t.preventDefault(),this.moveMonthFromKeyboard("next"));break;case 33:this.isOnFocus&&(t.preventDefault(),this.moveMonthFromKeyboard("prev"));break;case 13:this.isOnFocus&&(t.preventDefault(),this.handleReturn())}}setActiveDay(t){const e=document.activeElement;if(e&&this.hasClass(e,"datepicker__month-day--visibleMonth")&&this.datepicker.contains(e)){const s=parseInt(e.getAttribute("index"),10),i=parseInt(e.getAttribute("d"),10);let a=-1;switch(t){case"next":a=s+1;break;case"prev":a=s-1;break;case"up":a=s-7;break;case"down":a=s+7;break;case"first":if(1===i)return!1;a=s-(i-1);break;case"last":if(7===i)return!1;a=s+(7-i)}const n=this.datepicker.querySelectorAll('[index="'+a+'"]');if(n.length>0&&a>0)this.setDayFocus(n[0]);else if(a>0){let e="";if(this.goToNextMonth(2,!0)){const s=this.datepicker.getElementsByClassName("datepicker__month--month2");if(s.length>0){if("down"===t)e=s[0].querySelectorAll('.datepicker__month-day--visibleMonth[d="'+i+'"]');else if("last"===t){const t=i+(7-i);e=s[0].querySelectorAll('.datepicker__month-day--visibleMonth[d="'+t+'"]')}else e=s[0].querySelectorAll(".datepicker__month-day--visibleMonth");e.length>0&&this.setDayFocus(e[0])}}}else if(a<=0){let e="";if(this.goToPreviousMonth(1,!0)){const s=this.datepicker.getElementsByClassName("datepicker__month--month1");if(s.length>0){if("up"===t)e=s[0].querySelectorAll('.datepicker__month-day--visibleMonth[d="'+i+'"]');else if("first"===t){const t=i-(i-1);e=s[0].querySelectorAll('.datepicker__month-day--visibleMonth[d="'+t+'"]')}else e=s[0].querySelectorAll(".datepicker__month-day--visibleMonth");e.length>0&&this.setDayFocus(e[e.length-1])}}}}else this.setInitialActiveDay()}setInitialActiveDay(){const t=this.datepicker.getElementsByClassName("datepicker__month-day--today");if(t.length>0)return this.setDayFocus(t[0]),t[0];const e=this.datepicker.getElementsByClassName("datepicker__month-day--first-day-selected");if(e.length>0)return this.setDayFocus(e[0]),e[0];const s=this.datepicker.getElementsByClassName("datepicker__month-day--visibleMonth");return s.length>0?(this.setDayFocus(s[0]),s[0]):void 0}setDayFocus(t){const e=this.datepicker.getElementsByTagName("td");this.removeDaysTabIndex(e),t.setAttribute("tabindex","0"),t.focus(),this.start&&!this.end&&this.dayHovering(t)}removeDaysTabIndex(t){for(let e=0;e<t.length;e++)t[e].removeAttribute("tabindex")}setDayIndexes(){const t=this.datepicker.getElementsByTagName("td");this.dayIndex=1;for(let e=0;e<t.length;e++)this.hasClass(t[e],"datepicker__month-day--visibleMonth")?(t[e].setAttribute("index",this.dayIndex),this.dayIndex++):t[e].setAttribute("index",0)}setFocusToInput(){this.input.focus(),this.closeDatepicker(),this.clearHovering(),this.justEsc=!0,this.isOnFocus=!1}moveMonthFromKeyboard(t){"prev"===t?this.goToPreviousMonth(1,!0):this.goToNextMonth(2,!0)}handleReturn(){const t=document.activeElement;t&&this.datepicker.contains(t)&&(this.hasClass(t,"datepicker__month-day--visibleMonth")||this.hasClass(t,"datepicker__month-button")||this.hasClass(t,"datepicker__close-button")||this.hasClass(t,"datepicker__clear-button")||this.hasClass(t,"datepicker__submit-button"))&&t.click()}open(){this.openDatepicker()}close(){this.closeDatepicker()}getDatePicker(){return this.datepicker}setRange(t,e){"string"==typeof t&&"string"==typeof e?(t=this.parseDate(t),e=this.parseDate(e)):(t=new Date(t.getTime()),e=new Date(e.getTime())),this.setDateRange(t,e)}clear(){this.clearSelection()}getNights(){let t=0;if(this.start&&this.end)t=this.countDays(this.end,this.start)-1;else{const e=this.getValue(),s=e?e.split(this.separator):"";if(s&&s.length>=2){const e=this.format;t=this.countDays(this.parseDate(s[0],e),this.parseDate(s[1],e))-1}}return t}destroy(){document.getElementById(this.getDatepickerId())&&(this.removeAllBoundedListeners(this.input,"click"),this.removeAllBoundedListeners(document,"click"),this.removeAllBoundedListeners(this.input,"change"),this.datepicker.parentNode.removeChild(this.datepicker))}}return a}(fecha);
