<?php
/*
Plugin Name: WP Faster
Plugin URI: https://wpmore.cn/
Description: WordPress性能优化插件，主要提升运行效率。
Version: 1.2
Author: 更好的WordPress主题
Author URI: https://wpmore.cn/
Text Domain: WPFaster
Domain Path: /lang
*/

if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if( ! class_exists('WPFaster') ) :

/**
 * Generated by the WordPress Option Page generator
 * at http://jeremyhixon.com/wp-tools/option-page/
 */

class WPFaster {
	private $wp_faster_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'wp_faster_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'wp_faster_page_init' ) );
	}

	public function wp_faster_add_plugin_page() {
		add_options_page(
			'WP Faster', // page_title
			'WP Faster', // menu_title
			'manage_options', // capability
			'wp-faster', // menu_slug
			array( $this, 'wp_faster_create_admin_page' ) // function
		);
	}

	public function wp_faster_create_admin_page() {
		$this->wp_faster_options = get_option( 'wp_faster_option_name' ); ?>

		<div class="wrap">
			<h2>WP Faster</h2>
			<p>WordPress性能优化插件，联系QQ：309946202。</p>
			<?php settings_errors(); ?>

			<form method="post" action="options.php">
				<?php
					settings_fields( 'wp_faster_option_group' );
					do_settings_sections( 'wp-faster-admin' );
					submit_button();
				?>
			</form>
		</div>
	<?php }

	public function wp_faster_page_init() {
		register_setting(
			'wp_faster_option_group', // option_group
			'wp_faster_option_name', // option_name
			array( $this, 'wp_faster_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'wp_faster_setting_section', // id
			'Settings', // title
			array( $this, 'wp_faster_section_info' ), // callback
			'wp-faster-admin' // page
		);

		add_settings_field(
			'_0', // id
			'移除版本号', // title
			array( $this, '_0_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'rsd_1', // id
			'移除RSD', // title
			array( $this, 'rsd_1_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'wlwmanifest_2', // id
			'移除wlwmanifest', // title
			array( $this, 'wlwmanifest_2_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_3', // id
			'移除短链接', // title
			array( $this, '_3_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'wordpress_4', // id
			'移除自动修正WordPress大小写', // title
			array( $this, 'wordpress_4_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_5', // id
			'移除管理菜单', // title
			array( $this, '_5_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_6', // id
			'移除隐私相关页面', // title
			array( $this, '_6_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_7', // id
			'移除管理界面配色方案', // title
			array( $this, '_7_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_8', // id
			'移除后台页脚信息', // title
			array( $this, '_8_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'logo_10', // id
			'移除后台左上角logo', // title
			array( $this, 'logo_10_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_31', // id
			'移除后台帮助', // title
			array( $this, '_31_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'oembed_11', // id
			'禁用oEmbed', // title
			array( $this, 'oembed_11_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'embed_12', // id
			'禁用Embed', // title
			array( $this, 'embed_12_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_13', // id
			'禁用日志修订', // title
			array( $this, '_13_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'xml_rpc_14', // id
			'禁用XML-RPC', // title
			array( $this, 'xml_rpc_14_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'wp_cron_15', // id
			'禁用WP Cron', // title
			array( $this, 'wp_cron_15_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'rest_api_16', // id
			'禁用REST API', // title
			array( $this, 'rest_api_16_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_17', // id
			'禁用转译字符', // title
			array( $this, '_17_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'emoji_18', // id
			'禁用Emoji', // title
			array( $this, 'emoji_18_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_20', // id
			'禁用图片响应式资源请求', // title
			array( $this, '_20_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_21', // id
			'禁用全高度编辑器和免打扰功能', // title
			array( $this, '_21_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_22', // id
			'禁用古滕堡编辑器', // title
			array( $this, '_22_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'gravatarhttps_23', // id
			'Gravatar启用HTTPS', // title
			array( $this, 'gravatarhttps_23_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_24', // id
			'启用友情链接', // title
			array( $this, '_24_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_25', // id
			'防止标题转译', // title
			array( $this, '_25_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_26', // id
			'防止附件乱码', // title
			array( $this, '_26_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'utf8mb4_27', // id
			'去除utf8mb4不支持的非法字符', // title
			array( $this, 'utf8mb4_27_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'nofollow_28', // id
			'评论链接nofollow', // title
			array( $this, 'nofollow_28_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'nofollow_29', // id
			'阅读全文nofollow', // title
			array( $this, 'nofollow_29_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'nofollow_30', // id
			'文章外链nofollow', // title
			array( $this, 'nofollow_30_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_32', // id
			'屏蔽站点管理员邮箱验证', // title
			array( $this, '_32_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_33', // id
			'插入图片使用完整尺寸', // title
			array( $this, '_33_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);
		
		add_settings_field(
			'_34', // id
			'删除图像大小属性', // title
			array( $this, '_34_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_35', // id
			'后台可按照作者筛选文章', // title
			array( $this, '_35_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);

		add_settings_field(
			'_36', // id
			'登录页面返回站点信息', // title
			array( $this, '_36_callback' ), // callback
			'wp-faster-admin', // page
			'wp_faster_setting_section' // section
		);
	}

	public function wp_faster_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['_0'] ) ) {
			$sanitary_values['_0'] = $input['_0'];
		}

		if ( isset( $input['rsd_1'] ) ) {
			$sanitary_values['rsd_1'] = $input['rsd_1'];
		}

		if ( isset( $input['wlwmanifest_2'] ) ) {
			$sanitary_values['wlwmanifest_2'] = $input['wlwmanifest_2'];
		}

		if ( isset( $input['_3'] ) ) {
			$sanitary_values['_3'] = $input['_3'];
		}

		if ( isset( $input['wordpress_4'] ) ) {
			$sanitary_values['wordpress_4'] = $input['wordpress_4'];
		}

		if ( isset( $input['_5'] ) ) {
			$sanitary_values['_5'] = $input['_5'];
		}

		if ( isset( $input['_6'] ) ) {
			$sanitary_values['_6'] = $input['_6'];
		}

		if ( isset( $input['_7'] ) ) {
			$sanitary_values['_7'] = $input['_7'];
		}

		if ( isset( $input['_8'] ) ) {
			$sanitary_values['_8'] = $input['_8'];
		}

		if ( isset( $input['logo_10'] ) ) {
			$sanitary_values['logo_10'] = $input['logo_10'];
		}

		if ( isset( $input['oembed_11'] ) ) {
			$sanitary_values['oembed_11'] = $input['oembed_11'];
		}

		if ( isset( $input['embed_12'] ) ) {
			$sanitary_values['embed_12'] = $input['embed_12'];
		}

		if ( isset( $input['_13'] ) ) {
			$sanitary_values['_13'] = $input['_13'];
		}

		if ( isset( $input['xml_rpc_14'] ) ) {
			$sanitary_values['xml_rpc_14'] = $input['xml_rpc_14'];
		}

		if ( isset( $input['wp_cron_15'] ) ) {
			$sanitary_values['wp_cron_15'] = $input['wp_cron_15'];
		}

		if ( isset( $input['rest_api_16'] ) ) {
			$sanitary_values['rest_api_16'] = $input['rest_api_16'];
		}

		if ( isset( $input['_17'] ) ) {
			$sanitary_values['_17'] = $input['_17'];
		}

		if ( isset( $input['emoji_18'] ) ) {
			$sanitary_values['emoji_18'] = $input['emoji_18'];
		}

		if ( isset( $input['_20'] ) ) {
			$sanitary_values['_20'] = $input['_20'];
		}

		if ( isset( $input['_21'] ) ) {
			$sanitary_values['_21'] = $input['_21'];
		}

		if ( isset( $input['_22'] ) ) {
			$sanitary_values['_22'] = $input['_22'];
		}

		if ( isset( $input['gravatarhttps_23'] ) ) {
			$sanitary_values['gravatarhttps_23'] = $input['gravatarhttps_23'];
		}

		if ( isset( $input['_24'] ) ) {
			$sanitary_values['_24'] = $input['_24'];
		}

		if ( isset( $input['_25'] ) ) {
			$sanitary_values['_25'] = $input['_25'];
		}

		if ( isset( $input['_26'] ) ) {
			$sanitary_values['_26'] = $input['_26'];
		}

		if ( isset( $input['utf8mb4_27'] ) ) {
			$sanitary_values['utf8mb4_27'] = $input['utf8mb4_27'];
		}

		if ( isset( $input['nofollow_28'] ) ) {
			$sanitary_values['nofollow_28'] = $input['nofollow_28'];
		}

		if ( isset( $input['nofollow_29'] ) ) {
			$sanitary_values['nofollow_29'] = $input['nofollow_29'];
		}

		if ( isset( $input['nofollow_30'] ) ) {
			$sanitary_values['nofollow_30'] = $input['nofollow_30'];
		}

		if ( isset( $input['_31'] ) ) {
			$sanitary_values['_31'] = $input['_31'];
		}

		if ( isset( $input['_32'] ) ) {
			$sanitary_values['_32'] = $input['_32'];
		}

		if ( isset( $input['_33'] ) ) {
			$sanitary_values['_33'] = $input['_33'];
		}

		if ( isset( $input['_34'] ) ) {
			$sanitary_values['_34'] = $input['_34'];
		}

		if ( isset( $input['_35'] ) ) {
			$sanitary_values['_35'] = $input['_35'];
		}

		if ( isset( $input['_36'] ) ) {
			$sanitary_values['_36'] = $input['_36'];
		}

		return $sanitary_values;
	}

	public function wp_faster_section_info() {
		
	}

	public function _0_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_0]" id="_0" value="_0" %s>',
			( isset( $this->wp_faster_options['_0'] ) && $this->wp_faster_options['_0'] === '_0' ) ? 'checked' : ''
		);
	}

	public function rsd_1_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[rsd_1]" id="rsd_1" value="rsd_1" %s>',
			( isset( $this->wp_faster_options['rsd_1'] ) && $this->wp_faster_options['rsd_1'] === 'rsd_1' ) ? 'checked' : ''
		);
	}

	public function wlwmanifest_2_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[wlwmanifest_2]" id="wlwmanifest_2" value="wlwmanifest_2" %s>',
			( isset( $this->wp_faster_options['wlwmanifest_2'] ) && $this->wp_faster_options['wlwmanifest_2'] === 'wlwmanifest_2' ) ? 'checked' : ''
		);
	}

	public function _3_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_3]" id="_3" value="_3" %s>',
			( isset( $this->wp_faster_options['_3'] ) && $this->wp_faster_options['_3'] === '_3' ) ? 'checked' : ''
		);
	}

	public function wordpress_4_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[wordpress_4]" id="wordpress_4" value="wordpress_4" %s>',
			( isset( $this->wp_faster_options['wordpress_4'] ) && $this->wp_faster_options['wordpress_4'] === 'wordpress_4' ) ? 'checked' : ''
		);
	}

	public function _5_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_5]" id="_5" value="_5" %s>',
			( isset( $this->wp_faster_options['_5'] ) && $this->wp_faster_options['_5'] === '_5' ) ? 'checked' : ''
		);
	}

	public function _6_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_6]" id="_6" value="_6" %s>',
			( isset( $this->wp_faster_options['_6'] ) && $this->wp_faster_options['_6'] === '_6' ) ? 'checked' : ''
		);
	}

	public function _7_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_7]" id="_7" value="_7" %s>',
			( isset( $this->wp_faster_options['_7'] ) && $this->wp_faster_options['_7'] === '_7' ) ? 'checked' : ''
		);
	}

	public function _8_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_8]" id="_8" value="_8" %s>',
			( isset( $this->wp_faster_options['_8'] ) && $this->wp_faster_options['_8'] === '_8' ) ? 'checked' : ''
		);
	}

	public function logo_10_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[logo_10]" id="logo_10" value="logo_10" %s>',
			( isset( $this->wp_faster_options['logo_10'] ) && $this->wp_faster_options['logo_10'] === 'logo_10' ) ? 'checked' : ''
		);
	}

	public function oembed_11_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[oembed_11]" id="oembed_11" value="oembed_11" %s>',
			( isset( $this->wp_faster_options['oembed_11'] ) && $this->wp_faster_options['oembed_11'] === 'oembed_11' ) ? 'checked' : ''
		);
	}

	public function embed_12_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[embed_12]" id="embed_12" value="embed_12" %s>',
			( isset( $this->wp_faster_options['embed_12'] ) && $this->wp_faster_options['embed_12'] === 'embed_12' ) ? 'checked' : ''
		);
	}

	public function _13_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_13]" id="_13" value="_13" %s>',
			( isset( $this->wp_faster_options['_13'] ) && $this->wp_faster_options['_13'] === '_13' ) ? 'checked' : ''
		);
	}

	public function xml_rpc_14_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[xml_rpc_14]" id="xml_rpc_14" value="xml_rpc_14" %s>',
			( isset( $this->wp_faster_options['xml_rpc_14'] ) && $this->wp_faster_options['xml_rpc_14'] === 'xml_rpc_14' ) ? 'checked' : ''
		);
	}

	public function wp_cron_15_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[wp_cron_15]" id="wp_cron_15" value="wp_cron_15" %s>',
			( isset( $this->wp_faster_options['wp_cron_15'] ) && $this->wp_faster_options['wp_cron_15'] === 'wp_cron_15' ) ? 'checked' : ''
		);
	}

	public function rest_api_16_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[rest_api_16]" id="rest_api_16" value="rest_api_16" %s>',
			( isset( $this->wp_faster_options['rest_api_16'] ) && $this->wp_faster_options['rest_api_16'] === 'rest_api_16' ) ? 'checked' : ''
		);
	}

	public function _17_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_17]" id="_17" value="_17" %s>',
			( isset( $this->wp_faster_options['_17'] ) && $this->wp_faster_options['_17'] === '_17' ) ? 'checked' : ''
		);
	}

	public function emoji_18_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[emoji_18]" id="emoji_18" value="emoji_18" %s>',
			( isset( $this->wp_faster_options['emoji_18'] ) && $this->wp_faster_options['emoji_18'] === 'emoji_18' ) ? 'checked' : ''
		);
	}

	public function _20_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_20]" id="_20" value="_20" %s>',
			( isset( $this->wp_faster_options['_20'] ) && $this->wp_faster_options['_20'] === '_20' ) ? 'checked' : ''
		);
	}

	public function _21_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_21]" id="_21" value="_21" %s>',
			( isset( $this->wp_faster_options['_21'] ) && $this->wp_faster_options['_21'] === '_21' ) ? 'checked' : ''
		);
	}

	public function _22_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_22]" id="_22" value="_22" %s>',
			( isset( $this->wp_faster_options['_22'] ) && $this->wp_faster_options['_22'] === '_22' ) ? 'checked' : ''
		);
	}

	public function gravatarhttps_23_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[gravatarhttps_23]" id="gravatarhttps_23" value="gravatarhttps_23" %s>',
			( isset( $this->wp_faster_options['gravatarhttps_23'] ) && $this->wp_faster_options['gravatarhttps_23'] === 'gravatarhttps_23' ) ? 'checked' : ''
		);
	}

	public function _24_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_24]" id="_24" value="_24" %s>',
			( isset( $this->wp_faster_options['_24'] ) && $this->wp_faster_options['_24'] === '_24' ) ? 'checked' : ''
		);
	}

	public function _25_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_25]" id="_25" value="_25" %s>',
			( isset( $this->wp_faster_options['_25'] ) && $this->wp_faster_options['_25'] === '_25' ) ? 'checked' : ''
		);
	}

	public function _26_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_26]" id="_26" value="_26" %s>',
			( isset( $this->wp_faster_options['_26'] ) && $this->wp_faster_options['_26'] === '_26' ) ? 'checked' : ''
		);
	}

	public function utf8mb4_27_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[utf8mb4_27]" id="utf8mb4_27" value="utf8mb4_27" %s>',
			( isset( $this->wp_faster_options['utf8mb4_27'] ) && $this->wp_faster_options['utf8mb4_27'] === 'utf8mb4_27' ) ? 'checked' : ''
		);
	}

	public function nofollow_28_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[nofollow_28]" id="nofollow_28" value="nofollow_28" %s>',
			( isset( $this->wp_faster_options['nofollow_28'] ) && $this->wp_faster_options['nofollow_28'] === 'nofollow_28' ) ? 'checked' : ''
		);
	}

	public function nofollow_29_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[nofollow_29]" id="nofollow_29" value="nofollow_29" %s>',
			( isset( $this->wp_faster_options['nofollow_29'] ) && $this->wp_faster_options['nofollow_29'] === 'nofollow_29' ) ? 'checked' : ''
		);
	}

	public function nofollow_30_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[nofollow_30]" id="nofollow_30" value="nofollow_30" %s>',
			( isset( $this->wp_faster_options['nofollow_30'] ) && $this->wp_faster_options['nofollow_30'] === 'nofollow_30' ) ? 'checked' : ''
		);
	}

	public function _31_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_31]" id="_31" value="_31" %s>',
			( isset( $this->wp_faster_options['_31'] ) && $this->wp_faster_options['_31'] === '_31' ) ? 'checked' : ''
		);
	}

	public function _32_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_32]" id="_32" value="_32" %s>',
			( isset( $this->wp_faster_options['_32'] ) && $this->wp_faster_options['_32'] === '_32' ) ? 'checked' : ''
		);
	}

	public function _33_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_33]" id="_33" value="_33" %s>',
			( isset( $this->wp_faster_options['_33'] ) && $this->wp_faster_options['_33'] === '_33' ) ? 'checked' : ''
		);
	}

	public function _34_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_34]" id="_34" value="_34" %s>',
			( isset( $this->wp_faster_options['_34'] ) && $this->wp_faster_options['_34'] === '_34' ) ? 'checked' : ''
		);
	}

	public function _35_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_35]" id="_35" value="_35" %s>',
			( isset( $this->wp_faster_options['_35'] ) && $this->wp_faster_options['_35'] === '_35' ) ? 'checked' : ''
		);
	}

	public function _36_callback() {
		printf(
			'<input type="checkbox" name="wp_faster_option_name[_36]" id="_36" value="_36" %s>',
			( isset( $this->wp_faster_options['_36'] ) && $this->wp_faster_options['_36'] === '_36' ) ? 'checked' : ''
		);
	}

}
if ( is_admin() )
	$wp_faster = new WPFaster();

/* 
 * Retrieve this value with:
 * $wp_faster_options = get_option( 'wp_faster_option_name' ); // Array of All Options
 * $_0 = $wp_faster_options['_0']; // 移除版本号
 * $rsd_1 = $wp_faster_options['rsd_1']; // 移除RSD
 * $wlwmanifest_2 = $wp_faster_options['wlwmanifest_2']; // 移除wlwmanifest
 * $_3 = $wp_faster_options['_3']; // 移除短链接
 * $wordpress_4 = $wp_faster_options['wordpress_4']; // 移除自动修正WordPress大小写
 * $_5 = $wp_faster_options['_5']; // 移除管理菜单
 * $_6 = $wp_faster_options['_6']; // 移除隐私相关页面
 * $_7 = $wp_faster_options['_7']; // 移除管理界面配色方案
 * $_8 = $wp_faster_options['_8']; // 移除后台页脚信息
 * $logo_10 = $wp_faster_options['logo_10']; // 移除后台左上角logo
 * $oembed_11 = $wp_faster_options['oembed_11']; // 禁用oEmbed
 * $embed_12 = $wp_faster_options['embed_12']; // 禁用Embed
 * $_13 = $wp_faster_options['_13']; // 禁用日志修订
 * $xml_rpc_14 = $wp_faster_options['xml_rpc_14']; // 禁用XML-RPC
 * $wp_cron_15 = $wp_faster_options['wp_cron_15']; // 禁用WP Cron
 * $rest_api_16 = $wp_faster_options['rest_api_16']; // 禁用REST API
 * $_17 = $wp_faster_options['_17']; // 禁用转译字符
 * $emoji_18 = $wp_faster_options['emoji_18']; // 禁用Emoji
 * $_20 = $wp_faster_options['_20']; // 禁用图片响应式资源请求
 * $_21 = $wp_faster_options['_21']; // 禁用全高度编辑器和免打扰功能
 * $_22 = $wp_faster_options['_22']; // 禁用古滕堡编辑器
 * $gravatarhttps_23 = $wp_faster_options['gravatarhttps_23']; // Gravatar启用HTTPS
 * $_24 = $wp_faster_options['_24']; // 启用友情链接
 * $_25 = $wp_faster_options['_25']; // 防止标题转译
 * $_26 = $wp_faster_options['_26']; // 防止附件乱码
 * $utf8mb4_27 = $wp_faster_options['utf8mb4_27']; // 去除utf8mb4不支持的非法字符
 * $nofollow_28 = $wp_faster_options['nofollow_28']; // 评论链接nofollow
 * $nofollow_29 = $wp_faster_options['nofollow_29']; // 阅读全文nofollow
 * $nofollow_30 = $wp_faster_options['nofollow_30']; // 文章外链nofollow
 * $_31 = $wp_faster_options['_31']; // 移除后台帮助
 * $_32 = $wp_faster_options['_32']; // 屏蔽站点管理员邮箱验证
 * $_33 = $wp_faster_options['_33']; // 插入图片使用完整尺寸
 * $_34 = $wp_faster_options['_34']; // 删除图像大小属性
 * $_35 = $wp_faster_options['_35']; // 后台可按照作者筛选文章
 * $_36 = $wp_faster_options['_36']; // 登录页面返回站点信息
 */


  $_0 = $wp_faster_options['_0']; // 移除版本号
  if( $_0 = '_0'){
    remove_action('wp_head', 'wp_generator');
  }

  $rsd_1 = $wp_faster_options['rsd_1']; // 移除RSD
  if( $rsd_1 = 'rsd_1'){
    remove_action('wp_head', 'rsd_link');
  }

  $wlwmanifest_2 = $wp_faster_options['wlwmanifest_2']; // 移除wlwmanifest
  if( $wlwmanifest_2 = 'wlwmanifest_2'){
    remove_action('wp_head', 'wlwmanifest_link');
  }

  $_3 = $wp_faster_options['_3']; // 移除短链接
  if( $_3 = '_3'){
    remove_action('wp_head','wp_shortlink_wp_head',10,0);
    remove_action('template_redirect','wp_shortlink_header',11,0);
  }

  $wordpress_4 = $wp_faster_options['wordpress_4']; // 移除自动修正WordPress大小写
  if( $wordpress_4 = 'wordpress_4'){
    remove_filter( 'the_content', 'capital_P_dangit' );
    remove_filter( 'the_title', 'capital_P_dangit' );
    remove_filter( 'comment_text', 'capital_P_dangit' );
  }

  $_5 = $wp_faster_options['_5']; // 移除管理菜单
  if( $_5 = '_5'){
    add_filter( 'show_admin_bar', '__return_false' );
  }

  $_6 = $wp_faster_options['_6']; // 移除隐私相关页面
  if( $_6 = '_6'){
    add_action('admin_menu', function (){
        global $menu, $submenu;
    
        // 移除设置菜单下的隐私子菜单。
        unset($submenu['options-general.php'][45]);
    
        // 移除工具彩带下的相关页面
        remove_action( 'admin_menu', '_wp_privacy_hook_requests_page' );
    
        remove_filter( 'wp_privacy_personal_data_erasure_page', 'wp_privacy_process_personal_data_erasure_page', 10, 5 );
        remove_filter( 'wp_privacy_personal_data_export_page', 'wp_privacy_process_personal_data_export_page', 10, 7 );
        remove_filter( 'wp_privacy_personal_data_export_file', 'wp_privacy_generate_personal_data_export_file', 10 );
        remove_filter( 'wp_privacy_personal_data_erased', '_wp_privacy_send_erasure_fulfillment_notification', 10 );
    
        // Privacy policy text changes check.
        remove_action( 'admin_init', array( 'WP_Privacy_Policy_Content', 'text_change_check' ), 100 );
    
        // Show a "postbox" with the text suggestions for a privacy policy.
        remove_action( 'edit_form_after_title', array( 'WP_Privacy_Policy_Content', 'notice' ) );
    
        // Add the suggested policy text from WordPress.
        remove_action( 'admin_init', array( 'WP_Privacy_Policy_Content', 'add_suggested_content' ), 1 );
    
        // Update the cached policy info when the policy page is updated.
        remove_action( 'post_updated', array( 'WP_Privacy_Policy_Content', '_policy_page_updated' ) );
    },9);
  }

  $_7 = $wp_faster_options['_7']; // 移除管理界面配色方案
  if( $_7 = '_7'){
    remove_action("admin_color_scheme_picker", "admin_color_scheme_picker");
  }

  $_8 = $wp_faster_options['_8']; // 移除后台页脚信息
  if( $_8 = '_8'){
    function change_footer_admin () {
        return '';
    }
    add_filter('admin_footer_text', 'change_footer_admin', 9999);
    function change_footer_version() {
        return '';
    }
    add_filter( 'update_footer', 'change_footer_version', 9999);
  }

  $logo_10 = $wp_faster_options['logo_10']; // 移除后台左上角logo
  if( $logo_10 = 'logo_10'){
    function annointed_admin_bar_remove() {
      global $wp_admin_bar;
      $wp_admin_bar->remove_menu('wp-logo');
    }
    add_action('wp_before_admin_bar_render', 'annointed_admin_bar_remove', 0);
  }

  $oembed_11 = $wp_faster_options['oembed_11']; // 禁用oEmbed
  if( $oembed_11 = 'oembed_11'){
    remove_filter( 'the_content', array( $GLOBALS['wp_embed'], 'autoembed' ), 8 );
  }

  $embed_12 = $wp_faster_options['embed_12']; // 禁用Embed
  if( $embed_12 = 'embed_12'){
    remove_action('rest_api_init', 'wp_oembed_register_route');
    remove_filter('rest_pre_serve_request', '_oembed_rest_pre_serve_request', 10, 4);
    remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10 );
    remove_filter('oembed_response_data',   'get_oembed_response_data_rich',  10, 4);
    remove_action('wp_head', 'wp_oembed_add_discovery_links');
    remove_action('wp_head', 'wp_oembed_add_host_js');
  }

  $_13 = $wp_faster_options['_13']; // 禁用日志修订
  if( $_13 = '_13'){
    define('WP_POST_REVISIONS', false);
    add_filter( 'wp_revisions_to_keep', 'specs_wp_revisions_to_keep', 10, 2 );
    function specs_wp_revisions_to_keep( $num, $post ) {
        return 0;
    }
  }

  $xml_rpc_14 = $wp_faster_options['xml_rpc_14']; // 禁用XML-RPC
  if( $xml_rpc_14 = 'xml_rpc_14'){
    add_filter('xmlrpc_enabled', '__return_false');
  }

  $wp_cron_15 = $wp_faster_options['wp_cron_15']; // 禁用WP Cron
  if( $wp_cron_15 = 'wp_cron_15'){
    define('DISABLE_WP_CRON', true);
  }

  $rest_api_16 = $wp_faster_options['rest_api_16']; // 禁用REST API
  if( $rest_api_16 = 'rest_api_16'){
    add_filter('rest_enabled', '__return_false');
    add_filter('rest_jsonp_enabled', '__return_false');
    remove_action('wp_head', 'rest_output_link_wp_head', 10 );
    remove_action('template_redirect', 'rest_output_link_header', 11 );
    add_filter( 'rest_authentication_errors', function( $access ) {
        return new WP_Error( 'rest_cannot_acess', 'REST API不再提供访问', array( 'status' => 403 ) );
    });
  }

  $_17 = $wp_faster_options['_17']; // 禁用转译字符
  if( $_17 = '_17'){
    remove_filter('the_content', 'wptexturize');
    remove_filter('the_excerpt', 'wptexturize');
    remove_filter('comment_text', 'wptexturize');
  }

  $emoji_18 = $wp_faster_options['emoji_18']; // 禁用Emoji
  if( $emoji_18 = 'emoji_18'){
    remove_action('admin_print_scripts',    'print_emoji_detection_script');
    remove_action('admin_print_styles', 'print_emoji_styles');
    
    remove_action('wp_head',        'print_emoji_detection_script', 7);
    remove_action('wp_print_styles',    'print_emoji_styles');
    
    remove_action('embed_head',     'print_emoji_detection_script');
    
    remove_filter('the_content_feed',   'wp_staticize_emoji');
    remove_filter('comment_text_rss',   'wp_staticize_emoji');
    remove_filter('wp_mail',        'wp_staticize_emoji_for_email');
    
    add_filter( 'emoji_svg_url',        '__return_false' );
  }

  $_20 = $wp_faster_options['_20']; // 禁用图片响应式资源请求
  if( $_20 = '_20'){
    function disable_srcset( $sources ) {
        return false;
    }
    add_filter( 'wp_calculate_image_srcset', 'disable_srcset' );
  }

  $_21 = $wp_faster_options['_21']; // 禁用全高度编辑器和免打扰功能
  if( $_21 = '_21'){
    add_action('admin_init', function(){
        wp_deregister_script('editor-expand');
    });
    
    add_filter('tiny_mce_before_init', function($init){
        unset($init['wp_autoresize_on']);
        return $init;
    });
  }

  $_22 = $wp_faster_options['_22']; // 禁用古滕堡编辑器
  if( $_22 = '_22'){
    add_filter('use_block_editor_for_post_type', '__return_false');
    wp_deregister_style('wp-block-library');
  }

  $gravatarhttps_23 = $wp_faster_options['gravatarhttps_23']; // Gravatar启用HTTPS
  if( $gravatarhttps_23 = 'gravatarhttps_23'){
    function iopenv_get_https_avatar($avatar) {
        // Replacement for HTTPS domain
        $avatar = str_replace(array("www.gravatar.com", "0.gravatar.com", "1.gravatar.com", "2.gravatar.com"), "secure.gravatar.com", $avatar);
        // Replacement for HTTPS protocol
        $avatar = str_replace("http:", "https:", $avatar);
        return $avatar;
    }
    
    add_filter('get_avatar', 'iopenv_get_https_avatar');
  }

  $_24 = $wp_faster_options['_24']; // 启用友情链接
  if( $_24 = '_24'){
    add_filter( 'pre_option_link_manager_enabled', '__return_true' );
  }

  $_25 = $wp_faster_options['_25']; // 防止标题转译
  if( $_25 = '_25'){
    add_filter( 'run_wptexturize', '__return_false' );
  }

  $_26 = $wp_faster_options['_26']; // 防止附件乱码
  if( $_26 = '_26'){
    function info_sanitize_file_name($filename) {
        $info = pathinfo($filename);
        $extension = $info['extension'];
        return md5(uniqid(microtime(true),true)).'.'.$extension;
    }
    add_filter('sanitize_file_name', 'info_sanitize_file_name', 10);
  }

  $utf8mb4_27 = $wp_faster_options['utf8mb4_27']; // 去除utf8mb4不支持的非法字符
  if( $utf8mb4_27 = 'utf8mb4_27'){
    function rm_strip_invalid_text($str){
        $regex = '/
        (
            (?: [\x00-\x7F]                  # single-byte sequences   0xxxxxxx
            |   [\xC2-\xDF][\x80-\xBF]       # double-byte sequences   110xxxxx 10xxxxxx
            |   \xE0[\xA0-\xBF][\x80-\xBF]   # triple-byte sequences   1110xxxx 10xxxxxx * 2
            |   [\xE1-\xEC][\x80-\xBF]{2}
            |   \xED[\x80-\x9F][\x80-\xBF]
            |   [\xEE-\xEF][\x80-\xBF]{2}
            |    \xF0[\x90-\xBF][\x80-\xBF]{2} # four-byte sequences   11110xxx 10xxxxxx * 3
            |    [\xF1-\xF3][\x80-\xBF]{3}
            |    \xF4[\x80-\x8F][\x80-\xBF]{2}
            ){1,50}                          # ...one or more times
        )
        | .                                  # anything else
        /x';
    
        return preg_replace($regex, '$1', $str);
    }
  }

  $nofollow_28 = $wp_faster_options['nofollow_28']; // 评论链接nofollow
  if( $nofollow_28 = 'nofollow_28'){
    function add_nofollow_to_comments_popup_link(){
        return ' rel="nofollow" ';
    }
    add_filter('comments_popup_link_attributes', 'add_nofollow_to_comments_popup_link');
      }

  $nofollow_29 = $wp_faster_options['nofollow_29']; // 阅读全文nofollow
  if( $nofollow_29 = 'nofollow_29'){
    function add_nofollow_to_link($link) {
        return str_replace('<a', '<a rel="nofollow" target="_blank"', $link);
    }
    add_filter('the_content_more_link','add_nofollow_to_link', 0);
      }

  $nofollow_30 = $wp_faster_options['nofollow_30']; // 文章外链nofollow
  if( $nofollow_30 = 'nofollow_30'){
    add_filter('the_content','the_content_external',999);
    function the_content_external($content){
        preg_match_all('/href="(.*?)"/',$content,$matches);
        if($matches){
            foreach($matches[1] as $val){
                if( strpos($val,$_SERVER['HTTP_HOST'])===false ) $content=str_replace("href=\"$val\"", "href=\"$val\" rel=\"external nofollow noopener\" ",$content);
            }
        }
        return $content;
    }
  }

  $_31 = $wp_faster_options['_31']; // 移除后台帮助
  if( $_31 = '_31'){
    add_action('in_admin_header', function(){
        global $current_screen;
        $current_screen->remove_help_tabs();
    });
  }

  $_32 = $wp_faster_options['_32']; // 屏蔽站点管理员邮箱验证
  if( $_32 = '_32'){
    add_filter('admin_email_check_interval', '__return_false');
	}

	$_33 = $wp_faster_options['_33']; // 插入图片使用完整尺寸
  if( $_33 = '_33'){
    add_filter('image_size_names_choose', 'wpjam_image_size_names_choose');
		function wpjam_image_size_names_choose($image_sizes){
				unset($image_sizes['thumbnail']);
				unset($image_sizes['medium']);
				unset($image_sizes['large']);
				return $image_sizes;
		}
	}
	
	$_34 = $wp_faster_options['_34']; // 删除图像大小属性
  if( $_34 = '_34'){
    add_filter( 'the_content', 'remove_width_attribute', 10 );
		function remove_width_attribute( $html ) {
			$html = preg_replace( '/(width|height)="\d*"\s/', "", $html );
			return $html;
		}
	}

	$_35 = $wp_faster_options['_35']; // 后台可按照作者筛选文章
  if( $_35 = '_35'){
    add_action('restrict_manage_posts', function($post_type){
			if(post_type_supports($post_type, 'author')){
				wp_dropdown_users([
					'name'						=> 'author',
					'who'						=> 'authors',
					'show_option_all'			=> '所有作者',
					'hide_if_only_one_author'	=> true,
					'selected'					=> $_REQUEST['author'] ?? 0
				]);
			}
		});
	}

	$_36 = $wp_faster_options['_36']; // 登录页面返回站点信息
  if( $_36 = '_36'){
    add_filter('login_headerurl', create_function(false,"return get_bloginfo('url');"));
		add_filter('login_headertitle', create_function(false,"return get_bloginfo('name');"));
	}

endif; // class_exists check