<?php
/* phpcs:disable WordPress.NamingConventions.PrefixAllGlobals */
/**
 * This class used to backup all tables for this plugins.
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 3.0.0
 * @package Maps
 */


if ( isset( $_POST['operation'] ) and 'clean_database' == $_POST['operation'] ) {
	$clean_database = $response;
} else {
	$clean_database = array();
}

if ( isset( $_POST['operation'] ) and 'upload_sampledata' == $_POST['operation'] ) {
	$upload_sampledata = $response;
} else {
	$upload_sampledata = array();
}

	$import_form = new WPGMP_Template();
	$import_form->form_id = 'install_sample_data_form';

	$import_form->set_header( esc_html__( 'Install Sample Data', 'wp-google-map-plugin' ), $upload_sampledata,true );

	$import_form->add_element(
		'group', 'install_database', array(
			'value'  => esc_html__( 'Install Sample Data', 'wp-google-map-plugin' ),
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$import_form->add_element(
		'hidden', 'operation', array(
			'value' => 'upload_sampledata',
		)
	);

	$import_form->add_element(
		'message', 'sampledata_message', array(
			'value' => esc_html__( 'Click below to install sample data. This is very useful to get started. 2 categories, 5 locations, 2 routes and 1 map will be created for demonstration purpose.', 'wp-google-map-plugin' ),
			'class' => 'fc-alert fc-alert-info',
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$import_form->add_element(
		'text', 'wpgmp_sampledata_consent', array(
			'label'  => esc_html__( 'Verify Action', 'wp-google-map-plugin' ),
			'class'  => 'form-control',
			'desc'   => esc_html__( 'Enter "YES" and submit the button below to install sample map data.', 'wp-google-map-plugin' ),
			'before' => '<div class="fc-4">',
			'after'  => '</div>',
		)
	);


	$import_form->add_element(
		'submit', 'wpgmp_sampledata_submit', array(
			'value' => esc_html__( 'Create Sample Data', 'wp-google-map-plugin' ),
		)
	);

	$import_form->render();


	$form = new WPGMP_Template(array( 'no_header' => true ));
	$form->form_id = 'clean_wpgmp_database';
	$form->set_header( esc_html__( 'Clean Database', 'wp-google-map-plugin' ), $clean_database,true );

	$form->add_element(
		'group', 'clean_database', array(
			'value'  => esc_html__( 'Clean Database', 'wp-google-map-plugin' ),
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'hidden', 'operation', array(
			'value' => 'clean_database',
		)
	);

	$form->add_element(
		'message', 'backup_message', array(
			'value' => esc_html__( 'Enter "DELETE" in the below textbox and submit the form to remove all locations, maps, categories and routes i.e compelete database generated by our plugin. This method is not recommended on a live site as everything related to our plugin will be removed except plugin settings.', 'wp-google-map-plugin' ),
			'class' => 'fc-alert fc-alert-info',
			'before' => '<div class="fc-12">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'text', 'wpgmp_clean_consent', array(
			'label'  => esc_html__( 'Verify Action', 'wp-google-map-plugin' ),
			'id'     => 'wpgmp_consent',
			'class'  => 'form-control',
			'desc'   => esc_html__( 'Enter "DELETE" to give consent that you actually want to remove all maps data generated by our plugin.', 'wp-google-map-plugin' ),
			'before' => '<div class="fc-4">',
			'after'  => '</div>',
		)
	);

	$form->add_element(
		'submit', 'wpgmp_cleandatabase_tools', array(
			'value' => esc_html__( 'Clear Database', 'wp-google-map-plugin' ),
			'no-sticky' => true,
		)
	);

	$form->render();
	
	/* phpcs:enable WordPress.NamingConventions.PrefixAllGlobals */

	
