<?php

namespace StripeWPFS\Stripe\Util;

class ObjectTypes
{
    /**
     * @var array Mapping from object types to resource classes
     */
    const mapping
        = [
            \StripeWPFS\Stripe\Collection::OBJECT_NAME => \StripeWPFS\Stripe\Collection::class,
            \StripeWPFS\Stripe\Issuing\CardDetails::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\CardDetails::class,
            \StripeWPFS\Stripe\SearchResult::OBJECT_NAME => \StripeWPFS\Stripe\SearchResult::class,
            \StripeWPFS\Stripe\File::OBJECT_NAME_ALT => \StripeWPFS\Stripe\File::class,
            // object classes: The beginning of the section generated from our OpenAPI spec
            \StripeWPFS\Stripe\Account::OBJECT_NAME => \StripeWPFS\Stripe\Account::class,
            \StripeWPFS\Stripe\AccountLink::OBJECT_NAME => \StripeWPFS\Stripe\AccountLink::class,
            \StripeWPFS\Stripe\AccountSession::OBJECT_NAME => \StripeWPFS\Stripe\AccountSession::class,
            \StripeWPFS\Stripe\ApplePayDomain::OBJECT_NAME => \StripeWPFS\Stripe\ApplePayDomain::class,
            \StripeWPFS\Stripe\Application::OBJECT_NAME => \StripeWPFS\Stripe\Application::class,
            \StripeWPFS\Stripe\ApplicationFee::OBJECT_NAME => \StripeWPFS\Stripe\ApplicationFee::class,
            \StripeWPFS\Stripe\ApplicationFeeRefund::OBJECT_NAME => \StripeWPFS\Stripe\ApplicationFeeRefund::class,
            \StripeWPFS\Stripe\Apps\Secret::OBJECT_NAME => \StripeWPFS\Stripe\Apps\Secret::class,
            \StripeWPFS\Stripe\Balance::OBJECT_NAME => \StripeWPFS\Stripe\Balance::class,
            \StripeWPFS\Stripe\BalanceTransaction::OBJECT_NAME => \StripeWPFS\Stripe\BalanceTransaction::class,
            \StripeWPFS\Stripe\BankAccount::OBJECT_NAME => \StripeWPFS\Stripe\BankAccount::class,
            \StripeWPFS\Stripe\Billing\Alert::OBJECT_NAME => \StripeWPFS\Stripe\Billing\Alert::class,
            \StripeWPFS\Stripe\Billing\AlertTriggered::OBJECT_NAME => \StripeWPFS\Stripe\Billing\AlertTriggered::class,
            \StripeWPFS\Stripe\Billing\CreditBalanceSummary::OBJECT_NAME => \StripeWPFS\Stripe\Billing\CreditBalanceSummary::class,
            \StripeWPFS\Stripe\Billing\CreditBalanceTransaction::OBJECT_NAME => \StripeWPFS\Stripe\Billing\CreditBalanceTransaction::class,
            \StripeWPFS\Stripe\Billing\CreditGrant::OBJECT_NAME => \StripeWPFS\Stripe\Billing\CreditGrant::class,
            \StripeWPFS\Stripe\Billing\Meter::OBJECT_NAME => \StripeWPFS\Stripe\Billing\Meter::class,
            \StripeWPFS\Stripe\Billing\MeterEvent::OBJECT_NAME => \StripeWPFS\Stripe\Billing\MeterEvent::class,
            \StripeWPFS\Stripe\Billing\MeterEventAdjustment::OBJECT_NAME => \StripeWPFS\Stripe\Billing\MeterEventAdjustment::class,
            \StripeWPFS\Stripe\Billing\MeterEventSummary::OBJECT_NAME => \StripeWPFS\Stripe\Billing\MeterEventSummary::class,
            \StripeWPFS\Stripe\BillingPortal\Configuration::OBJECT_NAME => \StripeWPFS\Stripe\BillingPortal\Configuration::class,
            \StripeWPFS\Stripe\BillingPortal\Session::OBJECT_NAME => \StripeWPFS\Stripe\BillingPortal\Session::class,
            \StripeWPFS\Stripe\Capability::OBJECT_NAME => \StripeWPFS\Stripe\Capability::class,
            \StripeWPFS\Stripe\Card::OBJECT_NAME => \StripeWPFS\Stripe\Card::class,
            \StripeWPFS\Stripe\CashBalance::OBJECT_NAME => \StripeWPFS\Stripe\CashBalance::class,
            \StripeWPFS\Stripe\Charge::OBJECT_NAME => \StripeWPFS\Stripe\Charge::class,
            \StripeWPFS\Stripe\Checkout\Session::OBJECT_NAME => \StripeWPFS\Stripe\Checkout\Session::class,
            \StripeWPFS\Stripe\Climate\Order::OBJECT_NAME => \StripeWPFS\Stripe\Climate\Order::class,
            \StripeWPFS\Stripe\Climate\Product::OBJECT_NAME => \StripeWPFS\Stripe\Climate\Product::class,
            \StripeWPFS\Stripe\Climate\Supplier::OBJECT_NAME => \StripeWPFS\Stripe\Climate\Supplier::class,
            \StripeWPFS\Stripe\ConfirmationToken::OBJECT_NAME => \StripeWPFS\Stripe\ConfirmationToken::class,
            \StripeWPFS\Stripe\ConnectCollectionTransfer::OBJECT_NAME => \StripeWPFS\Stripe\ConnectCollectionTransfer::class,
            \StripeWPFS\Stripe\CountrySpec::OBJECT_NAME => \StripeWPFS\Stripe\CountrySpec::class,
            \StripeWPFS\Stripe\Coupon::OBJECT_NAME => \StripeWPFS\Stripe\Coupon::class,
            \StripeWPFS\Stripe\CreditNote::OBJECT_NAME => \StripeWPFS\Stripe\CreditNote::class,
            \StripeWPFS\Stripe\CreditNoteLineItem::OBJECT_NAME => \StripeWPFS\Stripe\CreditNoteLineItem::class,
            \StripeWPFS\Stripe\Customer::OBJECT_NAME => \StripeWPFS\Stripe\Customer::class,
            \StripeWPFS\Stripe\CustomerBalanceTransaction::OBJECT_NAME => \StripeWPFS\Stripe\CustomerBalanceTransaction::class,
            \StripeWPFS\Stripe\CustomerCashBalanceTransaction::OBJECT_NAME => \StripeWPFS\Stripe\CustomerCashBalanceTransaction::class,
            \StripeWPFS\Stripe\CustomerSession::OBJECT_NAME => \StripeWPFS\Stripe\CustomerSession::class,
            \StripeWPFS\Stripe\Discount::OBJECT_NAME => \StripeWPFS\Stripe\Discount::class,
            \StripeWPFS\Stripe\Dispute::OBJECT_NAME => \StripeWPFS\Stripe\Dispute::class,
            \StripeWPFS\Stripe\Entitlements\ActiveEntitlement::OBJECT_NAME => \StripeWPFS\Stripe\Entitlements\ActiveEntitlement::class,
            \StripeWPFS\Stripe\Entitlements\ActiveEntitlementSummary::OBJECT_NAME => \StripeWPFS\Stripe\Entitlements\ActiveEntitlementSummary::class,
            \StripeWPFS\Stripe\Entitlements\Feature::OBJECT_NAME => \StripeWPFS\Stripe\Entitlements\Feature::class,
            \StripeWPFS\Stripe\EphemeralKey::OBJECT_NAME => \StripeWPFS\Stripe\EphemeralKey::class,
            \StripeWPFS\Stripe\Event::OBJECT_NAME => \StripeWPFS\Stripe\Event::class,
            \StripeWPFS\Stripe\ExchangeRate::OBJECT_NAME => \StripeWPFS\Stripe\ExchangeRate::class,
            \StripeWPFS\Stripe\File::OBJECT_NAME => \StripeWPFS\Stripe\File::class,
            \StripeWPFS\Stripe\FileLink::OBJECT_NAME => \StripeWPFS\Stripe\FileLink::class,
            \StripeWPFS\Stripe\FinancialConnections\Account::OBJECT_NAME => \StripeWPFS\Stripe\FinancialConnections\Account::class,
            \StripeWPFS\Stripe\FinancialConnections\AccountOwner::OBJECT_NAME => \StripeWPFS\Stripe\FinancialConnections\AccountOwner::class,
            \StripeWPFS\Stripe\FinancialConnections\AccountOwnership::OBJECT_NAME => \StripeWPFS\Stripe\FinancialConnections\AccountOwnership::class,
            \StripeWPFS\Stripe\FinancialConnections\Session::OBJECT_NAME => \StripeWPFS\Stripe\FinancialConnections\Session::class,
            \StripeWPFS\Stripe\FinancialConnections\Transaction::OBJECT_NAME => \StripeWPFS\Stripe\FinancialConnections\Transaction::class,
            \StripeWPFS\Stripe\Forwarding\Request::OBJECT_NAME => \StripeWPFS\Stripe\Forwarding\Request::class,
            \StripeWPFS\Stripe\FundingInstructions::OBJECT_NAME => \StripeWPFS\Stripe\FundingInstructions::class,
            \StripeWPFS\Stripe\Identity\VerificationReport::OBJECT_NAME => \StripeWPFS\Stripe\Identity\VerificationReport::class,
            \StripeWPFS\Stripe\Identity\VerificationSession::OBJECT_NAME => \StripeWPFS\Stripe\Identity\VerificationSession::class,
            \StripeWPFS\Stripe\Invoice::OBJECT_NAME => \StripeWPFS\Stripe\Invoice::class,
            \StripeWPFS\Stripe\InvoiceItem::OBJECT_NAME => \StripeWPFS\Stripe\InvoiceItem::class,
            \StripeWPFS\Stripe\InvoiceLineItem::OBJECT_NAME => \StripeWPFS\Stripe\InvoiceLineItem::class,
            \StripeWPFS\Stripe\InvoicePayment::OBJECT_NAME => \StripeWPFS\Stripe\InvoicePayment::class,
            \StripeWPFS\Stripe\InvoiceRenderingTemplate::OBJECT_NAME => \StripeWPFS\Stripe\InvoiceRenderingTemplate::class,
            \StripeWPFS\Stripe\Issuing\Authorization::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Authorization::class,
            \StripeWPFS\Stripe\Issuing\Card::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Card::class,
            \StripeWPFS\Stripe\Issuing\Cardholder::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Cardholder::class,
            \StripeWPFS\Stripe\Issuing\Dispute::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Dispute::class,
            \StripeWPFS\Stripe\Issuing\PersonalizationDesign::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\PersonalizationDesign::class,
            \StripeWPFS\Stripe\Issuing\PhysicalBundle::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\PhysicalBundle::class,
            \StripeWPFS\Stripe\Issuing\Token::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Token::class,
            \StripeWPFS\Stripe\Issuing\Transaction::OBJECT_NAME => \StripeWPFS\Stripe\Issuing\Transaction::class,
            \StripeWPFS\Stripe\LineItem::OBJECT_NAME => \StripeWPFS\Stripe\LineItem::class,
            \StripeWPFS\Stripe\LoginLink::OBJECT_NAME => \StripeWPFS\Stripe\LoginLink::class,
            \StripeWPFS\Stripe\Mandate::OBJECT_NAME => \StripeWPFS\Stripe\Mandate::class,
            \StripeWPFS\Stripe\PaymentIntent::OBJECT_NAME => \StripeWPFS\Stripe\PaymentIntent::class,
            \StripeWPFS\Stripe\PaymentLink::OBJECT_NAME => \StripeWPFS\Stripe\PaymentLink::class,
            \StripeWPFS\Stripe\PaymentMethod::OBJECT_NAME => \StripeWPFS\Stripe\PaymentMethod::class,
            \StripeWPFS\Stripe\PaymentMethodConfiguration::OBJECT_NAME => \StripeWPFS\Stripe\PaymentMethodConfiguration::class,
            \StripeWPFS\Stripe\PaymentMethodDomain::OBJECT_NAME => \StripeWPFS\Stripe\PaymentMethodDomain::class,
            \StripeWPFS\Stripe\Payout::OBJECT_NAME => \StripeWPFS\Stripe\Payout::class,
            \StripeWPFS\Stripe\Person::OBJECT_NAME => \StripeWPFS\Stripe\Person::class,
            \StripeWPFS\Stripe\Plan::OBJECT_NAME => \StripeWPFS\Stripe\Plan::class,
            \StripeWPFS\Stripe\Price::OBJECT_NAME => \StripeWPFS\Stripe\Price::class,
            \StripeWPFS\Stripe\Product::OBJECT_NAME => \StripeWPFS\Stripe\Product::class,
            \StripeWPFS\Stripe\ProductFeature::OBJECT_NAME => \StripeWPFS\Stripe\ProductFeature::class,
            \StripeWPFS\Stripe\PromotionCode::OBJECT_NAME => \StripeWPFS\Stripe\PromotionCode::class,
            \StripeWPFS\Stripe\Quote::OBJECT_NAME => \StripeWPFS\Stripe\Quote::class,
            \StripeWPFS\Stripe\Radar\EarlyFraudWarning::OBJECT_NAME => \StripeWPFS\Stripe\Radar\EarlyFraudWarning::class,
            \StripeWPFS\Stripe\Radar\ValueList::OBJECT_NAME => \StripeWPFS\Stripe\Radar\ValueList::class,
            \StripeWPFS\Stripe\Radar\ValueListItem::OBJECT_NAME => \StripeWPFS\Stripe\Radar\ValueListItem::class,
            \StripeWPFS\Stripe\Refund::OBJECT_NAME => \StripeWPFS\Stripe\Refund::class,
            \StripeWPFS\Stripe\Reporting\ReportRun::OBJECT_NAME => \StripeWPFS\Stripe\Reporting\ReportRun::class,
            \StripeWPFS\Stripe\Reporting\ReportType::OBJECT_NAME => \StripeWPFS\Stripe\Reporting\ReportType::class,
            \StripeWPFS\Stripe\ReserveTransaction::OBJECT_NAME => \StripeWPFS\Stripe\ReserveTransaction::class,
            \StripeWPFS\Stripe\Review::OBJECT_NAME => \StripeWPFS\Stripe\Review::class,
            \StripeWPFS\Stripe\SetupAttempt::OBJECT_NAME => \StripeWPFS\Stripe\SetupAttempt::class,
            \StripeWPFS\Stripe\SetupIntent::OBJECT_NAME => \StripeWPFS\Stripe\SetupIntent::class,
            \StripeWPFS\Stripe\ShippingRate::OBJECT_NAME => \StripeWPFS\Stripe\ShippingRate::class,
            \StripeWPFS\Stripe\Sigma\ScheduledQueryRun::OBJECT_NAME => \StripeWPFS\Stripe\Sigma\ScheduledQueryRun::class,
            \StripeWPFS\Stripe\Source::OBJECT_NAME => \StripeWPFS\Stripe\Source::class,
            \StripeWPFS\Stripe\SourceMandateNotification::OBJECT_NAME => \StripeWPFS\Stripe\SourceMandateNotification::class,
            \StripeWPFS\Stripe\SourceTransaction::OBJECT_NAME => \StripeWPFS\Stripe\SourceTransaction::class,
            \StripeWPFS\Stripe\Subscription::OBJECT_NAME => \StripeWPFS\Stripe\Subscription::class,
            \StripeWPFS\Stripe\SubscriptionItem::OBJECT_NAME => \StripeWPFS\Stripe\SubscriptionItem::class,
            \StripeWPFS\Stripe\SubscriptionSchedule::OBJECT_NAME => \StripeWPFS\Stripe\SubscriptionSchedule::class,
            \StripeWPFS\Stripe\Tax\Calculation::OBJECT_NAME => \StripeWPFS\Stripe\Tax\Calculation::class,
            \StripeWPFS\Stripe\Tax\CalculationLineItem::OBJECT_NAME => \StripeWPFS\Stripe\Tax\CalculationLineItem::class,
            \StripeWPFS\Stripe\Tax\Registration::OBJECT_NAME => \StripeWPFS\Stripe\Tax\Registration::class,
            \StripeWPFS\Stripe\Tax\Settings::OBJECT_NAME => \StripeWPFS\Stripe\Tax\Settings::class,
            \StripeWPFS\Stripe\Tax\Transaction::OBJECT_NAME => \StripeWPFS\Stripe\Tax\Transaction::class,
            \StripeWPFS\Stripe\Tax\TransactionLineItem::OBJECT_NAME => \StripeWPFS\Stripe\Tax\TransactionLineItem::class,
            \StripeWPFS\Stripe\TaxCode::OBJECT_NAME => \StripeWPFS\Stripe\TaxCode::class,
            \StripeWPFS\Stripe\TaxDeductedAtSource::OBJECT_NAME => \StripeWPFS\Stripe\TaxDeductedAtSource::class,
            \StripeWPFS\Stripe\TaxId::OBJECT_NAME => \StripeWPFS\Stripe\TaxId::class,
            \StripeWPFS\Stripe\TaxRate::OBJECT_NAME => \StripeWPFS\Stripe\TaxRate::class,
            \StripeWPFS\Stripe\Terminal\Configuration::OBJECT_NAME => \StripeWPFS\Stripe\Terminal\Configuration::class,
            \StripeWPFS\Stripe\Terminal\ConnectionToken::OBJECT_NAME => \StripeWPFS\Stripe\Terminal\ConnectionToken::class,
            \StripeWPFS\Stripe\Terminal\Location::OBJECT_NAME => \StripeWPFS\Stripe\Terminal\Location::class,
            \StripeWPFS\Stripe\Terminal\Reader::OBJECT_NAME => \StripeWPFS\Stripe\Terminal\Reader::class,
            \StripeWPFS\Stripe\TestHelpers\TestClock::OBJECT_NAME => \StripeWPFS\Stripe\TestHelpers\TestClock::class,
            \StripeWPFS\Stripe\Token::OBJECT_NAME => \StripeWPFS\Stripe\Token::class,
            \StripeWPFS\Stripe\Topup::OBJECT_NAME => \StripeWPFS\Stripe\Topup::class,
            \StripeWPFS\Stripe\Transfer::OBJECT_NAME => \StripeWPFS\Stripe\Transfer::class,
            \StripeWPFS\Stripe\TransferReversal::OBJECT_NAME => \StripeWPFS\Stripe\TransferReversal::class,
            \StripeWPFS\Stripe\Treasury\CreditReversal::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\CreditReversal::class,
            \StripeWPFS\Stripe\Treasury\DebitReversal::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\DebitReversal::class,
            \StripeWPFS\Stripe\Treasury\FinancialAccount::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\FinancialAccount::class,
            \StripeWPFS\Stripe\Treasury\FinancialAccountFeatures::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\FinancialAccountFeatures::class,
            \StripeWPFS\Stripe\Treasury\InboundTransfer::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\InboundTransfer::class,
            \StripeWPFS\Stripe\Treasury\OutboundPayment::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\OutboundPayment::class,
            \StripeWPFS\Stripe\Treasury\OutboundTransfer::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\OutboundTransfer::class,
            \StripeWPFS\Stripe\Treasury\ReceivedCredit::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\ReceivedCredit::class,
            \StripeWPFS\Stripe\Treasury\ReceivedDebit::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\ReceivedDebit::class,
            \StripeWPFS\Stripe\Treasury\Transaction::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\Transaction::class,
            \StripeWPFS\Stripe\Treasury\TransactionEntry::OBJECT_NAME => \StripeWPFS\Stripe\Treasury\TransactionEntry::class,
            \StripeWPFS\Stripe\WebhookEndpoint::OBJECT_NAME => \StripeWPFS\Stripe\WebhookEndpoint::class,
            // object classes: The end of the section generated from our OpenAPI spec
        ];

    /**
     * @var array Mapping from v2 object types to resource classes
     */
    const v2Mapping = [
        // v2 object classes: The beginning of the section generated from our OpenAPI spec
        \StripeWPFS\Stripe\V2\Billing\MeterEvent::OBJECT_NAME => \StripeWPFS\Stripe\V2\Billing\MeterEvent::class,
        \StripeWPFS\Stripe\V2\Billing\MeterEventAdjustment::OBJECT_NAME => \StripeWPFS\Stripe\V2\Billing\MeterEventAdjustment::class,
        \StripeWPFS\Stripe\V2\Billing\MeterEventSession::OBJECT_NAME => \StripeWPFS\Stripe\V2\Billing\MeterEventSession::class,
        \StripeWPFS\Stripe\V2\Event::OBJECT_NAME => \StripeWPFS\Stripe\V2\Event::class,
        \StripeWPFS\Stripe\V2\EventDestination::OBJECT_NAME => \StripeWPFS\Stripe\V2\EventDestination::class,
        // v2 object classes: The end of the section generated from our OpenAPI spec
    ];
}
