<tr valign="top" class="<?php echo $option->get_hide_class_attribute(); ?>">
    <th scope="row">
        <label for="<?php echo $option->get_id_attribute(); ?>" class="<?php echo $option->get_label_class_attribute(); ?>">
            <?php echo $option->get_label(); ?>
        </label>
        <?php if($link = $option->get_arg('link')) { ?>
            <a target="_blank" class="tooltip" href="<?php echo esc_url($link); ?>" title="<?php _e('Help'); ?>"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M12 4.75a7.25 7.25 0 100 14.5 7.25 7.25 0 000-14.5zM3.25 12a8.75 8.75 0 1117.5 0 8.75 8.75 0 01-17.5 0zM12 8.75a1.5 1.5 0 01.167 2.99c-.465.052-.917.44-.917 1.01V14h1.5v-.845A3 3 0 109 10.25h1.5a1.5 1.5 0 011.5-1.5zM11.25 15v1.5h1.5V15h-1.5z"></path></svg></a>
        <?php } ?>
    </th>
    <td>
        <?php
        \wp_editor(html_entity_decode($option->get_value_attribute() ?? '', ENT_QUOTES, 'UTF-8'), $option->get_id_attribute(), [
            'textarea_name' => $option->get_name_attribute(),
            'wpautop' => $option->get_arg('wpautop', true),
            'teeny' => $option->get_arg('teeny', false),
            'media_buttons' => $option->get_arg('media_buttons', true),
            'default_editor' => $option->get_arg('default_editor'),
            'drag_drop_upload' => $option->get_arg('drag_drop_upload', false),
            'textarea_rows' => $option->get_arg('textarea_rows', 10),
            'tabindex' => $option->get_arg('tabindex'),
            'tabfocus_elements' => $option->get_arg('tabfocus_elements'),
            'editor_css' => $option->get_arg('editor_css'),
            'editor_class' => $option->get_arg('editor_class'),
            'tinymce' => $option->get_arg('tinymce', true),
            'quicktags' => $option->get_arg('quicktags', true)
        ]); ?>
        
        <?php if ($description = $option->get_arg('description')) { ?>
            <p class="description"><?php echo $description; ?></p>
        <?php } ?>

        <?php if ($error = $option->has_error()) { ?>
            <div class="wps-error-feedback"><?php echo $error; ?></div>
        <?php } ?>
    </td>
</tr>
