(function() {
    tinymce.PluginManager.add('cleanhtml', function(editor, url) {
        editor.addButton('cleanhtml', {
            title: 'Clean HTML',
            icon: 'insert-spellcheck mce-i-spellchecker',
            onclick: function() {
                try {
                    var content = editor.getContent();
                    var whitelist = 'p,b,strong,i,em,h2,h3,h4,h5,h6,ul,li,ol,a,img,table,tr,td';
                    var allowedAttrPrefixes = ['aria-'];
                    var allowedAttrNames = ['id', 'class', 'style'];

                    function breakSearchAndReplace(content) {
                        content = content.replace(/(<br\s*\/?>){2,}/gi, "+-+");
                        return formatContent(content);
                    }

                    function formatContent(content) {
                        var tagWhitelistRegex = new RegExp(`<(/?)(?!(${whitelist.split(',').join('|')}))\b[^>]*>`, 'gi');
                        content = content.replace(tagWhitelistRegex, "").replace(/\s+/g, ' ').trim();
                        content = content.replace(/<p>\s*<\/p>/g, " ");
                        var tempDiv = document.createElement('div');
                        tempDiv.innerHTML = content;
                        var elements = tempDiv.querySelectorAll('*');
                        elements.forEach(function(element) {
                            Array.from(element.attributes).forEach(function(attr) {
                                if (attr.name.match(/^data-(start|end|is-last-node|is-only-node|sourcepos)$/)) {
                                    element.removeAttribute(attr.name);
                                }
                            });
                        });
                        return tempDiv.innerHTML;
                    }

                    function removeExtraLines(content) {
                        content = content.replace(/\/\+-\+\//g, "</p>").replace(/<p>\+-\+<\/p>/g, "");
                        return replaceBrTagsToP(content);
                    }

                    function replaceBrTagsToP(content) {
                        return content.split(/(?=<p>)/g).map(part => part.replace(/\+-\+/g, "</p><p>")).join("");
                    }

                    var cleanedContent = breakSearchAndReplace(content);
                    if (typeof jQuery !== 'undefined' && jQuery('#wp-content-wrap').hasClass('html-active')) {
                        jQuery('#content').val(cleanedContent);
                    } else {
                        var activeEditor = tinyMCE.get('content');
                        if (activeEditor) {
                            activeEditor.setContent(cleanedContent);
                        }
                    }
                } catch (e) {
                    console.error('Error in cleanhtml plugin:', e);
                    editor.windowManager.alert('An error occurred while cleaning HTML');
                }
            }
        });
    });
})();