<?php
/**
 * Admin Submenu of the Plugin
 *
 * @link       https://shapedplugin.com/
 * @since      2.0.0
 *
 * @package    WP_Tabs
 * @subpackage WP_Tabs/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Admin Submenu of the Plugin
 */
class WP_Tabs_Admin_Menu {

	/**
	 * The ID of this plugin.
	 *
	 * @since    2.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    2.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    2.0.0
	 * @param      string $plugin_name       The name of this plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Add plugin action menu
	 *
	 * @param array $links The action link.
	 * @param array $file The file link.
	 *
	 * @return array
	 */
	public function sptpro_plugin_action_links( $links, $file ) {

		if ( WP_TABS_BASENAME === $file ) {

			$new_links = array(
				sprintf( '<a href="%s">%s</a>', admin_url( 'edit.php?post_type=sp_products_tabs' ), __( 'Settings', 'wp-expand-tabs-free' ) ),
			);
			$links[]   = '<a href="' . esc_url( SP_SMART_TABS_PRO_LINK ) . '" style="color: #35b747; font-weight: 700;">' . __( 'Go Pro!', 'wp-expand-tabs-free' ) . '</a>';

			return array_merge( $new_links, $links );
		}

		return $links;
	}

	/**
	 * Bottom review notice.
	 *
	 * @param string $text The review notice.
	 * @return string
	 */
	public function sptpro_review_text( $text ) {
		$screen = get_current_screen();
		if ( 'sp_wp_tabs' === $screen->post_type ) {
			$url  = 'https://wordpress.org/support/plugin/wp-expand-tabs-free/reviews/';
			$text = sprintf(
				/* translators: 1: start strong tag, 2: close strong tag, 3: start a tag, 4: close a tag. */
				__( 'Enjoying %1$sSmart Tabs?%2$s Please rate us %3$sWordPress.org%4$s. Your positive feedback will help us grow more. Thank you! 😊', 'wp-expand-tabs-free' ),
				'<strong>',
				'</strong>',
				'<span class="sptabs-footer-text-star">★★★★★</span> <a href="' . esc_url( $url ) . '" target="_blank">',
				'</a>'
			);
		}

		return $text;
	}

	/**
	 * Bottom version notice.
	 *
	 * @param string $text Version notice.
	 * @return string
	 */
	public function sptpro_version_text( $text ) {
		$screen = get_current_screen();
		if ( 'sp_wp_tabs' === $screen->post_type ) {
			$text = 'Smart Tabs ' . $this->version;
		}
		return $text;
	}
}
