<?php
/**
 * Framework Custom_import field file.
 *
 * @link http://shapedplugin.com
 * @since 2.0.0
 *
 * @package wp-expand-tabs-free
 * @subpackage wp-expand-tabs-free/Framework
 */

if ( ! defined( 'ABSPATH' ) ) {
	die; } // Cannot access directly.

if ( ! class_exists( 'SP_WP_TABS_Field_custom_import' ) ) {
	/**
	 *
	 * Field: Custom_import
	 *
	 * @since 1.0.0
	 * @version 1.0.0
	 */
	class SP_WP_TABS_Field_custom_import extends SP_WP_TABS_Fields {

		/**
		 * Custom import field constructor.
		 *
		 * @param array  $field The field type.
		 * @param string $value The values of the field.
		 * @param string $unique The unique ID for the field.
		 * @param string $where To where show the output CSS.
		 * @param string $parent The parent args.
		 */
		public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
			parent::__construct( $field, $value, $unique, $where, $parent );
		}
		/**
		 * Render field.
		 *
		 * @return void
		 */
		public function render() {
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo $this->field_before();
			$tabs_link         = admin_url( 'edit.php?post_type=sp_wp_tabs' );
			$product_tabs_link = admin_url( 'edit.php?post_type=sp_products_tabs' );

			echo '<p><input type="file" id="import" accept=".json"></p>';
			echo '<p><button type="button" class="import">Import</button></p>';
			echo '<a id="wp__tabs_link_redirect" href="' . esc_url( $tabs_link ) . '"></a>';
			echo '<a id="wp_product_tabs_link_redirect" href="' . esc_url( $product_tabs_link ) . '"></a>';
			echo $this->field_after(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}
}
