<?php
	$has_shipping = false;
	$has_billing = false;
	if ( get_option( 'ec_option_use_shipping' ) ) {
		foreach ( $this->order->cart->cart as $cart_item ) {
			if ( $cart_item->is_shippable ) {
				$has_shipping = true;
			}
		}
	}
	if ( isset( $this->order->billing_address_line_1 ) && '' != $this->order->billing_address_line_1 ) {
		$has_billing = true;
	}
	if ( isset( $this->order->billing_address_city ) && '' != $this->order->billing_address_city ) {
		$has_billing = true;
	}
	if ( isset( $this->order->billing_address_state ) && '' != $this->order->billing_address_state ) {
		$has_billing = true;
	}
	if ( isset( $this->order->billing_address_zip ) && '' != $this->order->billing_address_zip ) {
		$has_billing = true;
	}
	if ( isset( $this->order->billing_address_country ) && '' != $this->order->billing_address_country ) {
		$has_billing = true;
	}
?>
<section class="ec_account_page" id="ec_account_order_details">
	<?php if ( $this->order ) { ?>
	<div class="right">
		<a href="<?php echo esc_attr( wpeasycart_links()->get_account_page( 'print_receipt', array( 'order_id' => (int) $this->order->order_id, 'ec_guest_key' => ( ( '' != $this->order->guest_key ) ? $this->order->guest_key : null ) ) ) ); ?>" target="_blank"><img src="<?php echo esc_attr( $this->get_print_order_icon_url( ) ); ?>" /></a>
	</div>

	<div class="ec_account_order_details_main_holder">
		<?php if ( ! $this->order->is_approved && ( 7 == $this->order->orderstatus_id || 9 == $this->order->orderstatus_id || 19 == $this->order->orderstatus_id ) ) { ?>
		<div class="ec_cart_error_row2" style="margin-bottom:20px;">
			<?php echo wp_easycart_language( )->get_text( 'ec_errors', 'delayed_payment_failed' )?> 
		</div>
		<?php } else if ( ! $this->order->is_approved && 16 == $this->order->orderstatus_id ) { ?>
		<div class="ec_cart_error_row2" style="margin-bottom:20px;">
			<?php echo wp_easycart_language( )->get_text( 'ec_errors', 'order_refunded' )?> 
		</div>
		<?php } else if ( ! $this->order->is_approved ) { ?>
		<div class="ec_cart_notice_row" style="margin-bottom:20px;">
			<?php echo wp_easycart_language( )->get_text( 'ec_errors', 'payment_processing' )?> 
		</div>
		<?php }?>
		<?php if ( $this->order->includes_preorder_items ) { ?>
			<div class="ec_cart_notice_row" style="margin-bottom:20px;">
				<?php echo str_replace( '[pickup_date]', esc_attr( date( apply_filters( 'wp_easycart_pickup_date_placeholder_format', 'F d, Y' ), strtotime( $this->order->pickup_date ) ) . ' - ' . date( apply_filters( 'wp_easycart_pickup_time_close_placeholder_format', 'g:i A' ), strtotime( $this->order->pickup_date . ' +1 hour' ) ) ), wp_easycart_language( )->get_text( 'ec_errors', 'preorder_message' ) ); ?>
			</div>
			<?php if ( $this->order->location_id ) { ?>
				<?php $location = $this->order->get_location(); ?>
				<?php if ( is_object( $location ) ) { ?>
					<?php
						$location_address_format = ( ( '' != $location->address_line_1 ) ? $location->address_line_1 : '' ) . ( ( '' != $location->address_line_2 ) ? ' ' . $location->address_line_2 : '' ) . ', ' . $location->city . ( ( '' != $location->state ) ? ' ' . $location->state : '' ) . ( ( '' != $location->zip ) ? ', ' . $location->zip : '' ) . ( ( '' != $location->country ) ? ', ' . $location->country : '' );
						$location_address_format =apply_filters( 'wp_easycart_location_address', $location_address_format, $location );
					?>
					<div class="ec_cart_pickup_location_box_details">
						<h2><?php echo wp_easycart_language( )->get_text( 'cart_payment_information', 'preorder_location' ); ?></h2>
						<?php if ( get_option( 'ec_option_pickup_location_select_enabled' ) && is_string( get_option( 'ec_option_pickup_location_google_site_key' ) ) && '' != get_option( 'ec_option_pickup_location_google_site_key' ) ) { ?>
						<div class="ec_cart_pickup_location_map" id="pickup_location_map"></div>
						<script>
						(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})({
							key: "<?php echo esc_attr( get_option( 'ec_option_pickup_location_google_site_key' ) ); ?>",
							v: "weekly",
						});
						</script>
						<script>
							let map;
							async function initMap() {
								const position = { lat: <?php echo esc_attr( $location->latitude ); ?>, lng: <?php echo esc_attr( $location->longitude ); ?> };
								const { Map } = await google.maps.importLibrary("maps");
								const { AdvancedMarkerElement } = await google.maps.importLibrary("marker");
								map = new Map(
									document.getElementById( 'pickup_location_map' ),
									{
										zoom: 15,
										center: position,
										mapId: 'mapid'
									}
								);
								const marker = new google.maps.marker.AdvancedMarkerElement({
									map: map,
									position: position,
									title: '<?php echo esc_attr( $location->location_label ); ?>'
								} );
							}
							initMap();
						</script>
						<?php }?>
						<div class="ec_cart_pickup_location_details">
							<h3><?php echo esc_attr( $location->location_label ); ?></h3>
							<p class="ec_cart_pickup_location_address"><?php echo esc_attr( $location_address_format ); ?></p>
							<?php if ( isset( $location->hours_note ) && is_string( $location->hours_note ) && '' != trim( $location->hours_note ) ) { ?>
								<p class="ec_cart_pickup_location_note"><?php echo esc_attr( $location->hours_note ); ?></p>
							<?php } ?>
							<?php if ( ( isset( $location->phone ) && '' != $location->phone ) || ( isset( $location->email ) && '' != $location->email ) ) { ?>
							<div class="ec_cart_pickup_location_note_button_row">
							<?php if ( isset( $location->phone ) && '' != $location->phone ) { ?>
								<a href="tel:<?php echo esc_attr( $location->phone ); ?>" title="<?php echo esc_attr( $location->phone ); ?>" class="ec_cart_pickup_location_note_button_phone"><span class="dashicons dashicons-phone"></span> <?php echo esc_attr( $location->phone ); ?></a>
							<?php } ?>
							<?php if ( isset( $location->email ) && '' != $location->email ) { ?>
								<a href="mailto:<?php echo esc_attr( $location->email ); ?>" title="<?php echo esc_attr( $location->email ); ?>" class="ec_cart_pickup_location_note_button_email"><span class="dashicons dashicons-email-alt"></span> <?php echo esc_attr( $location->email ); ?></a>
							<?php } ?>
							</div>
							<?php }?>
						</div>
					</div>
				<?php }?>
			<?php }?>
		<?php }?>
		<?php if ( $this->order->includes_restaurant_type ) { ?>
		<div class="ec_cart_notice_row" style="margin-bottom:20px;">
			<?php echo str_replace( '[pickup_time]', esc_attr( date( apply_filters( 'wp_easycart_pickup_time_placeholder_format', 'g:i A F d, Y' ), strtotime( $this->order->pickup_time ) ) ), wp_easycart_language( )->get_text( 'ec_errors', 'restaurant_message' ) ); ?>
		</div>
		<?php }?>

		<div class="ec_account_order_details_left">
			<div class="ec_cart_header ec_top"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_order_info_title' )?></div>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_order_number' )?></strong> <?php $this->order->display_order_id( ); ?></div>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_order_date' )?></strong> <?php $this->order->display_order_date( ); ?></div>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_order_status' )?></strong> <?php $this->order->display_order_status( ); ?></div>

			<?php if( $has_shipping ){
				if( $this->order->shipping_method ){ ?>
				<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_shipping_method' )?></strong> <?php $this->order->display_order_shipping_method( ); ?></div>
				<?php }
			} ?>

			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_email' )?></strong> <?php $this->order->display_order_email( ); ?></div>
			<?php if ( '' != $this->order->email_other ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_email_other' )?></strong> <?php $this->order->display_order_email_other( ); ?></div>
			<?php } ?>

			<?php if ( $this->order->promo_code ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_coupon_code' )?></strong> <?php $this->order->display_order_promocode( ); ?></div>
			<?php } ?>

			<?php if ( $this->order->giftcard_id ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_gift_card' )?></strong> <?php $this->order->display_order_giftcard( ); ?></div>
			<?php } ?>

			<?php if ( $this->order->has_tracking_number() ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_order_tracking' )?></strong> <?php $this->order->display_order_tracking_number(); ?></div>
			<?php } ?>

			<?php if ( $this->order->subscription_id ) {?>
			<div class="ec_cart_input_row"><strong><?php $this->order->display_subscription_link( wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_view_subscription' ) ); ?></strong> <?php $this->order->display_order_tracking_number( ); ?></div>
			<?php } ?>

			<?php if ( $this->order->has_membership_page() ) { ?>
			<div class="ec_cart_input_row"><strong><a href="<?php echo esc_attr( $this->order->get_membership_page_link( ) ); ?>"><?php echo wp_easycart_language( )->get_text( "cart_success", "cart_payment_complete_line_5" ); ?></a></strong></div>
			<?php } ?>

			<?php if ( $this->order->vat_registration_number != "" ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'cart_billing_information', 'cart_billing_information_vat_registration_number' ); ?>:</strong> <?php echo esc_attr( htmlspecialchars( stripslashes( $this->order->vat_registration_number ), ENT_QUOTES ) ); ?></div>
			<?php } ?>

			<?php do_action( 'wpeasycart_order_details_after_basic_info', $this->order ); ?>

			<div class="ec_cart_input_row">&nbsp;&nbsp;&nbsp;</div>

			<?php if ( $has_shipping && ( ! $this->order->subscription_id || get_option( 'ec_option_collect_shipping_for_subscriptions' ) ) ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_shipping_label' )?></strong></div>
			<div class="ec_cart_input_row"><?php $this->order->display_order_shipping_first_name( ); ?> <?php $this->order->display_order_shipping_last_name( ); ?></div>
			<?php if ( '' != $this->order->shipping_company_name ) { ?>
			<div class="ec_cart_input_row"><?php echo esc_attr( $this->order->shipping_company_name ); ?></div>
			<?php } ?>
			<div class="ec_cart_input_row"><?php $this->order->display_order_shipping_address_line_1(); ?></div>
			<?php if( '' != $this->order->shipping_address_line_2 ) { ?>
			<div class="ec_cart_input_row"><?php echo esc_attr( $this->order->shipping_address_line_2 ); ?></div>
			<?php }?>
			<div class="ec_cart_input_row"><?php $this->order->display_order_shipping_city(); ?>, <?php $this->order->display_order_shipping_state( ); ?> <?php $this->order->display_order_shipping_zip(); ?></div>
			<div class="ec_cart_input_row"><?php $this->order->display_order_shipping_country(); ?></div>
			<div class="ec_cart_input_row"><?php $this->order->display_order_shipping_phone(); ?></div>
			<div class="ec_cart_input_row">&nbsp;&nbsp;&nbsp;</div>
			<?php }?>

			<?php do_action( 'wpeasycart_order_details_after_shipping', $this->order ); ?>

			<?php if ( $has_billing ) { ?>
				<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_billing_label' )?></strong></div>
				<div class="ec_cart_input_row"><?php $this->order->display_order_billing_first_name( ); ?> <?php $this->order->display_order_billing_last_name( ); ?></div>
				<?php if ( '' != $this->order->billing_company_name ){ ?>
				<div class="ec_cart_input_row"><?php echo esc_attr( htmlspecialchars( $this->order->billing_company_name, ENT_QUOTES ) ); ?></div>
				<?php }?>
				<div class="ec_cart_input_row"><?php $this->order->display_order_billing_address_line_1(); ?></div>
				<?php if ( '' != $this->order->billing_address_line_2 ) { ?>
				<div class="ec_cart_input_row"><?php echo esc_attr( htmlspecialchars( $this->order->billing_address_line_2, ENT_QUOTES ) ); ?></div>
				<?php }?>
				<div class="ec_cart_input_row"><?php $this->order->display_order_billing_city(); ?>, <?php $this->order->display_order_billing_state(); ?> <?php $this->order->display_order_billing_zip(); ?></div>
				<div class="ec_cart_input_row"><?php $this->order->display_order_billing_country(); ?></div>
				<div class="ec_cart_input_row"><?php $this->order->display_order_billing_phone(); ?></div>

				<?php do_action( 'wpeasycart_order_details_after_billing', $this->order ); ?>
				<div class="ec_cart_input_row">&nbsp;&nbsp;&nbsp;</div>
			<?php }?>

			<?php if ( '' != $this->order->creditcard_digits ) { ?>
				<?php if ( '' != $this->order->card_holder_name ) { ?>
					<div class="ec_cart_input_row"><strong><?php echo esc_attr( $this->order->card_holder_name ); ?></strong></div>
				<?php } ?>
				<div class="ec_cart_input_row"><?php $this->order->display_payment_method( ); ?>: ************<?php echo esc_attr( $this->order->creditcard_digits ); ?></div>
			<?php } else { ?>
				<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_payment_method' )?></strong> <?php $this->order->display_payment_method( ); ?></div>
			<?php } ?>
			<div class="ec_cart_input_row">&nbsp;&nbsp;&nbsp;</div>

			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_subtotal' )?></strong> <?php $this->order->display_sub_total( ); ?></div>
			<?php if ( $this->order->tip_total > 0 ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'cart_totals', 'cart_totals_tip' ); ?></strong> <?php $this->order->display_tip_total( ); ?></div>
			<?php } ?>
			<?php if ( get_option( 'ec_option_use_shipping' ) && ( $this->order->shipping_method || $this->order->shipping_total > 0 ) ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_shipping_total' )?></strong> <?php $this->order->display_shipping_total( ); ?></div>
			<?php }?>
			<?php if ( $this->order->tax_total > 0 ) {?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_tax_total' )?></strong> <?php $this->order->display_tax_total( ); ?></div>
			<?php } ?>
			<?php if ( $this->order->discount_total != 0 ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_discount_total' )?></strong> -<?php $this->order->display_discount_total(); ?></div>
			<?php } ?>
			<?php if ( $this->order->has_duty() ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_duty_total' )?></strong> <?php $this->order->display_duty_total( ); ?></div>
			<?php } ?>
			<?php if ( $this->order->has_vat() ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_vat_total' )?></strong> <?php $this->order->display_vat_total( ); ?></div>
			<?php } ?>
			<?php if ( $this->order->gst_total > 0 ) {?>
			<div class="ec_cart_input_row"><strong>GST (<?php echo esc_attr( $this->order->gst_rate ); ?>%)</strong> <?php $this->order->display_gst_total( ); ?></div>
			<?php } ?>
			<?php if ( $this->order->pst_total > 0 ) { ?>
			<div class="ec_cart_input_row"><strong>PST (<?php echo esc_attr( $this->order->pst_rate ); ?>%)</strong> <?php $this->order->display_pst_total( ); ?></div>
			<?php } ?>
			<?php if ( $this->order->hst_total > 0 ) { ?>
			<div class="ec_cart_input_row"><strong>HST (<?php echo esc_attr( $this->order->hst_rate ); ?>%)</strong> <?php $this->order->display_hst_total( ); ?></div>
			<?php } ?>
			<?php if ( count( $this->order->order_fees ) > 0 ) { ?>
				<?php foreach ( $this->order->order_fees as $order_fee ) { ?>
				<div class="ec_cart_input_row"><strong><?php echo esc_attr( $order_fee->fee_label ); ?></strong> <?php echo esc_attr( $GLOBALS['currency']->get_currency_display( $order_fee->fee_total ) ); ?></div>
				<?php } ?>
			<?php } ?>
			<?php if ( $this->order->has_refund() ) { ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_refund_total' )?></strong> <?php $this->order->display_refund_total( ); ?></div>
			<?php } ?>
			<div class="ec_cart_input_row"><strong><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_grand_total' )?></strong> <?php $this->order->display_grand_total( ); ?></div>
			<?php do_action( 'wpeasycart_order_details_after_totals', $this->order ); ?>
		</div>

		<div class="ec_account_order_details_right">
			<?php do_action( 'wpeasycart_account_order_details_right_top', $this->order->order_id, $this->order ); ?>
			<div class="ec_cart_header ec_top"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_your_order_title' )?></div>
			<?php $this->order->display_order_customer_details_notes( ); ?>
			<table class="ec_account_order_details_table">
				<thead>
					<tr>
						<th class="ec_account_orderitem_head_name" colspan="2"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_header_1' )?></th>
						<th class="ec_account_orderitem_head_price"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_header_3' )?></th>
						<th class="ec_account_orderitem_head_quantity"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_header_4' )?></th>
						<th class="ec_account_orderitem_head_total"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'account_orders_details_header_5' )?></th>
					</tr>
				</thead>
				<tbody>
				<?php $this->display_order_detail_product_list( ); ?>
				</tbody>
			</table>
			<?php if ( get_option( 'ec_option_user_order_notes' ) && strlen( trim( $this->order->order_customer_notes ) ) > 0 ) { ?>
			<div class="ec_account_order_notes">
				<hr />
				<h4><?php echo wp_easycart_language( )->get_text( 'cart_payment_information', 'cart_payment_information_order_notes_title' ); ?></h4>
				<p><?php echo nl2br( esc_attr( $this->order->order_customer_notes ) ); ?></p>
				<br>
			</div>
			<?php } ?>
			<?php do_action( 'wpeasycart_order_detials_order_notes_after', $this->order ); ?>
		</div>
	</div>
	<?php } else { ?>
	<div class="ec_account_no_order_found"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'no_order_found' )?></div>
	<div class="ec_account_return_to_dashboard_button"><a href="<?php echo esc_attr( $this->account_page ); ?>"><?php echo wp_easycart_language( )->get_text( 'account_order_details', 'return_to_dashboard' )?></a></div>
	<?php } ?>

	<div style="clear:both;"></div>
	<div id="ec_current_media_size"></div>
</section>
