// Generated by CoffeeScript 1.12.6
(function() {
	var WPDocumentRevisions,
		bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	WPDocumentRevisions = (function() {
		WPDocumentRevisions.prototype.hasUpload = false;
		WPDocumentRevisions.prototype.secure = ( 'https:' === window.location.protocol );

	WPDocumentRevisions.prototype.window = window.dialogArguments || opener || parent || top;

		function WPDocumentRevisions($) {
			this.updateTimestamps = bind(this.updateTimestamps, this);
			this.postAutosaveCallback = bind(this.postAutosaveCallback, this);
			this.overrideLock = bind(this.overrideLock, this);
			this.restoreRevision = bind(this.restoreRevision, this);
			this.enableSubmit = bind(this.enableSubmit, this);
			this.autosaveEnableButtons = bind(this.autosaveEnableButtons, this);
			this.hijackAutosave = bind(this.hijackAutosave, this);
			this.cookieFalse = bind(this.cookieFalse, this);
			this.cookieTrue = bind(this.cookieTrue, this);
			this.cookieDelete = bind(this.cookieDelete, this);
			this.buildContent = bind(this.buildContent, this);
			this.checkUpdate = bind(this.checkUpdate, this);
			this.$ = $;
			this.$('.revision').click(this.restoreRevision);
			this.$('#override_link').click(this.overrideLock);
			this.$('#document a').click(this.requestPermission);
			this.$(document).bind('autosaveComplete', this.postAutosaveCallback);
			this.$(document).bind('documentUpload', this.legacyPostDocumentUpload);
			this.$(':button, :submit', '#submitpost').prop('disabled', true);
			this.$('#misc-publishing-actions a').click(this.enableSubmit);
			this.$('input, select').on('change', this.enableSubmit);
			this.$('input[type=text], textarea').on('keyup', this.enableSubmit);
			this.$('#sample-permalink').on('change', this.enableSubmit);
			this.$('#content-add_media').click(this.cookieFalse);
			this.$('#postimagediv .inside').click(this.cookieTrue);
			this.$('#publishing-action').click(this.buildContent);
			this.$('#submitdiv .inside').click(this.cookieDelete);
			this.$('#adminmenumain').click(this.cookieDelete);
			this.$('#wpadminbar').click(this.cookieDelete);
			this.$('#document').show();
			this.$('#revision-log').show();
			this.$('#revision-summary').hide();
			this.bindPostDocumentUploadCB();
			this.hijackAutosave();
			this.checkUpdate();
			setInterval(this.updateTimestamps, 60000);
			setInterval(this.checkUpdate, 1000);
		}

		WPDocumentRevisions.prototype.hijackAutosave = function() {
			this.autosaveEnableButtonsOriginal = window.autosave_enable_buttons;
			return window.autosave_enable_buttons = this.autosaveEnableButtons;
		};

		WPDocumentRevisions.prototype.autosaveEnableButtons = function() {
			this.window.document.$(document).trigger('autosaveComplete');
			if (this.hasUpload) {
				return this.autosaveEnableButtonsOriginal();
			}
		};

		WPDocumentRevisions.prototype.enableSubmit = function() {
			this.$('#revision-summary').show();
			this.$(':button, :submit', '#submitpost').removeAttr('disabled');
			return this.$('#lock_override').prev().fadeIn();
		};

		WPDocumentRevisions.prototype.restoreRevision = function(e) {
			e.preventDefault();
			if (confirm(wp_document_revisions.restoreConfirmation)) {
				return window.location.href = this.
				$(e.target).attr('href');
			}
		};

		WPDocumentRevisions.prototype.overrideLock = function() {
			return this.$.post(ajaxurl, {
				action: 'override_lock',
				post_id: this.$("#post_ID").val() || 0,
				nonce: wp_document_revisions.nonce
			}, function(data) {
				if (data) {
					this.$('#lock_override').hide();
					this.$('.error').not('#lock-notice').hide();
					this.$('#publish, .add_media, #lock-notice').fadeIn();
					return autosave();
				} else {
					return alert(wp_document_revisions.lockError);
				}
			});
		};

		WPDocumentRevisions.prototype.requestPermission = function() {
			if (window.webkitNotifications != null) {
				return window.webkitNotifications.requestPermission();
			}
		};

		WPDocumentRevisions.prototype.lockOverrideNotice = function(notice) {
			if (window.webkitNotifications.checkPermission() > 0) {
				return window.webkitNotifications.RequestPermission(lock_override_notice);
			} else {
				return window.webkitNotifications.createNotification(wp_document_revisions.lostLockNoticeLogo, wp_document_revisions.lostLockNoticeTitle, notice).show();
			}
		};

		WPDocumentRevisions.prototype.postAutosaveCallback = function() {
			if (this.$('#autosave-alert').length > 0 && this.$('#lock-notice').length > 0 && this.$('#lock-notice').is(":visible")) {
				wp_document_revisions.lostLockNotice = wp_document_revisions.lostLockNotice.replace('%s', this.window.document.$('#title').val());
				if (window.webkitNotifications) {
					lock_override_notice(wp_document_revisions.lostLockNotice);
				} else {
					alert(wp_document_revisions.lostLockNotice);
				}
				return location.reload(true);
			}
		};

		WPDocumentRevisions.prototype.legacyPostDocumentUpload = function(attachmentID, extension) {
			return this.postDocumentUpload(attachmentID, extension);
		};

		WPDocumentRevisions.prototype.human_time_diff = function(from, to) {
			var d, days, diff, hours, mins;
			d = new Date();
			to = to || (d.getTime() / 1000) + parseInt(wp_document_revisions.offset);
			diff = Math.abs(to - from);
			if (diff <= 3600) {
				mins = Math.floor(diff / 60);
				mins = this.roundUp(mins);
				if (mins === 1) {
					return wp_document_revisions.minute.replace('%d', mins);
				} else {
					return wp_document_revisions.minutes.replace('%d', mins);
				}
			} else if ((diff <= 86400) && (diff > 3600)) {
				hours = Math.floor(diff / 3600);
				hours = this.roundUp(hours);
				if (hours === 1) {
					return wp_document_revisions.hour.replace('%d', hours);
				} else {
					return wp_document_revisions.hours.replace('%d', hours);
				}
			} else if (diff >= 86400) {
				days = Math.floor(diff / 86400);
				days = this.roundUp(days);
				if (days === 1) {
					return wp_document_revisions.day.replace('%d', days);
				} else {
					return wp_document_revisions.days.replace('%d', days);
				}
			}
		};

		WPDocumentRevisions.prototype.roundUp = function(n) {
			if (n < 1) {
				n = 1;
			}
			return n;
		};

		WPDocumentRevisions.prototype.bindPostDocumentUploadCB = function() {
			if (typeof uploader === "undefined" || uploader === null) {
				return;
			}
			return uploader.bind('FileUploaded', (function(_this) {
				return function(up, file, response) {
					if (response.response.match('media-upload-error')) {
						return;
					}
					return _this.postDocumentUpload(file.name, response.response);
				};
			})(this));
		};

		WPDocumentRevisions.prototype.cookieFalse = function() {
			wpCookies.set( 'doc_image', 'false', 60 * 60, '/wp-admin', false, this.secure );
		};

		WPDocumentRevisions.prototype.cookieTrue = function() {
			wpCookies.set( 'doc_image', 'true', 60 * 60, '/wp-admin', false, this.secure );
			this.$(':button, :submit', '#submitpost').removeAttr('disabled');
			// Propagation will be stopped in postimagediv to stop document event setting cookie false.
		};

		WPDocumentRevisions.prototype.cookieDelete = function() {
			wpCookies.set( 'doc_image', 'true', -60, '/wp-admin', false, this.secure );
		};

		WPDocumentRevisions.prototype.updateTimestamps = function() {
			return this.$('.timestamp').each((function(_this) {
				return function() {
					return _this.$(_this).text(_this.human_time_diff(_this.$(_this).attr('id')));
				};
			})(this));
		};

		WPDocumentRevisions.prototype.getDescr = function() {
			// Extract data from TinyMCE window and clean up text.
			// On starting, the post_content is set to BOTH fields content and post_content. 
			var iframe = this.window.document.getElementById('content_ifr');
			if ( null === iframe ) {
				var content = this.$('#post_content').val();
				if ( undefined === content || '' === content || /^\d+$/.test(content) ) {
					return '';
				}
				return content;
			};
			var text   = iframe.contentWindow.document.getElementById('tinymce').innerHTML;
			if ( undefined === text ) {
				var content = this.$('#post_content').val();
				if ( '' === content || /^\d+$/.test(content) ) {
					return '';
				}
				return content;
			};
			text = text.replace(/<br data-mce-bogus=\"1\">/g, '');
			text = text.replace(/<br><\/p>/g, '</p>');
			text = text.replace(/<p>\s*<\/p>/g, '');
			return text;
		}    	

		WPDocumentRevisions.prototype.buildContent = function() {
			// Create the desired content for post_content.
			// Will be the combination of document id from field post_content and description from content.
			var content = this.$('#post_content').val();
			var newtext = this.getDescr();
			var attach;
			if ( '' === content ) {
				attach = [''];
			} else if ( /^\d+$/.test(content) ) {
				attach = ['<!-- WPDR ' + content + ' -->'];
			} else {
				// match returns array, so ensure all return array.
				attach = content.match(/<!-- WPDR \s*\d+ -->/);
			}
			// might have an extra space includes in the id provided.
			newtext = newtext.replace(/<!-- WPDR \s*\d+ -->/, '');
			newtext = attach[0] + newtext;
			if ( content !== newtext ) {
				this.enableSubmit();
			}
			// set the desired text eeverywhere.
			this.window.jQuery('#curr_content').val(newtext);
			this.window.jQuery('#post_content').val(newtext);
			this.window.jQuery('#content').val(newtext);
		};

		WPDocumentRevisions.prototype.postDocumentUpload = function(file, attachmentID) {
			if (typeof attachmentID === 'string' && attachmentID.indexOf('error') !== -1) {
				return this.$('.media-item:first').html(attachmentID);
			}
			if (file instanceof Object) {
				file = file.name.split('.').pop();
			}
			if (this.hasUpload) {
				return;
			}
			// On upload set the document identifier in the new format.
			var docID = /\d+$/.exec(attachmentID);
			// This will throw away the description for an existing post - but it is in content.
			this.window.jQuery('#post_content').val('<!-- WPDR '+docID+' -->');
			this.window.jQuery('#message').hide();
			this.hasUpload = true;
			this.window.tb_remove();
			this.window.jQuery('#post').before(wp_document_revisions.postUploadNotice).prev().fadeIn().fadeOut().fadeIn();
			this.enableSubmit();
			if (this.window.jQuery('#sample-permalink').length !== 0) {
				return this.window.jQuery('#sample-permalink').html(this.window.jQuery('#sample-permalink').html().replace(/\<\/span>(\.[a-z0-9]{1,7})?@$/i, wp_document_revisions.extension));
			}
		};

		WPDocumentRevisions.prototype.checkUpdate = function() {
			// Check whether an update is needed - via a 3rd field as amalgam of two input fields.
			var curr_content = this.$('#curr_content').val();
			if ( undefined === curr_content ) {
				return;
			}
			var post_content = this.$('#post_content').val();
			if ( curr_content === 'Unset' ) {
				// Clunky process to miss the first update (and keep the save button inactive). 
				this.$(':button, :submit', '#submitpost').prop('disabled', true);
				this.$('#curr_content').val(post_content);
				return;
			}
			var curr_text = this.getDescr();
			if ( curr_text !== curr_content || post_content !== curr_content ) {
				this.buildContent();
				this.enableSubmit();
			}
		}

		return WPDocumentRevisions;

	})();

	jQuery(function($) {
		return window.WPDocumentRevisions = new WPDocumentRevisions($);
	});

}).call(this);
