<?php
return [
    'fluent-crm' => [
        'name' => 'fluent-crm',
        'slug' => 'fluent-crm',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Fluent CRM', 'wp-cafe'),
        'description' => __('Connect with Fluent CRM to manage customer data and automate email marketing from your dashboard.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/wpc-fluentcrm-integration/',
        'icon' => '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M40 4C40 1.7924 38.2076 0 36 0H4C1.7924 0 0 1.7924 0 4V36C0 38.2076 1.7924 40 4 40H36C38.2076 40 40 38.2076 40 36V4Z" fill="#7742E6"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M33.4604 9.48242L9.324 15.9498C8.52504 16.1638 7.81905 16.6355 7.31552 17.2917C6.81199 17.9479 6.53906 18.752 6.53906 19.5791V22.111L28.2299 16.299C31.3151 15.4723 33.4604 12.6764 33.4604 9.48242ZM23.1277 20.6566L9.324 24.3554C8.52504 24.5694 7.81905 25.0411 7.31552 25.6973C6.81199 26.3535 6.53906 27.1576 6.53906 27.9847V30.5166L17.8971 27.4732C20.9824 26.6466 23.1277 23.8507 23.1277 20.6567V20.6566Z" fill="white"/>
</svg>
',
    ],
    'zapier' => [
        'name' => 'zapier',
        'slug' => 'zapier',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Zapier', 'wp-cafe'),
        'description' => __('Automate workflows by connecting with thousands of apps like Google Sheets and Slack.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/zapier-integration/',
        'icon' => '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_6600_3622)">
<path d="M24.9998 20.0088C25.0005 21.451 24.7404 22.8816 24.2319 24.2313C22.8817 24.7397 21.4509 25.0002 20.0081 25.0005H19.9912C18.5056 24.9986 17.0822 24.727 15.7687 24.2319C15.26 22.882 14.9995 21.4513 15 20.0088V19.9912C14.9993 18.5492 15.2592 17.119 15.7672 15.7694C17.1173 15.26 18.5484 14.9994 19.9914 15H20.0083C21.4511 14.9993 22.8821 15.2599 24.232 15.7692C24.7406 17.1187 25.0007 18.549 25 19.9911V20.0086L24.9998 20.0088ZM39.7222 16.6667H28.0478L36.3023 8.41156C35.6544 7.50143 34.9317 6.64696 34.1417 5.85703V5.85641C33.3517 5.06733 32.4974 4.34526 31.5878 3.69766L23.3327 11.9528V0.278437C22.2347 0.0937388 21.1234 0.000605765 20.01 0L19.9894 0C18.8569 0.000625 17.7477 0.096875 16.6667 0.278437V11.9528L8.41156 3.69766C7.50179 4.34508 6.64791 5.06767 5.85891 5.85781L5.85453 5.86094C5.06587 6.64988 4.34416 7.50303 3.69688 8.41156L11.9527 16.6667H0.278437C0.278437 16.6667 0 18.8594 0 19.9931V20.0069C0 21.1406 0.0960937 22.2517 0.278437 23.3333H11.9528L3.69703 31.5884C4.99573 33.4109 6.58906 35.0043 8.41156 36.303L16.6667 28.0472V39.7222C17.7634 39.906 18.8735 39.9989 19.9855 40H20.0138C21.1258 39.999 22.2358 39.9061 23.3325 39.7222V28.0472L31.5884 36.303C32.4979 35.6551 33.3519 34.9329 34.1417 34.1436L34.1436 34.1417C34.9325 33.3518 35.6546 32.4977 36.3023 31.5884L28.0466 23.3333H39.7222C39.9039 22.2536 39.9987 21.1458 40 20.0145V19.9855C39.9987 18.8542 39.9039 17.7464 39.7222 16.6667Z" fill="#FF4A00"/>
</g>
<defs>
<clipPath id="clip0_6600_3622">
<rect width="40" height="40" fill="white"/>
</clipPath>
</defs>
</svg>
',
    ],
    'pabbly' => [
        'name' => 'pabbly',
        'slug' => 'pabbly',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Pabbly', 'wp-cafe'),
        'description' => __('Integrate with Pabbly to automate business tasks and manage email marketing efficiently.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/pabbly-integration/',
        'icon' =>'<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_6753_1362)">
<path d="M40 19.9994C40 31.0417 31.0455 39.993 20 39.993C16.5368 39.993 13.2792 39.1134 10.4388 37.5648C4.2196 34.1742 0 27.5797 0 19.9994C0 8.95737 8.9543 0.00585938 19.9998 0.00585938C31.0455 0.00585938 40 8.95737 40 19.9994Z" fill="#20B276"/>
<path d="M27.9785 25.6892C25.862 27.8692 23.2931 28.9601 20.2729 28.9601C18.4295 28.9601 16.7168 28.6483 15.1113 27.7424L15.0919 39.3507L14.9398 39.3097L14.8456 39.2856L14.7345 39.2251L14.682 39.1303L14.6338 39.0234L14.6873 38.9563L9.39062 32.6447L9.39217 17.7247C9.39217 14.6159 10.4504 11.9756 12.5672 9.80332C14.6836 7.63089 17.2522 6.54492 20.2729 6.54492C23.2931 6.54492 25.8618 7.63476 27.9785 9.81523C30.0949 11.9954 31.1535 14.6412 31.1535 17.7524C31.1535 20.8639 30.0949 23.5092 27.9785 25.6892ZM23.9382 13.9736C22.9333 12.9375 21.7114 12.4197 20.2729 12.4197C18.8338 12.4197 17.612 12.9375 16.6073 13.9736C15.6023 15.0096 15.0998 16.269 15.0998 17.7527C15.0998 19.236 15.6022 20.4954 16.6073 21.5313C17.612 22.5676 18.8338 23.0857 20.2729 23.0857C21.7114 23.0857 22.9333 22.5676 23.9382 21.5313C24.9432 20.4954 25.4457 19.236 25.4457 17.7527C25.4457 16.269 24.9432 15.0095 23.9382 13.9736Z" fill="#147F52"/>
<path d="M27.56 25.2768C25.4432 27.4578 22.8744 28.5487 19.8538 28.5487C18.0104 28.5487 16.2861 28.0955 14.6807 27.1894L14.679 39.2861C14.679 39.2861 14.2882 39.1786 13.7797 39.0144C13.6543 38.9739 13.5276 38.9305 13.395 38.8837C13.3319 38.8612 13.3011 38.8481 13.2362 38.8294C13.0698 38.7816 12.8589 38.689 12.6963 38.6259C12.1502 38.4133 11.7077 38.2108 11.697 38.2058C11.6863 38.2006 10.1231 37.4552 9.9468 37.3451C9.78892 37.2465 9.64837 37.1693 9.52791 37.0829C9.48942 37.0554 9.46034 37.0357 9.42386 37.0106C9.13748 36.8139 8.97744 36.7008 8.97744 36.7008L8.97266 17.3102C8.97266 14.2002 10.0309 11.5591 12.1479 9.38635C14.2646 7.21311 16.8332 6.12695 19.854 6.12695C22.8746 6.12695 25.4432 7.21713 27.5602 9.39825C29.6767 11.5791 30.7355 14.2257 30.7355 17.3377C30.7351 20.4497 29.6765 23.096 27.56 25.2768ZM23.5194 13.5576C22.5143 12.5212 21.2926 12.0032 19.8537 12.0032C18.4146 12.0032 17.1927 12.5212 16.188 13.5576C15.1829 14.5939 14.6805 15.8537 14.6805 17.3377C14.6805 18.8215 15.1829 20.0814 16.188 21.1175C17.1927 22.1544 18.4146 22.6725 19.8537 22.6725C21.2924 22.6725 22.5143 22.1544 23.5194 21.1175C24.5242 20.0814 25.0271 18.8215 25.0271 17.3377C25.0271 15.8537 24.5242 14.5939 23.5194 13.5576Z" fill="white"/>
</g>
<defs>
<clipPath id="clip0_6753_1362">
<rect width="40" height="40" fill="white"/>
</clipPath>
</defs>
</svg>
',
    ],
    'twilio' => [
        'name' => 'twilio',
        'slug' => 'twilio',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Twilio', 'wp-cafe'),
        'description' => __('Enable real-time SMS notifications for new orders and reservations, improving communication with customers.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/twilio-sms-integration/',
        'icon' => '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_6600_3640)">
<path d="M19.9781 34.7341C11.8523 34.7341 5.265 28.1467 5.265 20.0211C5.265 11.8953 11.8523 5.30813 19.9781 5.30813C28.1038 5.30813 34.6909 11.8953 34.6909 20.0211C34.6909 28.1467 28.1038 34.7341 19.9781 34.7341ZM19.9781 0.0429688C8.94453 0.0429687 0 8.98766 0 20.0211C0 31.0547 8.94453 39.9991 19.9781 39.9991C31.0116 39.9991 39.9561 31.0547 39.9561 20.0211C39.9561 8.98766 31.0117 0.0429688 19.9781 0.0429688Z" fill="#CF272D"/>
<path d="M20.7984 15.0445C20.7984 12.7505 22.6583 10.8906 24.9525 10.8906C27.2467 10.8906 29.1064 12.7505 29.1064 15.0445C29.1064 17.3389 27.2467 19.1986 24.9525 19.1986C22.6583 19.1986 20.7984 17.3389 20.7984 15.0445ZM20.7984 24.9955C20.7984 22.7014 22.6583 20.8414 24.9525 20.8414C27.2467 20.8414 29.1064 22.7014 29.1064 24.9955C29.1064 27.2897 27.2467 29.1495 24.9525 29.1495C22.6583 29.1495 20.7984 27.2897 20.7984 24.9955ZM10.8477 24.9955C10.8477 22.7014 12.7077 20.8414 15.0017 20.8414C17.2959 20.8414 19.1558 22.7014 19.1558 24.9955C19.1558 27.2897 17.2959 29.1495 15.0017 29.1495C12.7077 29.1495 10.8477 27.2897 10.8477 24.9955ZM10.8477 15.0447C10.8477 12.7505 12.7077 10.8908 15.0017 10.8908C17.2959 10.8908 19.1558 12.7505 19.1558 15.0447C19.1558 17.3391 17.2959 19.1987 15.0017 19.1987C12.7077 19.1987 10.8477 17.3391 10.8477 15.0447Z" fill="#CF272D"/>
</g>
<defs>
<clipPath id="clip0_6600_3640">
<rect width="40" height="40" fill="white"/>
</clipPath>
</defs>
</svg>
',
    ],
    'thermal-printer' => [
        'name' => 'thermal-printer',
        'slug' => 'thermal-printer',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Thermal Printer', 'wp-cafe'),
        'description' => __('Print order receipts and tickets directly to a thermal printer, streamlining your kitchen operations.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/thermal-printer-integration/',
        'icon' => '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.2006 12.084H27.7969C29.2274 12.084 30.3785 12.084 31.3125 12.162C32.2747 12.2424 33.1129 12.4118 33.8904 12.8116C34.8212 13.2902 35.6204 13.985 36.2137 14.8385C36.7127 15.5564 36.9757 16.3583 37.1567 17.2833C37.3314 18.1763 37.4464 19.2847 37.5882 20.651L37.601 20.7743C37.7714 22.4148 37.9085 23.7368 37.9152 24.8062C37.9219 25.907 37.7947 26.8807 37.3374 27.7762C36.8005 28.8273 35.9722 29.7058 34.9524 30.3173C34.0907 30.8342 33.1187 31.0492 31.9932 31.1512C31.3262 31.2117 30.5577 31.2353 29.6724 31.2447C29.7657 31.6713 29.8435 32.056 29.8984 32.4003C30.0005 33.0415 30.0502 33.6887 29.9217 34.3457C29.636 35.8077 28.7342 37.101 27.4075 37.8032C26.7975 38.1262 26.154 38.2372 25.5339 38.287C24.9407 38.3345 24.2147 38.3345 23.3769 38.3345H16.6205C15.7826 38.3345 15.0566 38.3345 14.4634 38.287C13.8432 38.2372 13.1998 38.1262 12.5897 37.8032C11.2632 37.101 10.3613 35.8077 10.0756 34.3457C9.94718 33.6887 9.99678 33.0415 10.0989 32.4003C10.1538 32.056 10.2315 31.6713 10.325 31.2447C9.43978 31.2353 8.67121 31.2117 8.0042 31.1512C6.87876 31.0492 5.90678 30.8342 5.04503 30.3173C4.02511 29.7058 3.19686 28.8273 2.66006 27.7762C2.20273 26.8807 2.07556 25.907 2.08228 24.8062C2.08881 23.7368 2.2261 22.4145 2.39646 20.7738L2.40916 20.6513C2.55103 19.2848 2.6661 18.1765 2.84073 17.2833C3.02165 16.3583 3.28465 15.5564 3.78375 14.8385C4.3771 13.985 5.17621 13.2902 6.10701 12.8116C6.88455 12.4118 7.7227 12.2424 8.68491 12.162C9.6188 12.084 10.7701 12.084 12.2006 12.084ZM16.6842 28.3345C15.4057 28.3345 15.2034 28.3602 15.068 28.4107C14.793 28.5133 14.5285 28.7242 14.3387 29.041C14.2273 29.2268 14.1421 29.5073 13.8375 30.8293C13.6158 31.7915 13.4695 32.4307 13.3907 32.9248C13.3133 33.4112 13.3282 33.6102 13.347 33.7063C13.4538 34.2525 13.7753 34.6593 14.1493 34.8573C14.1769 34.8718 14.2985 34.9297 14.73 34.9643C15.1737 34.9998 15.7644 35.0012 16.6842 35.0012H23.3132C24.2329 35.0012 24.8237 34.9998 25.2672 34.9643C25.6989 34.9297 25.8204 34.8718 25.848 34.8573C26.222 34.6593 26.5435 34.2525 26.6504 33.7063C26.669 33.6102 26.684 33.4112 26.6065 32.9248C26.5279 32.4307 26.3815 31.7915 26.1599 30.8293C25.8552 29.5073 25.77 29.2268 25.6587 29.041C25.4689 28.7242 25.2044 28.5133 24.9292 28.4107C24.7939 28.3602 24.5917 28.3345 23.3132 28.3345H16.6842ZM28.332 20.0007C28.332 19.0802 29.0749 18.334 29.9912 18.334H30.0062C30.9225 18.334 31.6654 19.0802 31.6654 20.0007C31.6654 20.9212 30.9225 21.6673 30.0062 21.6673H29.9912C29.0749 21.6673 28.332 20.9212 28.332 20.0007Z" fill="#6B7280"/>
<path opacity="0.4" d="M21.7564 2.08399C23.2539 2.08394 24.5025 2.0839 25.4937 2.21719C26.54 2.35785 27.4847 2.6673 28.2439 3.42642C29.003 4.18554 29.3124 5.1302 29.453 6.17652C29.526 6.71964 29.559 7.8403 29.574 8.9889C29.5802 9.46617 29.5834 9.70479 29.4362 9.8536C29.289 10.0024 29.0474 10.002 28.5644 10.0011C28.3395 10.0006 28.1104 10.0007 27.877 10.0007H12.1288C11.8955 10.0007 11.6663 10.0006 11.4416 10.0011C10.9585 10.002 10.7169 10.0024 10.5697 9.8536C10.4226 9.70479 10.4257 9.46617 10.4319 8.9889C10.4468 7.8403 10.4798 6.71964 10.5528 6.17652C10.6935 5.1302 11.0029 4.18554 11.762 3.42642C12.5212 2.6673 13.4658 2.35785 14.5122 2.21719C15.5034 2.0839 16.7522 2.08394 18.2495 2.08399H21.7564Z" fill="#141B34"/>
</svg>
',
    ],
    'clover-pos' => [
        'name' => 'clover-pos',
        'slug' => 'clover-pos',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Clover POS', 'wp-cafe'),
        'description' => __('Connect online orders with your Clover POS system for centralized sales and inventory management.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/integrations/woocommerce-clover-pos-integration/',
        'icon' => '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.66448 26.7283C4.8766 21.9041 6.15539 19.898 9.25842 16.3828C12.5372 12.6737 15.816 8.96466 19.0948 5.24951C20.9372 3.1586 23.8584 3.29799 26.3796 3.64345C28.2342 3.89799 30.0948 4.15254 31.9311 4.52223C33.3493 4.80708 35.319 5.03738 36.4342 6.06769C36.9433 6.54041 37.3372 7.14648 37.6281 7.8192C38.7736 10.4495 38.1796 13.5283 36.3493 15.7344C32.2342 20.698 27.9251 24.995 23.8827 30.2131C23.0887 31.2374 22.2705 32.2859 21.1675 32.9707C20.0645 33.6556 18.5978 33.9041 17.4766 33.2616" fill="#6B7280"/>
<path opacity="0.5" d="M37.6289 7.82544C37.3926 7.28604 37.0895 6.79513 36.7198 6.37695C36.5501 7.15271 36.1017 7.85574 35.3744 8.24968C36.2895 10.783 35.6653 13.6497 33.932 15.7406C29.8168 20.7042 25.5077 25.0012 21.4653 30.2194C20.6714 31.2436 19.8532 32.2921 18.7501 32.977C18.4592 33.1588 18.138 33.3042 17.8047 33.4194C18.8774 33.8557 20.1683 33.5951 21.1683 32.977C22.2714 32.2921 23.0895 31.2497 23.8835 30.2194C27.9259 25.0012 32.235 20.7042 36.3501 15.7406C38.1804 13.5345 38.7744 10.4557 37.6289 7.82544Z" fill="#1A1A1A"/>
<path d="M6.8273 27.0605C5.53033 28.5636 4.66367 29.4908 3.28185 30.9212C2.50609 31.7212 0.875789 33.1636 2.43943 34.109C4.46973 35.3454 6.86973 35.6545 9.11821 36.2181C11.1606 36.7272 13.5728 36.8787 15.0697 35.1151C16.6576 33.2484 17.8091 31.6242 19.397 29.7636L6.8273 27.0605Z" fill="#FEC41B"/>
<path d="M18.1741 31.3149C18.7741 30.5573 18.7134 30.5755 19.4044 29.7634L6.8286 27.0664C6.02254 27.9997 6.04072 27.9331 5.34375 28.6785L17.6407 31.3149H18.1741Z" fill="black" fill-opacity="0.0627451"/>
<path d="M23.6817 3.97656C21.8756 6.27353 20.0756 8.5705 18.2695 10.8675C22.3423 11.9584 23.021 12.0978 28.0453 12.625C30.5726 9.84929 31.6817 8.30384 34.1968 5.09777" fill="white"/>
<path d="M11.5667 21.6257C11.6669 21.1611 10.9815 20.6192 10.0359 20.4152C9.09035 20.2113 8.24256 20.4226 8.14236 20.8873C8.04217 21.3519 8.7275 21.8938 9.67309 22.0978C10.6187 22.3017 11.4665 22.0904 11.5667 21.6257Z" fill="white"/>
<path d="M16.2307 22.6257C16.3309 22.1611 15.6456 21.6192 14.7 21.4152C13.7544 21.2113 12.9066 21.4226 12.8064 21.8873C12.7062 22.3519 13.3916 22.8938 14.3372 23.0978C15.2827 23.3017 16.1305 23.0904 16.2307 22.6257Z" fill="white"/>
<path d="M20.8987 23.6277C20.9989 23.1631 20.3136 22.6211 19.368 22.4172C18.4224 22.2133 17.5746 22.4246 17.4744 22.8892C17.3742 23.3538 18.0595 23.8958 19.0051 24.0997C19.9507 24.3036 20.7985 24.0923 20.8987 23.6277Z" fill="white"/>
<path d="M14.2659 18.0515C14.3661 17.5869 13.6808 17.0449 12.7352 16.841C11.7896 16.6371 10.9418 16.8484 10.8416 17.313C10.7414 17.7776 11.4267 18.3196 12.3723 18.5235C13.3179 18.7275 14.1657 18.5161 14.2659 18.0515Z" fill="white"/>
<path d="M18.926 19.0593C19.0262 18.5947 18.3409 18.0527 17.3953 17.8488C16.4497 17.6449 15.6019 17.8562 15.5017 18.3208C15.4015 18.7855 16.0869 19.3274 17.0325 19.5314C17.9781 19.7353 18.8258 19.5239 18.926 19.0593Z" fill="white"/>
<path d="M23.594 20.0613C23.6942 19.5967 23.0089 19.0547 22.0633 18.8508C21.1177 18.6468 20.2699 18.8582 20.1697 19.3228C20.0695 19.7874 20.7548 20.3294 21.7004 20.5333C22.646 20.7372 23.4938 20.5259 23.594 20.0613Z" fill="white"/>
<path d="M16.8909 14.4812C16.9911 14.0166 16.3058 13.4746 15.3602 13.2707C14.4146 13.0668 13.5668 13.2781 13.4666 13.7427C13.3664 14.2073 14.0517 14.7493 14.9973 14.9532C15.9429 15.1572 16.7907 14.9458 16.8909 14.4812Z" fill="white"/>
<path d="M21.5589 15.4832C21.6591 15.0185 20.9737 14.4766 20.0281 14.2726C19.0825 14.0687 18.2348 14.2801 18.1346 14.7447C18.0344 15.2093 18.7197 15.7513 19.6653 15.9552C20.6109 16.1591 21.4587 15.9478 21.5589 15.4832Z" fill="white"/>
<path d="M26.2268 16.4851C26.327 16.0205 25.6417 15.4785 24.6961 15.2746C23.7505 15.0707 22.9027 15.282 22.8025 15.7466C22.7023 16.2112 23.3877 16.7532 24.3332 16.9571C25.2788 17.1611 26.1266 16.9497 26.2268 16.4851Z" fill="white"/>
<path d="M18.9455 34.0854C18.3758 34.0854 17.8 33.9581 17.2546 33.649C17.0425 33.5278 16.9697 33.2611 17.0909 33.049C17.2122 32.8369 17.4788 32.7642 17.6909 32.8854C18.5697 33.3884 19.8425 33.2793 20.9334 32.6005C21.9819 31.952 22.7697 30.9339 23.5334 29.952C25.8909 26.9036 28.3758 24.1339 30.7819 21.449C32.5091 19.5217 34.2909 17.5339 36.0122 15.4611C37.794 13.3157 38.2667 10.3884 37.2243 8.00053C36.9334 7.33992 36.5697 6.80053 36.1334 6.39447C35.2728 5.59447 33.7334 5.30962 32.4909 5.07932C32.2667 5.03689 32.0485 4.99447 31.8425 4.95811C30.0122 4.58841 28.1334 4.33386 26.3212 4.08538C23.7273 3.73386 21.0909 3.66114 19.4303 5.54598L9.59397 16.6733C6.52125 20.152 5.34549 22.0308 6.10307 26.6551C6.13943 26.8975 5.98185 27.1217 5.73943 27.1642C5.50307 27.2066 5.27276 27.043 5.23034 26.8005C4.41822 21.8187 5.73337 19.7157 8.93337 16.0914L18.7697 4.95811C20.7152 2.75811 23.7394 2.83689 26.4425 3.20659C28.2728 3.45507 30.1637 3.71568 32.0243 4.09144C32.2243 4.13386 32.4364 4.17023 32.6546 4.21265C34.0061 4.4672 35.6909 4.77629 36.7334 5.74598C37.2606 6.23689 37.697 6.87326 38.0364 7.64901C39.2061 10.3399 38.6788 13.6248 36.6909 16.0248C34.9637 18.1096 33.1697 20.1096 31.4425 22.043C29.0485 24.7157 26.5758 27.4733 24.2364 30.4975C23.4667 31.4975 22.5879 32.6248 21.4061 33.3581C20.7334 33.7642 19.8546 34.0854 18.9455 34.0854Z" fill="#1D222B"/>
<path d="M11.5678 36.9944C10.7981 36.9944 9.94358 36.8793 9.0163 36.6489C8.52539 36.5277 8.02842 36.4186 7.53145 36.3035C5.72539 35.9035 3.86479 35.4914 2.2163 34.4853C1.70721 34.1762 1.42236 33.7823 1.36176 33.3156C1.24661 32.3641 2.13145 31.4671 2.77994 30.8065L2.96782 30.6126C4.33145 29.2005 5.20418 28.2671 6.49509 26.7702C6.65267 26.5883 6.93145 26.5641 7.11933 26.7217C7.30115 26.8793 7.32539 27.158 7.16782 27.3459C5.86479 28.855 4.97994 29.8005 3.60418 31.2247L3.41024 31.4247C2.94964 31.8914 2.17388 32.6793 2.24054 33.2065C2.24661 33.2793 2.27691 33.4914 2.67691 33.7338C4.19812 34.6611 5.99206 35.055 7.72539 35.4429C8.23448 35.558 8.73751 35.6671 9.23448 35.7944C11.8405 36.4429 13.6405 36.1277 14.7436 34.8308C15.5315 33.9035 16.2284 33.0186 16.8951 32.1641C17.5739 31.3035 18.2708 30.4126 19.0708 29.4732C19.2284 29.2853 19.5072 29.2671 19.6951 29.4247C19.883 29.5823 19.9012 29.8611 19.7436 30.0489C18.9557 30.9762 18.2587 31.8611 17.5921 32.7156C16.9133 33.5762 16.2163 34.4671 15.4163 35.4065C14.5133 36.4611 13.2224 36.9944 11.5678 36.9944Z" fill="#1D222B"/>
<path d="M20.5978 30.436C20.512 30.4372 20.4264 30.427 20.3432 30.4057C19.4705 30.2299 18.4947 30.036 17.4584 29.836C13.5917 29.0784 8.78565 28.139 5.53717 27.1511C5.48185 27.134 5.43045 27.1062 5.38589 27.0692C5.34134 27.0322 5.3045 26.9868 5.27749 26.9356C5.25048 26.8844 5.23381 26.8284 5.22845 26.7707C5.2231 26.7131 5.22915 26.6549 5.24626 26.5996C5.26337 26.5443 5.29121 26.4929 5.32818 26.4483C5.36516 26.4038 5.41055 26.3669 5.46177 26.3399C5.56519 26.2854 5.68606 26.2741 5.79777 26.3087C9.00383 27.2784 13.7857 28.2178 17.6341 28.9693C18.6705 29.1754 19.6523 29.3632 20.525 29.5451C20.5372 29.5451 20.5493 29.5511 20.5614 29.5511C20.5735 29.5329 20.5917 29.5026 20.616 29.4663C20.719 29.2905 20.719 29.0117 20.725 28.7693L20.7372 25.8541C20.7372 25.5147 21.0766 25.0117 28.6826 15.8299C31.8887 11.9572 35.2038 7.95717 36.3008 6.47839C36.4463 6.28445 36.719 6.24202 36.919 6.38748C37.1129 6.53293 37.1553 6.80566 37.0099 7.00566C35.8947 8.50263 32.5735 12.5147 29.3614 16.3996C25.919 20.5269 22.0402 25.2117 21.6099 25.939L21.5978 28.7693C21.5978 29.0905 21.5917 29.5269 21.3675 29.9147C21.2099 30.1814 21.016 30.436 20.5978 30.436Z" fill="#1D222B"/>
<path d="M28.0485 13.0617H28C22.8728 12.5223 22.1637 12.3647 18.1576 11.292C18.0874 11.2731 18.0229 11.237 17.97 11.187C17.9171 11.137 17.8775 11.0747 17.8547 11.0056C17.8318 10.9365 17.8265 10.8628 17.8392 10.7911C17.8519 10.7195 17.8822 10.6521 17.9273 10.595L23.3394 3.70411C23.3749 3.65833 23.4192 3.62007 23.4697 3.59157C23.5201 3.56308 23.5757 3.54492 23.6333 3.53815C23.6908 3.53138 23.7491 3.53613 23.8048 3.55214C23.8605 3.56815 23.9125 3.59509 23.9576 3.63139C24.1516 3.7829 24.1819 4.06169 24.0303 4.24957L19.0303 10.6132C22.4243 11.5162 23.2667 11.6738 27.8667 12.1587C29.8 10.0253 30.891 8.61926 32.5213 6.51623C32.9213 6.00108 33.3576 5.44351 33.8425 4.81926C33.994 4.62533 34.2667 4.59502 34.4607 4.74654C34.6546 4.89805 34.6849 5.17684 34.5334 5.36472C34.0485 5.9829 33.6182 6.54048 33.2122 7.05563C31.5273 9.22533 30.4122 10.6617 28.3637 12.9162C28.291 13.0071 28.1697 13.0617 28.0485 13.0617ZM10.3758 22.4738C10.1334 22.4738 9.87883 22.4435 9.6061 22.389C8.46671 22.1405 7.70913 21.4738 7.84853 20.8314C7.92126 20.492 8.22429 20.2374 8.69701 20.1223C9.09701 20.0253 9.59398 20.0253 10.097 20.1344C10.6 20.2435 11.0546 20.4435 11.3758 20.6981C11.7576 21.0011 11.9273 21.3526 11.8546 21.692C11.7455 22.1829 11.1516 22.4738 10.3758 22.4738ZM9.32126 20.6374C9.1455 20.6374 8.9758 20.6556 8.83035 20.692C8.60004 20.7526 8.44247 20.8496 8.41823 20.9526C8.36974 21.1708 8.86671 21.6253 9.72732 21.8132C10.5819 21.995 11.2243 21.789 11.2728 21.5647C11.297 21.4617 11.194 21.3041 11.0061 21.1587C10.7576 20.9587 10.3758 20.795 9.96974 20.7102C9.7455 20.6617 9.52732 20.6374 9.32126 20.6374ZM15.0425 23.4799C14.8 23.4799 14.5455 23.4496 14.2728 23.395C13.1334 23.1465 12.3758 22.4799 12.5152 21.8374C12.5879 21.4981 12.891 21.2435 13.3637 21.1284C13.7637 21.0314 14.2606 21.0314 14.7637 21.1405C15.2667 21.2496 15.7213 21.4496 16.0425 21.7041C16.4243 22.0071 16.594 22.3587 16.5213 22.6981C16.4061 23.189 15.8182 23.4799 15.0425 23.4799ZM13.9879 21.6435C13.8122 21.6435 13.6425 21.6617 13.497 21.6981C13.2667 21.7587 13.1091 21.8556 13.0849 21.9587C13.0364 22.1768 13.5334 22.6314 14.394 22.8193C15.2485 23.0011 15.891 22.795 15.9394 22.5708C15.9637 22.4678 15.8607 22.3102 15.6728 22.1647C15.4243 21.9647 15.0425 21.8011 14.6364 21.7162C14.4122 21.6678 14.194 21.6435 13.9879 21.6435ZM19.7031 24.4799C19.4606 24.4799 19.2061 24.4496 18.9334 24.395C17.794 24.1465 17.0364 23.4799 17.1758 22.8374C17.3152 22.195 18.2788 21.892 19.4182 22.1405C19.9213 22.2496 20.3758 22.4496 20.697 22.7041C21.0788 23.0071 21.2485 23.3587 21.1758 23.6981C21.0728 24.189 20.4849 24.4799 19.7031 24.4799ZM18.6607 22.6435C18.1394 22.6435 17.7879 22.8011 17.7516 22.9587C17.7031 23.1768 18.2 23.6314 19.0607 23.8193C19.9152 24.0011 20.5576 23.795 20.6061 23.5708C20.6303 23.4677 20.5273 23.3102 20.3394 23.1647C20.091 22.9647 19.7091 22.8011 19.3031 22.7162C19.0667 22.6678 18.8546 22.6435 18.6607 22.6435ZM13.0667 18.9041C12.8243 18.9041 12.5697 18.8738 12.297 18.8193C11.1576 18.5708 10.4 17.9041 10.5394 17.2617C10.6788 16.6193 11.6425 16.3162 12.7819 16.5647C13.2849 16.6738 13.7394 16.8738 14.0607 17.1284C14.4425 17.4314 14.6122 17.7829 14.5394 18.1223C14.4364 18.6132 13.8485 18.9041 13.0667 18.9041ZM12.0243 17.0678C11.5031 17.0678 11.1516 17.2253 11.1152 17.3829C11.0667 17.6011 11.5637 18.0556 12.4243 18.2435C13.2788 18.4253 13.9213 18.2193 13.9697 18.0011C13.994 17.8981 13.891 17.7405 13.7031 17.595C13.4546 17.395 13.0728 17.2314 12.6667 17.1465C12.4303 17.0859 12.2182 17.0678 12.0243 17.0678ZM17.7334 19.9041C17.491 19.9041 17.2364 19.8738 16.9637 19.8193C15.8243 19.5708 15.0667 18.9041 15.2061 18.2617C15.3455 17.6193 16.3091 17.3162 17.4485 17.5647C17.9516 17.6738 18.4061 17.8738 18.7273 18.1284C19.1091 18.4314 19.2788 18.7829 19.2061 19.1223C19.1031 19.6132 18.5152 19.9041 17.7334 19.9041ZM16.691 18.0677C16.1697 18.0677 15.8182 18.2253 15.7819 18.3829C15.7334 18.6011 16.2303 19.0556 17.091 19.2435C17.9516 19.4253 18.5879 19.2193 18.6364 19.0011C18.6607 18.8981 18.5576 18.7405 18.3697 18.595C18.1213 18.395 17.7394 18.2314 17.3334 18.1465C17.097 18.092 16.8788 18.0677 16.691 18.0677ZM22.4 20.9102C22.1576 20.9102 21.9031 20.8799 21.6303 20.8253C21.1273 20.7162 20.6728 20.5162 20.3516 20.2617C19.9697 19.9587 19.8 19.6071 19.8728 19.2678C20.0122 18.6253 20.9758 18.3223 22.1152 18.5708C22.6182 18.6799 23.0728 18.8799 23.394 19.1344C23.7758 19.4374 23.9455 19.789 23.8728 20.1284C23.7697 20.6193 23.1819 20.9102 22.4 20.9102ZM21.3576 19.0738C20.8364 19.0738 20.4849 19.2314 20.4485 19.389C20.4243 19.492 20.5273 19.6496 20.7152 19.795C20.9637 19.995 21.3455 20.1587 21.7516 20.2435C22.6061 20.4253 23.2485 20.2193 23.297 20.0011C23.3213 19.8981 23.2182 19.7405 23.0303 19.595C22.7819 19.395 22.4 19.2314 21.994 19.1465C21.7637 19.0981 21.5455 19.0738 21.3576 19.0738ZM15.7031 15.3284C15.4546 15.3284 15.2 15.2981 14.9394 15.2435C14.4364 15.1344 13.9819 14.9344 13.6607 14.6799C13.2788 14.3768 13.1091 14.0253 13.1819 13.6859C13.2546 13.3465 13.5576 13.092 14.0303 12.9768C14.4303 12.8799 14.9273 12.8799 15.4303 12.989C16.5697 13.2314 17.3273 13.9041 17.1879 14.5465C17.1152 14.8859 16.8122 15.1405 16.3394 15.2556C16.1394 15.3041 15.9273 15.3284 15.7031 15.3284ZM14.6546 13.492C14.4788 13.492 14.3091 13.5102 14.1637 13.5465C13.9334 13.6071 13.7758 13.7041 13.7516 13.8071C13.7273 13.9102 13.8303 14.0677 14.0182 14.2193C14.2667 14.4193 14.6485 14.5829 15.0546 14.6678C15.4606 14.7526 15.8728 14.7587 16.1879 14.6859C16.4182 14.6253 16.5758 14.5284 16.6 14.4253C16.6485 14.2071 16.1516 13.7526 15.291 13.5647C15.0788 13.5162 14.8546 13.492 14.6546 13.492ZM20.3637 16.3344C20.1152 16.3344 19.8607 16.3041 19.6 16.2496C19.097 16.1405 18.6425 15.9405 18.3213 15.6859C17.9394 15.3829 17.7697 15.0314 17.8425 14.692C17.9152 14.3526 18.2182 14.0981 18.691 13.9829C19.091 13.8859 19.5879 13.8859 20.091 13.995C20.594 14.1041 21.0485 14.3041 21.3697 14.5587C21.7516 14.8617 21.9213 15.2132 21.8485 15.5526C21.7758 15.892 21.4728 16.1465 21 16.2617C20.8061 16.3102 20.594 16.3344 20.3637 16.3344ZM19.3213 14.4981C19.1455 14.4981 18.9758 14.5162 18.8303 14.5526C18.6 14.6132 18.4425 14.7102 18.4182 14.8132C18.394 14.9162 18.497 15.0738 18.6849 15.2253C18.9334 15.4253 19.3152 15.589 19.7213 15.6738C20.1273 15.7587 20.5394 15.7708 20.8546 15.692C21.0849 15.6314 21.2425 15.5344 21.2667 15.4314C21.291 15.3284 21.1879 15.1708 21 15.0193C20.7516 14.8193 20.3697 14.6556 19.9637 14.5708C19.7455 14.5223 19.5213 14.4981 19.3213 14.4981ZM25.0364 17.3405C24.794 17.3405 24.5394 17.3102 24.2667 17.2556C23.1273 17.0132 22.3697 16.3405 22.5091 15.6981C22.6485 15.0556 23.6122 14.7587 24.7516 15.0011C25.2546 15.1102 25.7091 15.3102 26.0303 15.5647C26.4122 15.8678 26.5819 16.2193 26.5091 16.5587C26.4061 17.0496 25.8182 17.3405 25.0364 17.3405ZM23.9879 15.5041C23.4667 15.5041 23.1152 15.6617 23.0788 15.8193C23.0303 16.0374 23.5273 16.492 24.3879 16.6799C25.2485 16.8617 25.8849 16.6556 25.9334 16.4374C25.9576 16.3344 25.8546 16.1768 25.6667 16.0314C25.4182 15.8314 25.0364 15.6677 24.6303 15.5829C24.394 15.5223 24.1819 15.5041 23.9879 15.5041Z" fill="#1D222B"/>
<path d="M31.7493 18.1271C31.7068 18.0846 31.9856 17.7331 32.4462 17.1877C32.9068 16.6422 33.5553 15.9028 34.1796 15.024C34.8038 14.1453 35.2402 13.2786 35.4765 12.618C35.719 11.9574 35.8038 11.521 35.8705 11.5331C35.919 11.5392 35.9432 11.9937 35.7614 12.7089C35.5917 13.424 35.1674 14.3634 34.519 15.2665C33.8765 16.1756 33.1796 16.8907 32.6583 17.3937C32.1432 17.8907 31.7917 18.1695 31.7493 18.1271ZM28.0341 4.93313C28.0705 5.05434 26.925 5.41798 25.7674 6.27858C24.5977 7.12101 23.9068 8.10283 23.7977 8.0301C23.7008 7.98767 24.2705 6.84222 25.519 5.93919C26.7553 5.02404 28.022 4.8301 28.0341 4.93313ZM15.0159 31.9877C15.0583 32.0119 14.9371 32.3998 14.5796 32.9574C14.3977 33.2301 14.1553 33.5513 13.8159 33.8422C13.4826 34.1392 13.022 34.3816 12.5068 34.4907C11.4583 34.6907 10.5493 34.3695 9.95531 34.1453C9.34925 33.8968 9.00986 33.6907 9.02804 33.6422C9.05228 33.5877 9.4341 33.6968 10.0462 33.8665C10.6523 34.018 11.5189 34.2604 12.422 34.0846C13.325 33.9089 13.9493 33.2604 14.3432 32.7877C14.7432 32.2968 14.9614 31.9574 15.0159 31.9877Z" fill="#1D222B"/>
</svg>
',
    ],
    'google-map' => [
        'name' => 'google-map',
        'slug' => 'google-map',
        'type' => 'integration',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Google Map', 'wp-cafe'),
        'description' => __('Helps you accurately set and display the precise location of your restaurant branches on a map, making it easy for customers to find your business.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/delivery-module/store-added-in-google-maps/',
        'icon' => '<svg width="28" height="40" viewBox="0 0 28 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_6753_1171)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M18.2294 0.650281C16.8945 0.22992 15.4746 0 14.0001 0C9.69798 0 5.84799 1.9386 3.28125 4.98409L9.89516 10.5307L18.2293 0.650161L18.2294 0.650281Z" fill="#1A73E8"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M3.27963 4.98438C1.23474 7.40994 0 10.5401 0 13.9546C0 16.5797 0.524856 18.7059 1.38642 20.6113L9.89354 10.531L3.27963 4.98438Z" fill="#EA4335"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.0025 8.6196C16.9606 8.6196 19.3574 11.0088 19.3574 13.9576C19.3574 15.2701 18.881 16.4738 18.0923 17.4023C18.0923 17.4023 22.3216 12.388 26.4264 7.52472C24.7304 4.27355 21.7906 1.77239 18.2348 0.650391L9.89453 10.531C10.8776 9.3606 12.3521 8.6196 14.0025 8.6196Z" fill="#4285F4"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.0018 19.2919C11.0437 19.2919 8.64695 16.9027 8.64695 13.9539C8.64695 12.6504 9.11715 11.4558 9.89384 10.5273L1.38672 20.6106C2.83994 23.8255 5.25802 26.4053 7.74892 29.6563L18.0885 17.4017C17.1085 18.557 15.6401 19.2919 14.0018 19.2919Z" fill="#FBBC04"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M17.8833 33.0025C22.5525 25.7229 27.9984 22.4173 27.9984 13.9551C27.9984 11.6354 27.428 9.44887 26.4238 7.52539L7.75 29.6576C8.54186 30.692 9.33974 31.7928 10.1194 33.0056C12.9592 37.3789 12.1703 40.0009 14.0029 40.0009C15.8293 40.0009 15.0435 37.3758 17.8833 33.0025Z" fill="#34A853"/>
</g>
<defs>
<clipPath id="clip0_6753_1171">
<rect width="28" height="40" fill="white"/>
</clipPath>
</defs>
</svg>
',
    ],
];