<?php
return [
    'reservation' => [
        'name' => 'reservation',
        'slug' => 'reservation',
        'type' => 'module',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Reservation', 'wp-cafe'),
        'description' => __('Allows customers to book tables online for specific dates and times, giving you full control over your restaurant’s schedule.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => '',
        'icon' => wpc_get_addons_icon_url('reservation'),
    ],
    'food_ordering' => [
        'name' => 'food_ordering',
        'slug' => 'food_ordering',
        'type' => 'module',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Food Ordering', 'wp-cafe'),
        'description' => __('Enables customers to place online orders from your restaurant website. Integrating with WooCommerce for seamless checkout and order management.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => '',
        'icon' => wpc_get_addons_icon_url('food-order'),
    ],
    'qr_code' => [
        'name' => 'qr_code',
        'slug' => 'qr_code',
        'type' => 'module',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('QR Code', 'wp-cafe'),
        'description' => __('Allows customers to access the menu and place orders by scanning a QR code at their table.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/qr-code',
        'doc_link' => 'http://support.themewinter.com/docs/plugins/plugin-docs/food-ordering/food-ordering-with-qr-code/',
        'icon' => '<?xml version="1.0" encoding="utf-8"?>
<svg fill="#000000" width="24" height="24" viewBox="0 0 56 56" xmlns="http://www.w3.org/2000/svg"><path d="M 34.4335 26.0664 L 45.0976 26.0664 C 48.0976 26.0664 49.5743 24.5664 49.5743 21.4727 L 49.5743 10.9961 C 49.5743 7.9023 48.0976 6.4258 45.0976 6.4258 L 34.4335 6.4258 C 31.4570 6.4258 29.9570 7.9023 29.9570 10.9961 L 29.9570 21.4727 C 29.9570 24.5664 31.4570 26.0664 34.4335 26.0664 Z M 10.9023 26.0664 L 21.5898 26.0664 C 24.5663 26.0664 26.0663 24.5664 26.0663 21.4727 L 26.0663 10.9961 C 26.0663 7.9023 24.5663 6.4258 21.5898 6.4258 L 10.9023 6.4258 C 7.9257 6.4258 6.4257 7.9023 6.4257 10.9961 L 6.4257 21.4727 C 6.4257 24.5664 7.9257 26.0664 10.9023 26.0664 Z M 10.9492 22.7617 C 10.1288 22.7617 9.7304 22.3398 9.7304 21.4727 L 9.7304 10.9961 C 9.7304 10.1523 10.1288 9.7305 10.9492 9.7305 L 21.5195 9.7305 C 22.3398 9.7305 22.7617 10.1523 22.7617 10.9961 L 22.7617 21.4727 C 22.7617 22.3398 22.3398 22.7617 21.5195 22.7617 Z M 34.4804 22.7617 C 33.6601 22.7617 33.2617 22.3398 33.2617 21.4727 L 33.2617 10.9961 C 33.2617 10.1523 33.6601 9.7305 34.4804 9.7305 L 45.0742 9.7305 C 45.8710 9.7305 46.2695 10.1523 46.2695 10.9961 L 46.2695 21.4727 C 46.2695 22.3398 45.8710 22.7617 45.0742 22.7617 Z M 14.2304 18.7071 L 18.2382 18.7071 C 18.5898 18.7071 18.7304 18.5664 18.7304 18.1680 L 18.7304 14.2774 C 18.7304 13.9023 18.5898 13.7617 18.2382 13.7617 L 14.2304 13.7617 C 13.8788 13.7617 13.7851 13.9023 13.7851 14.2774 L 13.7851 18.1680 C 13.7851 18.5664 13.8788 18.7071 14.2304 18.7071 Z M 37.9023 18.7071 L 41.8866 18.7071 C 42.2382 18.7071 42.3788 18.5664 42.3788 18.1680 L 42.3788 14.2774 C 42.3788 13.9023 42.2382 13.7617 41.8866 13.7617 L 37.9023 13.7617 C 37.5507 13.7617 37.4335 13.9023 37.4335 14.2774 L 37.4335 18.1680 C 37.4335 18.5664 37.5507 18.7071 37.9023 18.7071 Z M 10.9023 49.5742 L 21.5898 49.5742 C 24.5663 49.5742 26.0663 48.0977 26.0663 45.0039 L 26.0663 34.5039 C 26.0663 31.4336 24.5663 29.9336 21.5898 29.9336 L 10.9023 29.9336 C 7.9257 29.9336 6.4257 31.4336 6.4257 34.5039 L 6.4257 45.0039 C 6.4257 48.0977 7.9257 49.5742 10.9023 49.5742 Z M 31.5273 36.0039 L 35.5351 36.0039 C 35.8866 36.0039 36.0273 35.8633 36.0273 35.4649 L 36.0273 31.5742 C 36.0273 31.1992 35.8866 31.0586 35.5351 31.0586 L 31.5273 31.0586 C 31.1757 31.0586 31.0820 31.1992 31.0820 31.5742 L 31.0820 35.4649 C 31.0820 35.8633 31.1757 36.0039 31.5273 36.0039 Z M 43.9726 36.0039 L 47.9804 36.0039 C 48.3320 36.0039 48.4727 35.8633 48.4727 35.4649 L 48.4727 31.5742 C 48.4727 31.1992 48.3320 31.0586 47.9804 31.0586 L 43.9726 31.0586 C 43.6210 31.0586 43.5039 31.1992 43.5039 31.5742 L 43.5039 35.4649 C 43.5039 35.8633 43.6210 36.0039 43.9726 36.0039 Z M 10.9492 46.2695 C 10.1288 46.2695 9.7304 45.8477 9.7304 45.0039 L 9.7304 34.5274 C 9.7304 33.6602 10.1288 33.2383 10.9492 33.2383 L 21.5195 33.2383 C 22.3398 33.2383 22.7617 33.6602 22.7617 34.5274 L 22.7617 45.0039 C 22.7617 45.8477 22.3398 46.2695 21.5195 46.2695 Z M 14.2304 42.2383 L 18.2382 42.2383 C 18.5898 42.2383 18.7304 42.0977 18.7304 41.6758 L 18.7304 37.8086 C 18.7304 37.4336 18.5898 37.2930 18.2382 37.2930 L 14.2304 37.2930 C 13.8788 37.2930 13.7851 37.4336 13.7851 37.8086 L 13.7851 41.6758 C 13.7851 42.0977 13.8788 42.2383 14.2304 42.2383 Z M 37.8085 42.2383 L 41.8163 42.2383 C 42.1679 42.2383 42.3085 42.0977 42.3085 41.6758 L 42.3085 37.8086 C 42.3085 37.4336 42.1679 37.2930 41.8163 37.2930 L 37.8085 37.2930 C 37.4570 37.2930 37.3632 37.4336 37.3632 37.8086 L 37.3632 41.6758 C 37.3632 42.0977 37.4570 42.2383 37.8085 42.2383 Z M 31.5273 48.4492 L 35.5351 48.4492 C 35.8866 48.4492 36.0273 48.3086 36.0273 47.9102 L 36.0273 44.0195 C 36.0273 43.6445 35.8866 43.5039 35.5351 43.5039 L 31.5273 43.5039 C 31.1757 43.5039 31.0820 43.6445 31.0820 44.0195 L 31.0820 47.9102 C 31.0820 48.3086 31.1757 48.4492 31.5273 48.4492 Z M 43.9726 48.4492 L 47.9804 48.4492 C 48.3320 48.4492 48.4727 48.3086 48.4727 47.9102 L 48.4727 44.0195 C 48.4727 43.6445 48.3320 43.5039 47.9804 43.5039 L 43.9726 43.5039 C 43.6210 43.5039 43.5039 43.6445 43.5039 44.0195 L 43.5039 47.9102 C 43.5039 48.3086 43.6210 48.4492 43.9726 48.4492 Z"/></svg>',
    ],
    'table_layout' => [
        'name' => 'table_layout',
        'slug' => 'table_layout',
        'type' => 'module',
        'parent' => 'reservation',
        'status' => $table_layout_status,
        'is_pro' => true,
        'title' => __('Table Layout', 'wp-cafe'),
        'description' => __('Provides a visual table layout for your restaurant, letting customers select their preferred table when making a reservation.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/table-layout',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/reservation/table-selection-layout/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.21293 10.4682C4.75942 10.8333 5.52017 10.8333 7.04167 10.8333C8.56318 10.8333 9.32392 10.8333 9.87041 10.4682C10.107 10.3101 10.3101 10.107 10.4682 9.8704C10.8333 9.32391 10.8333 8.56317 10.8333 7.04167C10.8333 5.52017 10.8333 4.75942 10.4682 4.21293C10.3101 3.97635 10.107 3.77323 9.87041 3.61515C9.32392 3.25 8.56318 3.25 7.04167 3.25C5.52017 3.25 4.75942 3.25 4.21293 3.61515C3.97635 3.77323 3.77323 3.97635 3.61516 4.21293C3.25 4.75942 3.25 5.52017 3.25 7.04167C3.25 8.56317 3.25 9.32391 3.61516 9.8704C3.77323 10.107 3.97635 10.3101 4.21293 10.4682Z" stroke="#525266" stroke-width="1.625" stroke-linejoin="round"/>
<path d="M16.1308 10.4682C16.6774 10.8333 17.4381 10.8333 18.9596 10.8333C20.4811 10.8333 21.2419 10.8333 21.7883 10.4682C22.0249 10.3101 22.2281 10.107 22.3861 9.8704C22.7513 9.32391 22.7513 8.56317 22.7513 7.04167C22.7513 5.52017 22.7513 4.75942 22.3861 4.21293C22.2281 3.97635 22.0249 3.77323 21.7883 3.61515C21.2419 3.25 20.4811 3.25 18.9596 3.25C17.4381 3.25 16.6774 3.25 16.1308 3.61515C15.8943 3.77323 15.6912 3.97635 15.5331 4.21293C15.168 4.75942 15.168 5.52017 15.168 7.04167C15.168 8.56317 15.168 9.32391 15.5331 9.8704C15.6912 10.107 15.8943 10.3101 16.1308 10.4682Z" stroke="#525266" stroke-width="1.625" stroke-linejoin="round"/>
<path d="M4.21293 22.3842C4.75942 22.7494 5.52017 22.7493 7.04167 22.7493C8.56318 22.7493 9.32392 22.7494 9.87041 22.3842C10.107 22.2261 10.3101 22.023 10.4682 21.7864C10.8333 21.2399 10.8333 20.4792 10.8333 18.9577C10.8333 17.4361 10.8333 16.6754 10.4682 16.129C10.3101 15.8924 10.107 15.6893 9.87041 15.5312C9.32392 15.166 8.56318 15.166 7.04167 15.166C5.52017 15.166 4.75942 15.166 4.21293 15.5312C3.97635 15.6893 3.77323 15.8924 3.61516 16.129C3.25 16.6754 3.25 17.4361 3.25 18.9577C3.25 20.4792 3.25 21.2399 3.61516 21.7864C3.77323 22.023 3.97635 22.2261 4.21293 22.3842Z" stroke="#525266" stroke-width="1.625" stroke-linejoin="round"/>
<path d="M16.1308 22.3842C16.6774 22.7494 17.4381 22.7493 18.9596 22.7493C20.4811 22.7493 21.2419 22.7494 21.7883 22.3842C22.0249 22.2261 22.2281 22.023 22.3861 21.7864C22.7513 21.2399 22.7513 20.4792 22.7513 18.9577C22.7513 17.4361 22.7513 16.6754 22.3861 16.129C22.2281 15.8924 22.0249 15.6893 21.7883 15.5312C21.2419 15.166 20.4811 15.166 18.9596 15.166C17.4381 15.166 16.6774 15.166 16.1308 15.5312C15.8943 15.6893 15.6912 15.8924 15.5331 16.129C15.168 16.6754 15.168 17.4361 15.168 18.9577C15.168 20.4792 15.168 21.2399 15.5331 21.7864C15.6912 22.023 15.8943 22.2261 16.1308 22.3842Z" stroke="#525266" stroke-width="1.625" stroke-linejoin="round"/>
</svg>
',
    ],
    'delivery' => [
        'name' => 'delivery',
        'slug' => 'delivery',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => $delivery_module_status,
        'is_pro' => true,
        'title' => __('Delivery', 'wp-cafe'),
        'description' => __('Manage and automate your food delivery service, including setting up delivery areas, times, and fees.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/settings?tab=delivery',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/restaurant-delivery-setup-in-wpcafe/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.16406 14.547V8.66602H23.8307V14.547C23.8307 18.9243 23.8307 21.113 22.4206 22.4728C21.0103 23.8327 18.7406 23.8327 14.2011 23.8327H11.7937C7.25424 23.8327 4.98452 23.8327 3.57429 22.4728C2.16406 21.113 2.16406 18.9243 2.16406 14.547Z" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.16406 8.66602L3.20573 6.16602C4.01359 4.22713 4.41754 3.25769 5.23629 2.71185C6.05504 2.16602 7.10528 2.16602 9.20573 2.16602H16.7891C18.8895 2.16602 19.9397 2.16602 20.7585 2.71185C21.5773 3.25769 21.9812 4.22713 22.7891 6.16602L23.8307 8.66602" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 8.66602V2.16602" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.8359 13H15.1693" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
',
    ],
    'pickup' => [
        'name' => 'pickup',
        'slug' => 'pickup',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Pickup', 'wp-cafe'),
        'description' => __('Set up and manage food pickup options for your customers, allowing them to place orders online and collect them in-store.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/settings?tab=pickup',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/restaurant-pickup-setup-in-wpcafe/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.1276 18.9583C21.1276 20.4541 19.915 21.6667 18.4193 21.6667C16.9235 21.6667 15.7109 20.4541 15.7109 18.9583C15.7109 17.4626 16.9235 16.25 18.4193 16.25C19.915 16.25 21.1276 17.4626 21.1276 18.9583Z" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2917 18.9583C10.2917 20.4541 9.0791 21.6667 7.58333 21.6667C6.08756 21.6667 4.875 20.4541 4.875 18.9583C4.875 17.4626 6.08756 16.25 7.58333 16.25C9.0791 16.25 10.2917 17.4626 10.2917 18.9583Z" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.7057 18.959H10.2891M16.2474 16.7923V7.58398C16.2474 6.05192 16.2474 5.28589 15.7715 4.80994C15.2955 4.33398 14.5294 4.33398 12.9974 4.33398H5.41406C3.882 4.33398 3.11597 4.33398 2.64001 4.80994C2.16406 5.28589 2.16406 6.05192 2.16406 7.58398V16.2507C2.16406 17.2631 2.16406 17.7694 2.38177 18.1465C2.52439 18.3935 2.72953 18.5987 2.97656 18.7412C3.35365 18.959 3.85989 18.959 4.8724 18.959M16.7891 7.04232H18.7406C19.6394 7.04232 20.0888 7.04232 20.4613 7.25324C20.8338 7.46417 21.0651 7.84951 21.5275 8.6202L23.3676 11.6871C23.5977 12.0706 23.7128 12.2625 23.7718 12.4753C23.8307 12.6882 23.8307 12.9118 23.8307 13.3592V16.2507C23.8307 17.2631 23.8307 17.7694 23.613 18.1465C23.4704 18.3935 23.2652 18.5987 23.0182 18.7412C22.6411 18.959 22.1349 18.959 21.1224 18.959" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.03906 7.58398V11.9171M11.3724 7.58398V11.9171" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
',
    ],
    'tipping' => [
        'name' => 'tipping',
        'slug' => 'tipping',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Tipping', 'wp-cafe'),
        'description' => __('Allows customers to add a tip for your staff during checkout, giving you a way to increase revenue.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/settings?tab=tipping',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/how-to-set-up-tipping-using-wpcafe/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.6693 8.66667C21.6693 10.7607 19.9717 12.4583 17.8776 12.4583C15.7835 12.4583 14.0859 10.7607 14.0859 8.66667C14.0859 6.57258 15.7835 4.875 17.8776 4.875C19.9717 4.875 21.6693 6.57258 21.6693 8.66667Z" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.0644 5.33364C15.5723 3.81057 14.1426 2.70898 12.4557 2.70898C10.3616 2.70898 8.66406 4.40657 8.66406 6.50065C8.66406 8.59466 10.3616 10.2923 12.4557 10.2923C13.1104 10.2923 13.7263 10.1264 14.2637 9.83432" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.33594 14.625H6.93033C7.24899 14.625 7.56327 14.6968 7.84829 14.8347L10.0604 15.9051C10.3454 16.043 10.6597 16.1147 10.9784 16.1147H12.1079C13.2003 16.1147 14.0859 16.9717 14.0859 18.0288C14.0859 18.0715 14.0567 18.1091 14.0142 18.1208L11.2616 18.882C10.7678 19.0185 10.239 18.9709 9.77969 18.7486L7.41489 17.6045M14.0859 17.3333L19.0615 15.8046C19.9435 15.5298 20.897 15.8557 21.4495 16.6208C21.849 17.174 21.6863 17.9662 21.1043 18.302L12.9624 22.9997C12.4446 23.2985 11.8336 23.3714 11.2641 23.2024L4.33594 21.1466" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
',
    ],
    'discount' => [
        'name' => 'discount',
        'slug' => 'discount',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Discount', 'wp-cafe'),
        'description' => __('Create and manage various discount offers and coupons for your menu items, encouraging more sales and repeat customers.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/discount',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/how-to-add-discounts-using-wpcafe/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.7773 23.3043L9.5778 21.9988C9.01957 21.6675 8.74045 21.5018 8.43068 21.4922C8.09593 21.4818 7.81187 21.6408 7.20866 21.9988C6.53308 22.3999 5.18974 23.5044 4.32079 22.9777C3.78906 22.6553 3.78906 21.8365 3.78906 20.1989V8.66602C3.78906 5.60188 3.78906 4.06982 4.74097 3.11792C5.69287 2.16602 7.22493 2.16602 10.2891 2.16602H15.7057C18.7698 2.16602 20.3019 2.16602 21.2538 3.11792C22.2057 4.06982 22.2057 5.60188 22.2057 8.66602V20.1989C22.2057 21.8365 22.2057 22.6553 21.674 22.9777C20.8051 23.5044 19.4618 22.3999 18.7861 21.9988C18.2279 21.6675 17.9488 21.5018 17.639 21.4922C17.3043 21.4818 17.0202 21.6408 16.417 21.9988L14.2174 23.3043C13.6242 23.6565 13.3275 23.8326 12.9974 23.8326C12.6673 23.8326 12.3706 23.6565 11.7773 23.3043Z" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 8.66602L9.75 15.166" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 15.166H16.2403M9.75972 8.66602H9.75" stroke="#525266" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
',
    ],
    'timed-product' => [
        'name' => 'timed-product',
        'slug' => 'timed-product',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => 'on',
        'is_pro' => true,
        'title' => __('Timed Product', 'wp-cafe'),
        'description' => __('Lets you set up special menus or products that are only available for ordering during specific times of the day.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/timed-product',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/how-to-use-time-based-products-in-wpcafe/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.0749 3.25C8.84317 3.33659 8.61526 3.43105 8.39151 3.53303M22.4454 17.6595C22.5561 17.4199 22.6581 17.1754 22.7512 16.9265M20.0415 20.9784C20.2276 20.8048 20.4074 20.6246 20.5805 20.4382M16.5425 23.1533C16.7528 23.074 16.9598 22.9883 17.1635 22.8964M13.1702 23.8267C12.92 23.8354 12.6682 23.8354 12.4179 23.8267M8.43744 22.9021C8.6333 22.9902 8.83233 23.0726 9.03429 23.149M5.06311 20.4975C5.21119 20.6545 5.364 20.8069 5.52131 20.9547M2.85327 16.9699C2.93439 17.184 3.02224 17.395 3.11655 17.6023M2.17323 13.5474C2.1662 13.322 2.16622 13.0951 2.17323 12.8693M2.84542 9.46523C2.92511 9.25345 3.01138 9.04489 3.10396 8.83978M5.0452 5.93583C5.20192 5.7689 5.36395 5.60704 5.53106 5.45051" stroke="#525266" stroke-width="1.625" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.625 13C14.625 13.8974 13.8974 14.625 13 14.625C12.1026 14.625 11.375 13.8974 11.375 13C11.375 12.1026 12.1026 11.375 13 11.375M14.625 13C14.625 12.1026 13.8974 11.375 13 11.375M14.625 13H17.3333M13 11.375V6.5" stroke="#525266" stroke-width="1.625" stroke-linecap="round"/>
<path d="M23.8333 12.9993C23.8333 7.01626 18.983 2.16602 13 2.16602" stroke="#525266" stroke-width="1.625" stroke-linecap="round"/>
</svg>
',
    ],
    'mini_cart' => [
        'name' => 'mini_cart',
        'slug' => 'mini_cart',
        'type' => 'module',
        'parent' => 'food_ordering',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Mini Cart', 'wp-cafe'),
        'description' => __('Adds a floating mini-cart widget to your website, allowing customers to view and manage their order without leaving the page.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/settings?tab=mini-cart',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/wpcafe-version-3/mini-cart-settings/',
        'icon' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.66797 13.3333L13.9347 12.7277C16.2085 12.5383 16.7189 12.0417 16.9709 9.77408L17.5013 5" stroke="#141B34" stroke-width="1.25" stroke-linecap="round"/>
<path d="M5 5H18.3333" stroke="#141B34" stroke-width="1.25" stroke-linecap="round"/>
<path d="M4.9987 18.3333C5.91917 18.3333 6.66536 17.5871 6.66536 16.6667C6.66536 15.7462 5.91917 15 4.9987 15C4.07822 15 3.33203 15.7462 3.33203 16.6667C3.33203 17.5871 4.07822 18.3333 4.9987 18.3333Z" stroke="#141B34" stroke-width="1.25"/>
<path d="M14.1667 18.3333C15.0871 18.3333 15.8333 17.5871 15.8333 16.6667C15.8333 15.7462 15.0871 15 14.1667 15C13.2462 15 12.5 15.7462 12.5 16.6667C12.5 17.5871 13.2462 18.3333 14.1667 18.3333Z" stroke="#141B34" stroke-width="1.25"/>
<path d="M6.66797 16.6665H12.5013" stroke="#141B34" stroke-width="1.25" stroke-linecap="round"/>
<path d="M1.66797 1.6665H2.47297C3.2602 1.6665 3.94642 2.187 4.13735 2.92895L6.61674 12.5636C6.74203 13.0505 6.6348 13.5663 6.32484 13.9678L5.52808 14.9998" stroke="#141B34" stroke-width="1.25" stroke-linecap="round"/>
</svg>
',
    ],
      'location' => [
        'name' => 'location',
        'slug' => 'location',
        'type' => 'module',
        'status' => 'on',
        'is_pro' => false,
        'title' => __('Location', 'wp-cafe'),
        'description' => __('Helps you manage multiple restaurant branches and allows customers to see menus and services specific to each location.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => 'admin.php?page=wpcafe#/location',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/food-ordering/general-settings-5/',
        'icon' => '<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.25 10.291C16.25 12.086 14.795 13.541 13 13.541C11.205 13.541 9.75 12.086 9.75 10.291C9.75 8.49609 11.205 7.04102 13 7.04102C14.795 7.04102 16.25 8.49609 16.25 10.291Z" stroke="#525266" stroke-width="1.625"/>
<path d="M13 2.16602C17.397 2.16602 21.125 5.87971 21.125 10.3852C21.125 14.9623 17.3364 18.1744 13.8369 20.3586C13.5819 20.5054 13.2935 20.5827 13 20.5827C12.7065 20.5827 12.4181 20.5054 12.1631 20.3586C8.67019 18.1531 4.875 14.9782 4.875 10.3852C4.875 5.87971 8.60297 2.16602 13 2.16602Z" stroke="#525266" stroke-width="1.625"/>
<path d="M19.5 21.666C19.5 22.8627 16.5898 23.8327 13 23.8327C9.41015 23.8327 6.5 22.8627 6.5 21.666" stroke="#525266" stroke-width="1.625" stroke-linecap="round"/>
</svg>
',
    ],
    'wpcafe-multivendor' => [
        'name' => 'wpcafe-multivendor',
        'slug' => 'wpcafe-multivendor',
        'type' => 'plugin',
        'status' => 'install',
        'is_pro' => false,
        'deps'   => ['dokan-lite'],
        'title'  => __('Dokan Multivendor', 'wp-cafe'),
        'description' => __('WPCafe Multivendor Restaurant Addon for Dokan helps to convert your Restaurant Website into a multivendor restaurant and food-selling marketplace with WPCafe. ', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/food-ordering/how-to-set-up-receipt-layouts-in-wpcafe/',
        'icon' => '<svg width="22" height="26" viewBox="0 0 22 26" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
<rect width="21.3228" height="26" fill="url(#pattern0_196_2098)"/>
<defs>
<pattern id="pattern0_196_2098" patternContentUnits="objectBoundingBox" width="1" height="1">
<use xlink:href="#image0_196_2098" transform="scale(0.00322581 0.0026455)"/>
</pattern>
<image id="image0_196_2098" width="1201" height="378" xlink:href="data:image/png;base64,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"/>
</defs>
</svg>
',
    ],
    'wpcafe-oxygen-addon' => [
        'name' => 'wpcafe-oxygen-addon',
        'slug' => 'wpcafe-oxygen-addon',
        'type' => 'plugin',
        'status' => 'install',
        'is_pro' => false,
        'title' => __('Oxygen Page Builder', 'wp-cafe'),
        'description' => __('WPCafe with Oxygen Page Builder allows you to visually design your restaurant, from header to footer, without needing to write any code.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/getting-started/wpcafe-oxygen-builder-elements/',
        'icon' => '<svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle opacity="0.1" cx="25" cy="25" r="25" fill="#5D5DFF"/>
<circle opacity="0.1" cx="25" cy="25" r="25" fill="#5D5DFF"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M30.4391 34.5634C30.8191 35.1846 31.4188 35.6568 32.1301 35.8719C32.4055 35.9552 32.6975 36 33 36C34.6569 36 36 34.6569 36 33C36 32.6975 35.9552 32.4055 35.8719 32.1301C35.6568 31.4188 35.1846 30.8191 34.5634 30.4391C34.1081 30.1605 33.5728 30 33 30C31.3431 30 30 31.3431 30 33C30 33.5728 30.1605 34.1081 30.4391 34.5634ZM35.3941 28.6094C34.6831 28.2209 33.8674 28 33 28C30.2386 28 28 30.2386 28 33C28 33.8674 28.2209 34.6831 28.6094 35.3941C27.4788 35.7867 26.2643 36 25 36C18.9249 36 14 31.0751 14 25C14 18.9249 18.9249 14 25 14C31.0751 14 36 18.9249 36 25C36 26.2643 35.7867 27.4788 35.3941 28.6094ZM37.0025 30.0028C37.6451 28.4629 38 26.7729 38 25C38 17.8203 32.1797 12 25 12C17.8203 12 12 17.8203 12 25C12 32.1797 17.8203 38 25 38C26.7729 38 28.4629 37.6451 30.0028 37.0025C30.838 37.6289 31.8757 38 33 38C35.7614 38 38 35.7614 38 33C38 31.8757 37.6289 30.838 37.0025 30.0028Z" fill="#7E68EE"/>
</svg>
',
    ],
     'wpcafe-elementor-addons' => [
        'name' => 'wpcafe-elementor-addons',
        'slug' => 'wpcafe-elementor-addons',
        'type' => 'plugin',
        'status' => 'install',
        'is_pro' => false,
        'title' => __('WPCafe Elementor Addon', 'wp-cafe'),
        'description' => __('WPCafe Elementor Addon extends the power of WPCafe by adding beautiful, drag-and-drop widgets for restaurant menus, online food ordering and reservations.Easily design and customize every section of your restaurant website, no coding required.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => '',
        'settings_link' => '',
        'doc_link' => 'https://support.themewinter.com/docs/plugins/plugin-docs/getting-started/wpcafe-elementor-widgets/',
        'icon' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="54" height="54.422" viewBox="0 0 54 54.422"><path d="m5.25 -0.068 1.196 -0.013 1.315 -0.008 1.382 -0.013q2.273 -0.018 4.546 -0.029l1.566 -0.009q3.681 -0.018 7.361 -0.029 3.822 -0.011 7.644 -0.046 4.101 -0.037 8.202 -0.042 1.563 -0.005 3.127 -0.024c1.459 -0.016 2.918 -0.017 4.377 -0.014l1.302 -0.025c2.554 0.026 3.942 0.419 5.786 2.225 0.943 1.128 0.999 1.9 1.004 3.334l0.008 1.188 0.001 1.308 0.006 1.374q0.009 2.258 0.012 4.517l0.008 3.131q0.006 3.286 0.009 6.573 0.005 4.214 0.025 8.426 0.011 3.236 0.011 6.47 0.002 1.553 0.01 3.107 0.01 2.173 0.003 4.345l0.012 1.299c-0.016 2.798 -0.405 4.171 -2.272 6.296 -1.919 1.102 -3.709 0.961 -5.885 0.944l-1.412 0.009c-1.54 0.008 -3.08 0.003 -4.619 -0.003l-3.211 0.005q-3.364 0.003 -6.728 -0.01 -3.885 -0.011 -7.771 0.003 -3.742 0.011 -7.485 0.002 -1.591 -0.002 -3.181 0.004 -2.222 0.004 -4.444 -0.012l-1.329 0.01c-1.879 -0.022 -2.979 -0.038 -4.608 -1.034 -1.144 -1.273 -1.268 -1.962 -1.282 -3.633l-0.013 -1.217 -0.008 -1.339 -0.013 -1.407a1324.08 1324.08 0 0 1 -0.029 -4.628l-0.009 -1.594q-0.017 -3.317 -0.027 -6.634 -0.013 -4.75 -0.056 -9.5a865.08 865.08 0 0 1 -0.036 -7.489q-0.005 -1.592 -0.024 -3.183a340.2 340.2 0 0 1 -0.014 -4.456l-0.025 -1.327c0.025 -2.575 0.4 -3.985 2.225 -5.843 1.13 -0.94 1.908 -0.998 3.344 -1.01" fill="#ED5229"/><path d="m16.136 7.805 0.958 0.004c2.71 0.081 4.712 0.761 6.953 2.317l1.187 0.765c3.091 3.091 3.951 6.442 4.071 10.708 -0.299 1.821 -1.393 2.483 -2.779 3.583 -0.872 1.075 -0.918 1.517 -1.107 2.848 -0.219 1.202 -0.357 1.764 -1.254 2.61a21.06 21.06 0 0 1 -2.649 1.422l-1.002 0.467c-3.192 1.089 -6.83 0.652 -9.849 -0.755 -3.704 -2.138 -5.531 -4.983 -6.868 -8.993 -0.37 -3.951 0.441 -7.423 2.953 -10.547 2.826 -2.814 5.277 -4.465 9.386 -4.43" fill="#EF642D"/><path d="M43.453 26.157c2.362 2.075 3.983 4.112 4.321 7.287 0.161 3.076 -0.478 5.563 -2.535 7.906 -2.251 2.114 -4.58 3.376 -7.693 3.528 -2.634 -0.119 -5.062 -1.07 -7.008 -2.879 -2.43 -2.717 -3.066 -5.27 -2.926 -8.905 0.463 -2.917 1.905 -5.144 4.239 -6.937 3.832 -2.373 7.764 -2.277 11.601 0" fill="#95043D"/><path d="M43.335 23.07c3.704 2.137 5.531 4.982 6.868 8.993 0.357 3.362 -0.406 6.391 -1.977 9.36 -2.08 2.53 -4.404 4.824 -7.725 5.404 -4.514 0.419 -7.778 0.173 -11.371 -2.789 -2.29 -2.096 -4.088 -4.9 -4.324 -8.06 -0.045 -3.191 0.028 -6.443 1.352 -9.401 1.405 -1.348 2.952 -2.183 4.694 -3.032l1.322 -0.651c3.546 -1.642 7.637 -1.468 11.163 0.175M29.359 28.588c-1.863 2.807 -2.028 5.678 -1.515 8.96 1.149 3.218 3.294 5.255 6.328 6.75 2.905 0.899 5.493 0.543 8.239 -0.648 2.263 -1.342 3.863 -3.331 5.049 -5.655 0.557 -3.416 0.48 -6.346 -1.476 -9.307 -2.363 -2.692 -4.882 -4.011 -8.411 -4.403 -3.155 0.131 -6.269 1.872 -8.216 4.303" fill="#FCF7F7"/><path d="m16.136 7.805 0.958 0.004c2.71 0.081 4.712 0.761 6.953 2.317l1.187 0.765c3.091 3.091 3.951 6.442 4.071 10.708 -0.299 1.821 -1.393 2.483 -2.779 3.583 -0.872 1.075 -0.918 1.517 -1.107 2.848 -0.219 1.202 -0.357 1.764 -1.254 2.61a21.06 21.06 0 0 1 -2.649 1.422l-1.002 0.467c-3.192 1.089 -6.83 0.652 -9.849 -0.755 -3.704 -2.138 -5.531 -4.983 -6.868 -8.993 -0.37 -3.951 0.441 -7.423 2.953 -10.547 2.826 -2.814 5.277 -4.465 9.386 -4.43m-7.296 5.614c-2.252 2.532 -2.808 4.755 -2.668 8.144 0.422 3.294 2.17 5.198 4.673 7.28 2.267 1.615 5.006 1.948 7.718 1.533 3.288 -1.037 5.439 -2.945 7.172 -5.907 0.872 -2.498 0.896 -5.923 -0.079 -8.385 -1.606 -2.767 -3.23 -4.486 -6.25 -5.536 -4.231 -1.029 -7.457 -0.163 -10.567 2.871" fill="#FEF6F4"/><path d="M18.141 14.343c1.111 0.997 1.635 1.616 1.795 3.115 -0.124 1.279 -0.495 1.99 -1.162 3.081 -0.821 1.247 -0.821 1.247 -1.055 2.663 1.536 -0.512 1.819 -1.16 2.573 -2.54 0.457 -0.94 0.457 -0.94 0.802 -2.443 0.422 -1.345 0.422 -1.345 1.319 -1.952l0.791 -0.237c0.422 0.422 0.422 0.422 0.58 1.582 -0.211 1.821 -0.945 2.249 -2.268 3.481a32.4 32.4 0 0 0 -0.818 1.582c-0.869 1.371 -0.869 1.371 -2.161 1.766 -3.763 0.08 -3.763 0.08 -5.458 -0.395 -0.939 -1.241 -1.688 -2.642 -1.688 -4.218l-0.791 -0.079c-0.896 -0.343 -0.896 -0.343 -1.423 -1.425l-0.316 -1.028c1.266 -0.843 1.266 -0.843 2.147 -0.797 0.807 0.375 0.807 0.375 1.203 1.172l0.262 0.996c0.448 1.529 0.909 2.817 1.872 4.114h0.843c-0.167 -1.209 -0.289 -1.95 -1.081 -2.901 -0.899 -1.328 -0.801 -2.284 -0.606 -3.849 1.213 -1.893 2.487 -2.034 4.641 -1.688" fill="#FEF5F1"/><path d="M33.328 30.375h1.688v8.438h-1.688z" fill="#F2EDEF"/><path d="M16.032 15.609c0.896 0.158 0.896 0.158 1.688 0.422 0.44 1.398 0.5 1.942 -0.132 3.296l-0.713 0.922h-0.843c-1.298 -1.731 -1.298 -1.731 -1.186 -3.032 0.342 -0.766 0.342 -0.766 1.186 -1.609" fill="#F8B9A1"/><path d="M36.703 37.125h5.063v1.688h-5.063z" fill="#FCFBFC"/><path d="M36.703 33.75h5.063v1.688h-5.063z" fill="#FCFBFC"/><path d="M36.703 30.375h5.063v1.688h-5.063z" fill="#FBFAFA"/><path d="m27.422 24.047 0.843 0.422v0.843l-1.028 0.923c-1.284 1.407 -1.393 2.27 -1.503 4.139l-0.843 -0.422c-0.192 -2.405 0.167 -3.606 1.688 -5.484z" fill="#F56038"/><path d="m21.093 18.984 0.843 1.266 -2.109 3.797 -1.688 -0.843 0.527 -0.448c1.038 -1.148 1.685 -2.415 2.427 -3.771" fill="#FDECE6"/><path d="M13.078 24.468h1.688l-0.422 2.109h-2.953l1.266 -0.422c0.309 -0.85 0.309 -0.85 0.422 -1.688" fill="#FACDBC"/><path d="m32.484 25.734 0.843 0.422 -3.797 3.797c0 -1.669 0.593 -2.156 1.688 -3.375z" fill="#A2184E"/><path d="m12.657 20.672 0.791 1.002c0.854 1.093 0.854 1.093 1.741 1.95l-2.109 0.422a42.12 42.12 0 0 1 -0.843 -2.532z" fill="#FCEAE2"/><path d="M17.718 16.875c0.422 1.266 0.422 1.266 -0.132 2.4l-0.712 0.975h-0.843l-0.422 -2.109 0.818 -0.158 0.87 -0.265z" fill="#F06F3D"/><path d="m18.563 24.468 1.688 0.422 -0.422 1.688h-1.688z" fill="#FBDCCF"/><path d="m11.048 16.611 0.765 0.264 -2.109 2.109 -0.843 -1.688c1.266 -0.843 1.266 -0.843 2.189 -0.686" fill="#F9CBB9"/></svg>'
    ],
     'deposet' => [
        'name' => 'deposet',
        'slug' => 'deposet',
        'type' => 'plugin',
        'status' => 'install',
        'is_pro' => false,
        'title' => __('Deposits & Partial Payments for WooCommerce', 'wp-cafe'),
        'description' => __('A powerful WooCommerce extension that allows customers to pay deposits on products and complete payments later. Perfect for high-value items, pre-orders, or custom products.', 'wp-cafe'),
        'notice' => '',
        'demo_link' => 'http://www.youtube.com',
        'settings_link' => 'admin.php?page=deposet-settings',
        'doc_link' => 'https://wordpress.org/plugins/deposet/',
        'icon' => '<svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path width="128" height="128" rx="19" fill="url(#pattern0_3023_2)" d="M7.422 0H42.578A7.422 7.422 0 0 1 50 7.422V42.578A7.422 7.422 0 0 1 42.578 50H7.422A7.422 7.422 0 0 1 0 42.578V7.422A7.422 7.422 0 0 1 7.422 0z"/><defs><pattern id="pattern0_3023_2" patternContentUnits="objectBoundingBox" width="1" height="1"><use xlink:href="#image0_3023_2" transform="scale(.00781)"/></pattern><image id="image0_3023_2" width="128" height="128" preserveAspectRatio="none" xlink:href="data:image/png;base64,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"/></defs></svg>',
    ],
];