<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! $product->is_purchasable() ) {
	return;
}

echo wp_kses_post( wc_get_stock_html( $product ) ); // WPCS: XSS ok.

if ( $product->is_in_stock() ) :

	do_action( 'woocommerce_before_add_to_cart_form' ); ?>

	<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>
		<?php
		do_action( 'woocommerce_before_add_to_cart_button' );

		do_action( 'woocommerce_before_add_to_cart_quantity' );

		woocommerce_quantity_input(
			array(
				'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
				'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
				'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( codesigner_sanitize_number( wp_unslash( $_POST['quantity'] ) ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
			),
			$product
		);

		do_action( 'woocommerce_after_add_to_cart_quantity' );

		printf(
			'<button type="submit" name="add-to-cart" value="%s" %s>%s</button>',
			esc_attr( $product->get_id() ),
			wp_kses_post( $this->get_render_attribute_string( 'add_to_cart_text' ) ),
			esc_html( $button_text )
		);

		do_action( 'woocommerce_after_add_to_cart_button' );
		?>

		<?php
		if ( $settings['cd_hide_default_vs_table'] ) {
			?>
				<input type="hidden" name="variation_id" class="variation_id" value="0">
			<?php
		}
		?>
	</form>

	<?php do_action( 'woocommerce_after_add_to_cart_form' );

endif; ?>
