<?php
/**
 * WooCommerce Wholesale Prices - Getting Started Page
 *
 * @package WWP
 */

defined( 'ABSPATH' ) || exit;

$five_stars = '';
for ( $i = 0; $i < 5; ++$i ) {
    $five_stars .= <<<SVG
<svg
    width="20" height="20" viewBox="0 0 20 20" fill="#d96208"
    xmlns="http://www.w3.org/2000/svg"
>
    <path
        d="M9.071 0.91166C9.41474 0.095201 10.5855 0.0952021 10.9292 0.911662L12.958 5.73055C13.103 6.07475 13.4307 6.30993 13.8068 6.33972L19.0728 6.75679C19.965 6.82746 20.3268 7.92745 19.647 8.50272L15.6349 11.898C15.3483 12.1405 15.2231 12.5211 15.3107 12.8837L16.5365 17.9603C16.7441 18.8204 15.797 19.5003 15.0331 19.0394L10.5247 16.3189C10.2026 16.1245 9.79762 16.1245 9.4756 16.3189L4.96711 19.0394C4.20323 19.5003 3.25608 18.8204 3.46376 17.9603L4.68954 12.8837C4.7771 12.5211 4.65194 12.1405 4.36538 11.898L0.353184 8.50272C-0.326596 7.92745 0.0351899 6.82746 0.927413 6.75679L6.19348 6.33972C6.56962 6.30993 6.89728 6.07475 7.04219 5.73055L9.071 0.91166Z"
    />
</svg>
SVG;
}
?>
<div class="wrap">
    <div class="wws-getting-started-container">
        <div class="wws-row">
            <img class="wws-logo" src="<?php echo esc_url( WWP_IMAGES_URL ); ?>logo.png" alt="Wholesale Suite" />
        </div>
        <div class="wws-row">
            <h3 class="wws-section-title"><?php esc_html_e( 'Welcome to Wholesale Suite!', 'woocommerce-wholesale-prices' ); ?> 🎉</h3>
        </div>
        <div class="wws-row">
            <div class="wws-w-50">
                <p><?php esc_html_e( 'Thank you for choosing Wholesale Suite. By selecting our plugins, you\'ve taken a significant step toward streamlining your wholesale operations and unlocking new profit opportunities for your WooCommerce store. We believe wholesale should be straightforward, which is why we\'ve developed tools that go beyond the basics—helping you manage pricing, streamline bulk orders, and expand your customer base with ease.', 'woocommerce-wholesale-prices' ); ?></p>

                <p><?php esc_html_e( 'We\'re proud to be trusted by over 25,000 WooCommerce store owners worldwide, and our dedicated team is here to support you at every stage of your journey. Your success is our priority, and we look forward to seeing the remarkable growth your business will achieve with Wholesale Suite.', 'woocommerce-wholesale-prices' ); ?></p>

                <p><a
                        class="wws-getting-started-link"
                        href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'kb/woocommerce-wholesale-prices-free-plugin-getting-started-guide/', 'wwp', 'upsell', 'wwpgettingstartedguidebutton' ) ); ?>"
                        target="_blank"
                    ><?php esc_html_e( 'Read Getting Started Guide', 'woocommerce-wholesale-prices' ); ?></a></p>
            </div>
        </div>
    </div>

    <div class="wws-green-section">
        <div class="wws-getting-started-container">
            <div class="wws-row">
                <h3 class="wws-section-title"><?php esc_html_e( 'Start With Our Free Plugin', 'woocommerce-wholesale-prices' ); ?> 🚀</h3>
            </div>
            <div class="wws-row">
                <div class="wws-w-50">
                    <p>
                    <?php
                    esc_html_e(
                        'Start your wholesale journey with the free version of our Wholesale Prices plugin! This powerful tool makes it simple to set up and manage wholesale pricing, giving you everything you need to cater to wholesale customers without any added cost.',
                        'woocommerce-wholesale-prices'
                    );
                    ?>
                    </p>
                </div>
            </div>
            <div class="wws-row">
                <div class="wws-feature-boxes">
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="61" height="43" viewBox="0 0 61 43" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M57.6667 0.248779H3.66667C2.0073 0.248779 0.666672 1.5894 0.666672 3.24878V39.2488C0.666672 40.9082 2.0073 42.2488 3.66667 42.2488H57.6667C59.326 42.2488 60.6667 40.9082 60.6667 39.2488V3.24878C60.6667 1.5894 59.326 0.248779 57.6667 0.248779ZM17.1667 27.9894V29.4988C17.1667 29.9113 16.8292 30.2488 16.4167 30.2488H14.9167C14.5042 30.2488 14.1667 29.9113 14.1667 29.4988V27.9707C13.1073 27.9144 12.076 27.5488 11.2229 26.9019C10.8573 26.63 10.8385 26.0769 11.1667 25.7675L12.2729 24.7175C12.5354 24.4738 12.9198 24.455 13.2198 24.6519C13.5854 24.8769 13.9979 24.9988 14.4198 24.9988H17.0542C17.6635 24.9988 18.1604 24.4457 18.1604 23.7613C18.1604 23.1988 17.8229 22.7113 17.3354 22.5707L13.1167 21.305C11.3729 20.78 10.1542 19.1113 10.1542 17.2363C10.1542 14.9394 11.9448 13.0738 14.1573 13.0082V11.4988C14.1573 11.0863 14.4948 10.7488 14.9073 10.7488H16.4073C16.8198 10.7488 17.1573 11.0863 17.1573 11.4988V13.0269C18.2167 13.0832 19.2479 13.4488 20.101 14.0957C20.4667 14.3675 20.4854 14.9207 20.1573 15.23L19.051 16.28C18.7885 16.5238 18.4042 16.5425 18.1042 16.3457C17.7385 16.1207 17.326 15.9988 16.9042 15.9988H14.2698C13.6604 15.9988 13.1635 16.5519 13.1635 17.2363C13.1635 17.7988 13.501 18.2863 13.9885 18.4269L18.2073 19.6925C19.951 20.2175 21.1698 21.8863 21.1698 23.7613C21.1698 26.0582 19.3792 27.9238 17.1667 27.9894ZM39.6667 26.4988C39.6667 26.9113 39.3292 27.2488 38.9167 27.2488H28.4167C28.0042 27.2488 27.6667 26.9113 27.6667 26.4988V24.9988C27.6667 24.5863 28.0042 24.2488 28.4167 24.2488H38.9167C39.3292 24.2488 39.6667 24.5863 39.6667 24.9988V26.4988ZM54.6667 26.4988C54.6667 26.9113 54.3292 27.2488 53.9167 27.2488H46.4167C46.0042 27.2488 45.6667 26.9113 45.6667 26.4988V24.9988C45.6667 24.5863 46.0042 24.2488 46.4167 24.2488H53.9167C54.3292 24.2488 54.6667 24.5863 54.6667 24.9988V26.4988ZM54.6667 17.4988C54.6667 17.9113 54.3292 18.2488 53.9167 18.2488H28.4167C28.0042 18.2488 27.6667 17.9113 27.6667 17.4988V15.9988C27.6667 15.5863 28.0042 15.2488 28.4167 15.2488H53.9167C54.3292 15.2488 54.6667 15.5863 54.6667 15.9988V17.4988Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Set Wholesale Prices', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php esc_html_e( 'Easily set wholesale prices directly from your product edit screen.', 'woocommerce-wholesale-prices' ); ?>
                        </div>
                    </div>
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="60" height="43" viewBox="0 0 60 43" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M18 21.2488C23.8031 21.2488 28.5 16.5519 28.5 10.7488C28.5 4.94565 23.8031 0.248779 18 0.248779C12.1969 0.248779 7.5 4.94565 7.5 10.7488C7.5 16.5519 12.1969 21.2488 18 21.2488ZM25.2 24.2488H24.4219C22.4719 25.1863 20.3062 25.7488 18 25.7488C15.6938 25.7488 13.5375 25.1863 11.5781 24.2488H10.8C4.8375 24.2488 0 29.0863 0 35.0488V37.7488C0 40.2332 2.01562 42.2488 4.5 42.2488H31.5C33.9844 42.2488 36 40.2332 36 37.7488V35.0488C36 29.0863 31.1625 24.2488 25.2 24.2488ZM45 21.2488C49.9688 21.2488 54 17.2175 54 12.2488C54 7.28003 49.9688 3.24878 45 3.24878C40.0312 3.24878 36 7.28003 36 12.2488C36 17.2175 40.0312 21.2488 45 21.2488ZM49.5 24.2488H49.1438C47.8406 24.6988 46.4625 24.9988 45 24.9988C43.5375 24.9988 42.1594 24.6988 40.8562 24.2488H40.5C38.5875 24.2488 36.825 24.8019 35.2781 25.6925C37.5656 28.1582 39 31.43 39 35.0488V38.6488C39 38.855 38.9531 39.0519 38.9437 39.2488H55.5C57.9844 39.2488 60 37.2332 60 34.7488C60 28.9457 55.3031 24.2488 49.5 24.2488Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Assign Wholesale User Roles', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php esc_html_e( 'Grant wholesale access to bulk buyers instantly by assigning the Wholesale Customer user role.', 'woocommerce-wholesale-prices' ); ?>
                        </div>
                    </div>
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="47" height="47" viewBox="0 0 47 47" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M29.9239 20.0113C29.9239 21.9332 28.3583 23.4988 26.4364 23.4988H19.8458V16.5238H26.4364C28.3583 16.5238 29.9239 18.0894 29.9239 20.0113ZM46.5833 23.4988C46.5833 36.3425 36.177 46.7488 23.3333 46.7488C10.4895 46.7488 0.083252 36.3425 0.083252 23.4988C0.083252 10.655 10.4895 0.248779 23.3333 0.248779C36.177 0.248779 46.5833 10.655 46.5833 23.4988ZM34.5739 20.0113C34.5739 15.5207 30.927 11.8738 26.4364 11.8738H15.1958V35.1238H19.8458V28.1488H26.4364C30.927 28.1488 34.5739 24.5019 34.5739 20.0113Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Supports All Product Types', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php esc_html_e( 'Apply wholesale pricing to Simple and Variable products seamlessly.', 'woocommerce-wholesale-prices' ); ?>
                        </div>
                    </div>
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M0.666672 38.2457V42.2488C0.666672 45.5582 8.72917 48.2488 18.6667 48.2488C28.6042 48.2488 36.6667 45.5582 36.6667 42.2488V38.2457C32.7948 40.9738 25.7167 42.2488 18.6667 42.2488C11.6167 42.2488 4.53855 40.9738 0.666672 38.2457ZM30.6667 12.2488C40.6042 12.2488 48.6667 9.55815 48.6667 6.24878C48.6667 2.9394 40.6042 0.248779 30.6667 0.248779C20.7292 0.248779 12.6667 2.9394 12.6667 6.24878C12.6667 9.55815 20.7292 12.2488 30.6667 12.2488ZM0.666672 28.4113V33.2488C0.666672 36.5582 8.72917 39.2488 18.6667 39.2488C28.6042 39.2488 36.6667 36.5582 36.6667 33.2488V28.4113C32.7948 31.5988 25.7073 33.2488 18.6667 33.2488C11.626 33.2488 4.53855 31.5988 0.666672 28.4113ZM39.6667 29.4425C45.0385 28.4019 48.6667 26.4707 48.6667 24.2488V20.2457C46.4917 21.7832 43.2948 22.8332 39.6667 23.48V29.4425ZM18.6667 15.2488C8.72917 15.2488 0.666672 18.605 0.666672 22.7488C0.666672 26.8925 8.72917 30.2488 18.6667 30.2488C28.6042 30.2488 36.6667 26.8925 36.6667 22.7488C36.6667 18.605 28.6042 15.2488 18.6667 15.2488ZM39.226 20.5269C44.851 19.5144 48.6667 17.5269 48.6667 15.2488V11.2457C45.3385 13.5988 39.6198 14.8644 33.601 15.1644C36.3667 16.505 38.401 18.305 39.226 20.5269Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Hide Retail Prices', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php
                            esc_html_e(
                                'Optionally hide retail pricing for a tailored, wholesale-only experience.',
                                'woocommerce-wholesale-prices'
                            );
                            ?>
                        </div>
                    </div>
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="54" height="49" viewBox="0 0 54 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M53.3777 21.966C48.0996 12.9942 38.2371 7.00354 27.0059 7.00354C24.334 7.00354 21.7465 7.34104 19.2715 7.97854L14.3309 1.20979C13.6184 0.187917 12.2121 -0.055833 11.1996 0.656667L9.97148 1.51917C8.9496 2.23167 8.70586 3.63792 9.41835 4.65042L13.459 10.1254C8.3871 12.6004 3.7746 16.6317 0.63398 21.966C0.63398 21.966 0.63398 21.966 0.63398 21.9754C-0.19102 23.3723 -0.20977 25.116 0.63398 26.541C4.24335 32.6629 9.98085 37.4067 16.8434 39.7879L5.19023 23.1567C5.97867 21.9624 6.86617 20.8365 7.84335 19.791L19.0371 35.7848L22.8434 41.2223C25.2956 41.5554 27.779 41.5932 30.2402 41.3348L12.4277 15.891C13.5842 15.12 14.8006 14.4428 16.0652 13.866L39.6715 47.2879C40.384 48.3098 41.7902 48.5535 42.8027 47.841L44.0309 46.9785C45.0527 46.266 45.2965 44.8598 44.584 43.8473L40.5434 38.3723C45.9059 35.7473 50.3684 31.6223 53.3684 26.5317C53.7766 25.8402 53.9919 25.0519 53.9919 24.2489C53.9919 23.4459 53.7766 22.6575 53.3684 21.966H53.3777ZM36.5684 32.6817L34.7777 30.1317C37.0934 27.0754 37.3746 22.9692 35.6027 19.6598C35.6027 21.8817 33.8027 23.6723 31.5902 23.6723C29.359 23.6723 27.5777 21.8629 27.5777 19.6598C27.5777 17.4379 29.3777 15.6473 31.5902 15.6473C29.2652 14.4098 26.5746 14.1848 24.1371 14.9254L22.3465 12.3754C23.7996 11.8129 25.3652 11.5035 27.0059 11.5035C34.0559 11.5035 39.7559 17.2035 39.7559 24.2535C39.7559 27.4879 38.5559 30.441 36.5684 32.6817Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Restrict Access', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php esc_html_e( 'Create a private store by requiring wholesale customers to log in to view pricing.', 'woocommerce-wholesale-prices' ); ?>
                        </div>
                    </div>
                    <div class="wws-feature-box">
                        <div class="wws-feature-icon">
                            <svg width="43" height="49" viewBox="0 0 43 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M38.657 12.2494C36.557 12.2119 34.832 13.9744 34.832 16.0744V24.2494H34.082V7.73062C34.082 5.63062 32.357 3.86812 30.257 3.90562C28.2226 3.94312 26.582 5.61187 26.582 7.65562V24.2494H25.832V4.07437C25.832 1.97437 24.107 0.211867 22.007 0.249367C19.9726 0.286867 18.332 1.95562 18.332 3.99937V24.2494H17.582V7.82437C17.582 5.72437 15.857 3.96187 13.757 3.99937C11.7226 4.03687 10.082 5.70562 10.082 7.74937V29.8744L7.11951 25.7962C5.90076 24.1181 3.55701 23.7525 1.87889 24.9712C0.200762 26.19 -0.164863 28.5337 1.05389 30.2119L12.8289 46.4025C13.2469 46.9751 13.7942 47.4409 14.4263 47.7618C15.0584 48.0827 15.7575 48.2498 16.4664 48.2494H34.9914C37.082 48.2494 38.8914 46.815 39.3695 44.7806L41.8539 34.215C42.1719 32.863 42.3323 31.4788 42.332 30.09V15.9994C42.332 13.9556 40.6914 12.2869 38.657 12.2494Z"
                                    fill="#46BF93"
                                />
                            </svg>
                        </div>
                        <div class="wws-feature-title">
                            <h4><?php esc_html_e( 'Disable Coupon Usage', 'woocommerce-wholesale-prices' ); ?></h4>
                        </div>
                        <div class="wws-feature-content">
                            <?php esc_html_e( 'Prevent wholesale customers from using retail coupons to avoid double discounts.', 'woocommerce-wholesale-prices' ); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wws-row">
                <div class="wws-start-setting-up-container">
                    <p><a class="wws-start-setting-up" href="/wp-admin/edit.php?post_type=product"><?php esc_html_e( 'Start Setting Up Your Wholesale Prices Now!', 'woocommerce-wholesale-prices' ); ?></a></p>
                </div>
            </div>
        </div>
    </div>

    <div class="wws-getting-started-container">
        <div class="wws-row">
            <h3 class="wws-section-title"><?php esc_html_e( 'Scale Your Wholesale Business With Our Full Suite Of Premium Tools', 'woocommerce-wholesale-prices' ); ?> 📈</h3>
        </div>
        <div class="wws-row">
            <div class="wws-w-50">
                <p>
                <?php
                esc_html_e(
                    'Our premium plugins are designed to make every aspect of your wholesale business easier, faster, and more profitable. Here\'s what our plugins can do for you:',
                    'woocommerce-wholesale-prices'
                );
                ?>
                </p>
            </div>
        </div>
        <div class="wws-row">
            <div class="wws-plugins wws-w-75">
                <div class="wws-plugin">
                    <div class="wws-plugin-info">
                        <h4><?php esc_html_e( 'Wholesale Prices Premium', 'woocommerce-wholesale-prices' ); ?></h4>
                        <div class="plugin-excerpt">
                            <p><?php esc_html_e( 'Unlock advanced pricing features that give you full control over your wholesale strategy.', 'woocommerce-wholesale-prices' ); ?></p>
                        </div>
                        <div class="plugin-content">
                            <p>
                            <?php
                            esc_html_e(
                                'Create tiered pricing, manage multiple wholesale roles, and customize shipping and tax rules specifically for your wholesale customers. It\'s the ultimate upgrade to streamline your operations and increase your profits.',
                                'woocommerce-wholesale-prices'
                            );
                            ?>
                            </p>
                        </div>
                        <p><a class="wws-plugin-learn-more" href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'woocommerce-wholesale-prices-premium', 'wwp', 'upsell', 'wwpgettingstartedpremiumlink' ) ); ?>" target="_blank"><?php esc_html_e( 'Learn More', 'woocommerce-wholesale-prices' ); ?><span
                                    class="dashicons dashicons-arrow-right-alt"
                                ></span></a></p>
                    </div>
                    <div class="wws-plugin-sample-img">
                        <img src="<?php echo esc_url( WWP_IMAGES_URL ); ?>wwpp-sample-image.png" alt="" />
                    </div>
                </div>
            </div>
        </div>
        <div class="wws-row">
            <div class="wws-plugins wws-w-75">
                <div class="wws-plugin">
                    <div class="wws-plugin-sample-img">
                        <img src="<?php echo esc_url( WWP_IMAGES_URL ); ?>wwof-sample-image.png" alt="" />
                    </div>
                    <div class="wws-plugin-info">
                        <h4><?php esc_html_e( 'Wholesale Order Form', 'woocommerce-wholesale-prices' ); ?></h4>
                        <div class="plugin-excerpt">
                            <p><?php esc_html_e( 'Make bulk ordering easy for customers . ', 'woocommerce - wholesale - prices' ); ?></p>
                        </div>
                        <div class="plugin-content">
                            <p>
                            <?php
                            esc_html_e(
                                'This powerful plugin allows you to create a fast, user-friendly, one-page order form. Designed for speed and convenience, it simplifies bulk purchasing and reordering, making the process effortless for your customers while saving you time.',
                                'woocommerce-wholesale-prices'
                            );
                            ?>
                            </p>
                        </div>
                        <p><a class="wws-plugin-learn-more" href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'woocommerce-wholesale-order-form', 'wwp', 'upsell', 'wwpgettingstartedorderformlink' ) ); ?>" target="_blank"><?php esc_html_e( 'Learn More' ); ?><span
                                    class="dashicons dashicons-arrow-right-alt"
                                ></span></a></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="wws-row">
            <div class="wws-plugins wws-w-75">
                <div class="wws-plugin">
                    <div class="wws-plugin-info">
                        <h4><?php esc_html_e( 'Wholesale Lead Capture', 'woocommerce-wholesale-prices' ); ?></h4>
                        <div class="plugin-excerpt">
                            <p><?php esc_html_e( 'Grow your wholesale customer base effortlessly.', 'woocommerce-wholesale-prices' ); ?></p>
                        </div>
                        <div class="plugin-content">
                            <p>
                            <?php
                            esc_html_e(
                                'Use customizable registration forms, manage approval workflows with ease, and turn leads into loyal wholesale buyers—all while maintaining control over who gains access to your store.',
                                'woocommerce-wholesale-prices'
                            );
                            ?>
                            </p>
                        </div>
                        <p><a class="wws-plugin-learn-more" href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'woocommerce-wholesale-lead-capture', 'wwp', 'upsell', 'wwpgettingstartedleadcapturelink' ) ); ?>" target="_blank"><?php esc_html_e( 'Learn More' ); ?><span
                                    class="dashicons dashicons-arrow-right-alt"
                                ></span></a></p>
                    </div>
                    <div class="wws-plugin-sample-img">
                        <img src="<?php echo esc_url( WWP_IMAGES_URL ); ?>wwlc-sample-image.png" alt="" />
                    </div>
                </div>
            </div>
        </div>
        <div class="wws-row">
            <div class="wws-plugins wws-w-75">
                <div class="wws-plugin">
                    <div class="wws-plugin-sample-img">
                        <img src="<?php echo esc_url( WWP_IMAGES_URL ); ?>wpay-sample-image.png" alt="" />
                    </div>
                    <div class="wws-plugin-info">
                        <h4><?php esc_html_e( 'Wholesale Payments', 'woocommerce-wholesale-prices' ); ?></h4>
                        <p><?php esc_html_e( 'Provide wholesale customers with flexible invoice payment terms on payment plans you design.', 'woocommerce-wholesale-prices' ); ?></p>
                        <div class="plugin-content">
                            <p>
                            <?php
                            esc_html_e(
                                'Set up NET 30/60/90, manage invoices seamlessly, and offer tailored payment options to suit their needs. It\'s the perfect solution to keep your customers happy while staying on top of your cash flow.',
                                'woocommerce-wholesale-prices'
                            );
                            ?>
                            </p>
                        </div>
                        <p>
                            <a class="wws-plugin-learn-more" href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'woocommerce-wholesale-payments', 'wwp', 'upsell', 'wwpgettingstartedpaymentslink' ) ); ?>" target="_blank"><?php esc_html_e( 'Learn More' ); ?>
                                <span class="dashicons dashicons-arrow-right-alt"></span></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="wws-green-section">
        <div class="wws-getting-started-container">
            <div class="wws-row all-access-bundle-container">
                <div class="all-access-bundle">
                    <div class="left-content">
                        <h3><?php esc_html_e( 'Get The All Access Bundle', 'woocommerce-wholesale-prices' ); ?></h3>
                        <p>Over 25,000+ stores are using Wholesale Suite to grow their wholesale businesses with confidence and now you can get all of our tools in one easy bundle.</p>
                        <p class="rating-stars"><?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
                        <p class="rating-comment">
                            <?php esc_html_e( '"The best Wholesale Pricing plugin out there for WordPress, hands down."', 'woocommerce-wholesale-prices' ); ?>
                        </p>
                        <p class="rating-author">
                        <svg
                            width="41" height="41" viewBox="0 0 41 41" fill="none"
                            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                        >
                            <circle cx="20.5" cy="20.188" r="20" fill="url(#pattern0_5905_19678)" />
                            <defs>
                                <pattern
                                    id="pattern0_5905_19678" patternContentUnits="objectBoundingBox" width="1"
                                    height="1"
                                >
                                    <use xlink:href="#image0_5905_19678" transform="scale(0.025)" />
                                </pattern>
                                <image
                                    id="image0_5905_19678" width="40" height="40"
                                    xlink:href="data:image/png;base64,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"
                                />
                            </defs>
                        </svg>

                        <span>Ryan McDonald-Smith, youniquecreation.com</span>
                        </p>
                        <p>
                            <a class="get-bundle-link" href="<?php echo esc_url( WWP_Helper_Functions::get_utm_url( 'bundle', 'wwp', 'upsell', 'wwpgettingstartedbundlelink' ) ); ?>" target="_blank">
                                <?php esc_html_e( 'Get All Access Bundle &rarr;', 'woocommerce-wholesale-prices' ); ?>
                            </a>
                        </p>
                    </div>
                    <div class="right-content">
                        <div class="wws-bundle-4-image">
                            <img src="<?php echo esc_url( WWP_IMAGES_URL ); ?>wholesalesuite-bundle-4.png" alt="" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="wws-getting-started-container">
        <div class="wws-row">
            <h3 class="wws-section-title"><?php esc_html_e( 'What Store Owners Are Saying', 'woocommerce-wholesale-prices' ); ?></h3>
        </div>
        <div class="wws-row">
            <div class="reviews-container">
                <div class="review">
                    <svg
                        width="64" height="64" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg"
                        xmlns:xlink="http://www.w3.org/1999/xlink"
                    >
                        <circle cx="43" cy="42.7441" r="42.5" fill="url(#pattern0_5911_20280)" />
                        <defs>
                            <pattern
                                id="pattern0_5911_20280" patternContentUnits="objectBoundingBox" width="1" height="1"
                            >
                                <use
                                    xlink:href="#image0_5911_20280"
                                    transform="translate(-0.0394631 -0.00287869) scale(0.0126582)"
                                />
                            </pattern>
                            <image
                                id="image0_5911_20280" width="427" height="79"
                                xlink:href="data:image/png;base64,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"
                            />
                        </defs>
                    </svg>
                    <div class="review-author">
                        Laura Hartwig
                    </div>
                    <div class="review-stars">
                        <?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                    <p class="review-content">
                        <?php esc_html_e( '"Makes using wholesale prices simple."', 'woocommerce-wholesale-prices' ); ?>
                    </p>
                </div>
                <div class="review">
                    <svg width="64" height="64" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <circle cx="43" cy="42.7441" r="42.5" fill="url(#pattern0_5923_141)"/>
                        <defs>
                            <pattern id="pattern0_5923_141" patternContentUnits="objectBoundingBox" width="1" height="1">
                                <use xlink:href="#image0_5923_141" transform="translate(-1.11341 0.00241169) scale(0.0126582)"/>
                            </pattern>
                            <image id="image0_5923_141" width="427" height="79" xlink:href="data:image/png;base64,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"/>
                        </defs>
                    </svg>
                    <div class="review-author">
                        David Swanson
                    </div>
                    <div class="review-stars">
                        <?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                    <p class="review-content">
                        <?php esc_html_e( '"Thank you for a great WooCommerce plugin."', 'woocommerce-wholesale-prices' ); ?>
                    </p>
                </div>
                <div class="review">
                    <svg width="64" height="64" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <circle cx="43" cy="42.7441" r="42.5" fill="url(#pattern0_5923_80)"/>
                        <defs>
                            <pattern id="pattern0_5923_80" patternContentUnits="objectBoundingBox" width="1" height="1">
                                <use xlink:href="#image0_5923_80" transform="translate(-2.20253) scale(0.0126582)"/>
                            </pattern>
                            <image id="image0_5923_80" width="427" height="79" xlink:href="data:image/png;base64,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"/>
                        </defs>
                    </svg>
                    <div class="review-author">
                        Agentur Roth
                    </div>
                    <div class="review-stars">
                        <?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                    <p class="review-content">
                        <?php esc_html_e( '"Cool plugin - ingeniously simple, simply ingenious."', 'woocommerce-wholesale-prices' ); ?>
                    </p>
                </div>
                <div class="review">
                    <svg width="64" height="64" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <circle cx="43" cy="42.7441" r="42.5" fill="url(#pattern0_5923_143)"/>
                        <defs>
                            <pattern id="pattern0_5923_143" patternContentUnits="objectBoundingBox" width="1" height="1">
                                <use xlink:href="#image0_5923_143" transform="translate(-3.26403 -0.00259344) scale(0.0126582)"/>
                            </pattern>
                            <image id="image0_5923_143" width="427" height="79" xlink:href="data:image/png;base64,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"/>
                        </defs>
                    </svg>
                    <div class="review-author">
                        Kjc9901
                    </div>
                    <div class="review-stars">
                        <?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                    <p class="review-content">
                        <?php esc_html_e( '"Amazing plugin that is easy to set up!"', 'woocommerce-wholesale-prices' ); ?>
                    </p>
                </div>
                <div class="review">
                    <svg width="64" height="64" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <circle cx="43" cy="42.7441" r="42.5" fill="url(#pattern0_5923_146)"/>
                        <defs>
                            <pattern id="pattern0_5923_146" patternContentUnits="objectBoundingBox" width="1" height="1">
                                <use xlink:href="#image0_5923_146" transform="translate(-4.34173 -0.00259344) scale(0.0126582)"/>
                            </pattern>
                            <image id="image0_5923_146" width="427" height="79" xlink:href="data:image/png;base64,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"/>
                        </defs>
                    </svg>
                    <div class="review-author">
                        Leo Koo
                    </div>
                    <div class="review-stars">
                        <?php echo $five_stars; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                    <p class="review-content">
                        <?php esc_html_e( '"Great stuff as usual from Rymera!"', 'woocommerce-wholesale-prices' ); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
