<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
if ( ! empty( $order_items ) ) : ?>
<table class="widefat striped" style="font-family:monospace; text-align:left; width:100%;">
    <tbody>
        <p>  <?php echo 'Type: ' . esc_html( $type ); ?> </p>
        <?php
            foreach ( $order_items as $order_item ) :
                $data = $order_item->get_data();
                foreach ( $data as $key => $value ) :
                    if ( 'meta_data' === $key ) :
                        foreach ( $value as $meta ) :
                            ?>
                            <tr>
                                <th style="width:20%;"><?php echo 'meta_data[' . esc_html( $meta->get_data()['key'] ) . ']'; ?></th>
                                <td>
                                    <?php
                                    $value = $meta->get_data()['value'];
                                    switch ( $value ) {
                                    case is_array( $value ):
                                        echo '<pre>' . esc_html( print_r( $value, true ) ) . '</pre>'; // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                                        break;
                                    case is_object( $value ):
                                        echo '<pre>' . esc_html( print_r( $value, true ) ) . '</pre>'; // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                                        break;
                                    default:
                                        echo esc_html( $value );
                                        break;
                                    }
                                    ?>
                                </td>   
                            </tr>
                            <?php
                        endforeach;
                    else :
                        ?>
                        <tr>
                            <th style="width:20%;"><?php echo esc_html( $key ); ?></th>
                            <td>
                                <?php
                                switch ( $value ) {
                                    case is_array( $value ):
                                        echo '<pre>' . esc_html( print_r( $value, true ) ) . '</pre>'; // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                                        break;
                                    case is_object( $value ):
                                        echo '<pre>' . esc_html( print_r( $value, true ) ) . '</pre>'; // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                                        break;
                                    default:
                                        echo esc_html( $value );
                                        break;
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                    endif;
                endforeach;
            endforeach;
        ?>
    </tbody>
</table>
<?php else : ?>
<p><?php echo 'No order item data is associated with type: ' . esc_html( $type ); ?></p>
<?php endif; ?>
