<?php

/**
 *
 * This file is part of phpFastCache.
 *
 * @license MIT License (MIT)
 *
 * For full copyright and license information, please see the docs/CREDITS.txt file.
 *
 * @author Khoa Bui (khoaofgod)  <khoaofgod@gmail.com> https://www.phpfastcache.com
 * @author Georges.L (Geolim4)  <contact@geolim4.com>
 *
 */
declare (strict_types=1);
namespace WCPOS\Vendor\Phpfastcache\Drivers\Mongodb;

use WCPOS\Vendor\Phpfastcache\Config\ConfigurationOption;
class Config extends ConfigurationOption
{
    /**
     * @var string
     */
    protected $host = '127.0.0.1';
    /**
     * @var int
     */
    protected $port = 27017;
    /**
     * @var int
     */
    protected $timeout = 3;
    /**
     * @var string
     */
    protected $username = '';
    /**
     * @var string
     */
    protected $password = '';
    /**
     * @var array
     */
    protected $servers = [];
    /**
     * @var string
     */
    protected $collectionName = 'phpfastcache';
    /**
     * @var string
     */
    protected $databaseName = Driver::MONGODB_DEFAULT_DB_NAME;
    /**
     * @var array
     */
    protected $options = [];
    /**
     * @var array
     */
    protected $driverOptions = [];
    /**
     * @var string
     */
    protected $protocol = 'mongodb';
    /**
     * @return string
     */
    public function getHost() : string
    {
        return $this->host;
    }
    /**
     * @param string $host
     * @return self
     */
    public function setHost(string $host) : self
    {
        $this->host = $host;
        return $this;
    }
    /**
     * @return int
     */
    public function getPort() : int
    {
        return $this->port;
    }
    /**
     * @param int $port
     * @return self
     */
    public function setPort(int $port) : self
    {
        $this->port = $port;
        return $this;
    }
    /**
     * @return int
     */
    public function getTimeout() : int
    {
        return $this->timeout;
    }
    /**
     * @param int $timeout
     * @return self
     */
    public function setTimeout(int $timeout) : self
    {
        $this->timeout = $timeout;
        return $this;
    }
    /**
     * @return string
     */
    public function getUsername() : string
    {
        return $this->username;
    }
    /**
     * @param string $username
     * @return self
     */
    public function setUsername(string $username) : self
    {
        $this->username = $username;
        return $this;
    }
    /**
     * @return string
     */
    public function getPassword() : string
    {
        return $this->password;
    }
    /**
     * @param string $password
     * @return self
     */
    public function setPassword(string $password) : self
    {
        $this->password = $password;
        return $this;
    }
    /**
     * @return array
     */
    public function getServers() : array
    {
        return $this->servers;
    }
    /**
     * @param array $servers
     * @return self
     */
    public function setServers(array $servers) : self
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * @return string
     */
    public function getCollectionName() : string
    {
        return $this->collectionName;
    }
    /**
     * @param string $collectionName
     * @return self
     */
    public function setCollectionName(string $collectionName) : self
    {
        $this->collectionName = $collectionName;
        return $this;
    }
    /**
     * @return string
     */
    public function getDatabaseName() : string
    {
        return $this->databaseName;
    }
    /**
     * @param string $databaseName
     * @return self
     */
    public function setDatabaseName(string $databaseName) : self
    {
        $this->databaseName = $databaseName;
        return $this;
    }
    /**
     * @return array
     */
    public function getOptions() : array
    {
        return $this->options;
    }
    /**
     * @see https://docs.mongodb.com/manual/reference/connection-string/#connections-connection-options
     * @param array $options
     * @return Config
     */
    public function setOptions(array $options) : self
    {
        $this->options = $options;
        return $this;
    }
    /**
     * @return array
     */
    public function getDriverOptions() : array
    {
        return $this->driverOptions;
    }
    /**
     * @param array $driverOptions
     * @return self
     */
    public function setDriverOptions(array $driverOptions) : self
    {
        $this->driverOptions = $driverOptions;
        return $this;
    }
    /**
     * @return string
     */
    public function getProtocol() : string
    {
        return $this->protocol;
    }
    /**
     * @param string $protocol
     * @return self
     */
    public function setProtocol(string $protocol) : self
    {
        $this->protocol = $protocol;
        return $this;
    }
}
