<?php

/**
 *
 * This file is part of phpFastCache.
 *
 * @license MIT License (MIT)
 *
 * For full copyright and license information, please see the docs/CREDITS.txt file.
 *
 * @author Khoa Bui (khoaofgod)  <khoaofgod@gmail.com> https://www.phpfastcache.com
 * @author Georges.L (Geolim4)  <contact@geolim4.com>
 *
 */
declare (strict_types=1);
namespace WCPOS\Vendor\Phpfastcache\Drivers\Cassandra;

use WCPOS\Vendor\Phpfastcache\Config\ConfigurationOption;
class Config extends ConfigurationOption
{
    /**
     * @var string
     */
    protected $host = '127.0.0.1';
    /**
     * @var int
     */
    protected $port = 9042;
    /**
     * @var int
     */
    protected $timeout = 2;
    /**
     * @var string
     */
    protected $username = '';
    /**
     * @var string
     */
    protected $password = '';
    /**
     * @var bool
     */
    protected $sslEnabled = \false;
    /**
     * @var bool
     */
    protected $sslVerify = \false;
    /**
     * @var bool
     */
    protected $useLegacyExecutionOptions = \false;
    /**
     * @return string
     */
    public function getHost() : string
    {
        return $this->host;
    }
    /**
     * @param string $host
     * @return self
     */
    public function setHost(string $host) : self
    {
        $this->host = $host;
        return $this;
    }
    /**
     * @return int
     */
    public function getPort() : int
    {
        return $this->port;
    }
    /**
     * @param int $port
     * @return self
     */
    public function setPort(int $port) : self
    {
        $this->port = $port;
        return $this;
    }
    /**
     * @return int
     */
    public function getTimeout() : int
    {
        return $this->timeout;
    }
    /**
     * @param int $timeout
     * @return self
     */
    public function setTimeout(int $timeout) : self
    {
        $this->timeout = $timeout;
        return $this;
    }
    /**
     * @return string
     */
    public function getUsername() : string
    {
        return $this->username;
    }
    /**
     * @param string $username
     * @return self
     */
    public function setUsername(string $username) : self
    {
        $this->username = $username;
        return $this;
    }
    /**
     * @return string
     */
    public function getPassword() : string
    {
        return $this->password;
    }
    /**
     * @param string $password
     * @return self
     */
    public function setPassword(string $password) : self
    {
        $this->password = $password;
        return $this;
    }
    /**
     * @return bool
     */
    public function isSslEnabled() : bool
    {
        return $this->sslEnabled;
    }
    /**
     * @param bool $sslEnabled
     * @return self
     */
    public function setSslEnabled(bool $sslEnabled) : self
    {
        $this->sslEnabled = $sslEnabled;
        return $this;
    }
    /**
     * @return bool
     */
    public function isSslVerify() : bool
    {
        return $this->sslVerify;
    }
    /**
     * @param bool $sslVerify
     * @return self
     */
    public function setSslVerify(bool $sslVerify) : self
    {
        $this->sslVerify = $sslVerify;
        return $this;
    }
    /**
     * @return bool
     */
    public function isUseLegacyExecutionOptions() : bool
    {
        return $this->useLegacyExecutionOptions;
    }
    /**
     * @param bool $useLegacyExecutionOptions
     * @return $this
     */
    public function setUseLegacyExecutionOptions(bool $useLegacyExecutionOptions) : self
    {
        $this->useLegacyExecutionOptions = $useLegacyExecutionOptions;
        return $this;
    }
}
