<?php

declare(strict_types=1);

use MyParcelNL\Sdk\src\Model\Consignment\AbstractConsignment;
use MyParcelNL\WooCommerce\includes\adapter\RecipientFromWCOrder;
use WPO\WC\MyParcel\Compatibility\Order as WCX_Order;
use WPO\WC\MyParcel\Compatibility\WC_Core as WCX;
use MyParcelNL\WooCommerce\includes\admin\OrderSettings;

defined('ABSPATH') or die();

include('html-start.php');

/**
 * @var array $order_ids
 */

$export_return = WCMP_Export::EXPORT_RETURN;
$export        = WCMP_Export::EXPORT;

$order_ids_string = implode(';', $order_ids);

$target_url = wp_nonce_url(
    admin_url("admin-ajax.php?action=$export&request=$export_return&modal=true&order_ids=$order_ids_string"),
    WCMYPA::NONCE_ACTION
);

?>
    <form
        method="post" class="page-form wcmp__bulk-options wcmp__return-dialog" action="<?php echo esc_url($target_url); ?>">
        <table style="width: 100%">
            <tbody>
            <?php
            $c = true;
            foreach ($order_ids as $order_id) :
                $order         = WCX::get_order($order_id);
                $orderSettings = new OrderSettings($order);

                // skip non-myparcel destinations
                $shipping_country = WCX_Order::get_prop($order, 'shipping_country');
                if (! WCMP_Country_Codes::isAllowedDestination($shipping_country)) {
                    continue;
                }

                $recipient     = (new RecipientFromWCOrder($order, AbstractConsignment::CC_NL, RecipientFromWCOrder::SHIPPING))->toArray();
                $package_types = WCMP_Data::getPackageTypes();
                ?>
                <tr
                    class="order-row <?php echo(($c = ! $c)
                        ? 'alternate'
                        : ''); ?>">
                    <td>
                        <table style="width: 100%">
                            <tr>
                                <td colspan="2">
                                    <strong>
                                        <?php echo sprintf(
                                            '%s %s',
                                            esc_html__('Order', 'woocommerce-myparcel'),
                                            esc_html($order->get_order_number())
                                        ); ?>
                                    </strong>
                                </td>
                            </tr>
                            <tr>
                                <td class="ordercell">
                                    <table class="widefat">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th><?php esc_html_e("Product name", "woocommerce-myparcel"); ?></th>
                                            <th class="wcmp__text--right"><?php esc_html_e("weight", "woocommerce-myparcel"); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($order->get_items() as $item_id => $item) : ?>
                                            <tr>
                                                <td><?php echo (int) $item['qty'], 'x'; ?></td>
                                                <td><?php echo esc_html(WCMP_Export::get_item_display_name($item, $order)) ?></td>
                                                <td class="wcmp__text--right">
                                                    <?php

                                                    $weight = $item->get_product()->weight ?? null;

                                                    if ($weight) {
                                                        echo esc_html(wc_format_weight($weight * $item['qty']));
                                                    } else {
                                                        echo esc_html__('N/A', 'woocommerce-myparcel');
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th>&nbsp;</th>
                                            <th><?php esc_html_e("Total weight", "woocommerce-myparcel"); ?></th>
                                            <th class="wcmp__text--right">
                                                <?php
                                                $weight = $orderSettings->getWeight();

                                                if ($weight) {
                                                    echo esc_html(wc_format_weight($weight));
                                                } else {
                                                    echo esc_html__('N/A', 'woocommerce-myparcel');
                                                }
                                                ?>
                                            </th>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </td>
                                <td>
                                    <?php
                                    if (WCMP_Data::isHomeCountry($shipping_country)
                                    && (empty($recipient['street']) || empty($recipient['number']))): ?>
                                    <p>
                                        <span style="color:red">
                                            <?php __(
                                                "This order does not contain valid street and house number data and cannot be exported because of this! This order was probably placed before the MyParcel plugin was activated. The address data can still be manually entered in the order screen.",
                                                "woocommerce-myparcel"
                                            ); ?>
                                        </span>
                                    </p>
                                </td>
                            </tr> <!-- last row -->
                            <?php else: // required address data is available
                                // print address
                                echo '<p>', wp_kses_post($order->get_formatted_shipping_address()), '<br/>', esc_html(WCX_Order::get_prop(
                                        $order,
                                        'billing_phone'
                                    )), '<br/>', esc_html(WCX_Order::get_prop($order, 'billing_email')), '</p>';
                                ?>
                                </td></tr>
                                <tr>
                                    <td
                                        colspan="2" class="wcmp__shipment-options">
                                        <?php
                                        $skip_save = true; // dont show save button for each order
                                        if (isset($dialog) && $dialog === 'shipment') {
                                            include('html-order-shipment-options.php');
                                        } else {
                                            include('html-order-return-shipment-options.php');
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div>
            <?php
            if (isset($dialog) && $dialog === 'shipment') {
                $button_text = __('action_export_to_myparcel', 'woocommerce-myparcel');
            } else {
                $button_text = __('Send email', 'woocommerce-myparcel');
            }
            ?>
            <div class="wcmp__d--flex">
                <input type="submit" value="<?php echo esc_html($button_text); ?>" class="button wcmp__return-dialog__save">
                <?php WCMYPA_Admin::renderSpinner() ?>
            </div>
        </div>
    </form>

<?php

include('html-end.php');
