# WC - APG Weight Shipping
Contributors: artprojectgroup

Donate link: https://artprojectgroup.es/tienda/donacion

Tags: WooCommerce, Shipping, Weight, Dimensions

Requires at least: 5.0

Tested up to: 6.9

Stable tag: 3.6.0.3

WC requires at least: 5.6

WC tested up to: 10.2.1

License: GPLv2 or later

License URI: https://www.gnu.org/licenses/gpl-2.0.html

Añade a WooCommerce el cálculo de los gastos de envío según el peso, dimensiones y el código postal, provincia (estado) y/o país del cliente.

## Description
**IMPORTANTE: *WC - APG Weight Shipping* requiere WooCommerce 2.6.0 o superior.**

**NOTA: WooCommerce - APG Weight and Postcode/State/Country Shipping ahora se llama *WC - APG Weight Shipping*.**

**WC - APG Weight Shipping** añade a tu tienda WooCommerce la posibilidad de calcular los gastos de envío basándose en el peso y en el código postal, provincia (estado) y/o país de la dirección de envío.

### Características
* Totalmente compatible con los bloques Carrito y Finalizar compra del editor de bloques de WordPress.
* Puedes añadir un coste fijo de embalaje y/o manipulación por envío.
* Puedes añadir, además del coste de embalaje, un coste fijo adicional en forma de cantidad o porcentaje, por envío o producto.
* Puedes crear un número ilimitado de tarifas.
* Puedes crear las tarifas con un peso y/o dimensiones máximos.
* Puedes crear tarifas con peso mínimo distinto de cero.
* Puedes crear tarifas repetitivas con un número máximo de tarifas.
* Puedes crear tarifas por número de productos.
* Puedes crear tarifas por total del pedido.
* Puedes asignar tarifas a clases de envío específicas.
* Puedes seleccionar la tarifa de clase de envío más cara en lugar de la suma de tarifas.
* Puedes elegir si aceptar excesos de peso o dimensiones.
* Puedes excluir el envío de una o varias categorías de producto.
* Puedes excluir el envío de una o varias etiquetas de producto.
* Puedes excluir el envío de uno o varios atributos.
* Puedes excluir el envío de una, varias o todas las clases de envío del sistema.
* Puedes excluir roles de usuario.
* Puedes ocultar medios de pago.
* Puedes ocultar métodos de envío de la misma zona de envío.
* Puedes mostrar una imagen personalizada.
* Puedes mostrar el tiempo estimado de entrega.
* Puedes modificar el título del método de envío con el filtro `apg_shipping_label`.
* Puedes modificar la etiqueta del método de envío con el filtro `apg_shipping_final_label`.
* Puedes eliminar el texto previo del tiempo estimado de entrega con el filtro `apg_shipping_delivery`.
* Totalmente compatible con el plugin [WooCommerce Product Bundles](https://woocommerce.com/products/product-bundles/).
* Totalmente compatible con el plugin [WPML](https://wpml.org/?aid=80296&affiliate_key=m66Ss5ps0xoS).

### Traducciones
* Español ([**Art Project Group**](https://artprojectgroup.es/)).
* English ([**Art Project Group**](https://artprojectgroup.es/)).
* Français ([**Guillaume**](https://guillaume-thibord.com/)).
* Português ([**Alain Aubry**](https://www.casa-indigo.com/)).
* Português (Brasil) ([**Danilo Lopes da Silva**](https://www.armarinhosdonaflor.com.br/)).
* Italiano ([**Angelo Lazzari**](https://www.redtulp.com/)).

### Soporte técnico
**Art Project Group** te ofrece [**Soporte técnico**](https://artprojectgroup.es/tienda/ticket-de-soporte) para configurar o instalar ***WC - APG Weight Shipping***.

### Origen
**WC - APG Weight Shipping** ha sido programado a partir del plugin [*AWD Weight/Country Shipping*](https://wordpress.org/plugins/awd-weightcountry-shipping/) de [Andy_P](https://profiles.wordpress.org/andy_p/) y la modificación de [Mantish](https://wordpress.org/support/profile/mantish) publicada en [GitHub](https://gist.github.com/Mantish/5658280), que, a pesar de su brillantez, no ofrecían todas las características que necesitábamos. Aún así su trabajo ha sido completamente imprescindible para la realización de este plugin.

### Más información
En nuestro sitio web oficial puede obtener más información sobre [**WC - APG Weight Shipping**](https://artprojectgroup.es/plugins-para-woocommerce/wc-apg-weight-shipping). 

### Comentarios
No olvides dejarnos tu comentario en:

* [WC - APG Weight Shipping](https://artprojectgroup.es/plugins-para-woocommerce/wc-apg-weight-shipping) en Art Project Group.
* [Art Project Group](https://www.facebook.com/artprojectgroup) en Facebook.
* [@artprojectgroup](https://twitter.com/artprojectgroup) en Twitter.

### Más plugins
Recuerda que puedes encontrar más [plugins para WordPress](https://artprojectgroup.es/plugins-para-wordpress) y más [plugins para WooCommerce](https://artprojectgroup.es/plugins-para-woocommerce) en [Art Project Group](https://artprojectgroup.es) y en nuestro perfil en [WordPress](https://profiles.wordpress.org/artprojectgroup/).

### GitHub
Puedes seguir el desarrollo de este plugin en [Github](https://github.com/artprojectgroup/woocommerce-apg-weight-and-postcodestatecountry-shipping).

## Instalación
1. Puedes:
 * Subir la carpeta `woocommerce-apg-weight-and-postcodestatecountry-shipping` al directorio `/wp-content/plugins/` vía FTP. 
 * Subir el archivo ZIP completo vía *Plugins -> Añadir nuevo -> Subir* en el Panel de Administración de tu instalación de WordPress.
 * Buscar **WC - APG Weight Shipping** en el buscador disponible en *Plugins -> Añadir nuevo* y pulsar el botón *Instalar ahora*.
2. Activar el plugin a través del menú *Plugins* en el Panel de Administración de WordPress.
3. Configurar el plugin en *WooCommerce -> Ajustes -> Envío* o a través del botón *Ajustes*.
4. Listo, ahora ya puedes disfrutar de él, y si te gusta y te resulta útil, hacer una [*donación*](https://artprojectgroup.es/tienda/donacion).


## Preguntas frecuentes
### ¿Cómo se configura?
Como la configuración del plugin es un poco compleja, hemos creado un tutorial donde explicamos paso a paso el proceso de configuración con un ejemplo real. Puedes visitarlo en [¿Cómo se configura WooCommerce – APG Weight and Postcode/State/Country Shipping?](https://artprojectgroup.es/como-se-configura-woocommerce-apg-weight-and-postcodestatecountry-shipping).

### Soporte técnico
Si necesitas ayuda para configurar o instalar **WC - APG Weight Shipping**, **Art Project Group** te ofrece su servicio de [**Soporte técnico**](https://artprojectgroup.es/tienda/ticket-de-soporte). 

*En ningún caso **Art Project Group** proporciona ningún tipo de soporte técnico gratuito.*

## Changelog
### 3.6.0.3
* Pequeños arreglos.

### 3.6.0.2
* Pequeños arreglos.

### 3.6.0.1
* Pequeños arreglos.

### 3.6
* Añadido filtro `apg_shipping_final_label`.
* Añadidos los phpDocs en el código.
* Pequeños arreglos.

### 3.5.0.2
* Pequeños arreglos.

### 3.5.0.1
* Pequeños arreglos.

### 3.5
* Corregida la gestión de las tarifas con la opción "Mostrar el precio máximo" activada.
* Corregida la visualización de la opción de depuración en el entorno clásico (sin bloques).
* Pequeños arreglos.

### 3.4.2
* Pequeños arreglos.

### 3.4.1
* Pequeños arreglos.

### 3.4
* Corregida la gestión de las tarifas con pesos decimales.
* Limitada la visualización de la opción de depuración a usuarios administradores.
* Pequeños arreglos.

### 3.3.0.1
* Pequeños arreglos.

### 3.3
* Añadida opción para crear tarifas con peso mínimo distinto de cero.
* Añadida opción para crear tarifas repetitivas con un número máximo de tarifas.
* Mejorada la opción de depuración.
* Añadida opción de copiado del texto de depuración al portapapeles.
* Mejora de la seguridad.
* Mejora de rendimiento general.
* Adecuación completa del código a los estándares de seguridad marcadas por WordPress.
* Añade soporte al bloque Finalizar compra.
* Pequeños arreglos.

### 3.2.1
* Versión 2.6.5 temporalmente restablecida.

### 3.2.0.1
* Corrección en el cálculo de tarifas.

### 3.2
* Reprogramación del código encargado de gestionar las tarifas y realizar el cálculo del total del gasto de envío.
* Añadida opción de copiado del texto de depuración al portapapeles.

### 3.1
* Añade soporte a los bloques Carrito y Finalizar compra.

### 3.0.0.2
* Pequeños arreglos.

### 3.0.0.1
* Pequeños arreglos.

### 3.0
* Añadida opción para crear tarifas con peso mínimo distinto de cero.
* Añadida opción para crear tarifas repetitivas con un número máximo de tarifas.
* Mejorada la opción de depuración.
* Mejora de la seguridad.
* Mejora de rendimiento general.
* Adecuación completa del código a los estándares de seguridad marcadas por WordPress.
* Pequeños arreglos.

### 2.6.5
* Pequeños arreglos.

### 2.6.4
* Pequeños arreglos.

### 2.6.3
* Pequeños arreglos.

### 2.6.2
* Pequeños arreglos.

### 2.6.1
* Pequeños arreglos.

### 2.6.0.1
* Pequeños arreglos.

### 2.6
* Pequeños arreglos.
* Mejora del rendimiento.

### 2.5.0.6
* Pequeños arreglos.

### 2.5.0.5
* Actualización de cabecera.
* Actualización de hoja de estilo.
* Actualización de captura de pantalla.

### 2.5.0.4
* Corregido un problema de compatibilidad con el plugin CTT Express.

### 2.5.0.3
* Pequeños arreglos.

### 2.5.0.2
* Pequeños arreglos.

### 2.5.0.1
* Pequeños arreglos.

### 2.5
* Añadida opción para excluir el envío por atributos. **Actualización patrocinada por [YonofumoYovapeo](https://yonofumoyovapeo.com)**.
* Añadido filtro `apg_shipping_label`.
* Actualización de captura de pantalla.

### 2.4.0.9
* Pequeños arreglos.

### 2.4.0.8
* Añadido filtro `apg_shipping_delivery`.
* Pequeños arreglos.

### 2.4.0.7
* Pequeños arreglos.

### 2.4.0.6
* Pequeños arreglos.

### 2.4.0.5
* Pequeños arreglos.

### 2.4.0.4
* Pequeños arreglos.

### 2.4.0.3
* Pequeños arreglos.

### 2.4.0.2
* Pequeños arreglos.

### 2.4.0.1
* Pequeños arreglos.

### 2.4
* Añadida opción para excluir métodos de envío de la misma zona de envío. **Actualización patrocinada por [YonofumoYovapeo](https://yonofumoyovapeo.com)**.

### 2.3.2.3
* Pequeños arreglos.

### 2.3.2.2
* Pequeños arreglos.

### 2.3.2.1
* Pequeños arreglos.

### 2.3.2
* Mejora del rendimiento.
* Pequeños arreglos.

### 2.3.1.7
* Vuelta a la versión 2.3.1.5

### 2.3.1.6
* Pequeños arreglos.

### 2.3.1.5
* Pequeños arreglos.

### 2.3.1.4
* Pequeñas correcciones en el cálculo de los costes de envío. **Notificado por [aceone999](https://wordpress.org/support/topic/wrong-fee-with-shipping-classes/)**.

### 2.3.1.3
* Pequeños arreglos.

### 2.3.1.2
* Pequeñas correcciones en el cálculo de los costes de envío. **Notificado por [aceone999](https://wordpress.org/support/topic/version-2-3-1-1-still-broken/)**.

### 2.3.1.1
* Pequeñas correcciones en el cálculo de los costes de envío. **Notificado por [aceone999](https://wordpress.org/support/topic/bug-for-dimensions-in-2-3-1/)**.

### 2.3.1
* Función de generación de tarifas reescrita.

### 2.3.0.3
* Pequeñas correcciones en el cálculo de los costes de envío. **Notificado por [lepress](https://wordpress.org/support/topic/fee-is-wrong-for-being-ignorant-the-shipping-class/#post-11943232)**.


### 2.3.0.2
* Pequeños arreglos en la exclusión del envío por categorías y etiquetas de producto.

### 2.3.0.1
* Pequeños arreglos.

### 2.3
* Añadidas opciones para excluir el envío por categorías y etiquetas de producto. **Actualización patrocinada por [YonofumoYovapeo](https://yonofumoyovapeo.com)**.
* Actualización de captura de pantalla.

### 2.2.3.4
* Pequeños arreglos.

### 2.2.3.3
* Pequeños arreglos.

### 2.2.3.2
* Pequeños arreglos.

### 2.2.3.1
* Pequeños arreglos.

### 2.2.3
* Cambio de nombre del plugin: de WooCommerce - APG Weight and Postcode/State/Country Shipping a WC - APG Weight Shipping.

### 2.2.2.2
* Ajuste para optimizar la compatibilidad con WooCommerce Product Bundles.

### 2.2.2.1
* Actualización de cabecera.
* Actualización de hoja de estilo.
* Actualización de captura de pantalla.

### 2.2.2
* Corregido problema de compatibilidad con Polylang.
* Añadido campo de depuración.

### 2.2.1.6
* Arreglo de campos rotos.

### 2.2.1.5
* Soporte para el plugin [WPML](https://wpml.org/?aid=80296&affiliate_key=m66Ss5ps0xoS).

### 2.2.1.4
* Ajuste para optimizar la compatibilidad con WooCommerce Product Bundles.
* Arreglo de error detectado con WooCommerce Germanized Pro.

### 2.2.1.3
* Soporte para el plugin [WooCommerce Product Bundles](https://woocommerce.com/products/product-bundles/).

### 2.2.1.2
* Arreglo de configuración del plugin.

### 2.2.1.1
* Arreglo de localización.

### 2.2.1
* Arreglo de error con el cálculo de gastos de envío por clases de envío.

### 2.2.0.4
* Ajuste para optimizar la compatibilidad con WooCommerce 3.0.

### 2.2.0.3
* Ajuste para optimizar la compatibilidad con WooCommerce 3.0.

### 2.2.0.2
* Prevención de error en la página Mi cuenta.

### 2.2.0.1
* Prevención de error en caso de estar desactivado WooCommerce.

### 2.2
* Soporte para ocultar medios de pago.

### 2.1.0.1
* Arreglo de error en la clave de rol de usuario.

### 2.1
* Soporte de roles de usuario para no realizar envíos gratuitos. **Actualización patrocinada por [**Dermoder**](http://dermoder.com)** 
* Soporte de tarifas por total de pedido. **Actualización patrocinada por [**Marketing Paradise**](https://mkparadise.com)**
* Soporte para seleccionar la tarifa de clase de envío más cara.
* Soporte para añadir imagen personalizada.
* Soporte para añadir el tiempo estimado de entrega.
* Actualización de la captura de pantalla.

### 2.0.3.1
* Ajuste para optimizar la compatibilidad con WooCommerce 2.7.

### 2.0.3
* Soporte para instalaciones multisitio.

### 2.0.2.6
* Arreglo de error con el cálculo de tarifas únicas.
* Actualización de código no compatible con WooCommerce 2.7.

### 2.0.2.5
* Arreglo de error con el cálculo de gastos de envío por clases de envío.

### 2.0.2.4
* Arreglo de error con el cálculo de gastos de envío sin sobrepeso/dimensión.
* Arreglo de error con el cálculo de gastos de envío por clases de envío.

### 2.0.2.3
* Añadida opción para activar o desactivar un método de envío.

### 2.0.2.2
* Eliminada la carga de código CSS inexistente.

### 2.0.2.1
* Arreglo de error en el borrado del plugin.

### 2.0.2
* Reescrito el cálculo de tarifas por clases de envío.

### 2.0.1.1
* Arreglo de error con la gestión de clases de envío.

### 2.0.1
* Soporte para múltiples gastos de envío por zona de envío.

### 2.0
* Compatibilidad completa con WooCommerce 2.6. **Nota: No es compatible con versiones anteriores a 2.6.0, tampoco su configuración.**

### 1.9.3.1
* Creación de alerta de seguridad para la próxima versión 2.0.

### 1.9.3
* Eliminada la posibilidad de vincular con medios de pago.

### 1.9.2
* Arreglo de error en el listado de medios de pago.

### 1.9.1.1
* Arreglo de error con el cálculo de impuestos al 0%.

### 1.9.1
* Actualización de código para mantener compatibilidad con la nueva versión de **WooCommerce - APG Free Postcode/State/Country Shipping**.
* Actualización de la primera captura de pantalla.

### 1.9.0.6
* Actualización de enlaces de soporte y pequeñas actualizaciones.

### 1.9.0.5
* Arreglo de error con las medidas reportado y solucionado por [DJ Team Digital](http://www.teamdigital.com.au/).

### 1.9.0.4
* Actualización del paquete de fuentes. Nuevo icono de Google+.
* Actualización de las traducciones.

### 1.9.0.3
* Traducción al idioma portugués gracias a [**Alain Aubry**](http://www.casa-indigo.com/).

### 1.9.0.2
* Control de activación de WooCommerce.

### 1.9.0.1
* Eliminación de Warning que aparecía al crear nuevos gastos de envío.
* Actualización de la captura de pantalla.

### 1.9
* Actualización del formulario que permite crear nuevos métodos de envío APG y creación de nuevas funciones que permiten sincronizarlo con las nuevas funcionalidades de WooCommerce 2.4.
* Actualización de idiomas.
* Actualización de la captura de pantalla.

### 1.8.0.4
* Eliminación de Warning que aparecía en determinadas instalaciones.

### 1.8.0.3
* Traducción al idioma italiano gracias a [**Angelo Lazzari**](http://www.redtulp.com/).
* Actualización del idioma francés.

### 1.8.0.2
* Traducción al idioma portugués (Brasil) gracias a [**Danilo Lopes da Silva**](http://www.armarinhosdonaflor.com.br/).

### 1.8.0.1
* Eliminación de mensaje que aparecía en el checkout.

### 1.8
* Arreglo del cálculo de medidas.
* Arreglo de error que mostraba clases de envío en blanco.
* Arreglo de error detectado al actualizar los países específicos.
* Añadida nueva opción para no realizar envíos a determinadas clases de envío.
* Actualización de las traducciones.
* Nueva hoja de estilo sensible.
* Actualización de la captura de pantalla.

### 1.7.5.2
* Arreglo de error detectado en el cálculo de los impuestos.

### 1.7.5.1
* Arreglo de error detectado en el cálculo de los impuestos.

### 1.7.5
* Arreglo de error en el manejo de códigos postales. Error descrito en [Support](https://wordpress.org/support/topic/order-of-post-code-wildcards-may-produce-wrong-results).
* Modificación de la estructura interna del plugin para ajustarse a los estándares de WordPress.

### 1.7.4.2
* Arreglo de error detectado en el cálculo de los impuestos.

### 1.7.4.1
* Arreglo de error que impedía realizar la compra en configuraciones sin impuestos.

### 1.7.4
* Arreglo de error que impedía realizar la compra.
* Mejora en el cálculo de totales con clases de envío múltiples.

### 1.7.3.10
* Arreglo de error detectado en el cálculo de los impuestos.

### 1.7.3.9
* Traducción al idioma francés gracias a [**Guillaume**](http://guillaume-thibord.com/).

### 1.7.3.8
* Arreglo de error detectado en la lectura de las clases de envío múltiples.

### 1.7.3.7
* Arreglo de error detectado en el cálculo de los impuestos parciales.

### 1.7.3.6
* Arreglo de error detectado en el cálculo del cargo adicional.
* Arreglo de error detectado en el cálculo de los impuestos parciales.

### 1.7.3.5
* Arreglo de error detectado en el cálculo del cargo adicional.
* Arreglo de error detectado en la devolución del precio máximo.

### 1.7.3.4
* Arreglo de error detectado en el cálculo de los impuestos.

### 1.7.3.3
* Arreglo de error detectado en el cálculo de tarifas con clases de envío.

### 1.7.3.2
* Arreglo de error detectado en el cálculo de tarifas con clases de envío.

### 1.7.3.1
* Arreglo de error detectado en el cálculo de tarifas al desactivar la devolución del precio máximo.

### 1.7.3
* Arreglo de error detectado en el cálculo de tarifas por medidas.
* Control de error provocado por WooCommerce al leer los medios de cobro.

### 1.7.2.2
* Arreglo de error detectado en las tarifas mixtas (peso y medidas).

### 1.7.2.1
* Arreglo de error detectado en el listado de clases de envío del grupo global.

### 1.7.2
* Arreglo de error detectado en las tarifas mixtas (peso y medidas).

### 1.7.1
* Arreglo de error que no tenía en cuenta el país de origen en los grupos de códigos postales y provincias o estados.

### 1.7
* Arreglo de un error que se producía al crear gastos de envío adicionales.
* Nueva interfaz y función de gestión de la opción Gastos de envío adicionales.
* Optimización del código de **WC - APG Weight Shipping** para que consuma la menor cantidad de recursos posibles. Gracias *Óscar de la Mata Casasola* por el aviso.
* Nueva captura de pantalla.

### 1.6.3.2
* Arreglo de error en los cálculos de las tarifas para envíos que superan el máximo de peso introducido.

### 1.6.3.1
* Arreglo de error en los cálculos de las tarifas.

### 1.6.3
* Arreglo de error en los cálculos de las tarifas para el grupo de países global.

### 1.6.2
* Arreglo de error en los cálculos de las tarifas.

### 1.6.1
* Arreglo de error que no tenía en cuenta los grupos a no atender.

### 1.6
* Permite vincular el envío con una, varias o todas las clases de envío del sistema.
* Permite crear tarifas no ascendentes.
* Nuevos enlaces e iconos.
* Actualización de la hoja de estilo.

### 1.5.1.1
* Modificación de la URL del plugin en Art Project Group.

### 1.5.1
* Arreglo de error que borraba toda la configuración al desactivar el plugin.
* Corrección menor que evita la aparición de un código de error al recopilar información sobre el plugin.

### 1.5
* Arreglo de error detectado en el campo grupo global.
* Añadida selección de impuestos para el campo grupo global.

### 1.4.2
* Cambio del enlace de donación.

### 1.4.1
* Arreglo de error que aparecía al recopilar información sobre los medios de cobro.

### 1.4
* Arreglo de error en el cálculo del peso del pedido con variaciones de productos virtuales.
* Arreglo de error en el cálculo del impuesto.
* Corrección menor que evita la aparición de un código de error al recopilar información sobre el plugin.

### 1.3.6
* Arreglo que muestra correctamente los medios de cobro en todos los gastos de envío.
* Corrección del icono y enlace del botón de donación.

### 1.3.5
* Corrección menor que evita la aparición de un código de error al recopilar los medios de pago.

### 1.3.4
* Arreglo que muestra correctamente los medios de cobro en todos los gastos de envío.
* Añadida caché para los datos externos.
* Cambio del botón de donación.

### 1.3.3
* Arreglo de compatibilidad a WooCommerce 2.1.2 con los medios de cobro disponibles para cada gasto envío.

### 1.3.2
* Eliminación de mensaje de error que aparecía con WooCommerce configurado para vender en todos los países.

### 1.3.1
* Actualización del enlace de Ajustes.

### 1.3
* Actualización del código para que sea 100% compatible con la última versión de WooCommerce. **Ojo: No es compatible con versiones anteriores a WooCommerce 2.1.0.** 

### 1.2
* Añadida nueva función que limpia la base de datos al desinstalar el plugin.

### 1.1
* Añadida opción para seleccionar múltiples pasarelas de pago específicas para el gasto de envío.

### 1.0.2
* Añadido control de error que aparece al dejar campos vacíos.

### 1.0.1
* Eliminación de imagen externa por otra local.

### 1.0
* Actualización de las hojas de estilo acorde al nuevo WordPress.
* Arreglo de pequeños errores en el código.

### 0.9
* Añadida nueva opción que oculta el coste del envío en caso de estar habilitado WooCommerce - APG Free Postcode/State/Country Shipping.
* Oculta o muestra las opciones *Añadir países a específicos* y *Añadir grupo global* en función de la configuración de WooCommerce.
* Actualización de la captura de pantalla.

### 0.8
* Añadida opción para crear un grupo global, con soporte para todos los países no incluidos en el resto de grupos.
* Arreglo de un error que mostraba un mensaje de error en países sin provincias (estados).
* Actualización de la captura de pantalla.

### 0.7.2
* Arreglo de error al mostrar todas las pasarelas de pago en el resto de envíos.

### 0.7.1
* Arreglo de error en la selección de la pasarela de pago específica.

### 0.7
* Añadida opción para seleccionar una pasarela de pago específica para el gasto de envío.
* Añadida opción para indicar grupos de código postal y/o provincia (estado) donde no se atenderán los pedidos.

### 0.6.4
* Modificación de la pantalla de configuración.
* Modificación de los enlaces del plugin.
* Actualización de la captura de pantalla.
* Añadidos nuevos enlaces.

### 0.6.3
* Modificación de la pantalla de configuración.
* Modificación de los enlaces del plugin.
* Actualización de la captura de pantalla.

### 0.6.2
* Actualización de la traducción.

### 0.6.1
* Control de la existencia de los parámetros de configuración.
* Añadidos nuevos enlaces.

### 0.6
* Añadida opción de crear tarifas basadas exclusivamente en dimensiones.

### 0.5.1
* Arreglo del archivo ZIP.

### 0.5
* Añadido soporte de medidas.
* Añadida opción para devolver, o no, el precio máximo en caso de exceso de peso o dimensiones.
* Rediseño de la pantalla de configuración.
* Arreglos menores en el código.

### 0.4
* Arreglo de fallo en el guardado de configuraciones de gastos de envío adicionales.
* Arreglo de fallo en el idioma español.

### 0.3
* Añadido campo Coste adicional.
* Añadidos tipos de impuestos por grupos.

### 0.2
* Pequeñas modificaciones y arreglos de código.
* Inclusión de enlaces.
* Actualización de los textos de información.
* Añadido campo Gastos de envío adicionales para poder crear nuevos Gastos de envío.

### 0.1
* Versión inicial.

## Traducciones
* *English*: by [**Art Project Group**](https://artprojectgroup.es/) (default language).
* *Español*: por [**Art Project Group**](https://artprojectgroup.es/).
* *Français*: par [**Guillaume**](http://guillaume-thibord.com/).
* *Português*: por [**Alain Aubry**](http://www.casa-indigo.com/).
* *Português (Brasil)*: por [**Danilo Lopes da Silva**](http://www.armarinhosdonaflor.com.br/).
* *Italiano*: da [**Angelo Lazzari**](http://www.redtulp.com/).

## Soporte técnico
Dado que **WC - APG Weight Shipping** es totalmente gratuito, **Art Project Group** sólo proporciona el servicio de [**Soporte técnico**](https://artprojectgroup.es/tienda/ticket-de-soporte) previo pago. En ningún caso **Art Project Group** proporciona ningún tipo de soporte técnico gratuito.

## Donación
¿Te ha gustado y te ha resultado útil **WC - APG Weight Shipping** en tu sitio web? Te agradeceríamos una [pequeña donación](https://artprojectgroup.es/tienda/donacion) que nos ayudará a seguir mejorando este plugin y a crear más plugins totalmente gratuitos para toda la comunidad WordPress.

## Gracias
* A [Andy_P](https://profiles.wordpress.org/andy_p/) y [Mantish](https://wordpress.org/support/profile/mantish) por el gran plugin y la modificación que han inspirado **WC - APG Weight Shipping**.
* A todos los que lo usáis.
* A todos los que ayudáis a mejorarlo.
* A todos los que realizáis donaciones.
* A todos los que nos animáis con vuestros comentarios.

¡Muchas gracias a todos!

## Servicios Externos
Este plugin se conecta a la API de plugins de WordPress.org para obtener información sobre plugins.

Envía el enlace permanente del plugin cuando solicita datos.

Más información: https://wordpress.org/about/privacy/