# Contributing to Pay with Vipps and MobilePay for WooCommerce

If you want to contribute: Great! No issue or pull request is too small!

## Getting started

1. Make sure you have a GitHub account
1. See the [GitHub help pages](https://help.github.com) if you have questions.

## Contributing

Contributing is easy. The steps below is intended to be helpful. Please help us improve it.

1. Create a personal fork of the project [on GitHub](https://github.com/vippsas/vipps-woocommerce).
1. Clone the fork on your local machine
1. Create a new branch to work on, use a self-explanatory name. Example: `git branch my_contribution master`
1. Check out your new branch (avoid working on the `master` branch): `git checkout my_contribution master`
1. Implement/fix your feature, comment your code.
1. Follow the code style of the project, including indentation.
1. Add or change the documentation as needed.
1. Squash your commits into a single commit with git's [interactive rebase](https://help.github.com/articles/interactive-rebase). Create a new branch if necessary.
1. Push your branch to your fork on GitHub.
1. From your fork open a pull request in the correct branch.
1. Once the pull request is approved and merged, you can pull the changes from `master` to your local repo and delete your extra branch(es).

## Report an issue

If you find a bug in a project you're using (and you don't know how to fix it), have trouble following the documentation or have a question about the project – create an issue!

Creating an issue in GitHub is easy, and whatever issue you're having, you're likely not the only one, so others will
find your issue helpful too. For more information on how issues work, check out the official [GitHub issues guide](https://guides.github.com/features/issues/).

## License

The LICENSE file defines the license for the project. An open source project's license informs users what they can and can't do (e.g., use, modify, redistribute), and contributors, what they are allowing others to do.

The Pay with Vipps and MobilePay for WooCommerce is since version 1.4.8 licensed under the [MIT License](https://choosealicense.com/licenses/mit/).
Earlier versions were licensed under the [Affero General Public License version 3](https://choosealicense.com/licenses/agpl-3.0/).
