/*!
 * perfect-scrollbar v1.4.0
 * (c) 2018 Hyunje Jun
 * @license MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):global.PerfectScrollbar=factory()}(this,(function(){"use strict";function get(element){return getComputedStyle(element)}function set(element,obj){for(var key in obj){var val=obj[key];"number"==typeof val&&(val+="px"),element.style[key]=val}return element}function div(className){var div=document.createElement("div");return div.className=className,div}var elMatches="undefined"!=typeof Element&&(Element.prototype.matches||Element.prototype.webkitMatchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector);function matches(element,query){if(!elMatches)throw new Error("No element matching method supported");return elMatches.call(element,query)}function remove(element){element.remove?element.remove():element.parentNode&&element.parentNode.removeChild(element)}function queryChildren(element,selector){return Array.prototype.filter.call(element.children,(function(child){return matches(child,selector)}))}var cls_main="ps",cls_element={thumb:function(x){return"ps__thumb-"+x},rail:function(x){return"ps__rail-"+x},consuming:"ps__child--consume"},cls_state={focus:"ps--focus",clicking:"ps--clicking",active:function(x){return"ps--active-"+x},scrolling:function(x){return"ps--scrolling-"+x}},scrollingClassTimeout={x:null,y:null};function addScrollingClass(i,x){var classList=i.element.classList,className=cls_state.scrolling(x);classList.contains(className)?clearTimeout(scrollingClassTimeout[x]):classList.add(className)}function removeScrollingClass(i,x){scrollingClassTimeout[x]=setTimeout((function(){return i.isAlive&&i.element.classList.remove(cls_state.scrolling(x))}),i.settings.scrollingThreshold)}function setScrollingClassInstantly(i,x){addScrollingClass(i,x),removeScrollingClass(i,x)}var EventElement=function EventElement(element){this.element=element,this.handlers={}},prototypeAccessors={isEmpty:{configurable:!0}};EventElement.prototype.bind=function bind(eventName,handler){void 0===this.handlers[eventName]&&(this.handlers[eventName]=[]),this.handlers[eventName].push(handler),this.element.addEventListener(eventName,handler,!1)},EventElement.prototype.unbind=function unbind(eventName,target){var this$1=this;this.handlers[eventName]=this.handlers[eventName].filter((function(handler){return!(!target||handler===target)||(this$1.element.removeEventListener(eventName,handler,!1),!1)}))},EventElement.prototype.unbindAll=function unbindAll(){var this$1=this;for(var name in this.handlers)this.unbind(name)},prototypeAccessors.isEmpty.get=function(){var this$1=this;return Object.keys(this.handlers).every((function(key){return 0===this$1.handlers[key].length}))},Object.defineProperties(EventElement.prototype,prototypeAccessors);var EventManager=function EventManager(){this.eventElements=[]};function createEvent(name){if("function"==typeof window.CustomEvent)return new CustomEvent(name);var evt=document.createEvent("CustomEvent");return evt.initCustomEvent(name,!1,!1,void 0),evt}EventManager.prototype.eventElement=function eventElement(element){var ee=this.eventElements.filter((function(ee){return ee.element===element}))[0];return ee||(ee=new EventElement(element),this.eventElements.push(ee)),ee},EventManager.prototype.bind=function bind(element,eventName,handler){this.eventElement(element).bind(eventName,handler)},EventManager.prototype.unbind=function unbind(element,eventName,handler){var ee=this.eventElement(element);ee.unbind(eventName,handler),ee.isEmpty&&this.eventElements.splice(this.eventElements.indexOf(ee),1)},EventManager.prototype.unbindAll=function unbindAll(){this.eventElements.forEach((function(e){return e.unbindAll()})),this.eventElements=[]},EventManager.prototype.once=function once(element,eventName,handler){var ee=this.eventElement(element),onceHandler=function(evt){ee.unbind(eventName,onceHandler),handler(evt)};ee.bind(eventName,onceHandler)};var processScrollDiff=function(i,axis,diff,useScrollingClass,forceFireReachEvent){var fields;if(void 0===useScrollingClass&&(useScrollingClass=!0),void 0===forceFireReachEvent&&(forceFireReachEvent=!1),"top"===axis)fields=["contentHeight","containerHeight","scrollTop","y","up","down"];else{if("left"!==axis)throw new Error("A proper axis should be provided");fields=["contentWidth","containerWidth","scrollLeft","x","left","right"]}processScrollDiff$1(i,diff,fields,useScrollingClass,forceFireReachEvent)};function processScrollDiff$1(i,diff,ref,useScrollingClass,forceFireReachEvent){var contentHeight=ref[0],containerHeight=ref[1],scrollTop=ref[2],y=ref[3],up=ref[4],down=ref[5];void 0===useScrollingClass&&(useScrollingClass=!0),void 0===forceFireReachEvent&&(forceFireReachEvent=!1);var element=i.element;i.reach[y]=null,element[scrollTop]<1&&(i.reach[y]="start"),element[scrollTop]>i[contentHeight]-i[containerHeight]-1&&(i.reach[y]="end"),diff&&(element.dispatchEvent(createEvent("ps-scroll-"+y)),diff<0?element.dispatchEvent(createEvent("ps-scroll-"+up)):diff>0&&element.dispatchEvent(createEvent("ps-scroll-"+down)),useScrollingClass&&setScrollingClassInstantly(i,y)),i.reach[y]&&(diff||forceFireReachEvent)&&element.dispatchEvent(createEvent("ps-"+y+"-reach-"+i.reach[y]))}function toInt(x){return parseInt(x,10)||0}function isEditable(el){return matches(el,"input,[contenteditable]")||matches(el,"select,[contenteditable]")||matches(el,"textarea,[contenteditable]")||matches(el,"button,[contenteditable]")}function outerWidth(element){var styles=get(element);return toInt(styles.width)+toInt(styles.paddingLeft)+toInt(styles.paddingRight)+toInt(styles.borderLeftWidth)+toInt(styles.borderRightWidth)}var env={isWebKit:"undefined"!=typeof document&&"WebkitAppearance"in document.documentElement.style,supportsTouch:"undefined"!=typeof window&&("ontouchstart"in window||window.DocumentTouch&&document instanceof window.DocumentTouch),supportsIePointer:"undefined"!=typeof navigator&&navigator.msMaxTouchPoints,isChrome:"undefined"!=typeof navigator&&/Chrome/i.test(navigator&&navigator.userAgent)},updateGeometry=function(i){var element=i.element,roundedScrollTop=Math.floor(element.scrollTop);i.containerWidth=element.clientWidth,i.containerHeight=element.clientHeight,i.contentWidth=element.scrollWidth,i.contentHeight=element.scrollHeight,element.contains(i.scrollbarXRail)||(queryChildren(element,cls_element.rail("x")).forEach((function(el){return remove(el)})),element.appendChild(i.scrollbarXRail)),element.contains(i.scrollbarYRail)||(queryChildren(element,cls_element.rail("y")).forEach((function(el){return remove(el)})),element.appendChild(i.scrollbarYRail)),!i.settings.suppressScrollX&&i.containerWidth+i.settings.scrollXMarginOffset<i.contentWidth?(i.scrollbarXActive=!0,i.railXWidth=i.containerWidth-i.railXMarginWidth,i.railXRatio=i.containerWidth/i.railXWidth,i.scrollbarXWidth=getThumbSize(i,toInt(i.railXWidth*i.containerWidth/i.contentWidth)),i.scrollbarXLeft=toInt((i.negativeScrollAdjustment+element.scrollLeft)*(i.railXWidth-i.scrollbarXWidth)/(i.contentWidth-i.containerWidth))):i.scrollbarXActive=!1,!i.settings.suppressScrollY&&i.containerHeight+i.settings.scrollYMarginOffset<i.contentHeight?(i.scrollbarYActive=!0,i.railYHeight=i.containerHeight-i.railYMarginHeight,i.railYRatio=i.containerHeight/i.railYHeight,i.scrollbarYHeight=getThumbSize(i,toInt(i.railYHeight*i.containerHeight/i.contentHeight)),i.scrollbarYTop=toInt(roundedScrollTop*(i.railYHeight-i.scrollbarYHeight)/(i.contentHeight-i.containerHeight))):i.scrollbarYActive=!1,i.scrollbarXLeft>=i.railXWidth-i.scrollbarXWidth&&(i.scrollbarXLeft=i.railXWidth-i.scrollbarXWidth),i.scrollbarYTop>=i.railYHeight-i.scrollbarYHeight&&(i.scrollbarYTop=i.railYHeight-i.scrollbarYHeight),updateCss(element,i),i.scrollbarXActive?element.classList.add(cls_state.active("x")):(element.classList.remove(cls_state.active("x")),i.scrollbarXWidth=0,i.scrollbarXLeft=0,element.scrollLeft=0),i.scrollbarYActive?element.classList.add(cls_state.active("y")):(element.classList.remove(cls_state.active("y")),i.scrollbarYHeight=0,i.scrollbarYTop=0,element.scrollTop=0)},clickRail,dragThumb;function getThumbSize(i,thumbSize){return i.settings.minScrollbarLength&&(thumbSize=Math.max(thumbSize,i.settings.minScrollbarLength)),i.settings.maxScrollbarLength&&(thumbSize=Math.min(thumbSize,i.settings.maxScrollbarLength)),thumbSize}function updateCss(element,i){var xRailOffset={width:i.railXWidth},roundedScrollTop=Math.floor(element.scrollTop);i.isRtl?xRailOffset.left=i.negativeScrollAdjustment+element.scrollLeft+i.containerWidth-i.contentWidth:xRailOffset.left=element.scrollLeft,i.isScrollbarXUsingBottom?xRailOffset.bottom=i.scrollbarXBottom-roundedScrollTop:xRailOffset.top=i.scrollbarXTop+roundedScrollTop,set(i.scrollbarXRail,xRailOffset);var yRailOffset={top:roundedScrollTop,height:i.railYHeight};i.isScrollbarYUsingRight?i.isRtl?yRailOffset.right=i.contentWidth-(i.negativeScrollAdjustment+element.scrollLeft)-i.scrollbarYRight-i.scrollbarYOuterWidth:yRailOffset.right=i.scrollbarYRight-element.scrollLeft:i.isRtl?yRailOffset.left=i.negativeScrollAdjustment+element.scrollLeft+2*i.containerWidth-i.contentWidth-i.scrollbarYLeft-i.scrollbarYOuterWidth:yRailOffset.left=i.scrollbarYLeft+element.scrollLeft,set(i.scrollbarYRail,yRailOffset),set(i.scrollbarX,{left:i.scrollbarXLeft,width:i.scrollbarXWidth-i.railBorderXWidth}),set(i.scrollbarY,{top:i.scrollbarYTop,height:i.scrollbarYHeight-i.railBorderYWidth})}function bindMouseScrollHandler(i,ref){var containerHeight=ref[0],contentHeight=ref[1],pageY=ref[2],railYHeight=ref[3],scrollbarY=ref[4],scrollbarYHeight=ref[5],scrollTop=ref[6],y=ref[7],scrollbarYRail=ref[8],element=i.element,startingScrollTop=null,startingMousePageY=null,scrollBy=null;function mouseMoveHandler(e){element[scrollTop]=startingScrollTop+scrollBy*(e[pageY]-startingMousePageY),addScrollingClass(i,y),updateGeometry(i),e.stopPropagation(),e.preventDefault()}function mouseUpHandler(){removeScrollingClass(i,y),i[scrollbarYRail].classList.remove(cls_state.clicking),i.event.unbind(i.ownerDocument,"mousemove",mouseMoveHandler)}i.event.bind(i[scrollbarY],"mousedown",(function(e){startingScrollTop=element[scrollTop],startingMousePageY=e[pageY],scrollBy=(i[contentHeight]-i[containerHeight])/(i[railYHeight]-i[scrollbarYHeight]),i.event.bind(i.ownerDocument,"mousemove",mouseMoveHandler),i.event.once(i.ownerDocument,"mouseup",mouseUpHandler),i[scrollbarYRail].classList.add(cls_state.clicking),e.stopPropagation(),e.preventDefault()}))}var keyboard,wheel,touch,defaultSettings=function(){return{handlers:["click-rail","drag-thumb","keyboard","wheel","touch"],maxScrollbarLength:null,minScrollbarLength:null,scrollingThreshold:1e3,scrollXMarginOffset:0,scrollYMarginOffset:0,suppressScrollX:!1,suppressScrollY:!1,swipeEasing:!0,useBothWheelAxes:!1,wheelPropagation:!0,wheelSpeed:1}},handlers={"click-rail":function(i){i.event.bind(i.scrollbarY,"mousedown",(function(e){return e.stopPropagation()})),i.event.bind(i.scrollbarYRail,"mousedown",(function(e){var positionTop,direction=e.pageY-window.pageYOffset-i.scrollbarYRail.getBoundingClientRect().top>i.scrollbarYTop?1:-1;i.element.scrollTop+=direction*i.containerHeight,updateGeometry(i),e.stopPropagation()})),i.event.bind(i.scrollbarX,"mousedown",(function(e){return e.stopPropagation()})),i.event.bind(i.scrollbarXRail,"mousedown",(function(e){var positionLeft,direction=e.pageX-window.pageXOffset-i.scrollbarXRail.getBoundingClientRect().left>i.scrollbarXLeft?1:-1;i.element.scrollLeft+=direction*i.containerWidth,updateGeometry(i),e.stopPropagation()}))},"drag-thumb":function(i){bindMouseScrollHandler(i,["containerWidth","contentWidth","pageX","railXWidth","scrollbarX","scrollbarXWidth","scrollLeft","x","scrollbarXRail"]),bindMouseScrollHandler(i,["containerHeight","contentHeight","pageY","railYHeight","scrollbarY","scrollbarYHeight","scrollTop","y","scrollbarYRail"])},keyboard:function(i){var element=i.element,elementHovered=function(){return matches(element,":hover")},scrollbarFocused=function(){return matches(i.scrollbarX,":focus")||matches(i.scrollbarY,":focus")};function shouldPreventDefault(deltaX,deltaY){var scrollTop=Math.floor(element.scrollTop);if(0===deltaX){if(!i.scrollbarYActive)return!1;if(0===scrollTop&&deltaY>0||scrollTop>=i.contentHeight-i.containerHeight&&deltaY<0)return!i.settings.wheelPropagation}var scrollLeft=element.scrollLeft;if(0===deltaY){if(!i.scrollbarXActive)return!1;if(0===scrollLeft&&deltaX<0||scrollLeft>=i.contentWidth-i.containerWidth&&deltaX>0)return!i.settings.wheelPropagation}return!0}i.event.bind(i.ownerDocument,"keydown",(function(e){if(!(e.isDefaultPrevented&&e.isDefaultPrevented()||e.defaultPrevented)&&(elementHovered()||scrollbarFocused())){var activeElement=document.activeElement?document.activeElement:i.ownerDocument.activeElement;if(activeElement){if("IFRAME"===activeElement.tagName)activeElement=activeElement.contentDocument.activeElement;else for(;activeElement.shadowRoot;)activeElement=activeElement.shadowRoot.activeElement;if(isEditable(activeElement))return}var deltaX=0,deltaY=0;switch(e.which){case 37:deltaX=e.metaKey?-i.contentWidth:e.altKey?-i.containerWidth:-30;break;case 38:deltaY=e.metaKey?i.contentHeight:e.altKey?i.containerHeight:30;break;case 39:deltaX=e.metaKey?i.contentWidth:e.altKey?i.containerWidth:30;break;case 40:deltaY=e.metaKey?-i.contentHeight:e.altKey?-i.containerHeight:-30;break;case 32:deltaY=e.shiftKey?i.containerHeight:-i.containerHeight;break;case 33:deltaY=i.containerHeight;break;case 34:deltaY=-i.containerHeight;break;case 36:deltaY=i.contentHeight;break;case 35:deltaY=-i.contentHeight;break;default:return}i.settings.suppressScrollX&&0!==deltaX||i.settings.suppressScrollY&&0!==deltaY||(element.scrollTop-=deltaY,element.scrollLeft+=deltaX,updateGeometry(i),shouldPreventDefault(deltaX,deltaY)&&e.preventDefault())}}))},wheel:function(i){var element=i.element;function shouldPreventDefault(deltaX,deltaY){var roundedScrollTop=Math.floor(element.scrollTop),isTop=0===element.scrollTop,isBottom=roundedScrollTop+element.offsetHeight===element.scrollHeight,isLeft=0===element.scrollLeft,isRight=element.scrollLeft+element.offsetWidth===element.scrollWidth,hitsBound;return!(hitsBound=Math.abs(deltaY)>Math.abs(deltaX)?isTop||isBottom:isLeft||isRight)||!i.settings.wheelPropagation}function getDeltaFromEvent(e){var deltaX=e.deltaX,deltaY=-1*e.deltaY;return void 0!==deltaX&&void 0!==deltaY||(deltaX=-1*e.wheelDeltaX/6,deltaY=e.wheelDeltaY/6),e.deltaMode&&1===e.deltaMode&&(deltaX*=10,deltaY*=10),deltaX!=deltaX&&deltaY!=deltaY&&(deltaX=0,deltaY=e.wheelDelta),e.shiftKey?[-deltaY,-deltaX]:[deltaX,deltaY]}function shouldBeConsumedByChild(target,deltaX,deltaY){if(!env.isWebKit&&element.querySelector("select:focus"))return!0;if(!element.contains(target))return!1;for(var cursor=target;cursor&&cursor!==element;){if(cursor.classList.contains(cls_element.consuming))return!0;var style=get(cursor),overflow;if([style.overflow,style.overflowX,style.overflowY].join("").match(/(scroll|auto)/)){var maxScrollTop=cursor.scrollHeight-cursor.clientHeight;if(maxScrollTop>0&&!(0===cursor.scrollTop&&deltaY>0||cursor.scrollTop===maxScrollTop&&deltaY<0))return!0;var maxScrollLeft=cursor.scrollWidth-cursor.clientWidth;if(maxScrollLeft>0&&!(0===cursor.scrollLeft&&deltaX<0||cursor.scrollLeft===maxScrollLeft&&deltaX>0))return!0}cursor=cursor.parentNode}return!1}function mousewheelHandler(e){var ref=getDeltaFromEvent(e),deltaX=ref[0],deltaY=ref[1];if(!shouldBeConsumedByChild(e.target,deltaX,deltaY)){var shouldPrevent=!1;i.settings.useBothWheelAxes?i.scrollbarYActive&&!i.scrollbarXActive?(deltaY?element.scrollTop-=deltaY*i.settings.wheelSpeed:element.scrollTop+=deltaX*i.settings.wheelSpeed,shouldPrevent=!0):i.scrollbarXActive&&!i.scrollbarYActive&&(deltaX?element.scrollLeft+=deltaX*i.settings.wheelSpeed:element.scrollLeft-=deltaY*i.settings.wheelSpeed,shouldPrevent=!0):(element.scrollTop-=deltaY*i.settings.wheelSpeed,element.scrollLeft+=deltaX*i.settings.wheelSpeed),updateGeometry(i),(shouldPrevent=shouldPrevent||shouldPreventDefault(deltaX,deltaY))&&!e.ctrlKey&&(e.stopPropagation(),e.preventDefault())}}void 0!==window.onwheel?i.event.bind(element,"wheel",mousewheelHandler):void 0!==window.onmousewheel&&i.event.bind(element,"mousewheel",mousewheelHandler)},touch:function(i){if(env.supportsTouch||env.supportsIePointer){var element=i.element,startOffset={},startTime=0,speed={},easingLoop=null;env.supportsTouch?(i.event.bind(element,"touchstart",touchStart),i.event.bind(element,"touchmove",touchMove),i.event.bind(element,"touchend",touchEnd)):env.supportsIePointer&&(window.PointerEvent?(i.event.bind(element,"pointerdown",touchStart),i.event.bind(element,"pointermove",touchMove),i.event.bind(element,"pointerup",touchEnd)):window.MSPointerEvent&&(i.event.bind(element,"MSPointerDown",touchStart),i.event.bind(element,"MSPointerMove",touchMove),i.event.bind(element,"MSPointerUp",touchEnd)))}function shouldPrevent(deltaX,deltaY){var scrollTop=Math.floor(element.scrollTop),scrollLeft=element.scrollLeft,magnitudeX=Math.abs(deltaX),magnitudeY=Math.abs(deltaY);if(magnitudeY>magnitudeX){if(deltaY<0&&scrollTop===i.contentHeight-i.containerHeight||deltaY>0&&0===scrollTop)return 0===window.scrollY&&deltaY>0&&env.isChrome}else if(magnitudeX>magnitudeY&&(deltaX<0&&scrollLeft===i.contentWidth-i.containerWidth||deltaX>0&&0===scrollLeft))return!0;return!0}function applyTouchMove(differenceX,differenceY){element.scrollTop-=differenceY,element.scrollLeft-=differenceX,updateGeometry(i)}function getTouch(e){return e.targetTouches?e.targetTouches[0]:e}function shouldHandle(e){return(!e.pointerType||"pen"!==e.pointerType||0!==e.buttons)&&(!(!e.targetTouches||1!==e.targetTouches.length)||!(!e.pointerType||"mouse"===e.pointerType||e.pointerType===e.MSPOINTER_TYPE_MOUSE))}function touchStart(e){if(shouldHandle(e)){var touch=getTouch(e);startOffset.pageX=touch.pageX,startOffset.pageY=touch.pageY,startTime=(new Date).getTime(),null!==easingLoop&&clearInterval(easingLoop)}}function shouldBeConsumedByChild(target,deltaX,deltaY){if(!element.contains(target))return!1;for(var cursor=target;cursor&&cursor!==element;){if(cursor.classList.contains(cls_element.consuming))return!0;var style=get(cursor),overflow;if([style.overflow,style.overflowX,style.overflowY].join("").match(/(scroll|auto)/)){var maxScrollTop=cursor.scrollHeight-cursor.clientHeight;if(maxScrollTop>0&&!(0===cursor.scrollTop&&deltaY>0||cursor.scrollTop===maxScrollTop&&deltaY<0))return!0;var maxScrollLeft=cursor.scrollLeft-cursor.clientWidth;if(maxScrollLeft>0&&!(0===cursor.scrollLeft&&deltaX<0||cursor.scrollLeft===maxScrollLeft&&deltaX>0))return!0}cursor=cursor.parentNode}return!1}function touchMove(e){if(shouldHandle(e)){var touch=getTouch(e),currentOffset={pageX:touch.pageX,pageY:touch.pageY},differenceX=currentOffset.pageX-startOffset.pageX,differenceY=currentOffset.pageY-startOffset.pageY;if(shouldBeConsumedByChild(e.target,differenceX,differenceY))return;applyTouchMove(differenceX,differenceY),startOffset=currentOffset;var currentTime=(new Date).getTime(),timeGap=currentTime-startTime;timeGap>0&&(speed.x=differenceX/timeGap,speed.y=differenceY/timeGap,startTime=currentTime),shouldPrevent(differenceX,differenceY)&&e.preventDefault()}}function touchEnd(){i.settings.swipeEasing&&(clearInterval(easingLoop),easingLoop=setInterval((function(){i.isInitialized?clearInterval(easingLoop):speed.x||speed.y?Math.abs(speed.x)<.01&&Math.abs(speed.y)<.01?clearInterval(easingLoop):(applyTouchMove(30*speed.x,30*speed.y),speed.x*=.8,speed.y*=.8):clearInterval(easingLoop)}),10))}}},PerfectScrollbar=function PerfectScrollbar(element,userSettings){var this$1=this;if(void 0===userSettings&&(userSettings={}),"string"==typeof element&&(element=document.querySelector(element)),!element||!element.nodeName)throw new Error("no element is specified to initialize PerfectScrollbar");for(var key in this.element=element,element.classList.add(cls_main),this.settings={handlers:["click-rail","drag-thumb","keyboard","wheel","touch"],maxScrollbarLength:null,minScrollbarLength:null,scrollingThreshold:1e3,scrollXMarginOffset:0,scrollYMarginOffset:0,suppressScrollX:!1,suppressScrollY:!1,swipeEasing:!0,useBothWheelAxes:!1,wheelPropagation:!0,wheelSpeed:1},userSettings)this$1.settings[key]=userSettings[key];this.containerWidth=null,this.containerHeight=null,this.contentWidth=null,this.contentHeight=null;var focus=function(){return element.classList.add(cls_state.focus)},blur=function(){return element.classList.remove(cls_state.focus)},originalScrollLeft,result;this.isRtl="rtl"===get(element).direction,this.isNegativeScroll=(originalScrollLeft=element.scrollLeft,result=null,element.scrollLeft=-1,result=element.scrollLeft<0,element.scrollLeft=originalScrollLeft,result),this.negativeScrollAdjustment=this.isNegativeScroll?element.scrollWidth-element.clientWidth:0,this.event=new EventManager,this.ownerDocument=element.ownerDocument||document,this.scrollbarXRail=div(cls_element.rail("x")),element.appendChild(this.scrollbarXRail),this.scrollbarX=div(cls_element.thumb("x")),this.scrollbarXRail.appendChild(this.scrollbarX),this.scrollbarX.setAttribute("tabindex",0),this.event.bind(this.scrollbarX,"focus",focus),this.event.bind(this.scrollbarX,"blur",blur),this.scrollbarXActive=null,this.scrollbarXWidth=null,this.scrollbarXLeft=null;var railXStyle=get(this.scrollbarXRail);this.scrollbarXBottom=parseInt(railXStyle.bottom,10),isNaN(this.scrollbarXBottom)?(this.isScrollbarXUsingBottom=!1,this.scrollbarXTop=toInt(railXStyle.top)):this.isScrollbarXUsingBottom=!0,this.railBorderXWidth=toInt(railXStyle.borderLeftWidth)+toInt(railXStyle.borderRightWidth),set(this.scrollbarXRail,{display:"block"}),this.railXMarginWidth=toInt(railXStyle.marginLeft)+toInt(railXStyle.marginRight),set(this.scrollbarXRail,{display:""}),this.railXWidth=null,this.railXRatio=null,this.scrollbarYRail=div(cls_element.rail("y")),element.appendChild(this.scrollbarYRail),this.scrollbarY=div(cls_element.thumb("y")),this.scrollbarYRail.appendChild(this.scrollbarY),this.scrollbarY.setAttribute("tabindex",0),this.event.bind(this.scrollbarY,"focus",focus),this.event.bind(this.scrollbarY,"blur",blur),this.scrollbarYActive=null,this.scrollbarYHeight=null,this.scrollbarYTop=null;var railYStyle=get(this.scrollbarYRail);this.scrollbarYRight=parseInt(railYStyle.right,10),isNaN(this.scrollbarYRight)?(this.isScrollbarYUsingRight=!1,this.scrollbarYLeft=toInt(railYStyle.left)):this.isScrollbarYUsingRight=!0,this.scrollbarYOuterWidth=this.isRtl?outerWidth(this.scrollbarY):null,this.railBorderYWidth=toInt(railYStyle.borderTopWidth)+toInt(railYStyle.borderBottomWidth),set(this.scrollbarYRail,{display:"block"}),this.railYMarginHeight=toInt(railYStyle.marginTop)+toInt(railYStyle.marginBottom),set(this.scrollbarYRail,{display:""}),this.railYHeight=null,this.railYRatio=null,this.reach={x:element.scrollLeft<=0?"start":element.scrollLeft>=this.contentWidth-this.containerWidth?"end":null,y:element.scrollTop<=0?"start":element.scrollTop>=this.contentHeight-this.containerHeight?"end":null},this.isAlive=!0,this.settings.handlers.forEach((function(handlerName){return handlers[handlerName](this$1)})),this.lastScrollTop=Math.floor(element.scrollTop),this.lastScrollLeft=element.scrollLeft,this.event.bind(this.element,"scroll",(function(e){return this$1.onScroll(e)})),updateGeometry(this)};return PerfectScrollbar.prototype.update=function update(){this.isAlive&&(this.negativeScrollAdjustment=this.isNegativeScroll?this.element.scrollWidth-this.element.clientWidth:0,set(this.scrollbarXRail,{display:"block"}),set(this.scrollbarYRail,{display:"block"}),this.railXMarginWidth=toInt(get(this.scrollbarXRail).marginLeft)+toInt(get(this.scrollbarXRail).marginRight),this.railYMarginHeight=toInt(get(this.scrollbarYRail).marginTop)+toInt(get(this.scrollbarYRail).marginBottom),set(this.scrollbarXRail,{display:"none"}),set(this.scrollbarYRail,{display:"none"}),updateGeometry(this),processScrollDiff(this,"top",0,!1,!0),processScrollDiff(this,"left",0,!1,!0),set(this.scrollbarXRail,{display:""}),set(this.scrollbarYRail,{display:""}))},PerfectScrollbar.prototype.onScroll=function onScroll(e){this.isAlive&&(updateGeometry(this),processScrollDiff(this,"top",this.element.scrollTop-this.lastScrollTop),processScrollDiff(this,"left",this.element.scrollLeft-this.lastScrollLeft),this.lastScrollTop=Math.floor(this.element.scrollTop),this.lastScrollLeft=this.element.scrollLeft)},PerfectScrollbar.prototype.destroy=function destroy(){this.isAlive&&(this.event.unbindAll(),remove(this.scrollbarX),remove(this.scrollbarY),remove(this.scrollbarXRail),remove(this.scrollbarYRail),this.removePsClasses(),this.element=null,this.scrollbarX=null,this.scrollbarY=null,this.scrollbarXRail=null,this.scrollbarYRail=null,this.isAlive=!1)},PerfectScrollbar.prototype.removePsClasses=function removePsClasses(){this.element.className=this.element.className.split(" ").filter((function(name){return!name.match(/^ps([-_].+|)$/)})).join(" ")},PerfectScrollbar}));