<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class PPCP_Checkout_Block extends AbstractPaymentMethodType {

    private $gateway;
    protected $name = 'wpg_paypal_checkout';
    public $pay_later;
    public $icon;
    public $button_class;
    public $button_size;
    public $is_mobile;
    public $device_class;

    public function initialize() {
        $this->settings = get_option('woocommerce_wpg_paypal_checkout_settings', []);
        if (!class_exists('PPCP_Paypal_Checkout_For_Woocommerce_Gateway')) {
            include_once ( WPG_PLUGIN_DIR . '/ppcp/includes/class-ppcp-paypal-checkout-for-woocommerce-gateway.php');
        }
        $this->gateway = new PPCP_Paypal_Checkout_For_Woocommerce_Gateway();
        if (!class_exists('PPCP_Paypal_Checkout_For_Woocommerce_Pay_Later')) {
            include_once ( WPG_PLUGIN_DIR . '/ppcp/includes/class-ppcp-paypal-checkout-for-woocommerce-pay-later-messaging.php');
        }
        $this->pay_later = PPCP_Paypal_Checkout_For_Woocommerce_Pay_Later::instance();
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles() {
        if (!function_exists('has_block') || !wpg_is_using_block_cart_or_checkout()) {
            return [];
        }
        wp_enqueue_script('ppcp-checkout-js');
        if (ppcp_has_active_session() === false) {
            wp_enqueue_script('ppcp-paypal-checkout-for-woocommerce-public');
        }
        wp_enqueue_style("ppcp-paypal-checkout-for-woocommerce-public");
        wp_register_script('wpg_paypal_checkout-blocks-integration', WPG_PLUGIN_ASSET_URL . 'ppcp/checkout-block/ppcp-checkout.js', array('jquery', 'react', 'wc-blocks-registry', 'wc-settings', 'wp-element', 'wp-i18n', 'wp-polyfill', 'wp-element', 'wp-plugins'), WPG_PLUGIN_VERSION, true);
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('wpg_paypal_checkout-blocks-integration', 'woo-paypal-gateway');
        }
        wp_enqueue_script('wpg_paypal_checkout');
        return ['wpg_paypal_checkout-blocks-integration'];
    }

    public function is_google_pay_enable_for_page($page = '') {
        if (!isset($this->settings['enabled_google_pay'])) {
            return false;
        }
        if (isset($this->settings['enabled_google_pay']) && $this->settings['enabled_google_pay'] === 'no') {
            return false;
        }
        if (empty($page)) {
            return false;
        }
        if (!isset($this->settings['google_pay_pages'])) {
            $this->settings['google_pay_pages'] = array('express_checkout');
        }
        if (empty($this->settings['google_pay_pages'])) {
            return false;
        }
        if (in_array($page, $this->settings['google_pay_pages'])) {
            return true;
        }
        return false;
    }

    public function is_apple_pay_enable_for_page($page = '') {
        if (!isset($this->settings['enabled_apple_pay'])) {
            return false;
        }
        if (isset($this->settings['enabled_apple_pay']) && $this->settings['enabled_apple_pay'] === 'no') {
            return false;
        }
        if (empty($page)) {
            return false;
        }
        if (empty($this->settings['apple_pay_pages'])) {
            return false;
        }
        if (in_array($page, $this->settings['apple_pay_pages'])) {
            return true;
        }
        return false;
    }

    public function is_paypal_enable_for_page($page = '') {
        if (!isset($this->settings['paypal_button_pages'])) {
            $this->settings['paypal_button_pages'] = array('express_checkout', 'checkout');
        }
        if (isset($this->settings['enabled']) && $this->settings['enabled'] === 'no') {
            return false;
        }
        if (empty($page)) {
            return false;
        }
        if (empty($this->settings['paypal_button_pages'])) {
            return false;
        }
        if (in_array($page, $this->settings['paypal_button_pages'])) {
            return true;
        }
        return false;
    }

    public function get_payment_method_data() {
        $this->icon = apply_filters('woocommerce_ppcp_cc_icon', WPG_PLUGIN_ASSET_URL . 'assets/images/wpg_paypal.png');
        if (ppcp_has_active_session()) {
            $order_button_text = apply_filters('wpg_paypal_checkout_order_review_page_place_order_button_text', _x('Confirm Your PayPal Order', 'Important', 'woo-paypal-gateway'));
        } else {
            $order_button_text = apply_filters('wpg_paypal_checkout_place_order_button_text', _x('Proceed to PayPal', 'Important', 'woo-paypal-gateway'));
        }
        $is_paylater_enable_incart_page = 'no';
        if ($this->pay_later->is_paypal_pay_later_messaging_enable_for_page($page = 'cart')) {
            $is_paylater_enable_incart_page = 'yes';
        } else {
            $is_paylater_enable_incart_page = 'no';
        }
        $this->is_mobile = wp_is_mobile();
        $this->device_class = $this->is_mobile ? 'mobile' : 'desktop';
        $page = '';
        $is_pay_page = '';
        $this->button_class = $this->device_class . ' ' . 'responsive';
        if (is_product()) {
            $page = 'product';
        } else if (is_cart() && WC()->cart && !WC()->cart->is_empty()) {
            $page = 'cart';
            $this->button_size = isset($this->settings['cart_button_size']) ? $this->settings['cart_button_size'] : 'responsive';
            $this->button_class = $this->device_class . ' ' . $this->button_size;
        } elseif (is_checkout_pay_page()) {
            $page = 'checkout';
            $is_pay_page = 'yes';
            $this->button_size = isset($this->settings['checkout_button_size']) ? $this->settings['checkout_button_size'] : 'responsive';
            $this->button_class = $this->device_class . ' ' . $this->button_size;
        } elseif (is_checkout()) {
            $page = 'checkout';
            $this->button_size = isset($this->settings['checkout_button_size']) ? $this->settings['checkout_button_size'] : 'responsive';
            $this->button_class = $this->device_class . ' ' . $this->button_size;
        }
        $filtered_settings['enable_checkout_button_top'] = $this->is_paypal_enable_for_page('express_checkout') ? 'yes' : 'no';
        $filtered_settings['show_on_cart'] = $this->is_paypal_enable_for_page('cart') ? 'yes' : 'no';
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'supports' => $this->get_supported_features(),
            'icons' => $this->gateway->icon,
            'use_place_order' => $this->gateway->use_place_order,
            'placeOrderButtonLabel' => $order_button_text,
            'placeOrderDescription' => sprintf(
                    /* translators: %s: Order button text (e.g. Place order) */
                    _x('Click the "%s" button below to process your order.', 'Important', 'woo-paypal-gateway'),
                    $order_button_text
            ),
            'is_order_confirm_page' => (ppcp_has_active_session() === false) ? 'no' : 'yes',
            'is_paylater_enable_incart_page' => $is_paylater_enable_incart_page,
            'settins' => $filtered_settings,
            'page' => $page,
            'is_block_enable' => 'yes',
            'is_google_pay_enable_for_cart' => $this->is_google_pay_enable_for_page('cart') ? 'yes' : 'no',
            'is_google_pay_enable_for_express_checkout' => $this->is_google_pay_enable_for_page('express_checkout') ? 'yes' : 'no',
            'is_google_pay_enable_for_checkout' => $this->is_google_pay_enable_for_page('checkout') ? 'yes' : 'no',
            'is_apple_pay_enable_for_cart' => $this->is_apple_pay_enable_for_page('cart') ? 'yes' : 'no',
            'is_apple_pay_enable_for_express_checkout' => $this->is_apple_pay_enable_for_page('express_checkout') ? 'yes' : 'no',
            'is_apple_pay_enable_for_checkout' => $this->is_apple_pay_enable_for_page('checkout') ? 'yes' : 'no',
            'is_mobile' => wp_is_mobile() ? 'mobile' : 'desktop',
            'button_class' => $this->button_class,
            'redirect_icon' => $this->gateway->redirect_icon,
            'show_redirect_icon' => $this->gateway->show_redirect_icon ? 'yes' : 'no'
        ];
    }
}
