<?php
defined( 'ABSPATH' ) || exit();

/**
 *
 * @return mixed
 * @package Braintree/Functions
 * @since 3.0.0
 */
function wc_braintree_get_error_messages() {
	return apply_filters(
		'wc_braintree_get_error_messages',
		array(
			'INSTANTIATION_OPTION_REQUIRED'            => __( 'Error initiating Braintree client. This error occurs when you haven\'t finished configuring your API keys.', 'woo-payment-gateway' ),
			'INVALID_CLIENT_TOKEN'                     => __( 'Invalid client token supplied. Please check your API keys.', 'woo-payment-gateway' ),
			'HOSTED_FIELDS_FIELDS_EMPTY'               => __( 'Please fill out the payment form.', 'woo-payment-gateway' ),
			'HOSTED_FIELDS_FIELDS_INVALID'             => __( 'Some of your payment fields are invalid.', 'woo-payment-gateway' ),
			'HOSTED_FIELDS_FAILED_TOKENIZATION'        => __( 'Please check that your credit card is valid.', 'woo-payment-gateway' ),
			'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR' => __( 'There was a network error. Please try again.', 'woo-payment-gateway' ),
			'VALIDATION'                               => __( 'Please check your payment method fields.', 'woo-payment-gateway' ),
			'THREEDS_LOOKUP_VALIDATION_ERROR'          => __( 'The address data passed to the 3D Secure provider was in an invalid format.', 'woo-payment-gateway' ),
			'THREEDS_HTTPS_REQUIRED'                   => __( '3D Secure requires HTTPS.', 'woo-payment-gateway' ),
			'THREEDS_NOT_ENABLED'                      => __( '3D Secure is not enabled for this merchant.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_ADDRESS'                   => __( 'Provided shipping address failed PayPal validation. Please check your entries.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_CLIENT'                    => __( 'Check your PayPal client ID and client secret in your Braintree Control Panel settings.', 'woo-payment-gateway' ),
			'PAYPAL_TOKENIZATION_REQUEST_ACTIVE'       => __( 'There is already a PayPal window open.', 'woo-payment-gateway' ),
			'PAYPAL_FLOW_OPTION_REQUIRED'              => __( 'PayPal vault flow is required.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_PAYMENT_OPTION_ADDRESS'    => __( 'PayPal validation of address failed. Please verify your shipping address.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_PAYMENT_OPTION_CITY'       => __( 'Invalid city entered for your shipping address.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_PAYMENT_OPTION_STATE'      => __( 'Invalid state entered for your shipping address.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_PAYMENT_OPTION_ZIP'        => __( 'Invalid zip code entered for shipping address.', 'woo-payment-gateway' ),
			'PAYPAL_LINKED_ACCOUNT_PRODUCTION'         => __( 'Please link your PayPal account in the Braintree control panel in order to use PayPal.', 'woo-payment-gateway' ),
			'PAYPAL_LINKED_ACCOUNT_SANDBOX'            => sprintf( __( 'Please link your PayPal account in the Braintree control panel in order to use PayPal. %sHow to link a sandbox PayPal account.%s', 'woo-payment-gateway' ), '<a href="https://developers.braintreepayments.com/guides/paypal/testing-go-live/php#linked-paypal-testing" target="_blank">', '</a>' ),
			'DATA_COLLECTOR_KOUNT_NOT_ENABLED'         => __( 'Please enable fraud tools within your Braintree Control Panel if you have enabled Advanced Fraud in the plugin settings. This setting can take several minutes to take affect.' ),
			'LOCAL_GATEWAY_INVALID_MERCHANT_ACCOUNT'   => __( 'No merchant account found for the requested currency.', 'woo-payment-gateway' ),
			'NO_MERCHANT_ACCOUNT'                      => __( 'No merchant account found for the requested currency.', 'woo-payment-gateway' ),
			'GOOGLE_PAYMENT_NOT_ENABLED'               => __( 'Google Pay is not enabled for this merchant. Please enable Google Pay within your Braintree control panel.', 'woo-payment-gateway' ),
			'DEVELOPER_ERROR_WHITELIST'                => __( 'You have not been whitelisted by Google to use the paymentDataRequest.callbackIntent. Please contact Google\'s API team to request that your merchant ID be whitelisted. You can disable the plugin\'s dynamc price setting which will allow you to accept payments while you wait for Google to whitelist you.', 'woo-payment-gateway' ),
			'PAYPAL_INVALID_LOCALE'                    => __( 'Please enter a locale that PayPal supports. You can change the locale in your Wordpress settings.', 'woo-payment-gateway' ),
			'PAYPAL_MERCHANT_ACCOUNT_EMPTY'            => sprintf(
				__( 'PayPal requires that you configure your merchant accounts. Navigate to the Braintree Plugin\'s Advanced Settings &#62; %1$sMerchant Accounts%2$s page and click %3$sImport Accounts%4$s.', 'woo-payment-gateway' ),
				'<a target="_blank" href="' .
				admin_url( 'admin.php?page=wc-settings&tab=checkout&section=braintree_advanced' ) . '">',
				'</a>',
				'<strong>',
				'</strong>'
			),
			'LOCAL_PAYMENT_WINDOW_OPEN_FAILED'         => __( 'LocalPayment window failed to open; please allow pop-ups for this site.', 'woo-payment-gateway' ),
			'DropinError'                              => __( 'Please fill out the payment form.', 'woo-payment-gateway' ),
			'avsPostalCodeResponseCode_N'              => __( 'Postal code does not match.', 'woo-payment-gateway' ),
			'avsStreetAddressResponseCode_N'           => __( 'Street address does not match.', 'woo-payment-gateway' ),
			'cvvResponseCode_N'                        => __( 'Card security code does not match.', 'woo-payment-gateway' ),
			'avsPostalCodeResponseCode_U'              => __( 'Postal code not verified.', 'woo-payment-gateway' ),
			'avsStreetAddressResponseCode_U'           => __( 'Street address not verified.', 'woo-payment-gateway' ),
			'cvvResponseCode_U'                        => __( 'Card security code not verified.', 'woo-payment-gateway' ),
			'avsPostalCodeResponseCode_I'              => __( 'Postal code not provided.', 'woo-payment-gateway' ),
			'avsStreetAddressResponseCode_I'           => __( 'Street address not provided.', 'woo-payment-gateway' ),
			'cvvResponseCode_I'                        => __( 'Card security code not provided.', 'woo-payment-gateway' ),
			'gatewayRejectionReason_three_d_secure'    => __( 'Your payment method was rejected due to 3D Secure.', 'woo-payment-gateway' ),
			'2000'                                     => __( 'Do Not Honor', 'woo-payment-gateway' ),
			'2001'                                     => __( 'Insufficient Funds', 'woo-payment-gateway' ),
			'2002'                                     => __( 'Limit Exceeded', 'woo-payment-gateway' ),
			'2003'                                     => __( 'Cardholder\'s Activity Limit Exceeded', 'woo-payment-gateway' ),
			'2004'                                     => __( 'Expired Card', 'woo-payment-gateway' ),
			'2005'                                     => __( 'Invalid Credit Card Number', 'woo-payment-gateway' ),
			'2006'                                     => __( 'Invalid Expiration Date', 'woo-payment-gateway' ),
			'2007'                                     => __( 'No Account', 'woo-payment-gateway' ),
			'2008'                                     => __( 'Card Account Length Error', 'woo-payment-gateway' ),
			'2009'                                     => __( 'No Such Issuer', 'woo-payment-gateway' ),
			'2010'                                     => __( 'Card Issuer Declined CVV', 'woo-payment-gateway' ),
			'2011'                                     => __( 'Voice Authorization Required', 'woo-payment-gateway' ),
			'2012'                                     => __( 'Processor Declined Possible Lost Card', 'woo-payment-gateway' ),
			'2013'                                     => __( 'Processor Declined - Possible Stolen Card', 'woo-payment-gateway' ),
			'2014'                                     => __( 'Processor Declined - Fraud Suspected', 'woo-payment-gateway' ),
			'2015'                                     => __( 'Transaction Not Allowed', 'woo-payment-gateway' ),
			'2016'                                     => __( 'Duplicate Transaction', 'woo-payment-gateway' ),
			'2017'                                     => __( 'Cardholder Stopped Billing', 'woo-payment-gateway' ),
			'2018'                                     => __( 'Cardholder Stopped All Billing', 'woo-payment-gateway' ),
			'2019'                                     => __( 'Invalid Transaction', 'woo-payment-gateway' ),
			'2020'                                     => __( 'Violation', 'woo-payment-gateway' ),
			'2021'                                     => __( 'Security Violation', 'woo-payment-gateway' ),
			'2022'                                     => __( 'Declined - Updated Cardholder Available', 'woo-payment-gateway' ),
			'2023'                                     => __( 'Processor Does Not Support This Feature', 'woo-payment-gateway' ),
			'2024'                                     => __( 'Card Type Not Enabled', 'woo-payment-gateway' ),
			'2025'                                     => __( 'Set Up Error - Merchant', 'woo-payment-gateway' ),
			'2026'                                     => __( 'Invalid Merchant ID', 'woo-payment-gateway' ),
			'2027'                                     => __( 'Set Up Error - Amount', 'woo-payment-gateway' ),
			'2028'                                     => __( 'Set Up Error - Hierarchy', 'woo-payment-gateway' ),
			'2029'                                     => __( 'Set Up Error - Card', 'woo-payment-gateway' ),
			'2030'                                     => __( 'Set Up Error - Terminal', 'woo-payment-gateway' ),
			'2031'                                     => __( 'Encryption Error', 'woo-payment-gateway' ),
			'2032'                                     => __( 'Surcharge Not Permitted', 'woo-payment-gateway' ),
			'2033'                                     => __( 'Inconsistent Data', 'woo-payment-gateway' ),
			'2034'                                     => __( 'No Action Taken', 'woo-payment-gateway' ),
			'2035'                                     => __( 'Partial Approval For Amount In Group III Version', 'woo-payment-gateway' ),
			'2036'                                     => __( 'Authorization could not be found to reverse', 'woo-payment-gateway' ),
			'2037'                                     => __( 'Already Reversed', 'woo-payment-gateway' ),
			'2038'                                     => __( 'Processor Declined', 'woo-payment-gateway' ),
			'2039'                                     => __( 'Invalid Authorization Code', 'woo-payment-gateway' ),
			'2040'                                     => __( 'Invalid Store', 'woo-payment-gateway' ),
			'2041'                                     => __( 'Declined - Call For Approval', 'woo-payment-gateway' ),
			'2042'                                     => __( 'Invalid Client ID', 'woo-payment-gateway' ),
			'2043'                                     => __( 'Error - Do Not Retry, Call Issuer', 'woo-payment-gateway' ),
			'2044'                                     => __( 'Declined - Call Issuer', 'woo-payment-gateway' ),
			'2045'                                     => __( 'Invalid Merchant Number', 'woo-payment-gateway' ),
			'2046'                                     => __( 'Declined', 'woo-payment-gateway' ),
			'2047'                                     => __( 'Call Issuer. Pick Up Card', 'woo-payment-gateway' ),
			'2048'                                     => __( 'Invalid Amount', 'woo-payment-gateway' ),
			'2049'                                     => __( 'Invalid SKU Number', 'woo-payment-gateway' ),
			'2050'                                     => __( 'Invalid Credit Plan', 'woo-payment-gateway' ),
			'2051'                                     => __( 'Credit Card Number does not match method of payment', 'woo-payment-gateway' ),
			'2053'                                     => __( 'Card reported as lost or stolen', 'woo-payment-gateway' ),
			'2054'                                     => __( 'Reversal amount does not match authorization amount', 'woo-payment-gateway' ),
			'2055'                                     => __( 'Invalid Transaction Division Number', 'woo-payment-gateway' ),
			'2056'                                     => __( 'Transaction amount exceeds the transaction division limit', 'woo-payment-gateway' ),
			'2057'                                     => __( 'Issuer or Cardholder has put a restriction on the card', 'woo-payment-gateway' ),
			'2058'                                     => __( 'Merchant not Mastercard SecureCode enabled', 'woo-payment-gateway' ),
			'2059'                                     => __( 'Address Verification Failed', 'woo-payment-gateway' ),
			'2060'                                     => __( 'Address Verification and Card Security Code Failed', 'woo-payment-gateway' ),
			'2061'                                     => __( 'Invalid Transaction Data', 'woo-payment-gateway' ),
			'2062'                                     => __( 'Invalid Tax Amount', 'woo-payment-gateway' ),
			'2063'                                     => __( 'PayPal Business Account preference resulted in the transaction failing', 'woo-payment-gateway' ),
			'2064'                                     => __( 'Invalid Currency Code', 'woo-payment-gateway' ),
			'2065'                                     => __( 'Refund Time Limit Exceeded', 'woo-payment-gateway' ),
			'2066'                                     => __( 'PayPal Business Account Restricted', 'woo-payment-gateway' ),
			'2067'                                     => __( 'Authorization Expired', 'woo-payment-gateway' ),
			'2068'                                     => __( 'PayPal Business Account Locked or Closed', 'woo-payment-gateway' ),
			'2069'                                     => __( 'PayPal Blocking Duplicate Order IDs', 'woo-payment-gateway' ),
			'2070'                                     => __( 'PayPal Buyer Revoked Future Payment Authorization', 'woo-payment-gateway' ),
			'2071'                                     => __( 'PayPal Payee Account Invalid Or Does Not Have a Confirmed Email', 'woo-payment-gateway' ),
			'2072'                                     => __( 'PayPal Payee Email Incorrectly Formatted', 'woo-payment-gateway' ),
			'2073'                                     => __( 'PayPal Validation Error', 'woo-payment-gateway' ),
			'2074'                                     => __( 'Funding Instrument In The PayPal Account Was Declined By The Processor Or Bank, Or It Can\'t Be Used For This Payment', 'woo-payment-gateway' ),
			'2075'                                     => __( 'Payer Account Is Locked Or Closed', 'woo-payment-gateway' ),
			'2076'                                     => __( 'Payer Cannot Pay For This Transaction With PayPal', 'woo-payment-gateway' ),
			'2077'                                     => __( 'Transaction Refused Due To PayPal Risk Model', 'woo-payment-gateway' ),
			'2079'                                     => __( 'PayPal Merchant Account Configuration Error', 'woo-payment-gateway' ),
			'2081'                                     => __( 'PayPal pending payments are not supported', 'woo-payment-gateway' ),
			'2082'                                     => __( 'PayPal Domestic Transaction Required', 'woo-payment-gateway' ),
			'2083'                                     => __( 'PayPal Phone Number Required', 'woo-payment-gateway' ),
			'2084'                                     => __( 'PayPal Tax Info Required', 'woo-payment-gateway' ),
			'2085'                                     => __( 'PayPal Payee Blocked Transaction', 'woo-payment-gateway' ),
			'2086'                                     => __( 'PayPal Transaction Limit Exceeded', 'woo-payment-gateway' ),
			'2087'                                     => __( 'PayPal reference transactions not enabled for your account', 'woo-payment-gateway' ),
			'2088'                                     => __( 'Currency not enabled for your PayPal seller account', 'woo-payment-gateway' ),
			'2089'                                     => __( 'PayPal payee email permission denied for this request', 'woo-payment-gateway' ),
			'2090'                                     => __( 'PayPal account not configured to refund more than settled amount', 'woo-payment-gateway' ),
			'2091'                                     => __( 'Currency of this transaction must match currency of your PayPal account', 'woo-payment-gateway' ),
			'3000'                                     => __( 'Processor Network Unavailable - Try Again', 'woo-payment-gateway' ),
			'Braintree\Exception\NotFound'             => __( 'Object was not found.', 'woo-payment-gateway' ),
			'Braintree\Exception\Authentication'       => __( 'Authentication failed, check your API key configuration.', 'woo-payment-gateway' ),
			'Braintree\Exception\Authorization'        => __( 'API Authorization check failed. Ensure you have entered your API keys correctly and the user associated with your API keys has the proper permissions.', 'woo-payment-gateway' ),
			'81801'                                    => __( 'Addresses must have at least one field filled in.', 'woo-payment-gateway' ),
			'81802'                                    => __( 'Company is too long.', 'woo-payment-gateway' ),
			'81804'                                    => __( 'Extended address is too long.', 'woo-payment-gateway' ),
			'81805'                                    => __( 'First name is too long.', 'woo-payment-gateway' ),
			'81806'                                    => __( 'Last name is too long.', 'woo-payment-gateway' ),
			'81807'                                    => __( 'Locality is too long.', 'woo-payment-gateway' ),
			'81813'                                    => __( 'Postal code can only contain letters, numbers, spaces, and hyphens.', 'woo-payment-gateway' ),
			'81808'                                    => __( 'Postal code is required.', 'woo-payment-gateway' ),
			'81809'                                    => __( 'Postal code may contain no more than 9 letter or number characters.', 'woo-payment-gateway' ),
			'81810'                                    => __( 'Region is too long.', 'woo-payment-gateway' ),
			'81811'                                    => __( 'Street address is required.', 'woo-payment-gateway' ),
			'81812'                                    => __( 'Street address is too long.', 'woo-payment-gateway' ),
			'81827'                                    => __( 'US state codes must be two characters to meet PayPal Seller Protection requirements.', 'woo-payment-gateway' ),
			'91803'                                    => __( 'Country name is not an accepted country.', 'woo-payment-gateway' ),
			'91815'                                    => __( 'Provided country information is inconsistent.', 'woo-payment-gateway' ),
			'91816'                                    => __( 'Country code (alpha3) is not an accepted country.', 'woo-payment-gateway' ),
			'91817'                                    => __( 'Country code (numeric) is not an accepted country.', 'woo-payment-gateway' ),
			'91814'                                    => __( 'Country code (alpha2) is not an accepted country.', 'woo-payment-gateway' ),
			'91818'                                    => __( 'Customer has already reached the maximum of 50 addresses.', 'woo-payment-gateway' ),
			'91819'                                    => __( 'First name must be a string.', 'woo-payment-gateway' ),
			'91820'                                    => __( 'Last name must be a string.', 'woo-payment-gateway' ),
			'91821'                                    => __( 'Company must be a string.', 'woo-payment-gateway' ),
			'91822'                                    => __( 'Street address must be a string.', 'woo-payment-gateway' ),
			'91823'                                    => __( 'Extended address must be a string.', 'woo-payment-gateway' ),
			'91824'                                    => __( 'Locality must be a string.', 'woo-payment-gateway' ),
			'91825'                                    => __( 'Region must be a string.', 'woo-payment-gateway' ),
			'91826'                                    => __( 'Postal code must be a string.', 'woo-payment-gateway' ),
			'91828'                                    => __( 'Address is invalid.', 'woo-payment-gateway' ),
			'82602'                                    => __( 'Applicant merchant id is too long.', 'woo-payment-gateway' ),
			'82603'                                    => __( 'Applicant merchant id format is invalid.', 'woo-payment-gateway' ),
			'82604'                                    => __( 'Applicant merchant id is in use.', 'woo-payment-gateway' ),
			'82605'                                    => __( 'Applicant merchant id is not allowed.', 'woo-payment-gateway' ),
			'82606'                                    => __( 'Master merchant account ID is required.', 'woo-payment-gateway' ),
			'82607'                                    => __( 'Master merchant account ID is invalid.', 'woo-payment-gateway' ),
			'82608'                                    => __( 'Master merchant account must be active.', 'woo-payment-gateway' ),
			'82610'                                    => __( 'Terms Of Service needs to be accepted. Applicant tos_accepted required.', 'woo-payment-gateway' ),
			'82675'                                    => __( 'Merchant account id can not be updated.', 'woo-payment-gateway' ),
			'82676'                                    => __( 'Master merchant account id can not be updated.', 'woo-payment-gateway' ),
			'82674'                                    => __( 'Merchant accounts with a status of pending or suspended cannot be updated.', 'woo-payment-gateway' ),
			'82609'                                    => __( 'Applicant first name is required.', 'woo-payment-gateway' ),
			'82637'                                    => __( 'Individual first name is required.', 'woo-payment-gateway' ),
			'82611'                                    => __( 'Applicant last name is required.', 'woo-payment-gateway' ),
			'82638'                                    => __( 'Individual last name is required.', 'woo-payment-gateway' ),
			'82612'                                    => __( 'Applicant date of birth is required.', 'woo-payment-gateway' ),
			'82639'                                    => __( 'Individual date of birth is required.', 'woo-payment-gateway' ),
			'82613'                                    => __( 'Applicant routing number is required.', 'woo-payment-gateway' ),
			'82640'                                    => __( 'Funding routing number is required.', 'woo-payment-gateway' ),
			'82614'                                    => __( 'Applicant account number is required.', 'woo-payment-gateway' ),
			'82641'                                    => __( 'Funding account number is required.', 'woo-payment-gateway' ),
			'82615'                                    => __( 'Applicant SSN must be blank, last 4 digits, or full 9 digits.', 'woo-payment-gateway' ),
			'82642'                                    => __( 'Individual SSN must be blank, last 4 digits, or full 9 digits.', 'woo-payment-gateway' ),
			'82616'                                    => __( 'Applicant email is invalid.', 'woo-payment-gateway' ),
			'82643'                                    => __( 'Individual email is invalid.', 'woo-payment-gateway' ),
			'82627'                                    => __( 'Applicant first name is invalid.', 'woo-payment-gateway' ),
			'82644'                                    => __( 'Individual first name is invalid.', 'woo-payment-gateway' ),
			'82628'                                    => __( 'Applicant last name is invalid.', 'woo-payment-gateway' ),
			'82645'                                    => __( 'Individual last name is invalid.', 'woo-payment-gateway' ),
			'82631'                                    => __( 'Applicant company name is invalid.', 'woo-payment-gateway' ),
			'82632'                                    => __( 'Applicant tax ID is invalid.', 'woo-payment-gateway' ),
			'82688'                                    => __( 'Business params provided in an invalid format.', 'woo-payment-gateway' ),
			'82647'                                    => __( 'Business tax ID is invalid.', 'woo-payment-gateway' ),
			'82633'                                    => __( 'Applicant company name is required with tax ID.', 'woo-payment-gateway' ),
			'82634'                                    => __( 'Applicant tax ID is required with company name.', 'woo-payment-gateway' ),
			'82635'                                    => __( 'Applicant routing number is invalid.', 'woo-payment-gateway' ),
			'82649'                                    => __( 'Funding routing number is invalid.', 'woo-payment-gateway' ),
			'82650'                                    => __( 'An unexpected error occurred trying to save the merchant account; support has been notified and is looking into the issue. You may safely retry this request', 'woo-payment-gateway' ),
			'82621'                                    => __( 'Applicant declined due to OFAC.', 'woo-payment-gateway' ),
			'82622'                                    => __( 'Applicant declined due to MasterCard MATCH.', 'woo-payment-gateway' ),
			'82623'                                    => __( 'Applicant declined due to failed KYC.', 'woo-payment-gateway' ),
			'82624'                                    => __( 'Applicant declined due to invalid SSN.', 'woo-payment-gateway' ),
			'82625'                                    => __( 'Applicant declined due to SSN matching that of a deceased person.', 'woo-payment-gateway' ),
			'82626'                                    => __( 'Applicant declined after review.', 'woo-payment-gateway' ),
			'82617'                                    => __( 'Applicant street address is required.', 'woo-payment-gateway' ),
			'82657'                                    => __( 'Individual street address is required.', 'woo-payment-gateway' ),
			'82618'                                    => __( 'Applicant locality is required.', 'woo-payment-gateway' ),
			'82658'                                    => __( 'Individual locality is required.', 'woo-payment-gateway' ),
			'82619'                                    => __( 'Applicant postal code is required.', 'woo-payment-gateway' ),
			'82659'                                    => __( 'Individual postal code is required.', 'woo-payment-gateway' ),
			'82620'                                    => __( 'Applicant region is required.', 'woo-payment-gateway' ),
			'82660'                                    => __( 'Individual region is required.', 'woo-payment-gateway' ),
			'82629'                                    => __( 'Applicant street address is invalid.', 'woo-payment-gateway' ),
			'82661'                                    => __( 'Individual street address is invalid.', 'woo-payment-gateway' ),
			'82664'                                    => __( 'Applicant region is invalid.', 'woo-payment-gateway' ),
			'82668'                                    => __( 'Individual region is invalid.', 'woo-payment-gateway' ),
			'82630'                                    => __( 'Applicant postal code is invalid.', 'woo-payment-gateway' ),
			'82662'                                    => __( 'Individual postal code is invalid.', 'woo-payment-gateway' ),
			'82636'                                    => __( 'Applicant phone is invalid.', 'woo-payment-gateway' ),
			'82656'                                    => __( 'Individual phone is invalid.', 'woo-payment-gateway' ),
			'82663'                                    => __( 'Applicant date of birth is invalid', 'woo-payment-gateway' ),
			'82666'                                    => __( 'Individual date of birth is invalid.', 'woo-payment-gateway' ),
			'82670'                                    => __( 'Applicant account number is invalid.', 'woo-payment-gateway' ),
			'82671'                                    => __( 'Funding account number is invalid.', 'woo-payment-gateway' ),
			'82665'                                    => __( 'Applicant email is required.', 'woo-payment-gateway' ),
			'82667'                                    => __( 'Individual email is required.', 'woo-payment-gateway' ),
			'82672'                                    => __( 'Business tax ID must be blank unless business legal name is present.', 'woo-payment-gateway' ),
			'82673'                                    => __( 'Applicant tax ID must be blank unless company name present.', 'woo-payment-gateway' ),
			'82646'                                    => __( 'Business DBA name is invalid.', 'woo-payment-gateway' ),
			'82677'                                    => __( 'Business legal name is invalid.', 'woo-payment-gateway' ),
			'82669'                                    => __( 'Business legal name is required with tax ID.', 'woo-payment-gateway' ),
			'82648'                                    => __( 'Business tax ID is required with business legal name.', 'woo-payment-gateway' ),
			'82685'                                    => __( 'Business street address is invalid.', 'woo-payment-gateway' ),
			'82686'                                    => __( 'Business postal code is invalid.', 'woo-payment-gateway' ),
			'82684'                                    => __( 'Business region is invalid.', 'woo-payment-gateway' ),
			'82679'                                    => __( 'Funding destination is invalid.', 'woo-payment-gateway' ),
			'82678'                                    => __( 'Funding destination is required.', 'woo-payment-gateway' ),
			'82681'                                    => __( 'Funding email is invalid.', 'woo-payment-gateway' ),
			'82680'                                    => __( 'Funding email is required when destination is email.', 'woo-payment-gateway' ),
			'82683'                                    => __( 'Funding mobile phone is invalid.', 'woo-payment-gateway' ),
			'82682'                                    => __( 'Funding mobile phone is required when destination is mobile phone.', 'woo-payment-gateway' ),
			'82687'                                    => __( 'Individual params provided in an invalid format.', 'woo-payment-gateway' ),
			'82689'                                    => __( 'Business locality is invalid.', 'woo-payment-gateway' ),
			'82690'                                    => __( 'Individual locality is invalid.', 'woo-payment-gateway' ),
			'82691'                                    => __( 'Applicant locality is invalid.', 'woo-payment-gateway' ),
			'92801'                                    => __( 'Cannot specify make_default without a customer_id', 'woo-payment-gateway' ),
			'92802'                                    => __( 'Cannot specify verify_card without a customer_id', 'woo-payment-gateway' ),
			'92803'                                    => __( 'Cannot specify fail_on_duplicate_payment_method without a customer_id', 'woo-payment-gateway' ),
			'92804'                                    => __( 'Customer specified by customer_id does not exist', 'woo-payment-gateway' ),
			'92806'                                    => __( 'Unsupported client token version', 'woo-payment-gateway' ),
			'92807'                                    => __( 'Merchant Account specified by merchant_account_id does not exist', 'woo-payment-gateway' ),
			'91602'                                    => __( 'Custom field is invalid:', 'woo-payment-gateway' ),
			'91609'                                    => __( 'Customer ID has already been taken.', 'woo-payment-gateway' ),
			'91610'                                    => __( 'Customer ID is invalid (use only letters, numbers, \'-\', and \'_\').', 'woo-payment-gateway' ),
			'91611'                                    => __( 'Customer ID is not an allowed ID.', 'woo-payment-gateway' ),
			'91612'                                    => __( 'Customer ID is too long.', 'woo-payment-gateway' ),
			'91613'                                    => __( 'Customer ID is required.', 'woo-payment-gateway' ),
			'91617'                                    => __( 'Nonce references a vaulted payment instrument - cannot be transferred between customers', 'woo-payment-gateway' ),
			'91618'                                    => __( 'Customer attribute must be a map of keys and values representing a customer.', 'woo-payment-gateway' ),
			'91619'                                    => __( 'Ambiguous usage of default payment method token.', 'woo-payment-gateway' ),
			'81601'                                    => __( 'Company is too long.', 'woo-payment-gateway' ),
			'81603'                                    => __( 'Custom field is too long:', 'woo-payment-gateway' ),
			'81604'                                    => __( 'Email is an invalid format.', 'woo-payment-gateway' ),
			'81605'                                    => __( 'Email is too long.', 'woo-payment-gateway' ),
			'81606'                                    => __( 'Email is required if sending a receipt.', 'woo-payment-gateway' ),
			'81607'                                    => __( 'Fax is too long.', 'woo-payment-gateway' ),
			'81608'                                    => __( 'First name is too long.', 'woo-payment-gateway' ),
			'81613'                                    => __( 'Last name is too long.', 'woo-payment-gateway' ),
			'81614'                                    => __( 'Phone is too long.', 'woo-payment-gateway' ),
			'81615'                                    => __( 'Website is too long.', 'woo-payment-gateway' ),
			'81616'                                    => __( 'Website is an invalid format.', 'woo-payment-gateway' ),
			'93101'                                    => __( 'Payment method params are required.', 'woo-payment-gateway' ),
			'93102'                                    => __( 'Nonce is invalid.', 'woo-payment-gateway' ),
			'93103'                                    => __( 'Nonce is required.', 'woo-payment-gateway' ),
			'93104'                                    => __( 'Customer ID is required.', 'woo-payment-gateway' ),
			'93105'                                    => __( 'Customer ID is invalid.', 'woo-payment-gateway' ),
			'93106'                                    => __( 'Cannot forward a payment method of this type.', 'woo-payment-gateway' ),
			'93107'                                    => __( 'Cannot use a payment_method_nonce more than once.', 'woo-payment-gateway' ),
			'93108'                                    => __( 'Unknown or expired payment_method_nonce.', 'woo-payment-gateway' ),
			'93109'                                    => __( 'Nonce is not vaultable.', 'woo-payment-gateway' ),
			'83501'                                    => __( 'Apple Pay cards are not accepted by this merchant account.', 'woo-payment-gateway' ),
			'83502'                                    => __( 'A customer ID is required to vault an Apple Pay Card.', 'woo-payment-gateway' ),
			'93503'                                    => __( 'Apple Pay token is taken.', 'woo-payment-gateway' ),
			'93504'                                    => __( 'Cannot use a payment_method_nonce more than once.', 'woo-payment-gateway' ),
			'93505'                                    => __( 'Unknown or expired payment_method_nonce.', 'woo-payment-gateway' ),
			'93506'                                    => __( 'Payment method nonce locked.', 'woo-payment-gateway' ),
			'83518'                                    => __( 'Credit card type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'93507'                                    => __( 'Payment method nonces cannot be used to update an existing Apple Pay Card.', 'woo-payment-gateway' ),
			'93508'                                    => __( 'Number is required for Apple Pay Card', 'woo-payment-gateway' ),
			'93509'                                    => __( 'Expiration Month is required for Apple Pay Card', 'woo-payment-gateway' ),
			'93510'                                    => __( 'Expiration Year is required for Apple Pay Card', 'woo-payment-gateway' ),
			'93511'                                    => __( 'Cryptogram is required for Apple Pay Card', 'woo-payment-gateway' ),
			'83512'                                    => __( 'Apple Pay payment data decryption failed', 'woo-payment-gateway' ),
			'93513'                                    => __( 'Apple Pay is disabled for this merchant', 'woo-payment-gateway' ),
			'93514'                                    => __( 'Apple Pay certificate, private key or merchant ID not configured', 'woo-payment-gateway' ),
			'93517'                                    => __( 'Certificate provided is not valid', 'woo-payment-gateway' ),
			'93519'                                    => __( 'Public key used to sign payment data does not match stored certificate', 'woo-payment-gateway' ),
			'83520'                                    => __( 'Payment data is malformed', 'woo-payment-gateway' ),
			'93521'                                    => __( 'Private key stored does not match private key used to encrypt payment data', 'woo-payment-gateway' ),
			'93522'                                    => __( 'Certificate does not match stored key pair', 'woo-payment-gateway' ),
			'91701'                                    => __( 'Cannot provide both a billing address and a billing address ID.', 'woo-payment-gateway' ),
			'91702'                                    => __( 'Billing address ID is invalid.', 'woo-payment-gateway' ),
			'91704'                                    => __( 'Customer ID is required.', 'woo-payment-gateway' ),
			'91705'                                    => __( 'Customer ID is invalid.', 'woo-payment-gateway' ),
			'91708'                                    => __( 'Cannot provide expirationdate if you are also providing expiration_month and expiration_year.', 'woo-payment-gateway' ),
			'91718'                                    => __( 'Token is invalid (use only letters, numbers, " - ", and \'\').', 'woo-payment-gateway' ),
			'91719'                                    => __( 'Credit card token is taken.', 'woo-payment-gateway' ),
			'91720'                                    => __( 'Credit card token is too long.', 'woo-payment-gateway' ),
			'91721'                                    => __( 'Token is not an allowed token.', 'woo-payment-gateway' ),
			'91722'                                    => __( 'Payment Method token is required.', 'woo-payment-gateway' ),
			'91744'                                    => __( 'Billing address format is invalid.', 'woo-payment-gateway' ),
			'81723'                                    => __( 'Cardholder name is too long.', 'woo-payment-gateway' ),
			'81703'                                    => __( 'Credit card type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'81718'                                    => __( 'Credit card number cannot be updated to an unsupported card type when it is associated to subscriptions.', 'woo-payment-gateway' ),
			'81706'                                    => __( 'CVV is required.', 'woo-payment-gateway' ),
			'81707'                                    => __( 'CVV must be 4 digits for American Express and 3 digits for other card types.', 'woo-payment-gateway' ),
			'81709'                                    => __( 'Expiration date is required.', 'woo-payment-gateway' ),
			'81710'                                    => __( 'Expiration date is invalid.', 'woo-payment-gateway' ),
			'81711'                                    => __( 'Expiration date year is invalid. It must be between 1975 and 2200.', 'woo-payment-gateway' ),
			'81712'                                    => __( 'Expiration month is invalid.', 'woo-payment-gateway' ),
			'81713'                                    => __( 'Expiration year is invalid.', 'woo-payment-gateway' ),
			'81714'                                    => __( 'Credit card number is required.', 'woo-payment-gateway' ),
			'81715'                                    => __( 'Credit card number is invalid.', 'woo-payment-gateway' ),
			'81716'                                    => __( 'Credit card number must be 12-19 digits.', 'woo-payment-gateway' ),
			'81717'                                    => __( 'Credit card number is not an accepted test number.', 'woo-payment-gateway' ),
			'91723'                                    => __( 'Update Existing Token is invalid.', 'woo-payment-gateway' ),
			'81724'                                    => __( 'Duplicate card exists in the vault.', 'woo-payment-gateway' ),
			'81725'                                    => __( 'Credit card must include number, payment_method_nonce, or venmo_sdk_payment_method_code.', 'woo-payment-gateway' ),
			'91726'                                    => __( 'Credit card type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91727'                                    => __( 'Invalid VenmoSDK payment method code', 'woo-payment-gateway' ),
			'91728'                                    => __( 'Verification Merchant Account ID is invalid.', 'woo-payment-gateway' ),
			'91729'                                    => __( 'Update Existing Token is not allowed when creating a customer.', 'woo-payment-gateway' ),
			'91730'                                    => __( 'Verifications are not supported on this merchant account', 'woo-payment-gateway' ),
			'91731'                                    => __( 'Cannot use a payment_method_nonce more than once.', 'woo-payment-gateway' ),
			'91732'                                    => __( 'Unknown or expired payment_method_nonce.', 'woo-payment-gateway' ),
			'91733'                                    => __( 'Payment method nonce locked.', 'woo-payment-gateway' ),
			'91734'                                    => __( 'Credit card type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91735'                                    => __( 'Payment method nonces cannot be used to update an existing card.', 'woo-payment-gateway' ),
			'91738'                                    => __( 'Payment method is not a credit card payment method.', 'woo-payment-gateway' ),
			'91742'                                    => __( 'Verification Merchant Account is suspended.', 'woo-payment-gateway' ),
			'91743'                                    => __( 'The current user does not have access to the specified verification_merchant_account_id', 'woo-payment-gateway' ),
			'81736'                                    => __( 'CVV verification failed.', 'woo-payment-gateway' ),
			'81737'                                    => __( 'Postal code verification failed.', 'woo-payment-gateway' ),
			'91739'                                    => __( 'Verification amount cannot be negative.', 'woo-payment-gateway' ),
			'91740'                                    => __( 'Verification amount is invalid.', 'woo-payment-gateway' ),
			'91741'                                    => __( 'Verification amount not supported by processor.', 'woo-payment-gateway' ),
			'91745'                                    => __( 'Payment method params supplied are not valid for updating a credit card.', 'woo-payment-gateway' ),
			'81750'                                    => __( 'Credit card number is prohibited.', 'woo-payment-gateway' ),
			'91752'                                    => __( 'Verification amount is too large.', 'woo-payment-gateway' ),
			'91755'                                    => __( 'Verification Merchant Account ID cannot be a sub-merchant account.', 'woo-payment-gateway' ),
			'93401'                                    => __( 'Industry type is invalid.', 'woo-payment-gateway' ),
			'93402'                                    => __( 'Lodging data is empty.', 'woo-payment-gateway' ),
			'93403'                                    => __( 'Folio number is invalid.', 'woo-payment-gateway' ),
			'93404'                                    => __( 'Check in date is invalid.', 'woo-payment-gateway' ),
			'93405'                                    => __( 'Check out date is invalid.', 'woo-payment-gateway' ),
			'93406'                                    => __( 'Check out date must occur during or after the check in date.', 'woo-payment-gateway' ),
			'93407'                                    => __( 'Data fields are unknown.', 'woo-payment-gateway' ),
			'93408'                                    => __( 'Travel and Cruise data is empty.', 'woo-payment-gateway' ),
			'93409'                                    => __( 'Data fields are unknown.', 'woo-payment-gateway' ),
			'93410'                                    => __( 'Travel Package is invalid.', 'woo-payment-gateway' ),
			'93411'                                    => __( 'Departure date is invalid.', 'woo-payment-gateway' ),
			'93412'                                    => __( 'Lodging check in date is invalid.', 'woo-payment-gateway' ),
			'93413'                                    => __( 'Lodging check out date is invalid.', 'woo-payment-gateway' ),
			'82901'                                    => __( 'Incomplete PayPal account information.', 'woo-payment-gateway' ),
			'82902'                                    => __( 'Pre-Approved Payment enabled PayPal account required for vaulting.', 'woo-payment-gateway' ),
			'82903'                                    => __( 'Invalid PayPal account information.', 'woo-payment-gateway' ),
			'82904'                                    => __( 'PayPal Accounts are not accepted by this merchant account.', 'woo-payment-gateway' ),
			'82905'                                    => __( 'A customer ID is required to vault a PayPal Account.', 'woo-payment-gateway' ),
			'92906'                                    => __( 'PayPal Account token is taken.', 'woo-payment-gateway' ),
			'92907'                                    => __( 'Cannot use a payment_method_nonce more than once.', 'woo-payment-gateway' ),
			'92908'                                    => __( 'Unknown or expired payment_method_nonce.', 'woo-payment-gateway' ),
			'92909'                                    => __( 'Payment method nonce locked.', 'woo-payment-gateway' ),
			'92910'                                    => __( 'Error communicating with PayPal.', 'woo-payment-gateway' ),
			'92911'                                    => __( 'PayPal authentication expired.', 'woo-payment-gateway' ),
			'92912'                                    => __( 'Funding source selection was given without an access token.', 'woo-payment-gateway' ),
			'92913'                                    => __( 'Funding source object is invalid or missing required fields.', 'woo-payment-gateway' ),
			'92914'                                    => __( 'Payment method nonces cannot be used to update an existing PayPal account.', 'woo-payment-gateway' ),
			'92915'                                    => __( 'Payment method params supplied are not valid for updating a PayPal account.', 'woo-payment-gateway' ),
			'84101'                                    => __( 'Common ID is required.', 'woo-payment-gateway' ),
			'84102'                                    => __( 'Username is required.', 'woo-payment-gateway' ),
			'84103'                                    => __( 'Venmo user ID is required.', 'woo-payment-gateway' ),
			'84104'                                    => __( 'Customer ID is required.', 'woo-payment-gateway' ),
			'84105'                                    => __( 'Venmo accounts are not accepted by this merchant account.', 'woo-payment-gateway' ),
			'84106'                                    => __( 'Customer ID is invalid.', 'woo-payment-gateway' ),
			'92001'                                    => __( 'Quantity is invalid.', 'woo-payment-gateway' ),
			'92002'                                    => __( 'Amount is invalid.', 'woo-payment-gateway' ),
			'92003'                                    => __( 'Amount cannot be blank.', 'woo-payment-gateway' ),
			'92004'                                    => __( 'Quantity cannot be blank.', 'woo-payment-gateway' ),
			'92005'                                    => __( 'Number of billing cycles is invalid.', 'woo-payment-gateway' ),
			'92010'                                    => __( 'Quantity must be greater than zero.', 'woo-payment-gateway' ),
			'92011'                                    => __( 'Existing ID is invalid.', 'woo-payment-gateway' ),
			'92012'                                    => __( 'Existing ID is required.', 'woo-payment-gateway' ),
			'92013'                                    => __( 'Inherited From ID is invalid.', 'woo-payment-gateway' ),
			'92014'                                    => __( 'Inherited From ID is required.', 'woo-payment-gateway' ),
			'92015'                                    => __( 'Cannot update a removed add-on or discount.', 'woo-payment-gateway' ),
			'92016'                                    => __( 'Cannot remove add-on or discount if not already associated with subscription.', 'woo-payment-gateway' ),
			'92017'                                    => __( 'Number of billing cycles cannot be blank.', 'woo-payment-gateway' ),
			'92018'                                    => __( 'Cannot specify both number of billing cycles and never expires as true.', 'woo-payment-gateway' ),
			'92019'                                    => __( 'Number of billing cycles must be greater than zero.', 'woo-payment-gateway' ),
			'92020'                                    => __( 'Existing ID is not of the correct kind.', 'woo-payment-gateway' ),
			'92021'                                    => __( 'ID to remove is incorrect kind.', 'woo-payment-gateway' ),
			'92022'                                    => __( 'Cannot edit add-on or discount on a past due subscription.', 'woo-payment-gateway' ),
			'92023'                                    => __( 'Amount is too large.', 'woo-payment-gateway' ),
			'92024'                                    => __( 'Cannot pass null modification.', 'woo-payment-gateway' ),
			'92025'                                    => __( 'ID to remove is invalid.', 'woo-payment-gateway' ),
			'81901'                                    => __( 'Cannot edit a canceled subscription.', 'woo-payment-gateway' ),
			'81902'                                    => __( 'ID has already been taken.', 'woo-payment-gateway' ),
			'81903'                                    => __( 'Price cannot be blank.', 'woo-payment-gateway' ),
			'81904'                                    => __( 'Price is an invalid format.', 'woo-payment-gateway' ),
			'81905'                                    => __( 'Subscription has already been canceled.', 'woo-payment-gateway' ),
			'81906'                                    => __( 'ID is invalid (use only letters, numbers, \'-\', and \'\').', 'woo-payment-gateway' ),
			'81907'                                    => __( 'Trial Duration is an invalid format.', 'woo-payment-gateway' ),
			'81908'                                    => __( 'Trial Duration is required.', 'woo-payment-gateway' ),
			'81909'                                    => __( 'Trial Duration Unit is invalid.', 'woo-payment-gateway' ),
			'81910'                                    => __( 'Cannot edit an expired subscription.', 'woo-payment-gateway' ),
			'81923'                                    => __( 'Price is too large.', 'woo-payment-gateway' ),
			'91901'                                    => __( 'Merchant Account ID is invalid.', 'woo-payment-gateway' ),
			'91902'                                    => __( 'Payment method token payment instrument type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91903'                                    => __( 'Payment method token is invalid.', 'woo-payment-gateway' ),
			'91904'                                    => __( 'Plan ID is invalid.', 'woo-payment-gateway' ),
			'91905'                                    => __( 'Payment method token does not belong to the subscription\'s customer.', 'woo-payment-gateway' ),
			'91906'                                    => __( 'Number Of Billing Cycles must be numeric.', 'woo-payment-gateway' ),
			'91907'                                    => __( 'Number Of Billing Cycles must be greater than zero.', 'woo-payment-gateway' ),
			'91908'                                    => __( 'Cannot specify both number of billing cycles and never expires as true.', 'woo-payment-gateway' ),
			'91909'                                    => __( 'Number Of Billing Cycles is less than the current billing cycle.', 'woo-payment-gateway' ),
			'91911'                                    => __( 'Cannot add duplicate add-on or discount.', 'woo-payment-gateway' ),
			'91912'                                    => __( 'Number Of Billing Cycles cannot be blank if the subscription expires.', 'woo-payment-gateway' ),
			'91913'                                    => __( 'Billing Day of Month must be numeric.', 'woo-payment-gateway' ),
			'91914'                                    => __( 'Billing Day of Month must be between 1 and 28, or 31.', 'woo-payment-gateway' ),
			'91915'                                    => __( 'First Billing Date is invalid.', 'woo-payment-gateway' ),
			'91916'                                    => __( 'First Billing Date cannot be in the past.', 'woo-payment-gateway' ),
			'91917'                                    => __( 'Cannot specify more than one type of start date.', 'woo-payment-gateway' ),
			'91918'                                    => __( 'Billing Day of Month cannot be updated.', 'woo-payment-gateway' ),
			'91919'                                    => __( 'First Billing Date cannot be updated.', 'woo-payment-gateway' ),
			'91920'                                    => __( 'Can only edit id, merchant account id, payment method token, and descriptor on a past due subscription.', 'woo-payment-gateway' ),
			'91921'                                    => __( 'Invalid request format.', 'woo-payment-gateway' ),
			'91922'                                    => __( 'Cannot update subscription to a plan with a different billing frequency.', 'woo-payment-gateway' ),
			'91923'                                    => __( 'Subscription Plan currency must be the same as the merchant account\'s currency.', 'woo-payment-gateway' ),
			'91924'                                    => __( 'Payment method nonce payment instrument type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91925'                                    => __( 'Payment method nonce is invalid.', 'woo-payment-gateway' ),
			'91926'                                    => __( 'Payment method nonce does not belong to the subscription\'s customer.', 'woo-payment-gateway' ),
			'91927'                                    => __( 'Payment method nonce represents an un-vaulted payment instrument.', 'woo-payment-gateway' ),
			'91928'                                    => __( 'Payment instrument type is not valid for subscriptions.', 'woo-payment-gateway' ),
			'91929'                                    => __( 'Payment instrument type is not valid for subscriptions.', 'woo-payment-gateway' ),
			'91930'                                    => __( 'Merchant Account does not support the given payment instrument type.', 'woo-payment-gateway' ),
			'82301'                                    => __( 'Settlement Date is required', 'woo-payment-gateway' ),
			'82302'                                    => __( 'Settlement Date is invalid', 'woo-payment-gateway' ),
			'82303'                                    => __( 'Group By Custom Field is not a valid custom field', 'woo-payment-gateway' ),
			'81501'                                    => __( 'Amount cannot be negative.', 'woo-payment-gateway' ),
			'81502'                                    => __( 'Amount is required.', 'woo-payment-gateway' ),
			'81503'                                    => __( 'Amount is an invalid format.', 'woo-payment-gateway' ),
			'81528'                                    => __( 'Amount is too large.', 'woo-payment-gateway' ),
			'81509'                                    => __( 'Credit card type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'81527'                                    => __( 'Custom field is too long:', 'woo-payment-gateway' ),
			'91501'                                    => __( 'Order ID is too long.', 'woo-payment-gateway' ),
			'91530'                                    => __( 'Cannot provide a billing address unless also providing a credit card.', 'woo-payment-gateway' ),
			'91504'                                    => __( 'Transaction can only be voided if status is authorized or submitted_for_settlement.', 'woo-payment-gateway' ),
			'91505'                                    => __( 'Credit transactions cannot be refunded.', 'woo-payment-gateway' ),
			'91506'                                    => __( 'Cannot refund a transaction unless it is settled.', 'woo-payment-gateway' ),
			'91507'                                    => __( 'Cannot submit for settlement unless status is authorized.', 'woo-payment-gateway' ),
			'91508'                                    => __( 'Cannot determine payment method.', 'woo-payment-gateway' ),
			'91526'                                    => __( 'Custom field is invalid:', 'woo-payment-gateway' ),
			'91510'                                    => __( 'Customer ID is invalid.', 'woo-payment-gateway' ),
			'91511'                                    => __( 'Customer does not have any credit cards.', 'woo-payment-gateway' ),
			'91512'                                    => __( 'Transaction has already been completely refunded.', 'woo-payment-gateway' ),
			'91513'                                    => __( 'Merchant account ID is invalid.', 'woo-payment-gateway' ),
			'91514'                                    => __( 'Merchant account is suspended.', 'woo-payment-gateway' ),
			'91515'                                    => __( 'Cannot provide both payment_method_token and credit_card attributes.', 'woo-payment-gateway' ),
			'91516'                                    => __( 'Cannot provide both payment_method_token and customer_id unless the payment_method belongs to the customer.', 'woo-payment-gateway' ),
			'91527'                                    => __( 'Cannot provide both payment_method_token and subscription_id unless the payment_method belongs to the subscription.', 'woo-payment-gateway' ),
			'91517'                                    => __( 'Payment instrument type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91518'                                    => __( 'Payment method token is invalid.', 'woo-payment-gateway' ),
			'91519'                                    => __( 'Processor authorization code cannot be set unless for a voice authorization.', 'woo-payment-gateway' ),
			'91521'                                    => __( 'Refund amount is too large.', 'woo-payment-gateway' ),
			'91538'                                    => __( 'Cannot refund a transaction with a suspended merchant account.', 'woo-payment-gateway' ),
			'91522'                                    => __( 'Settlement amount is too large.', 'woo-payment-gateway' ),
			'91529'                                    => __( 'Cannot provide both subscription_id and customer_id unless the subscription belongs to the customer.', 'woo-payment-gateway' ),
			'91528'                                    => __( 'Subscription ID is invalid.', 'woo-payment-gateway' ),
			'91523'                                    => __( 'Transaction type is invalid.', 'woo-payment-gateway' ),
			'91524'                                    => __( 'Transaction type is required.', 'woo-payment-gateway' ),
			'91525'                                    => __( 'Vault is disabled.', 'woo-payment-gateway' ),
			'91531'                                    => __( 'Subscription status must be Past Due in order to retry.', 'woo-payment-gateway' ),
			'91547'                                    => __( 'Merchant account does not support refunds.', 'woo-payment-gateway' ),
			'81531'                                    => __( 'Amount must be greater than zero.', 'woo-payment-gateway' ),
			'81534'                                    => __( 'Tax amount cannot be negative.', 'woo-payment-gateway' ),
			'81535'                                    => __( 'Tax amount is an invalid format.', 'woo-payment-gateway' ),
			'81536'                                    => __( 'Tax amount is too large.', 'woo-payment-gateway' ),
			'81571'                                    => __( 'Failed to authenticate, please try a different form of payment.', 'woo-payment-gateway' ),
			'91537'                                    => __( 'Purchase order number is too long.', 'woo-payment-gateway' ),
			'91539'                                    => __( 'Voice Authorization is not allowed for this card type', 'woo-payment-gateway' ),
			'91540'                                    => __( 'Transaction cannot be cloned if payment method is stored in vault.', 'woo-payment-gateway' ),
			'91541'                                    => __( 'Cannot clone voice authorization transactions.', 'woo-payment-gateway' ),
			'91542'                                    => __( 'Unsuccessful transaction cannot be cloned.', 'woo-payment-gateway' ),
			'91543'                                    => __( 'Credits cannot be cloned.', 'woo-payment-gateway' ),
			'91544'                                    => __( 'Cannot clone transaction without submit_for_settlement flag.', 'woo-payment-gateway' ),
			'91545'                                    => __( 'Voice Authorizations are not supported for this processor.', 'woo-payment-gateway' ),
			'91546'                                    => __( 'Credits are not supported by this processor.', 'woo-payment-gateway' ),
			'91548'                                    => __( 'Purchase order number is invalid.', 'woo-payment-gateway' ),
			'81520'                                    => __( 'Processor authorization code must be 6 characters.', 'woo-payment-gateway' ),
			'91549'                                    => __( 'Cannot provide more than one of payment_method_token, payment_method_nonce, credit_card, and venmo_sdk_payment_method_code attributes.', 'woo-payment-gateway' ),
			'91550'                                    => __( 'Channel is too long.', 'woo-payment-gateway' ),
			'91551'                                    => __( 'Settlement amount cannot be less than the service fee amount.', 'woo-payment-gateway' ),
			'91552'                                    => __( 'Credits not allowed with service fee.', 'woo-payment-gateway' ),
			'91553'                                    => __( 'Sub-merchant account requires a service fee.', 'woo-payment-gateway' ),
			'91554'                                    => __( 'Amount cannot be negative.', 'woo-payment-gateway' ),
			'91555'                                    => __( 'Amount is an invalid format.', 'woo-payment-gateway' ),
			'91556'                                    => __( 'Service fee amount is larger than transaction amount.', 'woo-payment-gateway' ),
			'91557'                                    => __( 'Service fee not supported on master merchant account.', 'woo-payment-gateway' ),
			'91558'                                    => __( 'Merchant account does not support MOTO transactions unless configured by processor.', 'woo-payment-gateway' ),
			'91559'                                    => __( 'Cannot refund a transaction with a pending merchant account.', 'woo-payment-gateway' ),
			'91560'                                    => __( 'Transaction could not be held in escrow.', 'woo-payment-gateway' ),
			'91561'                                    => __( 'Cannot release a transaction that is not escrowed.', 'woo-payment-gateway' ),
			'91562'                                    => __( 'Release can only be cancelled if the transaction is submitted for release.', 'woo-payment-gateway' ),
			'91563'                                    => __( 'Escrowed transactions cannot be partially refunded.', 'woo-payment-gateway' ),
			'91564'                                    => __( 'Cannot use a payment_method_nonce more than once.', 'woo-payment-gateway' ),
			'91565'                                    => __( 'Unknown or expired payment_method_nonce.', 'woo-payment-gateway' ),
			'91567'                                    => __( 'Payment instrument type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91568'                                    => __( 'Three D Secure Token is invalid.', 'woo-payment-gateway' ),
			'91569'                                    => __( 'payment_method_nonce does not contain a valid payment instrument type.', 'woo-payment-gateway' ),
			'91572'                                    => __( 'Current payment method does not support use_billing_for_shipping flag.', 'woo-payment-gateway' ),
			'91575'                                    => __( 'Cannot transition transaction to settled, settlement_confirmed, or settlement_declined', 'woo-payment-gateway' ),
			'91576'                                    => __( 'PayPal is not enabled for your merchant account.', 'woo-payment-gateway' ),
			'91577'                                    => __( 'Merchant account does not support payment instrument.', 'woo-payment-gateway' ),
			'91570'                                    => __( 'Transaction data does not match data from Three D Secure verify call.', 'woo-payment-gateway' ),
			'91573'                                    => __( 'Transaction cannot be cloned if payment method is a PayPal account.', 'woo-payment-gateway' ),
			'91574'                                    => __( 'Cannot refund a transaction transaction in settling status on this merchant account. Try again after the transaction has settled.', 'woo-payment-gateway' ),
			'91578'                                    => __( 'Service fee can not be applied on PayPal transactions.', 'woo-payment-gateway' ),
			'91580'                                    => __( 'PayPal custom fields must be less than 256 characters in length.', 'woo-payment-gateway' ),
			'91581'                                    => __( 'Shipping address customer does not match customer in request.', 'woo-payment-gateway' ),
			'91582'                                    => __( 'PayPal unilateral transactions must also be submitted for settlement.', 'woo-payment-gateway' ),
			'91583'                                    => __( 'This PayPal account was not vaulted with the required data', 'woo-payment-gateway' ),
			'91584'                                    => __( 'Merchant account must match the 3D Secure authorization merchant account.', 'woo-payment-gateway' ),
			'91585'                                    => __( 'Amount must match the 3D Secure authorization amount.', 'woo-payment-gateway' ),
			'91586'                                    => __( 'Shared billing address ID cannot be used in the same call as a standard billing address ID', 'woo-payment-gateway' ),
			'91587'                                    => __( 'Shared customer ID cannot be used in the same call as a standard customer ID', 'woo-payment-gateway' ),
			'91588'                                    => __( 'Shared payment method token cannot be used in the same call as a standard payment method token', 'woo-payment-gateway' ),
			'91589'                                    => __( 'Shared payment method token cannot be used in the same call as a non-shared identifier param', 'woo-payment-gateway' ),
			'91590'                                    => __( 'Shared identifier param cannot be used with non-shared payment method token', 'woo-payment-gateway' ),
			'91591'                                    => __( 'Shared shipping address ID cannot be used in the same call as a standard shipping address ID', 'woo-payment-gateway' ),
			'91592'                                    => __( 'Shared payment methods cannot be vaulted', 'woo-payment-gateway' ),
			'91593'                                    => __( 'Shared payment methods cannot be vaulted', 'woo-payment-gateway' ),
			'91594'                                    => __( 'Shared shipping addresses cannot be vaulted', 'woo-payment-gateway' ),
			'91595'                                    => __( 'Shared payment methods cannot be updated', 'woo-payment-gateway' ),
			'91597'                                    => __( 'Cannot provide both shared_payment_method_token and shared_customer_id unless the payment_method belongs to the customer.', 'woo-payment-gateway' ),
			'91598'                                    => __( 'Payment instrument type is not accepted by this merchant account.', 'woo-payment-gateway' ),
			'91599'                                    => __( 'Shared Shipping address customer does not match customer in request.', 'woo-payment-gateway' ),
			'91596'                                    => __( 'Shared payment method token is invalid.', 'woo-payment-gateway' ),
			'915100'                                   => __( 'Shared Customer ID is invalid.', 'woo-payment-gateway' ),
			'915103'                                   => __( 'Cannot submit for partial settlement.', 'woo-payment-gateway' ),
			'915101'                                   => __( 'Payment instrument type is not accepted.', 'woo-payment-gateway' ),
			'915102'                                   => __( 'Partial settlements are not supported by this processor.', 'woo-payment-gateway' ),
			'915104'                                   => __( 'Delayed settlements are not supported for this processor. The submit for settlement option is required.', 'woo-payment-gateway' ),
			'915105'                                   => __( 'Merchant account does not support Amex rewards.', 'woo-payment-gateway' ),
			'915106'                                   => __( 'Points amount is too large.', 'woo-payment-gateway' ),
			'915107'                                   => __( 'Updating order_id on submit_for_settlement is not supported by this processor.', 'woo-payment-gateway' ),
			'915108'                                   => __( 'Updating descriptor on submit_for_settlement is not supported by this processor.', 'woo-payment-gateway' ),
			'915109'                                   => __( 'PayPal supplementary data fields must be less than 4001 characters in length:', 'woo-payment-gateway' ),
			'915110'                                   => __( 'Cannot clone facilitated transactions.', 'woo-payment-gateway' ),
			'915111'                                   => __( 'PayPal supplementary data field count must be less than 101.', 'woo-payment-gateway' ),
			'915112'                                   => __( 'Shared payment method token originated from another merchant and is not allowed to be shared', 'woo-payment-gateway' ),
			'915113'                                   => __( 'EciFlag is required.', 'woo-payment-gateway' ),
			'915114'                                   => __( 'EciFlag is invalid.', 'woo-payment-gateway' ),
			'915115'                                   => __( 'Xid is required for specified EciFlag.', 'woo-payment-gateway' ),
			'915116'                                   => __( 'Cavv is required for specified EciFlag.', 'woo-payment-gateway' ),
			'915131'                                   => __( 'Merchant account does not support 3D Secure transactions for card type.', 'woo-payment-gateway' ),
			'915133'                                   => __( 'Transaction source must be either \'moto\' or \'recurring\'.', 'woo-payment-gateway' ),
			'915134'                                   => __( 'submit_for_settlement is required and must be true.', 'woo-payment-gateway' ),
			'915135'                                   => __( 'shared_payment_method_nonce does not contain valid payment instrument type.', 'woo-payment-gateway' ),
			'915136'                                   => __( 'Payment instrument type is not accepted by this merchant.', 'woo-payment-gateway' ),
			'915137'                                   => __( 'Cannot clone Braintree Marketplace transactions via the API.', 'woo-payment-gateway' ),
			'92201'                                    => __( 'Company name/DBA section is invalid.', 'woo-payment-gateway' ),
			'92202'                                    => __( 'Phone number is invalid.', 'woo-payment-gateway' ),
			'92203'                                    => __( 'Dynamic descriptors have not been enabled for this account. Please contact support@braintreepayments.com.', 'woo-payment-gateway' ),
			'92204'                                    => __( 'Descriptor format is invalid.', 'woo-payment-gateway' ),
			'92205'                                    => __( 'International phone number is invalid.', 'woo-payment-gateway' ),
			'92206'                                    => __( 'URL must be 13 characters or shorter.', 'woo-payment-gateway' ),
			'94201'                                    => __( 'Verification amount cannot be negative.', 'woo-payment-gateway' ),
			'94202'                                    => __( 'Verification amount is invalid.', 'woo-payment-gateway' ),
			'94203'                                    => __( 'Verification amount not supported by processor.', 'woo-payment-gateway' ),
			'94204'                                    => __( 'Verification Merchant Account ID is invalid.', 'woo-payment-gateway' ),
			'94205'                                    => __( 'Verification Merchant Account is suspended.', 'woo-payment-gateway' ),
			'94206'                                    => __( 'The current user does not have access to the specified merchant_account_id', 'woo-payment-gateway' ),
			'94207'                                    => __( 'Verification amount is too large.', 'woo-payment-gateway' ),
			'94208'                                    => __( 'Verification Merchant Account ID cannot be a sub-merchant account.', 'woo-payment-gateway' ),
			'95817'                                    => __( 'Product unit amount is in an invalid format.', 'woo-payment-gateway' ),
			'95820'                                    => __( 'Unit amount for transaction line item must be greater than zero. If this error continues, please disable the line items option in the plugin settings.', 'woo-payment-gateway' ),
			'gateway_rejected:_avs'                    => __( 'Invalid postal code or street address.', 'woo-payment-gateway' ),
			'gateway_rejected:_postal_code'            => __( 'Postal code.', 'woo-payment-gateway' ),
			'gateway_rejected:_cvv'                    => __( 'CVV.', 'woo-payment-gateway' ),
			'gateway_rejected:_avs_and_cvv'            => __( 'Invalid postal code and cvv', 'woo-payment-gateway' ),
			//'paypal_validation_failed'                 => __( 'Line item validation failed. Please disable line items for PayPal in the plugin settings.', 'woo-payment-gateway' ),
			'gateway_rejected:_three_d_secure'         => __( 'Your payment method was rejected due to 3D Secure.', 'woo-payment-gateway' ),
		)
	);
}
