<?php
/**
 * WBW Currency Switcher for WooCommerce - optionsViewWcu Class
 *
 * @version 2.2.0
 *
 * @author  woobewoo
 */

defined( 'ABSPATH' ) || exit;

class optionsViewWcu extends viewWcu {

	/**
	 * tabs.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $tabs;

	/**
	 * activeTab.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $activeTab;

	/**
	 * content.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $content;

	/**
	 * mainUrl.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $mainUrl;

	/**
	 * activeParentTabs.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $activeParentTabs;

	/**
	 * breadcrumbs.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $breadcrumbs;

	/**
	 * mainLink.
	 *
	 * @version 2.2.0
	 * @since   2.2.0
	 */
	public $mainLink;

	/**
	 * _news.
	 */
	private $_news = array();

	/**
	 * getNewFeatures.
	 */
	public function getNewFeatures() {
		$res = array();
		$readmePath = WCU_DIR. 'readme.txt';
		if(file_exists($readmePath)) {
			$readmeContent = @file_get_contents($readmePath);
			if(!empty($readmeContent)) {
				$matchedData = '';
				if(preg_match('/= '. WCU_VERSION. ' =(.+)=.+=/isU', $readmeContent, $matches)) {
					$matchedData = $matches[1];
				} elseif(preg_match('/= '. WCU_VERSION. ' =(.+)/is', $readmeContent, $matches)) {
					$matchedData = $matches[1];
				}
				$matchedData = trim($matchedData);
				if(!empty($matchedData)) {
					$res = array_map('trim', explode("\n", $matchedData));
				}
			}
		}
		return $res;
	}

	/**
	 * getAdminPage.
	 */
	public function getAdminPage() {
		$tabs = $this->getModule()->getTabs();
		$activeTab = $this->getModule()->getActiveTab();
		$content = 'No tab content found - ERROR';
		if(isset($tabs[ $activeTab ]) && isset($tabs[ $activeTab ]['callback'])) {
			$content = call_user_func($tabs[ $activeTab ]['callback']);
		}
		$activeParentTabs = array();
		foreach($tabs as $tabKey => $tab) {
			if($tabKey == $activeTab && isset($tab['child_of'])) {
				$activeTab = $tab['child_of'];
			}
		}
		frameWcu::_()->addJSVar('adminOptionsWcu', 'wcuActiveTab', $activeTab);
		$this->assign('tabs', $tabs);
		$this->assign('activeTab', $activeTab);
		$this->assign('content', $content);
		$this->assign('mainUrl', $this->getModule()->getTabUrl());
		$this->assign('activeParentTabs', $activeParentTabs);
		$this->assign('breadcrumbs', frameWcu::_()->getModule('admin_nav')->getView()->getBreadcrumbs());
		$this->assign('mainLink', frameWcu::_()->getModule('promo')->getMainLink());

		parent::display('optionsAdminPage');
	}

	/**
	 * sortOptsSet.
	 */
	public function sortOptsSet($a, $b) {
		if($a['weight'] > $b['weight'])
			return -1;
		if($a['weight'] < $b['weight'])
			return 1;
		return 0;
	}

	/**
	 * getTabContent.
	 */
	public function getTabContent() {
		frameWcu::_()->addScript('admin.mainoptions', $this->getModule()->getModPath(). 'js/admin.mainoptions.js');
		return parent::getContent('optionsAdminMain');
	}

	/**
	 * serverSettings.
	 */
	public function serverSettings() {
		global $wpdb;
		$this->assign('systemInfo', array(
			'Operating System'            => array('value' => PHP_OS),
			'PHP Version'                 => array('value' => PHP_VERSION),
			'Server Software'             => array('value' => $_SERVER['SERVER_SOFTWARE']),
			'MySQL'                       => array('value' =>  $wpdb->db_version()),
			'PHP Allow URL Fopen'         => array('value' => ini_get('allow_url_fopen') ? 'Yes' : 'No'),
			'PHP Memory Limit'            => array('value' => ini_get('memory_limit')),
			'PHP Max Post Size'           => array('value' => ini_get('post_max_size')),
			'PHP Max Upload Filesize'     => array('value' => ini_get('upload_max_filesize')),
			'PHP Max Script Execute Time' => array('value' => ini_get('max_execution_time')),
			'PHP EXIF Support'            => array('value' => extension_loaded('exif') ? 'Yes' : 'No'),
			'PHP EXIF Version'            => array('value' => phpversion('exif')),
			'PHP XML Support'             => array('value' => extension_loaded('libxml') ? 'Yes' : 'No', 'error' => !extension_loaded('libxml')),
			'PHP CURL Support'            => array('value' => extension_loaded('curl') ? 'Yes' : 'No', 'error' => !extension_loaded('curl')),
		));
		return parent::display('_serverSettings');
	}

	/**
	 * getSettingsTabContent.
	 */
	public function getSettingsTabContent() {
		frameWcu::_()->addScript('admin.settings', $this->getModule()->getModPath(). 'js/admin.settings.js');
		frameWcu::_()->getModule('templates')->loadJqueryUi();

		$options = frameWcu::_()->getModule('options')->getAll();
		$this->assign('options', $options);
		$this->assign('exportAllSubscribersUrl', uriWcu::mod('subscribe', 'getWpCsvList'));
		return parent::getContent('optionsSettingsTabContent');
	}

}
