<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * AJAX handler for admin notification bell
 */
add_action('wp_ajax_wcusage_admin_bell_data', 'wcusage_admin_bell_data_ajax');
function wcusage_admin_bell_data_ajax() {
    check_ajax_referer('wcusage_admin_bell', 'nonce');

    // Check if this is a bell click (update date) or just a fetch
    $update_date = isset($_POST['update_date']) && $_POST['update_date'] == '1';

    // Get pending registrations
    $pending_registrations = wcusage_get_pending_registrations_count();

    // Get pending payouts
    $pending_payouts = wcusage_get_pending_payouts_count();

    // Get pending direct links
    $pending_direct_links = wcusage_get_pending_direct_links_count();

    // Check if affiliates exist
    $affiliates_exist = wcusage_check_affiliates_exist();
    $show_affiliate_notification = !$affiliates_exist;

    $pending_total = intval($pending_registrations) + intval($pending_payouts) + intval($pending_direct_links);
    $bell_total = intval($pending_total) + ($show_affiliate_notification ? 1 : 0);

    // Get referral notifications
    $user_id = get_current_user_id();
    $notifications_enabled = get_user_meta($user_id, 'wcusage_admin_notifications_enabled', true);
    if ($notifications_enabled === '') $notifications_enabled = '1';
    $meta_key = 'wcusage_referral_notify_last_date';
    $now = current_time('mysql');
    $wpdb = $GLOBALS['wpdb'];
    $table = $wpdb->prefix . 'wcusage_activity';
    $max_days = 7;
    $last_date = sanitize_text_field(get_user_meta($user_id, $meta_key, true));
    if (!$last_date) {
        $date_limit = date('Y-m-d H:i:s', strtotime("-$max_days days", strtotime($now)));
    } else {
        $date_limit = $last_date;
    }
    $referrals = $wpdb->get_results($wpdb->prepare(
        "SELECT date FROM $table WHERE event = %s AND date >= %s",
        'referral', $date_limit
    )); // phpcs:ignore PluginCheck.Security.DirectDB.UnescapedDBParameter
    $referral_count = count($referrals);
    $referral_message = '';
    if ($referral_count > 0) {
        $referral_message = sprintf('There have been %d new affiliate referrals since %s.', $referral_count, date_i18n('F j, Y H:iA', strtotime($date_limit)));
        $bell_total += $referral_count; // Add actual number of new referrals to total
    }

    if (!$notifications_enabled) {
        $bell_total = 0;
        // Generate simple dropdown with toggle
        ob_start();
        ?>
        <div id="wcusage-admin-bell-dropdown" style="display: none; position: absolute; margin-top: 10px; left: 50%; top: 32px; background: #fff; border: 1px solid #ddd; border-radius: 8px; width: 300px; transform: translateX(-50%); box-shadow: 0 2px 16px rgba(0,0,0,0.12); z-index: 99999;">
            <div style="padding: 12px 16px; border-bottom: 1px solid #eee; font-weight: 600; color: #333; text-align: center;">Notifications Disabled</div>
            <div style="padding: 12px 16px; text-align: center;">
                <a href="#" id="wcusage-toggle-notifications" style="color: #0073aa; text-decoration: underline; font-size: 11px;">Enable Notifications</a>
            </div>
        </div>
        <?php
        $dropdown_html = ob_get_clean();
    } else {
        // Generate dropdown HTML
        ob_start();
        ?>
        <div id="wcusage-admin-bell-dropdown" style="display: none; position: absolute; margin-top: 10px; left: 50%; top: 32px; background: #fff; border: 1px solid #ddd; border-radius: 8px; width: 300px; transform: translateX(-50%); box-shadow: 0 2px 16px rgba(0,0,0,0.12); z-index: 99999;">
            <?php if ($referral_count > 0): ?>
            <div id="wcusage-admin-bell-referral-section" style="display:block;">
                <div style="padding: 12px 16px; border-bottom: 1px solid #eee; font-weight: 600; color: #333; text-align: center;">Notifications</div>
                <div id="wcusage-admin-bell-referral-message" style="padding:10px 16px; border-bottom: 1px solid #f3f3f3;">
                    <span class="fa-solid fa-cart-plus" style="margin-right: 5px;"></span>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wcusage_referrals')); ?>"
                        style="text-decoration: none; color: #111;">
                        <?php echo esc_html($referral_message); ?>
                    </a>
                </div>
            </div>
            <?php endif; ?>
            <div style="padding: 12px 16px; border-bottom: 1px solid #eee; font-weight: 600; color: #333; text-align: center;">Pending Admin Tasks</div>
            <ul style="list-style: none; margin: 0; padding: 0;" id="wcusage-admin-bell-referral-list">
                <?php if ($show_affiliate_notification): ?>
                <li style="padding: 5px 16px 7px 16px; display: flex; align-items: center; gap: 8px; margin-bottom: 0; border-bottom: 1px solid #f3f3f3;">
                    <span class="fa-solid fa-user-group" style="color: #f39c12;"></span>
                    <span style="font-weight: bold; color: #f39c12;">
                    <?php echo sprintf(esc_html__('You currently have no %s!', 'woo-coupon-usage'), esc_html(wcusage_get_affiliate_text(__( 'affiliates', 'woo-coupon-usage' )))); ?>
                    <br/>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wcusage_add_affiliate')); ?>"
                    style="margin-left: auto; color: #f39c12; text-decoration: underline; font-size: 13px; font-weight: bold;">
                        <?php echo sprintf(esc_html__('Add your first %s', 'woo-coupon-usage'), esc_html(wcusage_get_affiliate_text(__( 'affiliate', 'woo-coupon-usage' )))); ?>
                    </a>
                    </span>
                </li>
                <?php endif; ?>
                <?php if ($pending_registrations > 0): ?>
                <li style="padding: 10px 16px; border-bottom: 1px solid #f3f3f3; display: flex; align-items: center; gap: 8px; margin-bottom: 0;">
                    <span class="fa-solid fa-user-plus" style="color: #0073aa;"></span>
                    <span>Pending Registrations:</span>
                    <span style="margin-left: auto; font-weight: bold; color: #d9534f;"><?php echo intval($pending_registrations); ?></span>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wcusage_registrations')); ?>" style="margin-left: 10px; color: #0073aa; text-decoration: underline; font-size: 13px;">Manage</a>
                </li>
                <?php endif; ?>
                <?php if ($pending_direct_links > 0): ?>
                <li style="padding: 10px 16px; border-bottom: 1px solid #f3f3f3; display: flex; align-items: center; gap: 8px; margin-bottom: 0;">
                    <span class="fa-solid fa-globe" style="color: #6f42c1;"></span>
                    <span><?php echo esc_html__('Pending Domains:', 'woo-coupon-usage'); ?></span>
                    <span style="margin-left: auto; font-weight: bold; color: #d9534f;"><?php echo intval($pending_direct_links); ?></span>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wcusage_domains&status=pending')); ?>" style="margin-left: 10px; color: #6f42c1; text-decoration: underline; font-size: 13px;">Manage</a>
                </li>
                <?php endif; ?>
                <?php if ($pending_payouts > 0): ?>
                <li style="padding: 10px 16px; border-bottom: 1px solid #f3f3f3; display: flex; align-items: center; gap: 8px; margin-bottom: 0;">
                    <span class="fa-solid fa-money-bill" style="color: #28a745;"></span>
                    <span>Pending Payouts:</span>
                    <span style="margin-left: auto; font-weight: bold; color: #d9534f;"><?php echo intval($pending_payouts); ?></span>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wcusage_payouts')); ?>" style="margin-left: 10px; color: #28a745; text-decoration: underline; font-size: 13px;">Manage</a>
                </li>
                <?php endif; ?>
            </ul>
            <?php if ($pending_total == 0 && !$show_affiliate_notification): ?>
            <div style="padding: 12px 16px; color: #888; text-align: center;">No pending tasks 🎉</div>
            <?php endif; ?>
            <div style="padding: 4px 16px 9px 16px; border-top: 1px solid #eee; text-align: center;">
                <a href="#" id="wcusage-toggle-notifications" style="color: #0073aa; text-decoration: underline; font-size: 11px;">Disable Notifications</a>
            </div>
        </div>
        <?php
        $dropdown_html = ob_get_clean();
    }

    // Only update last viewed date if bell is clicked
    if ($update_date) {
        update_user_meta($user_id, $meta_key, $now);
    }

    wp_send_json(array(
        'count' => $bell_total,
        'dropdown_html' => $dropdown_html,
        'enabled' => $notifications_enabled
    ));
}

/**
 * AJAX handler for toggling admin notifications
 */
add_action('wp_ajax_wcusage_toggle_admin_notifications', 'wcusage_toggle_admin_notifications_ajax');
function wcusage_toggle_admin_notifications_ajax() {
    check_ajax_referer('wcusage_admin_bell', 'nonce');

    $user_id = get_current_user_id();
    $current = get_user_meta($user_id, 'wcusage_admin_notifications_enabled', true);
    if ($current === '') $current = '1';
    $new_value = $current == '1' ? '0' : '1';
    update_user_meta($user_id, 'wcusage_admin_notifications_enabled', $new_value);

    wp_send_json(array('enabled' => $new_value));
}

/**
 * Output the admin notification bell
 */
function wcusage_admin_notification_bell() {
    // Enqueue scripts and styles
    wp_enqueue_script('wcusage-admin-notification-bell', WCUSAGE_UNIQUE_PLUGIN_URL . 'js/admin-notification-bell.js', array('jquery'), null, true);
    wp_localize_script('wcusage-admin-notification-bell', 'wcusageAdminBell', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('wcusage_admin_bell'),
    ));

    // Add inline CSS for bell shake animation
    $shake_css = "
    @keyframes wcusage-bell-shake {
        0% { transform: rotate(0deg); }
        25% { transform: rotate(-10deg); }
        50% { transform: rotate(10deg); }
        75% { transform: rotate(-10deg); }
        100% { transform: rotate(0deg); }
    }
    .wcusage-bell-shake {
        animation: wcusage-bell-shake 0.5s ease-in-out;
    }
    ";
    wp_add_inline_style('wcusage-admin-header-menu', $shake_css);

    // Output the bell HTML placeholder
    $user_id = get_current_user_id();
    $notifications_enabled = get_user_meta($user_id, 'wcusage_admin_notifications_enabled', true);
    if ($notifications_enabled === '') $notifications_enabled = '1'; // default true
    ?>
    <div class="wcusage-admin-bell-container" style="position: relative; margin-left: 10px;">
        <a href="#" id="wcusage-admin-bell" style="display: flex; align-items: center; position: relative; text-decoration: none; <?php if (!$notifications_enabled) echo 'opacity: 0.5;'; ?>">
            <span class="fa-solid fa-bell" style="font-size: 22px; color: #333;"></span>
            <span class="wcusage-admin-bell-count" style="position: absolute;
            top: -11px; right: -2px; background: #d9534f; color: #fff;
            font-size: 10px; font-weight: bold; border-radius: 50%;
            padding: 1px 1px; min-width: 22px; text-align: center; box-shadow: 0 2px 8px rgba(217,83,79,0.15); display: none;"></span>
        </a>
        <div id="wcusage-admin-bell-dropdown-placeholder"></div>
    </div>
    <?php
}
add_action('wcusage_hook_admin_notification_bell', 'wcusage_admin_notification_bell');

/**
 * Helper functions
 */
function wcusage_get_pending_registrations_count() {
    global $wpdb;
    return $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}wcusage_register WHERE status = 'pending'");
}

function wcusage_get_pending_payouts_count() {
    global $wpdb;
    return $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}wcusage_payouts WHERE status = 'pending'");
}

function wcusage_get_pending_direct_links_count() {
    global $wpdb;
    $pending_direct_links = 0;
    $direct_links_enabled = wcusage_get_setting_value('wcusage_field_enable_directlinks', 0);
    if ($direct_links_enabled && wcu_fs()->can_use_premium_code()) {
        $direct_links_table = $wpdb->prefix . 'wcusage_directlinks';
        $pending_direct_links = intval($wpdb->get_var("SELECT COUNT(*) FROM {$direct_links_table} WHERE status = 'pending'"));
    }
    return $pending_direct_links;
}

function wcusage_check_affiliates_exist() {
    $affiliate_coupon_exists = get_posts(array(
        'post_type' => 'shop_coupon',
        'post_status' => array('publish', 'pending', 'draft'),
        'fields' => 'ids',
        'posts_per_page' => 1,
        'no_found_rows' => true,
        'suppress_filters' => true,
        'meta_query' => array(
            array(
                'key' => 'wcu_select_coupon_user',
                'value' => 0,
                'compare' => '>',
                'type' => 'NUMERIC',
            ),
        ),
    ));
    return !empty($affiliate_coupon_exists);
}