<?php
/**
 * Log writing section of the plugin
 *
 * @link       
 *
 * @package  Webtoffee_Product_Feed_Sync_Basic_Log 
 */
if (!defined('ABSPATH')) {
    exit;
}
if(!class_exists('Webtoffee_Product_Feed_Sync_Basic_Log')){
class Webtoffee_Product_Feed_Sync_Basic_Log
{
	public static $log_dir=WP_CONTENT_DIR.'/webtoffee_iew_log';
	public static $history_id='';
	public function __construct()
	{
		
	}
	
	/**
	* 	Get given temp file path.
	*	If file name is empty then file path will return
	*/
	public static function get_file_path($file_name="")
	{
		global $wp_filesystem;
		if (empty($wp_filesystem)) {
			require_once ABSPATH . '/wp-admin/includes/file.php';
			WP_Filesystem();
		}
		
		if(!$wp_filesystem->is_dir(self::$log_dir))
        {
            if(!$wp_filesystem->mkdir(self::$log_dir, 0700))
            {
            	return false;
            }else
            {
            	$files_to_create=array('.htaccess' => 'deny from all', 'index.php'=>'<?php // Silence is golden');
		        foreach($files_to_create as $file=>$file_content)
		        {
		        	if(!$wp_filesystem->exists(self::$log_dir.'/'.$file))
			        {
			            $wp_filesystem->put_contents(self::$log_dir.'/'.$file, $file_content);
			        }
		        } 
            }
        }
        return self::$log_dir.'/'.$file_name;
	}

	/**
	*	Checks a log file created for the history entry for current day
	*	@param 	 int   $history_id    id of history entry
	*	@return  string/bool if file found returns file name otherwise false
	*/
	public static function check_log_exists_for_entry($history_id)
	{
		$log_dir=self::get_file_path();
		$exp='~^'.$history_id.'.*\.log$~';
		$files = preg_grep($exp, scandir($log_dir));
		
		if(count($files)>0) /* file exists */
		{
			foreach($files as $key => $value)
			{
				$file_name=pathinfo($value, PATHINFO_FILENAME);
				$file_name_arr=explode('_', $file_name);
				$file_date_time=end($file_name_arr);
				$file_date_time_arr=explode(' ', $file_date_time);
				$file_time=strtotime($file_date_time_arr[0]);
				if($file_time) //file time exists
				{
					$today=strtotime(gmdate('Y-m-d'));
					$file_time=strtotime(gmdate('Y-m-d', $file_time));
					if($today==$file_time) //file exists with the current day
					{
						return $value;
					}
				}
			}
		}
		return false;
	}

	/**
	*	Generate log file name
	*
	*/
	public static function generate_file_name($post_type='', $action_type='', $history_id='')
	{
		$arr=array($history_id, $post_type);
		if(defined( 'WT_PRODUCT_FEED_CRON' )) /* this is a cron run so add a schedule prefix */
		{
			$arr[]='schedule';
		}
		$arr[]=$action_type;
		$arr[]=gmdate('Y-m-d h i s A'); /* if changing this format please consider `check_log_exists_for_entry` method */

		$arr=array_filter($arr);
		return implode("_", $arr).'.log';
	}
}
}