# WProofreader plugin for WordPress

Check spelling and grammar on your site automatically with multilingual [WProofreader plugin for WordPress](https://wordpress.org/plugins/webspellchecker/).  

![User Interface of WProofreader Plugin for WordPress](https://ps.w.org/webspellchecker/assets/screenshot-2.png?rev=3041860)

## Description

WProofreader plugin for WordPress scans and checks your website content for spelling,  grammar, punctuation and style issues. No banner ads on your website!

Compatible with the following WordPress versions:
* WordPress 4.x
* WordPress 5.x
* WordPress 6.x

Free WProofreader plugin supports only spell-check for 6 languages and comes with a usage limit of 10,000 words processed per day for a single website. Upon reaching the limit, the plugin stops working until the next day. Check more differences between WProofreader plugin free and pro versions below. 

[![Watch the video](https://img.youtube.com/vi/mhrZN87jydA/sddefault.jpg)](https://www.youtube.com/watch?v=mhrZN87jydA)

**WProofreader Free and Pro versions**

**Free version: ($0)**

* **Usage limit:** Up to 10,000 words processed per day for a single website. Once the daily limit is reached, the plugin will stop working.
* **Allowed number of websites:** 1 website.
* **Languages available for spell checking:** (6 languages) American English, British English, French, German, Italian and Spanish.
* **Languages available for grammar checking:** Not available.
* **User-level custom dictionary:** No cloud backup. The dictionary is only available in one browser on a single device.
* **Organization-level custom dictionary:** Not available.

**Pro version: ($49)**

* **Usage limit:** Up to 100 million words processed per year. No daily limits applied
* **Allowed number of websites:** unlimited
* **Languages available for spell checking:** 20+ popular languages. 
* **Languages available for grammar checking:** Not all listed languages support grammar checks. [Here](https://webspellchecker.com/supported-languages/) is the updated list of supported languages and the ones marked for grammar check.
* **User-level custom dictionary:** Stored in the cloud, available from any browser or device. The user can freely access, review and modify the list of words in the dictionary.
* **Organization-level custom dictionary:** The subscription owner can create global dictionaries that will be available across all the connected websites.

### User functionality

**Proofreading modes**

* The check-as-you-type mode instantaneously detects writing mistakes and provides suggestions on-hover.
* The proofread-in-dialog mode aggregates all the issues detected and suggestions provided.

**Customizable dictionaries**

The Pro version is shipped with:
* **User-level custom dictionary** allows end users to create personal dictionaries with specific words and terms (complex words, acronyms, proper names, etc.) and use them while working with WordPress. Once a word is added to a personal dictionary, it will not be considered as a misspelling, and will appear in the suggestions list. All customly added words are stored either in the browser local storage or on our cloud and are accessible from the browser. 
* **Organization-level custom dictionary** allows creating company-wide dictionaries that extend the vocabulary of the standard dictionary with custom words specific to your company culture, industry, domain, etc. All the words added to an organization-level custom dictionary by the admin will be available to all users within your company. This type of dictionary is available only under the Pro version.
* **Specialized medical spelling dictionaries** for English, German, French and Spanish  and legal dictionaries for English. Available for both — free and Pro versions of the plugin.

**Feature-rich**

* Multi-language support
* Spelling autocorrect functionality for instant correction of common typos
* Autocomplete suggestions functionality for faster writing
* Style guide functionality with pre-defined non-inclusive and profanity language check for professional writing
* User-level and organization-level dictionaries

**User-friendly and up-to-date**

* Straightforward plugin configuration ([check the video tutorial](https://www.youtube.com/watch?v=mhrZN87jydA))
* Visible and intuitive text check with different colors used for spelling, grammar, and style guide issues
* Easily toggle on/off the plugin button
* Support the latest version of WordPress
* Seamlessly integrates with the WordPress latest editor — Gutenberg and compatible with the classic editor of WordPress 4.x.
* Support of the browsers: Chrome, Firefox, Safari, Microsoft Edge, Internet Explorer 11
* _Content elements supported: pages, posts, tag descriptions, category descriptions, WooCommerce, WP eCommerce product descriptions, any custom post types, meta description fields of Yoast SEO plugin._

### Benefits of  WProofreader plugin for WordPress:

* It saves time proofreading in any of the two modes – check-as-you type and proofread-in-dialog.
* You can create and maintain quality posts in different languages without being worriesy about possible mistakes.
* Advanced functionality for spelling autocorrect, autocomplete suggestions and style guide for faster and more productive writing.

## Installation

**From your WordPress dashboard:**

1. Visit 'Plugins > Add New'.
2. Search for 'WProofreader'.
3. Activate WProofreader from your Plugins page.

**From WordPress.org:**

1. [Download WProofreader plugin](https://downloads.wordpress.org/plugin/webspellchecker.zip).
2. Upload the 'wproofreader' directory to your '/wp-content/plugins/' directory, using your favorite method (ftp, sftp, scp, etc...)
3. Activate WProofreader from your Plugins page.

## Updating

Automatic updates should run smoothly, but it's always a good idea to back up your site, just in case.

## Frequently asked questions

**What is License Key or how to obtain one?**

> A **license key** is a special data string that verifies authorized access to the Pro version of WProofreader plugin. The license key is provided by the WebSpellChecker when the Pro version is purchased.

**Can WProofreader plugin check the entire website?**

> The plugin does not check the whole website at a time. It is enabled only when the content on your website is in editing mode. Here is the list of content types which can be checked by the plugin: content of pages, content of posts, tag descriptions, category descriptions, WooCommerce and WP eCommerce product descriptions, any Custom Post Type, Meta description fields of Yoast SEO plugin.
	
**What other languages are available for WProofreader plugin?** 

> The free version of WProofreader plugin supports 6 languages, including:
> * American English
> * British English
> * French
> * German
> * Italian
> * Spanish

> The Pro version of WProofreader plugin supports 20+ popular languages.

> ****Note that not all languages support grammar checks.*** [Here](https://webspellchecker.com/supported-languages/) is the list of available languages. Languages with grammar enabled are marked.

**What is a user-level custom dictionary and how can I create one?**

> WProofreader plugin has a special functionality called a custom dictionary. It allows creating personal dictionaries with specific words and terms (complex words, acronyms, proper names, etc.) and using them across your website. Words added to a personal dictionary will not be marked as misspellings. 

> To create a new **user-level custom dictionary**, click the badge in the bottom right corner of the text field and select Settings. Then go to Dictionaries. Name your new dictionary and click Create. All new words will be added to a brand-new dictionary. If you have several personal dictionaries, for example, with different term types – new words will be added to the one, which is currently in use.

> To create an **organization-level custom dictionary** to be used across all the websites under your subscription, please follow the instructions in this [link](https://docs.webspellchecker.com/display/WebSpellCheckerCloud/Configuring+Cloud+Custom+Dictionary).

**Does WProofreader plugin check grammar as well?**

> Not all languages in the list support grammar checks. [Here](https://webspellchecker.com/supported-languages/) is the updated list of supported languages and the ones that can be used for grammar-check.

**Is technical support available for WProofreader plugin?**

> Support service is provided by WebSpellChecker LLC for Pro version users. For more details, please [contact us](https://webspellchecker.com/contact-us/).

**How to add a specialized medical or legal dictionary to the Pro version?**

> With the Pro version, the default list is already extended with specialized English [medical](https://webspellchecker.com/supported-languages/#medical-dictionary) and [legal](https://webspellchecker.com/supported-languages/#legal-dictionary) dictionaries.

> **Medical dictionary**
The medical dictionary includes over 192K terms related to anatomy, diseases, health care, generic and trademark drug names. Available for English, German, French and Spanish.

> **Legal dictionary**
The legal dictionary contains about 5K terms related to jurisprudence, law, criminology, and law enforcement. Available for English.

**What is an organization-level custom dictionary and how can I use it?**

> The organization-level custom dictionary functionality is available in the Pro version only and is aimed at extending a list of words in the default dictionaries with your custom words and terms. It helps to improve the quality of spelling check services. Using an account on the WebSpellChecker website, you may create a custom wordlist which includes specific terms, abbreviations, etc. These words won’t be flagged as misspellings.

**What are the Terms of Service?**

> Please see the complete [WebSpellChecker Terms of Service](https://webspellchecker.com/legal/terms-of-service/) for WProofreader plugin.

**Is my text secure? What is your Privacy Policy?**

> We have an extensive Privacy Policy in place to protect your texts. Please see the details [here](https://webspellchecker.com/legal/privacy-policy/).

**What browsers are supported?**

> The plugin supports the latest versions of Chrome, Firefox, Safari, and MS Edge, and Internet Explorer 11.

**Can I suggest a feature?**

> Sure, please let us know how we can make the plugin more useful for you. Create a new topic under the support section of this plugin.
