<?php
/**
 * Этот файл инициализирует этот плагин, как аддон для плагина Clearfy.
 *
 * Файл будет подключен только в плагине Clearfy, используя особый вариант загрузки. Это более простое решение
 * пришло на смену встроенной системы подключения аддонов в фреймворке.
 *
 * @author        Alex Kovalev <alex.kovalevv@gmail.com>, git: https://github.com/alexkovalevv
 * @copyright (c) 2018 Webraftic Ltd
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'WUPM_PLUGIN_ACTIVE' ) ) {
	define( 'WUPM_PLUGIN_VERSION', '1.2.0' );
	define( 'WUPM_TEXT_DOMAIN', 'webcraftic-updates-manager' );
	define( 'WUPM_PLUGIN_ACTIVE', true );

	// Этот плагин загружен, как аддон для плагина Clearfy
	define( 'LOADING_UPDATES_MANAGER_AS_ADDON', true );

	if ( ! defined( 'WUPM_PLUGIN_DIR' ) ) {
		define( 'WUPM_PLUGIN_DIR', dirname( __FILE__ ) );
	}

	if ( ! defined( 'WUPM_PLUGIN_BASE' ) ) {
		define( 'WUPM_PLUGIN_BASE', plugin_basename( __FILE__ ) );
	}

	if ( ! defined( 'WUPM_PLUGIN_URL' ) ) {
		define( 'WUPM_PLUGIN_URL', plugins_url( '', __FILE__ ) );
	}

	try {
		// Global scripts
		require_once( WUPM_PLUGIN_DIR . '/includes/3rd-party/class-clearfy-plugin.php' );
		new WUPM_Plugin();
	} catch( Exception $e ) {
		$wupm_plugin_error_func = function () use ( $e ) {
			$error = sprintf( "The %s plugin has stopped. <b>Error:</b> %s Code: %s", 'Webcraftic Updates Manager', $e->getMessage(), $e->getCode() );
			echo '<div class="notice notice-error"><p>' . $error . '</p></div>';
		};

		add_action( 'admin_notices', $wupm_plugin_error_func );
		add_action( 'network_admin_notices', $wupm_plugin_error_func );
	}
}


