<?php

namespace CTXFeed\V5\Merchant;

class MerchantAttributesFactory {

	public static function get( $template = null ) {
		$data = self::data();

		if ( $template === null ) {
			return $data;
		}

		// Override Merchant Template.

		if ( in_array( $template, array( 'pinterest', 'adroll', 'smartly.io' ) ) ) {
			$template = 'google';
		} elseif ( in_array( $template, array( 'connexity', 'shopzilla' ) ) ) {
			$template = 'become';
		} elseif ( $template === 'fruugo.au' ) {
			$template = 'fruugo';
		} elseif ( $template === 'shopalike.fr' ) {
			$template = 'kijiji.ca';
		}

		if ( isset( $data[ $template ] ) ) {
			return $data[ $template ];
		}

		return false;
	}

	private static function data() {
		return array(
			'google'                => array(
				1  => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'               => 'Product Id[id]',
						'webitemid'        => 'Product WebItemId[webitemid]',
						'region_id'        => 'Region Id[region_id]',
						'title'            => 'Product Title[title]',
						'description'      => 'Product Description[description]',
						'link'             => 'Product URL[link]',
						'canonical_link'   => 'Canonical Link[canonical_link]',
						'mobile_link'      => 'Product URL[mobile_link]',
						'product_type'     => 'Product Categories[product_type] ',
						'current_category' => 'Google Product Category[google_product_category]',
						'image'            => 'Main Image[image_link]',
						'images'           => 'Additional Images [additional_image_link]',
						'images_1'         => 'Additional Image 1 [additional_image_link]',
						'images_2'         => 'Additional Image 2 [additional_image_link]',
						'images_3'         => 'Additional Image 3 [additional_image_link]',
						'images_4'         => 'Additional Image 4 [additional_image_link]',
						'images_5'         => 'Additional Image 5 [additional_image_link]',
						'images_6'         => 'Additional Image 6 [additional_image_link]',
						'images_7'         => 'Additional Image 7 [additional_image_link]',
						'images_8'         => 'Additional Image 8 [additional_image_link]',
						'images_9'         => 'Additional Image 9 [additional_image_link]',
						'images_10'        => 'Additional Image 10 [additional_image_link]',
						'lifestyle_image'  => 'Lifestyle Image Link[lifestyle_image_link]',
						'condition'        => 'Condition[condition]',
					),
				),
				2  => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'inventory'                 => 'Facebook Inventory[inventory]',
						'override'                  => 'Facebook Override[override]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'cost_of_goods_sold'        => 'Cost of Goods Sold[cost_of_goods_sold]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
						'auto_pricing_min_price'    => 'Auto pricing minimum price[auto_pricing_min_price]',
					),
				),
				3  => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'upc'               => 'GTIN[gtin]',
						'sku'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4  => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id'        => 'Item Group Id[item_group_id]',
						'external_seller_id'   => 'External seller ID[external_seller_id]',
						'color'                => 'Color[color]',
						'gender'               => 'Gender[gender]',
						'age_group'            => 'Age Group[age_group]',
						'material'             => 'Material[material]',
						'pattern'              => 'Pattern[pattern]',
						'size'                 => 'Size of the item[size]',
						'size_type'            => 'Size Type[size_type]',
						'size_system'          => 'Size System[size_system]',
						'product_length'       => 'Product Length[product_length]',
						'product_width'        => 'Product Width[product_width]',
						'product_height'       => 'Product Height[product_height]',
						'product_weight'       => 'Product Weight[product_weight]',
						'product_highlight_1'  => 'Product Highlight 1[product_highlight]',
						'product_highlight_2'  => 'Product Highlight 2[product_highlight]',
						'product_highlight_3'  => 'Product Highlight 3[product_highlight]',
						'product_highlight_4'  => 'Product Highlight 4[product_highlight]',
						'product_highlight_5'  => 'Product Highlight 5[product_highlight]',
						'product_highlight_6'  => 'Product Highlight 6[product_highlight]',
						'product_highlight_7'  => 'Product Highlight 7[product_highlight]',
						'product_highlight_8'  => 'Product Highlight 8[product_highlight]',
						'product_highlight_9'  => 'Product Highlight 9[product_highlight]',
						'product_highlight_10' => 'Product Highlight 10[product_highlight]',
						'section_name'         => 'Section Name (Product Detail)[section_name]',
						'attribute_name'       => 'Attribute Name  (Product Detail)[attribute_name]',
						'attribute_value'      => 'Attribute Value  (Product Detail)[attribute_value]',
						'capacity'      	   => 'Capacity[capacity]',
						'checkout_link_template' => 'Checkout Link Template[checkout_link_template]',
					),
				),
				5  => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'                 => 'Tax[tax]',
						'tax_category'        => 'Tax[tax_category]',
						'shipping'            => 'Shipping',
						'location_id'         => 'location_id',
						'location_group_name' => 'location_group_name',
						'min_handling_time'   => 'Min Handling Time[min_handling_time]',
						'max_handling_time'   => 'Max Handling Time[max_handling_time]',
						'min_transit_time'    => 'Min Transit Time[min_transit_time]',
						'max_transit_time'    => 'Max Transit Time[max_transit_time]',
						'weight'              => 'Shipping Weight[shipping_weight]',
						'length'              => 'Shipping Length[shipping_length]',
						'width'               => 'Shipping Width[shipping_width]',
						'height'              => 'Shipping Height[shipping_height]',
						'ships_from_country'  => 'Shipping Country[ships_from_country]',
						'shipping_label'      => 'Shipping Label[shipping_label]',
						'material_1'          => 'The primary material',
						'material_2'          => 'The secondary material',
						'material_3'          => 'The tertiary material',
					),
				),
				6  => array(
					'optionGroup' => 'Product Combinations',
					'options'     => array(
						'multipack' => 'Multipack[multipack]',
						'is_bundle' => 'Is Bundle[is_bundle]',
					),
				),
				7  => array(
					'optionGroup' => 'Adult Products',
					'options'     => array(
						'adult' => 'Adult[adult]',
					),
				),
				8  => array(
					'optionGroup' => 'Ads Attributes',
					'options'     => array(
						'ads_redirect' => 'Ads Redirect[ads_redirect]',
						'pause' => 'Pause[pause]',
						'ads_labels' => 'Ads Label[ads_labels]',
						'ads_grouping' => 'Ads Grouping[ads_grouping]',
					),
				),
				9  => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				10 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'excluded_destination'          => 'Excluded Destination[excluded_destination]',
						'shopping_ads_excluded_country' => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
						'included_destination'          => 'Included Destination[included_destination]',
						'expiration_date'               => 'Expiration Date [expiration_date]',
						'transit_time_label'            => 'Transit Time [transit_time_label]',
					),
				),
				11 => array(
					'optionGroup' => 'Unit Prices, Subscription, and Installment',
					'options'     => array(
						'unit_pricing_measure'       => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'  => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment_months'         => 'Installment Months[months]',
						'installment_amount'         => 'Installment Amount[amount]',
						'subscription_period'        => 'Subscription Period[period]',
						'subscription_period_length' => 'Subscription Period Length[period_length]',
						'subscription_amount'        => 'Subscription Amount[amount]',
					),
				),
				12 => array(
					'optionGroup' => 'Energy Labels',
					'options'     => array(
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[energy_efficiency_class]',
						'certification'            	  => 'Certification [certification_code]',
						'certified_pre-owned'         => 'Certified pre-owned [certified_pre-owned]',
					),
				),
				13 => array(
					'optionGroup' => 'Loyalty Points (Japan Only)',
					'options'     => array(
						'loyalty_points' => 'loyalty_points[loyalty_points]',
					),
				),
				14 => array(
					'optionGroup' => 'Multiple Installments (Brazil Only)',
					'options'     => array(
						'installment' => 'Installment[installment]',
					),
				),
				15 => array(
					'optionGroup' => 'Merchant Promotions Attributes',
					'options'     => array(
						'promotion_id'                 => 'Promotion Id[promotion_id]',
						'product_applicability'        => 'Product Applicability[product_applicability]',
						'offer_type'                   => 'Offer Type[offer_type]',
						'long_title'                   => 'Long Title[long_title]',
						'promotion_effective_dates'    => 'Promotion Effective Dates[promotion_effective_dates]',
						'redemption_channel'           => 'Redemption Channel[redemption_channel]',
						'promotion_destination'        => 'Promotion Destination[promotion_destination]',
						'percent_off'                  => 'Percent Off[percent_off]',
						'money_off_amount'             => 'Money Off Amount[money_off_amount]',
						'get_this_quantity_discounted' => 'Get Quantity Discounted[get_this_quantity_discounted]',
						'free_shipping'                => 'Free Shipping[free_shipping]',
						'free_gift_value'              => 'Free Gift Value[free_gift_value]',
						'free_gift_description'        => 'Free Gift Description[free_gift_description]',
						'free_gift_item_id'            => 'Free Gift Item ID[free_gift_item_id]',
						'promotion_display_dates'      => 'Promotion Display Dates[promotion_display_dates]',
						'generic_redemption_code'      => 'Generic Redemption Code[generic_redemption_code]',
						'fine_print'                   => 'Fine Print[fine_print]',
						'promotion_price'              => 'Promotion Price[promotion_price]',
						'coupon_value_type'            => 'Coupon Value Type[coupon_value_type]',
						'limit_quantity'               => 'Limit Quantity[limit_quantity]',
						'limit_value'                  => 'Limit Value[limit_value]',
						'minimum_purchase_amount'      => 'Minimum Purchase Amount[minimum_purchase_amount]',
						'item_id_exclusion'            => 'Item ID Exclusion[item_id_exclusion]',
						'product_type_exclusion'       => 'Product Type Exclusion[product_type_exclusion]',
						'brand_exclusion'              => 'Brand Exclusion[brand_exclusion]',
						'item_group_id_exclusion'      => 'Item Group Exclusion[item_group_id_exclusion]',
					),
				),
				16 => array(
					'optionGroup' => 'Shopping Action Attributes',
					'options'     => array(
						'sell_on_google_quantity' => 'Number of Product Sold On Google [sell_on_google_quantity]',
						'return_address_label'    => 'Return Address [return_address_label]',
						'return_policy_label'     => 'Return Policy [return_policy_label]',
						'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
					),
				),
				17 => array(
					'optionGroup' => 'Local Inventory / Product Inventory',
					'options'     => array(
						'store_code'                  => 'Store Code [store_code]',
						'quantity'                    => 'Quantity [quantity]',
						'pickup_method'               => 'Pickup Method [pickup_method]',
						'pickup_sla'                  => 'Pickup SLA [pickup_sla]',
						'pickup_link_template'        => 'Pickup Link Template [pickup_link_template]',
						'link_template'               => 'Link Template [link_template]',
						'mobile_link_template'        => 'Mobile Link Template [mobile_link_template]',
						'mobile_pickup_link_template' => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
					),
				),
				18 => array(
					'optionGroup' => 'Pinterest Catalog Attributes',
					'options'     => array(
						'free_shipping_label'   => 'Free Shipping Label[free_shipping_label]',
						'free_shipping_limit'   => 'Free Shipping Limit[free_shipping_limit]',
						'average_review_rating' => 'Average Review Rating[average_review_rating]',
						'number_of_ratings'     => 'Number of Ratings[number_of_ratings]',
						'number_of_reviews'     => 'Number of Reviews[number_of_reviews]',
					),
				),
			),
			'facebook'              => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'                  => 'Product Id[id]',
						'title'               => 'Product Title[title]',
						'description'         => 'Product Description[description]',
						'link'                => 'Product URL[link]',
						'mobile_link'         => 'Product URL[mobile_link]',
						'product_type'        => 'Product Categories[product_type] ',
						'fb_product_category' => 'Facebook Product Category[fb_product_category]',
						'current_category'    => 'Google Product Category[google_product_category]',
						'image'               => 'Main Image[image_link]',
						'images'              => 'Additional Images [additional_image_link]',
						'images_1'            => 'Additional Image 1 [additional_image_link]',
						'images_2'            => 'Additional Image 2 [additional_image_link]',
						'images_3'            => 'Additional Image 3 [additional_image_link]',
						'images_4'            => 'Additional Image 4 [additional_image_link]',
						'images_5'            => 'Additional Image 5 [additional_image_link]',
						'images_6'            => 'Additional Image 6 [additional_image_link]',
						'images_7'            => 'Additional Image 7 [additional_image_link]',
						'images_8'            => 'Additional Image 8 [additional_image_link]',
						'images_9'            => 'Additional Image 9 [additional_image_link]',
						'images_10'           => 'Additional Image 10 [additional_image_link]',
						'condition'           => 'Condition[condition]',
					),
				),
				2 => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
				3 => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'gtin'              => 'GTIN[gtin]',
						'mpn'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4 => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id' => 'Item Group Id[item_group_id]',
						'color'         => 'Color[color]',
						'gender'        => 'Gender[gender]',
						'age_group'     => 'Age Group[age_group]',
						'material'      => 'Material[material]',
						'pattern'       => 'Pattern[pattern]',
						'size'          => 'Size of the item[size]',
					),
				),
				5 => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'             => 'Tax[tax]',
						'tax_country'     => 'Tax Country[tax_country]',
						'tax_region'      => 'Tax Region[tax_region]',
						'tax_rate'        => 'Tax Rate[tax_rate]',
						'tax_ship'        => 'Tax Ship[tax_ship]',
						'tax_category'    => 'Tax[tax_category]',
						'shipping'        => 'Shipping',
						'shipping_weight' => 'Shipping Weight[shipping_weight]',
					),
				),
				6 => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'internal_label' => 'Internal label [internal_label]',
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				7 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'inventory'                    => 'Facebook Inventory[inventory]',
						'override'                     => 'Facebook Override[override]',
						'status'                       => 'Status [status]',
						'video'                        => 'Video [video]',
						'unit_price_value'             => 'Unit Price > Value [unit_price_value]',
						'unit_price_currency'          => 'Unit Price > Currency [unit_price_currency]',
						'unit_price_unit'              => 'Unit Price > Unit [unit_price_unit]',
						'quantity_to_sell_on_facebook' => 'Quantity to Sell on Facebook [quantity_to_sell_on_facebook]',
						'commerce_tax_category'        => 'Commerce Tax Category [commerce_tax_category]',
						'expiration_date'              => 'Expiration Date[expiration_date]',
						'marked_for_product_launch'    => 'Marked for Product Launce [marked_for_product_launch]',
						'rich_text_description'        => 'Rich Text Description [rich_text_description]',
						'visibility'                   => 'Visibility [visibility]',
						'additional_variant_label'     => 'Additional Variant Attribute > Label [Variant Label]',
						'additional_variant_value'     => 'Additional Variant Attribute > Value [Variant Value]',
						'applink'                      => 'Applink [applink]',
						'origin_country'               => 'Origin Country [origin_country]',
						'importer_name'                => 'Importer Name [importer_name]',
						'importer_address'             => 'Importer Address [importer_address]',
						'manufacturer_info'            => 'Manufacturer Info [manufacturer_info]',
						'return_policy_info'           => 'Return Policy Info [return_policy_info]',
					),
				),
			),
			'google_dynamic_ads'    => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'Page URL'     => 'Page URL[Page URL]',
						'Custom Label' => 'Custom Label [Custom Label]',
					),
				),
			),
			'google_local'          => array(
				1  => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'               => 'Product Id[id]',
						'webitemid'        => 'Product WebItemId[webitemid]',
						'region_id'        => 'Region Id[region_id]',
						'title'            => 'Product Title[title]',
						'description'      => 'Product Description[description]',
						'link'             => 'Product URL[link]',
						'canonical_link'   => 'Canonical Link[canonical_link]',
						'mobile_link'      => 'Product URL[mobile_link]',
						'product_type'     => 'Product Categories[product_type] ',
						'current_category' => 'Google Product Category[google_product_category]',
						'image'            => 'Main Image[image_link]',
						'images'           => 'Additional Images [additional_image_link]',
						'images_1'         => 'Additional Image 1 [additional_image_link]',
						'images_2'         => 'Additional Image 2 [additional_image_link]',
						'images_3'         => 'Additional Image 3 [additional_image_link]',
						'images_4'         => 'Additional Image 4 [additional_image_link]',
						'images_5'         => 'Additional Image 5 [additional_image_link]',
						'images_6'         => 'Additional Image 6 [additional_image_link]',
						'images_7'         => 'Additional Image 7 [additional_image_link]',
						'images_8'         => 'Additional Image 8 [additional_image_link]',
						'images_9'         => 'Additional Image 9 [additional_image_link]',
						'images_10'        => 'Additional Image 10 [additional_image_link]',
						'condition'        => 'Condition[condition]',
					),
				),
				2  => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'inventory'                 => 'Facebook Inventory[inventory]',
						'override'                  => 'Facebook Override[override]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'cost_of_goods_sold'        => 'Cost of Goods Sold[cost_of_goods_sold]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
				3  => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'upc'               => 'GTIN[gtin]',
						'sku'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4  => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id'        => 'Item Group Id[item_group_id]',
						'external_seller_id'   => 'External seller ID[external_seller_id]',
						'color'                => 'Color[color]',
						'gender'               => 'Gender[gender]',
						'age_group'            => 'Age Group[age_group]',
						'material'             => 'Material[material]',
						'pattern'              => 'Pattern[pattern]',
						'size'                 => 'Size of the item[size]',
						'size_type'            => 'Size Type[size_type]',
						'size_system'          => 'Size System[size_system]',
						'product_length'       => 'Product Length[product_length]',
						'product_width'        => 'Product Width[product_width]',
						'product_height'       => 'Product Height[product_height]',
						'product_weight'       => 'Product Weight[product_weight]',
						'product_highlight_1'  => 'Product Highlight 1[product_highlight]',
						'product_highlight_2'  => 'Product Highlight 2[product_highlight]',
						'product_highlight_3'  => 'Product Highlight 3[product_highlight]',
						'product_highlight_4'  => 'Product Highlight 4[product_highlight]',
						'product_highlight_5'  => 'Product Highlight 5[product_highlight]',
						'product_highlight_6'  => 'Product Highlight 6[product_highlight]',
						'product_highlight_7'  => 'Product Highlight 7[product_highlight]',
						'product_highlight_8'  => 'Product Highlight 8[product_highlight]',
						'product_highlight_9'  => 'Product Highlight 9[product_highlight]',
						'product_highlight_10' => 'Product Highlight 10[product_highlight]',
						'section_name'         => 'Section Name (Product Detail)[section_name]',
						'attribute_name'       => 'Attribute Name  (Product Detail)[attribute_name]',
						'attribute_value'      => 'Attribute Value  (Product Detail)[attribute_value]',
					),
				),
				5  => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'                 => 'Tax[tax]',
						'tax_category'        => 'Tax[tax_category]',
						'shipping'            => 'Shipping',
						'location_id'         => 'location_id',
						'location_group_name' => 'location_group_name',
						'min_handling_time'   => 'Min Handling Time[min_handling_time]',
						'max_handling_time'   => 'Max Handling Time[max_handling_time]',
						'min_transit_time'    => 'Min Transit Time[min_transit_time]',
						'max_transit_time'    => 'Max Transit Time[max_transit_time]',
						'weight'              => 'Shipping Weight[shipping_weight]',
						'length'              => 'Shipping Length[shipping_length]',
						'width'               => 'Shipping Width[shipping_width]',
						'height'              => 'Shipping Height[shipping_height]',
						'ships_from_country'  => 'Shipping Country[ships_from_country]',
						'shipping_label'      => 'Shipping Label[shipping_label]',
						'material_1'          => 'The primary material',
						'material_2'          => 'The secondary material',
						'material_3'          => 'The tertiary material',
					),
				),
				6  => array(
					'optionGroup' => 'Product Combinations',
					'options'     => array(
						'multipack' => 'Multipack[multipack]',
						'is_bundle' => 'Is Bundle[is_bundle]',
					),
				),
				7  => array(
					'optionGroup' => 'Adult Products',
					'options'     => array(
						'adult' => 'Adult[adult]',
					),
				),
				8  => array(
					'optionGroup' => 'Ads Attributes',
					'options'     => array(
						'ads_redirect' => 'Ads Redirect[ads_redirect]',
					),
				),
				9  => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				10 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'excluded_destination'          => 'Excluded Destination[excluded_destination]',
						'shopping_ads_excluded_country' => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
						'included_destination'          => 'Included Destination[included_destination]',
						'expiration_date'               => 'Expiration Date [expiration_date]',
						'transit_time_label'            => 'Transit Time [transit_time_label]',
					),
				),
				11 => array(
					'optionGroup' => 'Unit Prices, Subscription, and Installment',
					'options'     => array(
						'unit_pricing_measure'       => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'  => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment_months'         => 'Installment Months[months]',
						'installment_amount'         => 'Installment Amount[amount]',
						'subscription_period'        => 'Subscription Period[period]',
						'subscription_period_length' => 'Subscription Period Length[period_length]',
						'subscription_amount'        => 'Subscription Amount[amount]',
					),
				),
				12 => array(
					'optionGroup' => 'Energy Labels',
					'options'     => array(
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[energy_efficiency_class]',
					),
				),
				13 => array(
					'optionGroup' => 'Loyalty Points (Japan Only)',
					'options'     => array(
						'loyalty_points' => 'loyalty_points[loyalty_points]',
					),
				),
				14 => array(
					'optionGroup' => 'Multiple Installments (Brazil Only)',
					'options'     => array(
						'installment' => 'Installment[installment]',
					),
				),
				15 => array(
					'optionGroup' => 'Merchant Promotions Attributes',
					'options'     => array(
						'promotion_id'                 => 'Promotion Id[promotion_id]',
						'product_applicability'        => 'Product Applicability[product_applicability]',
						'offer_type'                   => 'Offer Type[offer_type]',
						'long_title'                   => 'Long Title[long_title]',
						'promotion_effective_dates'    => 'Promotion Effective Dates[promotion_effective_dates]',
						'redemption_channel'           => 'Redemption Channel[redemption_channel]',
						'promotion_destination'        => 'Promotion Destination[promotion_destination]',
						'percent_off'                  => 'Percent Off[percent_off]',
						'money_off_amount'             => 'Money Off Amount[money_off_amount]',
						'get_this_quantity_discounted' => 'Get Quantity Discounted[get_this_quantity_discounted]',
						'free_shipping'                => 'Free Shipping[free_shipping]',
						'free_gift_value'              => 'Free Gift Value[free_gift_value]',
						'free_gift_description'        => 'Free Gift Description[free_gift_description]',
						'free_gift_item_id'            => 'Free Gift Item ID[free_gift_item_id]',
						'promotion_display_dates'      => 'Promotion Display Dates[promotion_display_dates]',
						'generic_redemption_code'      => 'Generic Redemption Code[generic_redemption_code]',
						'fine_print'                   => 'Fine Print[fine_print]',
						'promotion_price'              => 'Promotion Price[promotion_price]',
						'coupon_value_type'            => 'Coupon Value Type[coupon_value_type]',
						'limit_quantity'               => 'Limit Quantity[limit_quantity]',
						'limit_value'                  => 'Limit Value[limit_value]',
						'minimum_purchase_amount'      => 'Minimum Purchase Amount[minimum_purchase_amount]',
						'item_id_exclusion'            => 'Item ID Exclusion[item_id_exclusion]',
						'product_type_exclusion'       => 'Product Type Exclusion[product_type_exclusion]',
						'brand_exclusion'              => 'Brand Exclusion[brand_exclusion]',
						'item_group_id_exclusion'      => 'Item Group Exclusion[item_group_id_exclusion]',
					),
				),
				16 => array(
					'optionGroup' => 'Shopping Action Attributes',
					'options'     => array(
						'sell_on_google_quantity' => 'Number of Product Sold On Google [sell_on_google_quantity]',
						'return_address_label'    => 'Return Address [return_address_label]',
						'return_policy_label'     => 'Return Policy [return_policy_label]',
						'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
					),
				),
				17 => array(
					'optionGroup' => 'Local Inventory / Product Inventory',
					'options'     => array(
						'store_code'                  => 'Store Code [store_code]',
						'quantity'                    => 'Quantity [quantity]',
						'pickup_method'               => 'Pickup Method [pickup_method]',
						'pickup_sla'                  => 'Pickup SLA [pickup_sla]',
						'pickup_link_template'        => 'Pickup Link Template [pickup_link_template]',
						'link_template'               => 'Link Template [link_template]',
						'mobile_link_template'        => 'Mobile Link Template [mobile_link_template]',
						'mobile_pickup_link_template' => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
					),
				),
				18 => array(
					'optionGroup' => 'Pinterest Catalog Attributes',
					'options'     => array(
						'free_shipping_label'   => 'Free Shipping Label[free_shipping_label]',
						'free_shipping_limit'   => 'Free Shipping Limit[free_shipping_limit]',
						'average_review_rating' => 'Average Review Rating[average_review_rating]',
						'number_of_ratings'     => 'Number of Ratings[number_of_ratings]',
						'number_of_reviews'     => 'Number of Reviews[number_of_reviews]',
					),
				),
			),
			'google_local_inventory'=> array(
				1  => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'               => 'Product Id[id]',
						'webitemid'        => 'Product WebItemId[webitemid]',
						'region_id'        => 'Region Id[region_id]',
						'title'            => 'Product Title[title]',
						'description'      => 'Product Description[description]',
						'link'             => 'Product URL[link]',
						'canonical_link'   => 'Canonical Link[canonical_link]',
						'mobile_link'      => 'Product URL[mobile_link]',
						'product_type'     => 'Product Categories[product_type] ',
						'current_category' => 'Google Product Category[google_product_category]',
						'image'            => 'Main Image[image_link]',
						'images'           => 'Additional Images [additional_image_link]',
						'images_1'         => 'Additional Image 1 [additional_image_link]',
						'images_2'         => 'Additional Image 2 [additional_image_link]',
						'images_3'         => 'Additional Image 3 [additional_image_link]',
						'images_4'         => 'Additional Image 4 [additional_image_link]',
						'images_5'         => 'Additional Image 5 [additional_image_link]',
						'images_6'         => 'Additional Image 6 [additional_image_link]',
						'images_7'         => 'Additional Image 7 [additional_image_link]',
						'images_8'         => 'Additional Image 8 [additional_image_link]',
						'images_9'         => 'Additional Image 9 [additional_image_link]',
						'images_10'        => 'Additional Image 10 [additional_image_link]',
						'condition'        => 'Condition[condition]',
					),
				),
				2  => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'inventory'                 => 'Facebook Inventory[inventory]',
						'override'                  => 'Facebook Override[override]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'cost_of_goods_sold'        => 'Cost of Goods Sold[cost_of_goods_sold]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
				3  => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'upc'               => 'GTIN[gtin]',
						'sku'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4  => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id'        => 'Item Group Id[item_group_id]',
						'external_seller_id'   => 'External seller ID[external_seller_id]',
						'color'                => 'Color[color]',
						'gender'               => 'Gender[gender]',
						'age_group'            => 'Age Group[age_group]',
						'material'             => 'Material[material]',
						'pattern'              => 'Pattern[pattern]',
						'size'                 => 'Size of the item[size]',
						'size_type'            => 'Size Type[size_type]',
						'size_system'          => 'Size System[size_system]',
						'product_length'       => 'Product Length[product_length]',
						'product_width'        => 'Product Width[product_width]',
						'product_height'       => 'Product Height[product_height]',
						'product_weight'       => 'Product Weight[product_weight]',
						'product_highlight_1'  => 'Product Highlight 1[product_highlight]',
						'product_highlight_2'  => 'Product Highlight 2[product_highlight]',
						'product_highlight_3'  => 'Product Highlight 3[product_highlight]',
						'product_highlight_4'  => 'Product Highlight 4[product_highlight]',
						'product_highlight_5'  => 'Product Highlight 5[product_highlight]',
						'product_highlight_6'  => 'Product Highlight 6[product_highlight]',
						'product_highlight_7'  => 'Product Highlight 7[product_highlight]',
						'product_highlight_8'  => 'Product Highlight 8[product_highlight]',
						'product_highlight_9'  => 'Product Highlight 9[product_highlight]',
						'product_highlight_10' => 'Product Highlight 10[product_highlight]',
						'section_name'         => 'Section Name (Product Detail)[section_name]',
						'attribute_name'       => 'Attribute Name  (Product Detail)[attribute_name]',
						'attribute_value'      => 'Attribute Value  (Product Detail)[attribute_value]',
					),
				),
				5  => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'                 => 'Tax[tax]',
						'tax_category'        => 'Tax[tax_category]',
						'shipping'            => 'Shipping',
						'location_id'         => 'location_id',
						'location_group_name' => 'location_group_name',
						'min_handling_time'   => 'Min Handling Time[min_handling_time]',
						'max_handling_time'   => 'Max Handling Time[max_handling_time]',
						'min_transit_time'    => 'Min Transit Time[min_transit_time]',
						'max_transit_time'    => 'Max Transit Time[max_transit_time]',
						'weight'              => 'Shipping Weight[shipping_weight]',
						'length'              => 'Shipping Length[shipping_length]',
						'width'               => 'Shipping Width[shipping_width]',
						'height'              => 'Shipping Height[shipping_height]',
						'ships_from_country'  => 'Shipping Country[ships_from_country]',
						'shipping_label'      => 'Shipping Label[shipping_label]',
						'material_1'          => 'The primary material',
						'material_2'          => 'The secondary material',
						'material_3'          => 'The tertiary material',
					),
				),
				6  => array(
					'optionGroup' => 'Product Combinations',
					'options'     => array(
						'multipack' => 'Multipack[multipack]',
						'is_bundle' => 'Is Bundle[is_bundle]',
					),
				),
				7  => array(
					'optionGroup' => 'Adult Products',
					'options'     => array(
						'adult' => 'Adult[adult]',
					),
				),
				8  => array(
					'optionGroup' => 'Ads Attributes',
					'options'     => array(
						'ads_redirect' => 'Ads Redirect[ads_redirect]',
					),
				),
				9  => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				10 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'excluded_destination'          => 'Excluded Destination[excluded_destination]',
						'shopping_ads_excluded_country' => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
						'included_destination'          => 'Included Destination[included_destination]',
						'expiration_date'               => 'Expiration Date [expiration_date]',
						'transit_time_label'            => 'Transit Time [transit_time_label]',
					),
				),
				11 => array(
					'optionGroup' => 'Unit Prices, Subscription, and Installment',
					'options'     => array(
						'unit_pricing_measure'       => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'  => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment_months'         => 'Installment Months[months]',
						'installment_amount'         => 'Installment Amount[amount]',
						'subscription_period'        => 'Subscription Period[period]',
						'subscription_period_length' => 'Subscription Period Length[period_length]',
						'subscription_amount'        => 'Subscription Amount[amount]',
					),
				),
				12 => array(
					'optionGroup' => 'Energy Labels',
					'options'     => array(
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[energy_efficiency_class]',
					),
				),
				13 => array(
					'optionGroup' => 'Loyalty Points (Japan Only)',
					'options'     => array(
						'loyalty_points' => 'loyalty_points[loyalty_points]',
					),
				),
				14 => array(
					'optionGroup' => 'Multiple Installments (Brazil Only)',
					'options'     => array(
						'installment' => 'Installment[installment]',
					),
				),
				15 => array(
					'optionGroup' => 'Merchant Promotions Attributes',
					'options'     => array(
						'promotion_id'                 => 'Promotion Id[promotion_id]',
						'product_applicability'        => 'Product Applicability[product_applicability]',
						'offer_type'                   => 'Offer Type[offer_type]',
						'long_title'                   => 'Long Title[long_title]',
						'promotion_effective_dates'    => 'Promotion Effective Dates[promotion_effective_dates]',
						'redemption_channel'           => 'Redemption Channel[redemption_channel]',
						'promotion_destination'        => 'Promotion Destination[promotion_destination]',
						'percent_off'                  => 'Percent Off[percent_off]',
						'money_off_amount'             => 'Money Off Amount[money_off_amount]',
						'get_this_quantity_discounted' => 'Get Quantity Discounted[get_this_quantity_discounted]',
						'free_shipping'                => 'Free Shipping[free_shipping]',
						'free_gift_value'              => 'Free Gift Value[free_gift_value]',
						'free_gift_description'        => 'Free Gift Description[free_gift_description]',
						'free_gift_item_id'            => 'Free Gift Item ID[free_gift_item_id]',
						'promotion_display_dates'      => 'Promotion Display Dates[promotion_display_dates]',
						'generic_redemption_code'      => 'Generic Redemption Code[generic_redemption_code]',
						'fine_print'                   => 'Fine Print[fine_print]',
						'promotion_price'              => 'Promotion Price[promotion_price]',
						'coupon_value_type'            => 'Coupon Value Type[coupon_value_type]',
						'limit_quantity'               => 'Limit Quantity[limit_quantity]',
						'limit_value'                  => 'Limit Value[limit_value]',
						'minimum_purchase_amount'      => 'Minimum Purchase Amount[minimum_purchase_amount]',
						'item_id_exclusion'            => 'Item ID Exclusion[item_id_exclusion]',
						'product_type_exclusion'       => 'Product Type Exclusion[product_type_exclusion]',
						'brand_exclusion'              => 'Brand Exclusion[brand_exclusion]',
						'item_group_id_exclusion'      => 'Item Group Exclusion[item_group_id_exclusion]',
					),
				),
				16 => array(
					'optionGroup' => 'Shopping Action Attributes',
					'options'     => array(
						'sell_on_google_quantity' => 'Number of Product Sold On Google [sell_on_google_quantity]',
						'return_address_label'    => 'Return Address [return_address_label]',
						'return_policy_label'     => 'Return Policy [return_policy_label]',
						'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
					),
				),
				17 => array(
					'optionGroup' => 'Local Inventory / Product Inventory',
					'options'     => array(
						'store_code'                  => 'Store Code [store_code]',
						'quantity'                    => 'Quantity [quantity]',
						'pickup_method'               => 'Pickup Method [pickup_method]',
						'pickup_sla'                  => 'Pickup SLA [pickup_sla]',
						'pickup_link_template'        => 'Pickup Link Template [pickup_link_template]',
						'link_template'               => 'Link Template [link_template]',
						'mobile_link_template'        => 'Mobile Link Template [mobile_link_template]',
						'mobile_pickup_link_template' => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
						'local_shipping_label'		  => 'Local shipping label [local_shipping_label]'
					),
				),
				18 => array(
					'optionGroup' => 'Pinterest Catalog Attributes',
					'options'     => array(
						'free_shipping_label'   => 'Free Shipping Label[free_shipping_label]',
						'free_shipping_limit'   => 'Free Shipping Limit[free_shipping_limit]',
						'average_review_rating' => 'Average Review Rating[average_review_rating]',
						'number_of_ratings'     => 'Number of Ratings[number_of_ratings]',
						'number_of_reviews'     => 'Number of Reviews[number_of_reviews]',
					),
				),
			),
			'google_shopping_action'=> array(
				1  => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'               => 'Product Id[id]',
						'webitemid'        => 'Product WebItemId[webitemid]',
						'region_id'        => 'Region Id[region_id]',
						'title'            => 'Product Title[title]',
						'description'      => 'Product Description[description]',
						'link'             => 'Product URL[link]',
						'canonical_link'   => 'Canonical Link[canonical_link]',
						'mobile_link'      => 'Product URL[mobile_link]',
						'product_type'     => 'Product Categories[product_type] ',
						'current_category' => 'Google Product Category[google_product_category]',
						'image'            => 'Main Image[image_link]',
						'images'           => 'Additional Images [additional_image_link]',
						'images_1'         => 'Additional Image 1 [additional_image_link]',
						'images_2'         => 'Additional Image 2 [additional_image_link]',
						'images_3'         => 'Additional Image 3 [additional_image_link]',
						'images_4'         => 'Additional Image 4 [additional_image_link]',
						'images_5'         => 'Additional Image 5 [additional_image_link]',
						'images_6'         => 'Additional Image 6 [additional_image_link]',
						'images_7'         => 'Additional Image 7 [additional_image_link]',
						'images_8'         => 'Additional Image 8 [additional_image_link]',
						'images_9'         => 'Additional Image 9 [additional_image_link]',
						'images_10'        => 'Additional Image 10 [additional_image_link]',
						'condition'        => 'Condition[condition]',
					),
				),
				2  => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'inventory'                 => 'Facebook Inventory[inventory]',
						'override'                  => 'Facebook Override[override]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'cost_of_goods_sold'        => 'Cost of Goods Sold[cost_of_goods_sold]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
				3  => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'upc'               => 'GTIN[gtin]',
						'sku'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4  => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id'        => 'Item Group Id[item_group_id]',
						'external_seller_id'   => 'External seller ID[external_seller_id]',
						'color'                => 'Color[color]',
						'gender'               => 'Gender[gender]',
						'age_group'            => 'Age Group[age_group]',
						'material'             => 'Material[material]',
						'pattern'              => 'Pattern[pattern]',
						'size'                 => 'Size of the item[size]',
						'size_type'            => 'Size Type[size_type]',
						'size_system'          => 'Size System[size_system]',
						'product_length'       => 'Product Length[product_length]',
						'product_width'        => 'Product Width[product_width]',
						'product_height'       => 'Product Height[product_height]',
						'product_weight'       => 'Product Weight[product_weight]',
						'product_highlight_1'  => 'Product Highlight 1[product_highlight]',
						'product_highlight_2'  => 'Product Highlight 2[product_highlight]',
						'product_highlight_3'  => 'Product Highlight 3[product_highlight]',
						'product_highlight_4'  => 'Product Highlight 4[product_highlight]',
						'product_highlight_5'  => 'Product Highlight 5[product_highlight]',
						'product_highlight_6'  => 'Product Highlight 6[product_highlight]',
						'product_highlight_7'  => 'Product Highlight 7[product_highlight]',
						'product_highlight_8'  => 'Product Highlight 8[product_highlight]',
						'product_highlight_9'  => 'Product Highlight 9[product_highlight]',
						'product_highlight_10' => 'Product Highlight 10[product_highlight]',
						'section_name'         => 'Section Name (Product Detail)[section_name]',
						'attribute_name'       => 'Attribute Name  (Product Detail)[attribute_name]',
						'attribute_value'      => 'Attribute Value  (Product Detail)[attribute_value]',
					),
				),
				5  => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'                 => 'Tax[tax]',
						'tax_category'        => 'Tax[tax_category]',
						'shipping'            => 'Shipping',
						'location_id'         => 'location_id',
						'location_group_name' => 'location_group_name',
						'min_handling_time'   => 'Min Handling Time[min_handling_time]',
						'max_handling_time'   => 'Max Handling Time[max_handling_time]',
						'min_transit_time'    => 'Min Transit Time[min_transit_time]',
						'max_transit_time'    => 'Max Transit Time[max_transit_time]',
						'weight'              => 'Shipping Weight[shipping_weight]',
						'length'              => 'Shipping Length[shipping_length]',
						'width'               => 'Shipping Width[shipping_width]',
						'height'              => 'Shipping Height[shipping_height]',
						'ships_from_country'  => 'Shipping Country[ships_from_country]',
						'shipping_label'      => 'Shipping Label[shipping_label]',
						'material_1'          => 'The primary material',
						'material_2'          => 'The secondary material',
						'material_3'          => 'The tertiary material',
					),
				),
				6  => array(
					'optionGroup' => 'Product Combinations',
					'options'     => array(
						'multipack' => 'Multipack[multipack]',
						'is_bundle' => 'Is Bundle[is_bundle]',
					),
				),
				7  => array(
					'optionGroup' => 'Adult Products',
					'options'     => array(
						'adult' => 'Adult[adult]',
					),
				),
				8  => array(
					'optionGroup' => 'Ads Attributes',
					'options'     => array(
						'ads_redirect' => 'Ads Redirect[ads_redirect]',
					),
				),
				9  => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				10 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'excluded_destination'          => 'Excluded Destination[excluded_destination]',
						'shopping_ads_excluded_country' => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
						'included_destination'          => 'Included Destination[included_destination]',
						'expiration_date'               => 'Expiration Date [expiration_date]',
						'transit_time_label'            => 'Transit Time [transit_time_label]',
					),
				),
				11 => array(
					'optionGroup' => 'Unit Prices, Subscription, and Installment',
					'options'     => array(
						'unit_pricing_measure'       => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'  => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment_months'         => 'Installment Months[months]',
						'installment_amount'         => 'Installment Amount[amount]',
						'subscription_period'        => 'Subscription Period[period]',
						'subscription_period_length' => 'Subscription Period Length[period_length]',
						'subscription_amount'        => 'Subscription Amount[amount]',
					),
				),
				12 => array(
					'optionGroup' => 'Energy Labels',
					'options'     => array(
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[energy_efficiency_class]',
					),
				),
				13 => array(
					'optionGroup' => 'Loyalty Points (Japan Only)',
					'options'     => array(
						'loyalty_points' => 'loyalty_points[loyalty_points]',
					),
				),
				14 => array(
					'optionGroup' => 'Multiple Installments (Brazil Only)',
					'options'     => array(
						'installment' => 'Installment[installment]',
					),
				),
				15 => array(
					'optionGroup' => 'Merchant Promotions Attributes',
					'options'     => array(
						'promotion_id'                 => 'Promotion Id[promotion_id]',
						'product_applicability'        => 'Product Applicability[product_applicability]',
						'offer_type'                   => 'Offer Type[offer_type]',
						'long_title'                   => 'Long Title[long_title]',
						'promotion_effective_dates'    => 'Promotion Effective Dates[promotion_effective_dates]',
						'redemption_channel'           => 'Redemption Channel[redemption_channel]',
						'promotion_destination'        => 'Promotion Destination[promotion_destination]',
						'percent_off'                  => 'Percent Off[percent_off]',
						'money_off_amount'             => 'Money Off Amount[money_off_amount]',
						'get_this_quantity_discounted' => 'Get Quantity Discounted[get_this_quantity_discounted]',
						'free_shipping'                => 'Free Shipping[free_shipping]',
						'free_gift_value'              => 'Free Gift Value[free_gift_value]',
						'free_gift_description'        => 'Free Gift Description[free_gift_description]',
						'free_gift_item_id'            => 'Free Gift Item ID[free_gift_item_id]',
						'promotion_display_dates'      => 'Promotion Display Dates[promotion_display_dates]',
						'generic_redemption_code'      => 'Generic Redemption Code[generic_redemption_code]',
						'fine_print'                   => 'Fine Print[fine_print]',
						'promotion_price'              => 'Promotion Price[promotion_price]',
						'coupon_value_type'            => 'Coupon Value Type[coupon_value_type]',
						'limit_quantity'               => 'Limit Quantity[limit_quantity]',
						'limit_value'                  => 'Limit Value[limit_value]',
						'minimum_purchase_amount'      => 'Minimum Purchase Amount[minimum_purchase_amount]',
						'item_id_exclusion'            => 'Item ID Exclusion[item_id_exclusion]',
						'product_type_exclusion'       => 'Product Type Exclusion[product_type_exclusion]',
						'brand_exclusion'              => 'Brand Exclusion[brand_exclusion]',
						'item_group_id_exclusion'      => 'Item Group Exclusion[item_group_id_exclusion]',
					),
				),
				16 => array(
					'optionGroup' => 'Shopping Action Attributes',
					'options'     => array(
						'sell_on_google_quantity' => 'Number of Product Sold On Google [sell_on_google_quantity]',
						'return_address_label'    => 'Return Address [return_address_label]',
						'return_policy_label'     => 'Return Policy [return_policy_label]',
						'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
					),
				),
				17 => array(
					'optionGroup' => 'Local Inventory / Product Inventory',
					'options'     => array(
						'store_code'                  => 'Store Code [store_code]',
						'quantity'                    => 'Quantity [quantity]',
						'pickup_method'               => 'Pickup Method [pickup_method]',
						'pickup_sla'                  => 'Pickup SLA [pickup_sla]',
						'pickup_link_template'        => 'Pickup Link Template [pickup_link_template]',
						'link_template'               => 'Link Template [link_template]',
						'mobile_link_template'        => 'Mobile Link Template [mobile_link_template]',
						'mobile_pickup_link_template' => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
					),
				),
				18 => array(
					'optionGroup' => 'Pinterest Catalog Attributes',
					'options'     => array(
						'free_shipping_label'   => 'Free Shipping Label[free_shipping_label]',
						'free_shipping_limit'   => 'Free Shipping Limit[free_shipping_limit]',
						'average_review_rating' => 'Average Review Rating[average_review_rating]',
						'number_of_ratings'     => 'Number of Ratings[number_of_ratings]',
						'number_of_reviews'     => 'Number of Reviews[number_of_reviews]',
					),
				),
			),
			'bing'                  => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'                => 'Product Id[id]',
						'title'             => 'Product Title[title]',
						'link'              => 'Product URL[link]',
						'price'             => 'Product Price[price]',
						'description'       => 'Product Description[description]',
						'image_link'        => 'Image[image_link]',
						'shipping'          => 'Shipping [shipping]',
						'shipping_country'  => 'Shipping Country[shipping]',
						'shipping_service'  => 'Shipping Service[shipping]',
						'shipping_price'    => 'Shipping Price[shipping]',
						'gtin'              => 'GTIN[gtin]',
						'mpn'               => 'MPN[mpn]',
						'brand'             => 'Brand[brand]',
						'identifier_exists' => 'Identifier Exists[identifier_exists]',
					),
				),
				2 => array(
					'optionGroup' => 'Apparel Products',
					'options'     => array(
						'gender'      => 'Gender[gender]',
						'age_group'   => 'Age Group[age_group]',
						'color'       => 'Color[color]',
						'size'        => 'Size[size]',
						'size_type'   => 'Size Type[size_type]',
						'size_system' => 'Size System[size_system]',
					),
				),
				3 => array(
					'optionGroup' => 'Product Variants',
					'options'     => array(
						'item_group_id'         => 'Item Group ID[item_group_id]',
						'material'              => 'Material[material]',
						'pattern'               => 'Pattern[pattern]',
						'additional_image_link' => 'Additional Image Link[additional_image_link]',
					),
				),
				4 => array(
					'optionGroup' => 'Other Information',
					'options'     => array(
						'adult'                       => 'Adult[adult]',
						'availability'                => 'Availability[availability]',
						'product_category'            => 'Product Category[product_category]',
						'condition'                   => 'Condition[condition]',
						'expiration_date'             => 'Expiration Date[expiration_date]',
						'multipack'                   => 'Multipack[multipack]',
						'product_type'                => 'Product Type[product_type]',
						'mobile_link'                 => 'Mobile Link[mobile_link]',
						'unit_pricing_measure'        => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'   => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment'                 => 'Installment[installment]',
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[min_energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[max_energy_efficiency_class]',
						'seller_name'                 => 'Seller Name[seller_name]',
						'ads_redirect'                => 'Ads Redirect[ads_redirect]',
						'excluded_destination'        => 'Excluded Destination[excluded_destination]',
						'included_destination'        => 'Included Destination[included_destination]',
						'custom_label_0'              => 'Custom Label 0[custom_label_0]',
						'custom_label_1'              => 'Custom Label 1[custom_label_1]',
						'custom_label_2'              => 'Custom Label 2[custom_label_2]',
						'custom_label_3'              => 'Custom Label 3[custom_label_3]',
						'custom_label_4'              => 'Custom Label 4[custom_label_4]',
					),
				),
				5 => array(
					'optionGroup' => 'Sales & Promotions',
					'options'     => array(
						'sale_price'                => 'Sale Price[sale_price]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
						'promotion_ID'              => 'Promotion ID[promotion_ID]',
					),
				),
				6 => array(
					'optionGroup' => 'Local Product Inventory',
					'options'     => array(
						'store_code'      => 'Store Code[store_code]',
						'itemid'          => 'Item ID[itemid]',
						'quantity'        => 'Quantity[quantity]',
						'weeks_of_supply' => 'Weeks Of Supply[weeks_of_supply]',
						'pick_up_method'  => 'Pick Up Method[pick_up_method]',
						'pick_up_sla'     => 'Pick Up SLA[pick_up_sla]',
					),
				),
			),
			'pinterest'             => array(
				1  => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'               => 'Product Id[id]',
						'webitemid'        => 'Product WebItemId[webitemid]',
						'region_id'        => 'Region Id[region_id]',
						'title'            => 'Product Title[title]',
						'description'      => 'Product Description[description]',
						'link'             => 'Product URL[link]',
						'canonical_link'   => 'Canonical Link[canonical_link]',
						'mobile_link'      => 'Product URL[mobile_link]',
						'product_type'     => 'Product Categories[product_type] ',
						'current_category' => 'Google Product Category[google_product_category]',
						'image'            => 'Main Image[image_link]',
						'images'           => 'Additional Images [additional_image_link]',
						'images_1'         => 'Additional Image 1 [additional_image_link]',
						'images_2'         => 'Additional Image 2 [additional_image_link]',
						'images_3'         => 'Additional Image 3 [additional_image_link]',
						'images_4'         => 'Additional Image 4 [additional_image_link]',
						'images_5'         => 'Additional Image 5 [additional_image_link]',
						'images_6'         => 'Additional Image 6 [additional_image_link]',
						'images_7'         => 'Additional Image 7 [additional_image_link]',
						'images_8'         => 'Additional Image 8 [additional_image_link]',
						'images_9'         => 'Additional Image 9 [additional_image_link]',
						'images_10'        => 'Additional Image 10 [additional_image_link]',
						'condition'        => 'Condition[condition]',
					),
				),
				2  => array(
					'optionGroup' => 'Availability & Price',
					'options'     => array(
						'availability'              => 'Stock Status[availability]',
						'availability_date'         => 'Availability Date[availability_date]',
						'inventory'                 => 'Facebook Inventory[inventory]',
						'override'                  => 'Facebook Override[override]',
						'price'                     => 'Regular Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'cost_of_goods_sold'        => 'Cost of Goods Sold[cost_of_goods_sold]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
				3  => array(
					'optionGroup' => 'Unique Product Identifiers',
					'options'     => array(
						'brand'             => 'Manufacturer[brand]',
						'upc'               => 'GTIN[gtin]',
						'sku'               => 'MPN[mpn]',
						'identifier_exists' => 'Identifier Exist[identifier_exists]',
					),
				),
				4  => array(
					'optionGroup' => 'Detailed Product Attributes',
					'options'     => array(
						'item_group_id'        => 'Item Group Id[item_group_id]',
						'external_seller_id'   => 'External seller ID[external_seller_id]',
						'color'                => 'Color[color]',
						'gender'               => 'Gender[gender]',
						'age_group'            => 'Age Group[age_group]',
						'material'             => 'Material[material]',
						'pattern'              => 'Pattern[pattern]',
						'size'                 => 'Size of the item[size]',
						'size_type'            => 'Size Type[size_type]',
						'size_system'          => 'Size System[size_system]',
						'product_length'       => 'Product Length[product_length]',
						'product_width'        => 'Product Width[product_width]',
						'product_height'       => 'Product Height[product_height]',
						'product_weight'       => 'Product Weight[product_weight]',
						'product_highlight_1'  => 'Product Highlight 1[product_highlight]',
						'product_highlight_2'  => 'Product Highlight 2[product_highlight]',
						'product_highlight_3'  => 'Product Highlight 3[product_highlight]',
						'product_highlight_4'  => 'Product Highlight 4[product_highlight]',
						'product_highlight_5'  => 'Product Highlight 5[product_highlight]',
						'product_highlight_6'  => 'Product Highlight 6[product_highlight]',
						'product_highlight_7'  => 'Product Highlight 7[product_highlight]',
						'product_highlight_8'  => 'Product Highlight 8[product_highlight]',
						'product_highlight_9'  => 'Product Highlight 9[product_highlight]',
						'product_highlight_10' => 'Product Highlight 10[product_highlight]',
						'section_name'         => 'Section Name (Product Detail)[section_name]',
						'attribute_name'       => 'Attribute Name  (Product Detail)[attribute_name]',
						'attribute_value'      => 'Attribute Value  (Product Detail)[attribute_value]',
					),
				),
				5  => array(
					'optionGroup' => 'Tax & Shipping',
					'options'     => array(
						'tax'                 => 'Tax[tax]',
						'tax_category'        => 'Tax[tax_category]',
						'shipping'            => 'Shipping',
						'location_id'         => 'location_id',
						'location_group_name' => 'location_group_name',
						'min_handling_time'   => 'Min Handling Time[min_handling_time]',
						'max_handling_time'   => 'Max Handling Time[max_handling_time]',
						'min_transit_time'    => 'Min Transit Time[min_transit_time]',
						'max_transit_time'    => 'Max Transit Time[max_transit_time]',
						'weight'              => 'Shipping Weight[shipping_weight]',
						'length'              => 'Shipping Length[shipping_length]',
						'width'               => 'Shipping Width[shipping_width]',
						'height'              => 'Shipping Height[shipping_height]',
						'ships_from_country'  => 'Shipping Country[ships_from_country]',
						'shipping_label'      => 'Shipping Label[shipping_label]',
						'material_1'          => 'The primary material',
						'material_2'          => 'The secondary material',
						'material_3'          => 'The tertiary material',
					),
				),
				6  => array(
					'optionGroup' => 'Product Combinations',
					'options'     => array(
						'multipack' => 'Multipack[multipack]',
						'is_bundle' => 'Is Bundle[is_bundle]',
					),
				),
				7  => array(
					'optionGroup' => 'Adult Products',
					'options'     => array(
						'adult' => 'Adult[adult]',
					),
				),
				8  => array(
					'optionGroup' => 'Ads Attributes',
					'options'     => array(
						'ads_redirect' => 'Ads Redirect[ads_redirect]',
					),
				),
				9  => array(
					'optionGroup' => 'Custom Label Attributes',
					'options'     => array(
						'custom_label_0' => 'Custom label 0 [custom_label_0]',
						'custom_label_1' => 'Custom label 1 [custom_label_1]',
						'custom_label_2' => 'Custom label 2 [custom_label_2]',
						'custom_label_3' => 'Custom label 3 [custom_label_3]',
						'custom_label_4' => 'Custom label 4 [custom_label_4]',
					),
				),
				10 => array(
					'optionGroup' => 'Additional Attributes',
					'options'     => array(
						'excluded_destination'          => 'Excluded Destination[excluded_destination]',
						'shopping_ads_excluded_country' => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
						'included_destination'          => 'Included Destination[included_destination]',
						'expiration_date'               => 'Expiration Date [expiration_date]',
						'transit_time_label'            => 'Transit Time [transit_time_label]',
					),
				),
				11 => array(
					'optionGroup' => 'Unit Prices, Subscription, and Installment',
					'options'     => array(
						'unit_pricing_measure'       => 'Unit Pricing Measure[unit_pricing_measure]',
						'unit_pricing_base_measure'  => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
						'installment_months'         => 'Installment Months[months]',
						'installment_amount'         => 'Installment Amount[amount]',
						'subscription_period'        => 'Subscription Period[period]',
						'subscription_period_length' => 'Subscription Period Length[period_length]',
						'subscription_amount'        => 'Subscription Amount[amount]',
					),
				),
				12 => array(
					'optionGroup' => 'Energy Labels',
					'options'     => array(
						'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
						'min_energy_efficiency_class' => 'Min Energy Efficiency Class[energy_efficiency_class]',
						'max_energy_efficiency_class' => 'Max Energy Efficiency Class[energy_efficiency_class]',
					),
				),
				13 => array(
					'optionGroup' => 'Loyalty Points (Japan Only)',
					'options'     => array(
						'loyalty_points' => 'loyalty_points[loyalty_points]',
					),
				),
				14 => array(
					'optionGroup' => 'Multiple Installments (Brazil Only)',
					'options'     => array(
						'installment' => 'Installment[installment]',
					),
				),
				15 => array(
					'optionGroup' => 'Merchant Promotions Attributes',
					'options'     => array(
						'promotion_id'                 => 'Promotion Id[promotion_id]',
						'product_applicability'        => 'Product Applicability[product_applicability]',
						'offer_type'                   => 'Offer Type[offer_type]',
						'long_title'                   => 'Long Title[long_title]',
						'promotion_effective_dates'    => 'Promotion Effective Dates[promotion_effective_dates]',
						'redemption_channel'           => 'Redemption Channel[redemption_channel]',
						'promotion_destination'        => 'Promotion Destination[promotion_destination]',
						'percent_off'                  => 'Percent Off[percent_off]',
						'money_off_amount'             => 'Money Off Amount[money_off_amount]',
						'get_this_quantity_discounted' => 'Get Quantity Discounted[get_this_quantity_discounted]',
						'free_shipping'                => 'Free Shipping[free_shipping]',
						'free_gift_value'              => 'Free Gift Value[free_gift_value]',
						'free_gift_description'        => 'Free Gift Description[free_gift_description]',
						'free_gift_item_id'            => 'Free Gift Item ID[free_gift_item_id]',
						'promotion_display_dates'      => 'Promotion Display Dates[promotion_display_dates]',
						'generic_redemption_code'      => 'Generic Redemption Code[generic_redemption_code]',
						'fine_print'                   => 'Fine Print[fine_print]',
						'promotion_price'              => 'Promotion Price[promotion_price]',
						'coupon_value_type'            => 'Coupon Value Type[coupon_value_type]',
						'limit_quantity'               => 'Limit Quantity[limit_quantity]',
						'limit_value'                  => 'Limit Value[limit_value]',
						'minimum_purchase_amount'      => 'Minimum Purchase Amount[minimum_purchase_amount]',
						'item_id_exclusion'            => 'Item ID Exclusion[item_id_exclusion]',
						'product_type_exclusion'       => 'Product Type Exclusion[product_type_exclusion]',
						'brand_exclusion'              => 'Brand Exclusion[brand_exclusion]',
						'item_group_id_exclusion'      => 'Item Group Exclusion[item_group_id_exclusion]',
					),
				),
				16 => array(
					'optionGroup' => 'Shopping Action Attributes',
					'options'     => array(
						'sell_on_google_quantity' => 'Number of Product Sold On Google [sell_on_google_quantity]',
						'return_address_label'    => 'Return Address [return_address_label]',
						'return_policy_label'     => 'Return Policy [return_policy_label]',
						'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
					),
				),
				17 => array(
					'optionGroup' => 'Local Inventory / Product Inventory',
					'options'     => array(
						'store_code'                  => 'Store Code [store_code]',
						'quantity'                    => 'Quantity [quantity]',
						'pickup_method'               => 'Pickup Method [pickup_method]',
						'pickup_sla'                  => 'Pickup SLA [pickup_sla]',
						'pickup_link_template'        => 'Pickup Link Template [pickup_link_template]',
						'link_template'               => 'Link Template [link_template]',
						'mobile_link_template'        => 'Mobile Link Template [mobile_link_template]',
						'mobile_pickup_link_template' => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
					),
				),
				18 => array(
					'optionGroup' => 'Pinterest Catalog Attributes',
					'options'     => array(
						'free_shipping_label'   => 'Free Shipping Label[free_shipping_label]',
						'free_shipping_limit'   => 'Free Shipping Limit[free_shipping_limit]',
						'average_review_rating' => 'Average Review Rating[average_review_rating]',
						'number_of_ratings'     => 'Number of Ratings[number_of_ratings]',
						'number_of_reviews'     => 'Number of Reviews[number_of_reviews]',
					),
				),
			),
			'pinterest_rss'         => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'title'       => 'Product Title[title]',
						'description' => 'Product Description[description]',
						'link'        => 'Product URL[link]',
						'image'       => 'Main Image[image]',
						'pubDate'     => 'Publish Date[pubDate]',
						'guid'        => 'GUID[guid]',
					),
				),
			),
			'googlereview'          => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'product_name'      => 'Product Title [product_name]',
						'product_url'       => 'Product URL [product_url]',
						'review_temp_gtin'  => 'GTIN [gtin]',
						'review_temp_mpn'   => 'MPN [mpn]',
						'review_temp_sku'   => 'SKU [sku]',
						'review_temp_brand' => 'Brand [brand]',
					),
				),
			),
			'wine_searcher'         => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'name'          => 'Product Title[name]',
						'description'   => 'Product description[description]',
						'vintage'       => 'Vintage[vintage]',
						'link'          => 'Product URL[link]',
						'unit-size'     => 'Unit Size[unit-size]',
						'price'         => 'Price[price]',
						'url'           => 'URL[url] ',
						'min-order'     => 'Minimum Order[min-order]',
						'tax'           => 'Tax[tax]',
						'offer-type'    => 'Offer Type[offer-type]',
						'delivery-time' => 'Delivery Time[delivery-time]',
						'stock-level'   => 'Stock Level[stock-level]',
					),
				),
			),
			'tiktok'                => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'sku_id'                    => 'SKU ID[id]',
						'title'                     => 'Product Title[title]',
						'description'               => 'Product description[description]',
						'availability'              => 'Availability[availability]',
						'condition'                 => 'Condition[condition]',
						'price'                     => 'Price[price]',
						'sale_price'                => 'Sale Price[sale_price]',
						'shipping'                  => 'Shipping[shipping]',
						'tax '                      => 'Tax[tax]',
						'shipping_weight'           => 'Shipping Weight[shipping_weight]',
						'link'                      => 'Product URL[link]',
						'image_link'                => 'Product Image[image_link]',
						'additional_image_link'     => 'Additional Image [additional_image_link]',
						'item_group_id'             => 'Parent ID[item_group_id]',
						'brand'                     => 'Product Brand[brand]',
						'gtin'                      => 'Gtin[gtin]',
						'mpn'                       => 'MPN[mpn]',
						'google_product_category'   => 'Google Product Category[google_product_category]',
						'video_link'                => 'Video Link[video_link]',
						'age_group'                 => 'Age Group[age_group]',
						'color'                     => 'Color[color]',
						'size'                      => 'Size[size]',
						'gender'                    => 'Gender[gender]',
						'material'                  => 'Material[material]',
						'pattern'                   => 'Pattern[pattern]',
						'product_type'              => 'Product Type[product_type]',
						'ios_url'                   => 'IOS URL[ios_url]',
						'ios_app_store_id'          => 'IOS App Store ID[ios_app_store_id]',
						'ios_app_name'              => 'IOS App Name[ios_app_name]',
						'iPhone_url'                => 'iPhone URL[iPhone_url]',
						'iPhone_app_store_id'       => 'iPhone App Store ID[iPhone_app_store_id]',
						'iPhone_app_name'           => 'iPhone App Name[iPhone_app_name]',
						'iPad_url'                  => 'iPad URL[iPad_url]',
						'iPad_app_store_id'         => 'iPad App Store ID[iPad_app_store_id]',
						'iPad_app_name'             => 'iPad App Name[iPad_app_name]',
						'android_url'               => 'Android URL[android_url]',
						'android_package'           => 'Android Package[android_package]',
						'android_app_name'          => 'Android App Name[android_app_name]',
						'custom_label_0'            => 'custom_label_0[custom_label_0]',
						'custom_label_1'            => 'custom_label_1[custom_label_1]',
						'custom_label_2'            => 'custom_label_2[custom_label_2]',
						'custom_label_3'            => 'custom_label_3[custom_label_3]',
						'custom_label_4'            => 'custom_label_4[custom_label_4]',
						'merchant_brand'            => 'Merchant Brand[merchant_brand]',
						'productHisEval'            => 'Purchase Count:FeedBack[productHisEval]',
						'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
					),
				),
			),
			'modalova'              => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'id'                => 'Product ID[id]',
						'title'             => 'Product Title[title]',
						'slug'              => 'Product URL Slug[slug]',
						'description'       => 'Product description[description]',
						'short_description' => 'Product Short description[short_description]',
						'link'              => 'Product URL[link]',
						'sku'               => 'SKU[sku]',
						'brand'             => 'Product Brand[brand]',
						'main_image'        => 'Product Image[main_image]',
						'featured_image'    => 'Featured Image[featured_image]',
						'images'            => 'Images[images]',
						'price'             => 'Price[price]',
						'sale_price'        => 'Sale Price[sale_price]',
						'availability'      => 'Availability[availability]',
						'tags'              => 'Tags[tags]',
						'color'             => 'Color[color]',
						'size'              => 'Size[size]',
						'quantity'          => 'Quantity[quantity]',
						'parent_id'         => 'Parent ID[parent_id]',
						'condition'         => 'Condition[condition]',
						'category'          => 'Category[category]',
						'parent_category'   => 'Parent Category[parent_category]',
						'child_category'    => 'Child Category[child_category]',
						'category_path'     => 'Category Path[category_path]',
						'created_at'        => 'Created At[created_at]',
						'updated_at'        => 'Updated At[updated_at]',
					),
				),
			),
			'catchdotcom'           => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'product-id'          => 'Product ID [product-id]',
						'title'               => 'Product title [title]',
						'product-description' => 'Product Description[product-description]',
						'product-id-type'     => 'Product ID Type[product-id-type]',
						'internal-sku'        => 'Internal SKU[internal-sku]',
						'category'            => 'Product Category[category]',
						'image-1'             => 'Image 1 [image-1]',
						'images-2'            => 'Image 2 [image-2]',
						'images-3'            => 'Image 3 [image-3]',
						'images-4'            => 'Image 4 [image-4]',
						'images-5'            => 'Image 5 [image-5]',
						'images-6'            => 'Image 6 [image-6]',
						'image-size-chart'    => 'Image Size Chart[image-size-chart]',
						'brand'               => 'Brand[brand]',
						'adult'               => 'Adult[adult]',
						'keywords'            => 'Keywords[keywords]',
						'sku'                 => 'Offer SKU[sku]',
						'inventory'           => 'Facebook Inventory[inventory]',
						'override'            => 'Facebook Override[override]',
						'price'               => 'Regular Price[price]',
						'quantity'            => 'Offer Quantity[quantity]',
						'min-quantity-alert'  => 'Minimum Quantity Alert[min-quantity-alert]',
						'state'               => 'Offer State[state]',
						'logistic-class'      => 'Logistic Class[logistic-class]',
						'discount-price'      => 'Discount Price[discount-price]',
						'leadtime-to-ship'    => 'Lead Time to Ship[leadtime-to-ship]',
						'club-catch-eligible' => 'Club Catch eligible[club-catch-eligible]',
						'tax-au'              => 'GST %[tax-au]',
					),
				),
			),
			'fashionchick'          => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'Product ID'      => 'Product ID [Product ID]',
						'Titel'           => 'Product Titel [Titel]',
						'Omschrijving'    => 'Product Description [Omschrijving]',
						'Url'             => 'Product URL [Url]',
						'Image'           => 'Image [Image]',
						'Category'        => 'Product Category [Category (pad)]',
						'Prijs'           => 'Regular Price [Prijs]',
						'Merk'            => 'Brand [Merk]',
						'Cluster ID'      => 'Cluster ID [Cluster ID]',
						'internal-sku'    => 'Internal SKU [internal-sku]',
						'sku'             => 'Offer SKU[sku]',
						'Delivery Time'   => 'Delivery Time [Delivery Time]',
						'Shipping Costs'  => 'Shipping Costs [Shipping Costs]',
						'Old price'       => 'Old price [Old price]',
						'Product maten'   => 'Product sizes [Product maten]',
						'Stock'           => 'Stock [Stock]',
						'Voorraad aantal' => 'Stock quantity [Voorraad aantal]',
						'Materiaal'       => 'Material [Materiaal]',
						'Geslacht'        => 'Gender [Geslacht]',
						'Kleur'           => 'Color [Kleur]',
					),
				),
			),
			'goedgeplaatst'         => array(
				1 => array(
					'optionGroup' => 'Basic Information',
					'options'     => array(
						'title'             => 'Product Title [title]',
						'description'       => 'Product Description [description]',
						'type'              => 'Product Type [type]',
						'price'             => 'Price [price]',
						'images'            => 'Images [images]',
						'categoryId'        => 'Category ID [categoryId]',
						'externalAdId'      => 'External Ad ID [externalAdId]',
						'priceRetail'       => 'Retail Price [priceRetail]',
						'priceOther'        => 'Other Price [priceOther]',
						'bid'               => 'Bid [bid]',
						'showContact'       => 'Show Contact [showContact]',
						'website'           => 'Website [website]',
						'name'              => 'Name [name]',
						'phone'             => 'Phone [phone]',
						'address'           => 'Address [address]',
						'houseNumber'       => 'House Number [houseNumber]',
						'postalCode'        => 'Postal Code [postalCode]',
						'city'              => 'City [city]',
						'country'           => 'Country [country]',
						'autoReplace'       => 'Auto Replace [autoReplace]',
						'directForwardToMp' => 'Direct Forward Mp [directForwardToMp]',
						'priceBidMinimal'   => 'Price Bid Minimal [priceBidMinimal]',
						'priceBidAsking'    => 'Price Bid Asking [priceBidAsking]',
					),
				),
			),
			'skroutz'               => array(
				1 => array(
					'optionGroup' => 'Required Information',
					'options'     => array(
						'id'             => 'Unique ID',
						'name'           => 'Product Title',
						'description'    => 'Product Description',
						'link'           => 'Product Link',
						'image'          => 'Image Link',
						'category'       => 'Category Name',
						'price'          => 'Price',
						'price_with_vat' => 'Price With Tax',
						'manufacturer'   => 'Manufacturer',
						'mpn'            => 'MPN / ISBN',
						'availability'   => 'Availability',
					),
				),
				2 => array(
					'optionGroup' => 'Additional Information',
					'options'     => array(
						'instock'                => 'Stock Status [InStock]',
						'ean'                    => 'EAN / Barcode',
						'additional_imageurl'    => 'Additional Image Link',
						'additional_imageurl_1'  => 'Additional Image Link 1',
						'additional_imageurl_2'  => 'Additional Image Link 2',
						'additional_imageurl_3'  => 'Additional Image Link 3',
						'additional_imageurl_4'  => 'Additional Image Link 4',
						'additional_imageurl_5'  => 'Additional Image Link 5',
						'additional_imageurl_6'  => 'Additional Image Link 6',
						'additional_imageurl_7'  => 'Additional Image Link 7',
						'additional_imageurl_8'  => 'Additional Image Link 8',
						'additional_imageurl_9'  => 'Additional Image Link 9',
						'additional_imageurl_10' => 'Additional Image Link 10',
						'color'                  => 'Color',
						'size'                   => 'Size',
						'weight'                 => 'Weight',
						'quantity'               => 'Quantity',
					),
				),
			),
			'daisycon'              => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'sku'         => 'Unique Product ID [SKU]',
						'description' => 'Description',
						'link'        => 'Product URL',
						'price'       => 'Price[Current/Sale Price]',
						'title'       => 'Product Title',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'image_link_1'       => 'Main Image',
						'brand'              => 'Brand of the product',
						'category'           => 'Main category',
						'category_path'      => 'Category path',
						'delivery_time'      => 'Delivery time in days',
						'ean'                => 'EAN',
						'google_category_id' => 'Google category ID',
						'in_stock'           => 'Stock status',
						'in_stock_amount'    => 'Amount of items in stock',
						'price_old'          => 'Old price [Regular Price (in case of discount prices)]',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'color_primary'  => 'Primary color of the product',
						'condition'      => 'Product Condition',
						'gender_target'  => 'Gender Target',
						'price_shipping' => 'Shipping costs',
						'image_link_2'   => 'Image 2',
						'image_link_3'   => 'Image 3',
						'image_link_4'   => 'Image 4',
						'image_link_5'   => 'Image 5',
						'image_link_6'   => 'Image 6',
						'image_link_7'   => 'Image 7',
						'image_link_8'   => 'Image 8',
						'image_link_9'   => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'     => 'Additional costs',
						'brand_logo'           => 'Brand Logo URL',
						'delivery_description' => 'Description of the delivery method',
						'keywords'             => 'Keywords [Tags]',
						'model'                => 'Model name/number',
						'material_1'           => 'The primary material',
						'material_2'           => 'The secondary material',
						'material_3'           => 'The tertiary material',
						'priority'             => 'Priority of the product',
						'size'                 => 'General Size field',
						'size_description'     => 'Description for the “size” field',
						'terms_conditions'     => 'Full terms and conditions',
					),
				),
			),
			'daisycon_automotive'   => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'description' => 'Description of the product',
						'link'        => 'URL to the page of the product',
						'price'       => 'Price [Current/Sale Price]',
						'sku'         => 'Unique Product ID [SKU]',
						'title'       => 'Complete name of the product',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'brand'              => 'Brand of the product',
						'category'           => 'Main category',
						'category_path'      => 'Category path',
						'color_primary'      => 'Primary color of the product',
						'delivery_time'      => 'Delivery time in days',
						'ean'                => 'EAN',
						'google_category_id' => 'Google category ID',
						'in_stock'           => 'Stock status',
						'in_stock_amount'    => 'Amount of items in stock',
						'price_old'          => 'Old price [Regular Price]',
						'image_link_1'       => 'Main Image',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'condition'      => 'Product Condition',
						'price_shipping' => 'Shipping costs',
						'image_link_2'   => 'Image 2',
						'image_link_3'   => 'Image 3',
						'image_link_4'   => 'Image 4',
						'image_link_5'   => 'Image 5',
						'image_link_6'   => 'Image 6',
						'image_link_7'   => 'Image 7',
						'image_link_8'   => 'Image 8',
						'image_link_9'   => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'        => 'Additional costs',
						'brake_system'            => 'Brake system type',
						'brand_logo'              => 'Brand Logo URL',
						'delivery_description'    => 'Description of the delivery method',
						'fuel_type'               => 'Fuel type',
						'gear_system'             => 'Gear system type',
						'gender_target'           => 'Gender Target',
						'has_airco'               => 'Is there an airco present',
						'keywords'                => 'Keywords [Tags]',
						'model'                   => 'Model name/number',
						'material_1'              => 'The primary material',
						'material_2'              => 'The secondary material',
						'material_3'              => 'The tertiary material',
						'priority'                => 'Priority of the product',
						'rental_location_city'    => "City of a rental car's pick up location (if applicable)",
						'rental_location_country' => "Country of a rental car's pick up location (if applicable)",
						'rental_location_region'  => "Region of a rental car's pick up location (if applicable)",
						'size'                    => 'General field for size',
						'size_description'        => 'Description for the “size” field',
						'tire_size'               => 'The measurements of the tire size of the product.',
						'year_built'              => 'Year in which the product is fabricated',
						'terms_conditions'        => 'Full terms and conditions',
					),
				),
			),
			'daisycon_books'        => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'description' => 'Description of the product',
						'link'        => 'URL to the page of the product',
						'price'       => 'Price [Current/Sale Price]',
						'sku'         => 'Unique Product ID [SKU]',
						'title'       => 'Complete name of the product',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'author'             => 'Name of the author',
						'category'           => 'Main category',
						'category_path'      => 'Category path',
						'delivery_time'      => 'Delivery time in days',
						'ean'                => 'EAN',
						'google_category_id' => 'Google category ID',
						'in_stock'           => 'Stock status',
						'in_stock_amount'    => 'Amount of items in stock',
						'isbn'               => 'ISBN of the book/magazine',
						'price_old'          => 'Old price [Regular Price]',
						'image_link_1'       => 'Main Image',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'book_publisher' => 'Publisher of the book',
						'book_type'      => 'Type of book',
						'price_shipping' => 'Shipping costs',
						'image_link_2'   => 'Image 2',
						'image_link_3'   => 'Image 3',
						'image_link_4'   => 'Image 4',
						'image_link_5'   => 'Image 5',
						'image_link_6'   => 'Image 6',
						'image_link_7'   => 'Image 7',
						'image_link_8'   => 'Image 8',
						'image_link_9'   => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Low Priority Attributes',
					'options'      => array(
						'condition'       => 'Product Condition',
						'gender_target'   => 'Gender to which the product is aimed',
						'number_of_pages' => 'Number of pages',
						'release_date'    => 'Date of publication',
					),
				),
				5 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'     => 'Additional costs',
						'book_edition'         => 'Edition of the book',
						'brand'                => 'Brand of the product',
						'brand_logo'           => 'URL to an image of the brand logo',
						'color_primary'        => 'Primary color of the product',
						'delivery_description' => 'Description of the delivery method',
						'file_size'            => 'Total file size in kbps',
						'file_type'            => 'File type (for example: epub)',
						'keywords'             => 'Keywords for this product',
						'language'             => 'Language of the product',
						'model'                => 'Model name/number',
						'priority'             => 'Priority of the product',
						'size'                 => 'General field for size',
						'size_description'     => 'Description for the “size” field',
						'size_length'          => 'Magazine length in mm',
						'size_width'           => 'Magazine width in mm',
						'weight'               => 'Weight in grams',
						'material_1'           => 'The primary material',
						'material_2'           => 'The secondary material',
						'material_3'           => 'The tertiary material',
						'terms_conditions'     => 'Full terms and conditions',
					),
				),
			),
			'daisycon_cosmetics'    => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'description' => 'Description of the product',
						'link'        => 'URL to the page of the product',
						'price'       => 'Price [Current/Sale Price]',
						'sku'         => 'Unique Product ID [SKU]',
						'title'       => 'Complete name of the product',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'allergic_info'      => 'Allergy information',
						'amount_content'     => 'Amount of content, for example: 120(in combination with amount_description)',
						'amount_description' => 'The unit in which the amount is specified for example: ml',
						'category'           => 'Main category',
						'category_path'      => 'Category path',
						'delivery_time'      => 'Delivery time in days',
						'ean'                => 'EAN',
						'google_category_id' => 'Google category ID',
						'in_stock'           => 'Stock status',
						'in_stock_amount'    => 'Amount of items in stock',
						'price_old'          => 'Old price [Regular Price]',
						'image_link_1'       => 'Main Image',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'description_ingredients' => 'Description of the ingredients',
						'gender_target'           => 'Gender to which the product is aimed',
						'price_shipping'          => 'Shipping costs',
						'skin_type'               => 'Skintype for which the product is made',
						'image_link_2'            => 'Image 2',
						'image_link_3'            => 'Image 3',
						'image_link_4'            => 'Image 4',
						'image_link_5'            => 'Image 5',
						'image_link_6'            => 'Image 6',
						'image_link_7'            => 'Image 7',
						'image_link_8'            => 'Image 8',
						'image_link_9'            => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Low Priority Attributes',
					'options'      => array(
						'color_primary' => 'Primary color of the product',
					),
				),
				5 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'     => 'Additional costs',
						'brand_logo'           => 'URL to an image of the brand logo',
						'condition'            => 'Product Condition',
						'delivery_description' => 'Description of the delivery method',
						'keywords'             => 'Keywords for this product',
						'made_in_country'      => 'Country in which the product is fabricated',
						'model'                => 'Model name/number',
						'priority'             => 'Priority of the product',
						'size'                 => 'General field for size',
						'size_description'     => 'Description for the “size” field',
						'weight'               => 'Weight in grams',
						'material_1'           => 'The primary material',
						'material_2'           => 'The secondary material',
						'material_3'           => 'The tertiary material',
						'terms_conditions'     => 'Full terms and conditions',
					),
				),
			),
			'daisycon_daily_offers' => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'description' => 'Description of the product',
						'link'        => 'URL to the page of the product',
						'price'       => 'Price [Current/Sale Price]',
						'sku'         => 'Unique Product ID [SKU]',
						'title'       => 'Complete name of the product',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'brand'           => 'Brand of the product',
						'category'        => 'Main category',
						'category_path'   => 'Category path',
						'delivery_time'   => 'Delivery time in days',
						'ean'             => 'EAN',
						'in_stock'        => 'Stock status',
						'in_stock_amount' => 'Amount of items in stock',
						'price_old'       => 'Old price [Regular Price]',
						'image_link_1'    => 'Main Image',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'google_category_id' => 'Google category ID',
						'price_shipping'     => 'Shipping costs',
						'image_link_2'       => 'Image 2',
						'image_link_3'       => 'Image 3',
						'image_link_4'       => 'Image 4',
						'image_link_5'       => 'Image 5',
						'image_link_6'       => 'Image 6',
						'image_link_7'       => 'Image 7',
						'image_link_8'       => 'Image 8',
						'image_link_9'       => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'     => 'Additional costs',
						'brand_logo'           => 'URL to an image of the brand logo',
						'color_primary'        => 'Primary color of the product',
						'condition'            => 'Product Condition',
						'delivery_description' => 'Description of the delivery method',
						'discount_amount'      => "Amount of discount in euro's",
						'discount_percentage'  => 'Amount of discount in percent',
						'gender_target'        => 'Gender to which the product is aimed',
						'keywords'             => 'Keywords for this product',
						'model'                => 'Model name/number',
						'offer_datetime_end'   => 'End (time and) date of the daily offer',
						'offer_datetime_start' => 'Start (time and) date of the daily offer',
						'size'                 => 'General field for size',
						'size_description'     => 'Description for the “size” field',
						'material_1'           => 'The primary material',
						'material_2'           => 'The secondary material',
						'material_3'           => 'The tertiary material',
						'terms_conditions'     => 'Full terms and conditions',
					),
				),
			),
			'daisycon_electronics'  => array(
				1 => array(
					'optionGroup' => 'Required Attributes',
					'options'      => array(
						'description' => 'Description of the product',
						'link'        => 'URL to the page of the product',
						'price'       => 'Price [Current/Sale Price]',
						'sku'         => 'Unique Product ID [SKU]',
						'title'       => 'Complete name of the product',
					),
				),
				2 => array(
					'optionGroup' => 'Highly Recommended Attributes',
					'options'      => array(
						'brand'              => 'Brand of the product',
						'category'           => 'Main category',
						'category_path'      => 'Category path',
						'delivery_time'      => 'Delivery time in days',
						'ean'                => 'EAN',
						'google_category_id' => 'Google category ID',
						'in_stock'           => 'Stock status',
						'in_stock_amount'    => 'Amount of items in stock',
						'model'              => 'Model name/number',
						'price_old'          => 'Old price [Regular Price]',
						'image_link_1'       => 'Main Image',
					),
				),
				3 => array(
					'optionGroup' => 'Recommended Attributes',
					'options'      => array(
						'color_primary'  => 'Primary color of the product',
						'price_shipping' => 'Shipping costs',
						'image_link_2'   => 'Image 2',
						'image_link_3'   => 'Image 3',
						'image_link_4'   => 'Image 4',
						'image_link_5'   => 'Image 5',
						'image_link_6'   => 'Image 6',
						'image_link_7'   => 'Image 7',
						'image_link_8'   => 'Image 8',
						'image_link_9'   => 'Image 9',
					),
				),
				4 => array(
					'optionGroup' => 'Low Priority Attributes',
					'options'      => array(
						'condition' => 'Product Condition',
					),
				),
				5 => array(
					'optionGroup' => 'Optional Attributes',
					'options'      => array(
						'additional_costs'       => 'Additional costs',
						'audio_surround'         => 'Has audio surround sound',
						'batteries_included'     => 'Specifies is batteries are included at the purchase of the product',
						'brand_logo'             => 'URL to an image of the brand logo',
						'connection_type'        => 'Connection type, for example: USB',
						'delivery_description'   => 'Description of the delivery method',
						'device_max_content'     => 'Maximum content of the product, for example: 7KG or 3L',
						'device_max_temperature' => 'Maximum temperature the device can reach in Celsius',
						'device_serve_amount'    => 'Amount of portions/persons the product can serve.',
						'device_watt'            => 'Maximum wattage of the product for example: 450',
						'dishwasher_safe'        => 'Product is dishwasher proof',
						'disposal_fee'           => 'Disposal fee of the product in euro’s',
						'file_types_supported'   => 'Supported filetypes',
						'gender_target'          => 'Gender to which the product is aimed',
						'has_alarm'              => 'Product has an alarm',
						'has_grill'              => 'Product has a grill option, or a grill is present',
						'has_microwave'          => 'Product has a microwave option or a microwave is present',
						'has_oven'               => 'Product has an oven option or an oven is present',
						'has_radio'              => 'Product has a radio option or a radio is pressent',
						'has_remote_control'     => 'Product has a remote',
						'has_timer'              => 'Product has a timer',
						'has_wifi'               => 'Product has a wifi connection or wifi is present',
						'keywords'               => 'Keywords for this product',
						'made_in_country'        => 'Country in which the product is fabricated',
						'partnumber'             => 'Part Number [MPN]',
						'power_type'             => 'Type of energysource, for example: gas, electric, ceramic',
						'price_suggested_retail' => 'Suggested price',
						'priority'               => 'Priority of the product',
						'resolution_record'      => 'Camera recording resolution of the product (for example: 1280x768, 350dpi or 10MP)',
						'resolution_screen'      => 'Screenresolution of the product (For example: 1280x768 or 350dpi)',
						'screen_size'            => 'Screensize in inches',
						'screen_type'            => 'Screentype of the product (for example: LED/3D/etc.)',
						'size'                   => 'General field for size',
						'size_description'       => 'Description for the “size” field',
						'size_length'            => 'Product length in mm',
						'size_width'             => 'Product width in mm',
						'specs'                  => 'All specifications/functionalities of the product',
						'terms_conditions'       => 'Full terms and conditions',
						'material_1'             => 'The primary material',
						'material_2'             => 'The secondary material',
						'material_3'             => 'The tertiary material',
					),
				),
			),
            'chatgpt'   => array(
                1 => array(
                    'optionGroup' => 'OpenAI Flag',
                    'options'      => array(
                        'enable_search'       => 'Controls whether the product can be surfaced in ChatGPT search results',
                        'enable_checkout'     => 'Allows direct purchase inside ChatGPT.',
                    ),
                ),
                2 => array(
                    'optionGroup' => 'Basic Product Data',
                    'options'      => array(
                        'id'          => 'Merchant product ID (unique)',
                        'gtin'        => 'Universal product identifier',
                        'mpn'         => 'Manufacturer part number',
                        'title'       => 'Product title',
                        'description' => 'Full product description',
                        'link'        => 'Product detail page URL'
                    ),
                ),
                3 => array(
                    'optionGroup' => 'Item Information',
                    'options'      => array(
                        'condition'          => 'Condition of product',
                        'product_category'   => 'Category path',
                        'brand'              => 'Product brand',
                        'material'           => 'Primary material(s)',
                        'dimensions'         => 'Overall dimensions',
                        'length'             => 'Individual dimension(length)',
                        'width'              => 'Individual dimension(width)',
                        'height'             => 'Individual dimension(height)',
                        'weight'             => 'Product weight',
                        'age_group'          => 'Target demographic',
                    ),
                ),
                4 => array(
                    'optionGroup' => 'Media',
                    'options'      => array(
                        'image_link'            => 'Main product image URL',
                        'additional_image_link' => 'Extra images',
                        'video_link'            => 'Product video',
                        'model_3d_link'         => '3D model',
                    ),
                ),
                5 => array(
                    'optionGroup' => 'Price & Promotions',
                    'options'      => array(
                        'price'                     => 'Regular price',
                        'applicable_taxes_fees'     => 'Additional taxes/fees',
                        'sale_price'                => 'Discounted price',
                        'sale_price_effective_date' => 'Sale window',
                        'unit_pricing_measure'      => 'Unit price & base measure',
                        'pricing_trend'             => 'Lowest price in N months',
                    ),
                ),
                6 => array(
                    'optionGroup' => 'Availability & Inventory',
                    'options'      => array(
                        'availability'              => 'Product availability',
                        'availability_date'         => 'Availability date if preorder',
                        'inventory_quantity'        => 'Stock count',
                        'expiration_date'           => 'Remove product after date',
                        'pickup_method'             => 'Pickup options',
                        'pickup_sla'                => 'Pickup SLA',
                    ),
                ),
                7 => array(
                    'optionGroup' => 'Variants',
                    'options'      => array(
                        'item_group_id'             => 'Variant group ID',
                        'item_group_title'          => 'Group product title',
                        'color'                     => 'Variant color',
                        'size'                      => 'Variant size',
                        'size_system'               => 'Size System',
                        'gender'                    => 'Gender target',
                        'offer_id'                  => 'Offer ID (SKU+seller+price)',
                        'Custom_variant1_category'  => 'Custom variant dimension 1',
                        'Custom_variant1_option'    => 'Custom variant 1 option',
                        'Custom_variant2_category'  => 'Custom variant dimension 2',
                        'Custom_variant2_option'    => 'Custom variant 2 option',
                        'Custom_variant3_category'  => 'Custom variant dimension 3',
                        'Custom_variant3_option'    => 'Custom variant 3 option'
                    ),
                ),
                8 => array(
                    'optionGroup' => 'Fulfillment',
                    'options'      => array(
                        'shipping'              => 'Shipping method/cost/region',
                        'delivery_estimate'     => 'Estimated arrival date',
                    ),
                ),
                9 => array(
                    'optionGroup' => 'Merchant Info',
                    'options'      => array(
                        'seller_name'           => 'Seller name',
                        'seller_url'            => 'Seller page',
                        'seller_privacy_policy' => 'Seller-specific policies',
                        'seller_tos'            => 'Seller-specific terms of service',
                    ),
                ),
                10 => array(
                    'optionGroup' => 'Returns',
                    'options'      => array(
                        'return_policy'            => 'Return policy URL',
                        'return_window'            => 'Days allowed for return',
                    ),
                ),
                11 => array(
                    'optionGroup' => 'Performance Signals',
                    'options'      => array(
                        'popularity_score'       => 'Popularity indicator',
                        'return_rate'            => 'Return rate',
                    ),
                ),
                12 => array(
                    'optionGroup' => 'Compliance',
                    'options'      => array(
                        'warning'           => 'Product disclaimers',
                        'age_restriction'   => 'Minimum purchase age',
                    ),
                ),
                13 => array(
                    'optionGroup' => 'Reviews and Q&A',
                    'options'      => array(
                        'product_review_count'    => 'Number of product reviews',
                        'product_review_rating'   => 'Average review score',
                        'store_review_count'      => 'Number of brand/store reviews',
                        'store_review_rating'     => 'Average store rating',
                        'q_and_a'                 => 'FAQ content',
                        'raw_review_data'         => 'Raw review payload'
                    ),
                ),
                14 => array(
                    'optionGroup' => 'Related Products',
                    'options'      => array(
                        'related_product_id'      => 'Associated product IDs',
                        'relationship_type'       => 'Relationship type',
                    ),
                ),
                15 => array(
                    'optionGroup' => 'Geo Tagging',
                    'options'      => array(
                        'geo_price'         => 'Price by region',
                        'geo_availability'  => 'Availability per region',
                    ),
                ),
            ),
			'name'                  => array(),
		);
	}
}
