<?php

namespace kirillbdev\WCUkrShipping\Modules\Frontend;

use kirillbdev\WCUkrShipping\Foundation\NovaPoshtaShipping;
use kirillbdev\WCUkrShipping\Foundation\NovaPostShipping;
use kirillbdev\WCUkrShipping\Foundation\RozetkaDeliveryShipping;
use kirillbdev\WCUkrShipping\Foundation\SmartyParcelAddressDeliveryMethod;
use kirillbdev\WCUkrShipping\Foundation\UkrPoshtaShipping;
use kirillbdev\WCUkrShipping\Helpers\WCUSHelper;
use kirillbdev\WCUSCore\Contracts\ModuleInterface;

class ShippingMethod implements ModuleInterface
{
    private static ?string $cachedRateHash = null;

    /**
     * Boot function
     *
     * @return void
     */
    public function init()
    {
        add_filter('woocommerce_shipping_methods', [ $this, 'registerShippingMethod' ]);
        add_filter('woocommerce_cart_shipping_packages', [$this, 'calculatePackageRateHash']);
        add_filter('woocommerce_calculated_total', [$this, 'calculateCartTotal'], 10, 2);
    }

    public function registerShippingMethod($methods)
    {
        $methods[WC_UKR_SHIPPING_NP_SHIPPING_NAME] = NovaPoshtaShipping::class;
        $methods[WCUS_SHIPPING_METHOD_UKRPOSHTA] = UkrPoshtaShipping::class;
        $methods[WCUS_SHIPPING_METHOD_NOVA_POST] = NovaPostShipping::class;
        $methods[WCUS_SHIPPING_METHOD_ROZETKA] = RozetkaDeliveryShipping::class;
        $methods[WCUS_SHIPPING_METHOD_SP_ADDRESS_DELIVERY] = SmartyParcelAddressDeliveryMethod::class;

        return $methods;
    }

    public function calculatePackageRateHash(array $packages): array
    {
        // We need to perform calculation only for ajax refresh checkout and place order
        if (!isset($_GET['wc-ajax'])
            || !in_array($_GET['wc-ajax'], ['update_order_review', 'checkout'], true)) {
            return $packages;
        }

        $chosenMethods = wc_get_chosen_shipping_method_ids();
        $supportedMethods = [
            WC_UKR_SHIPPING_NP_SHIPPING_NAME,
            WCUS_SHIPPING_METHOD_UKRPOSHTA,
            WCUS_SHIPPING_METHOD_NOVA_POST,
            WCUS_SHIPPING_METHOD_ROZETKA,
        ];
        foreach ($packages as $key => &$package) {
            if (isset($chosenMethods[$key])
                && in_array($chosenMethods[$key], $supportedMethods, true)) {
                // todo: bad solution! provide array cache implementation instead
                if (self::$cachedRateHash === null) {
                    self::$cachedRateHash = md5(
                        sprintf('%s_%f', $chosenMethods[$key], microtime(true))
                    );
                }
                $package['wcus_rates_hash'] = self::$cachedRateHash;
            }
        }

        return $packages;
    }

    public function calculateCartTotal(float $total, \WC_Cart $cart): float
    {
        // Safe skip feature if any problems with WooCommerce session detected
        if ( ! is_callable([WC()->session, 'get'])) {
            return $total;
        }

        $chosenMethods = WC()->session->get( 'chosen_shipping_methods', []);
        $chosenInstance = reset($chosenMethods);
        if (!$chosenInstance) {
            return $total;
        }

        [$methodId, $instanceId] = explode(':', $chosenInstance);
        $costViewOnly = false;
        switch ($methodId) {
            case WC_UKR_SHIPPING_NP_SHIPPING_NAME:
                $shippingInstance = new NovaPoshtaShipping((int)$instanceId);
                $costViewOnly = $shippingInstance->get_option('add_cost_to_order') === 'no';
                break;
            case WCUS_SHIPPING_METHOD_UKRPOSHTA:
                $costViewOnly = (int)get_option('wcus_ukrposhta_cost_view_only') === 1;
                break;
            case WCUS_SHIPPING_METHOD_NOVA_POST:
                $costViewOnly = (int)get_option('wcus_nova_post_cost_view_only') === 1;
                break;
            case WCUS_SHIPPING_METHOD_ROZETKA:
                $costViewOnly = (int)get_option('wcus_rozetka_cost_view_only') === 1;
                break;
        }

        return $costViewOnly
            ? $total - $cart->get_shipping_total()
            : $total;
    }
}
